/*
 * Decompiled with CFR 0.152.
 */
package com.vertica.jdbc2;

import com.vertica.Driver;
import com.vertica.core.BaseConnection;
import com.vertica.core.BaseStatement;
import com.vertica.core.Field;
import com.vertica.core.ParameterList;
import com.vertica.core.Query;
import com.vertica.core.ResultCursor;
import com.vertica.core.ResultHandler;
import com.vertica.core.VectorTuple;
import com.vertica.core.types.PGBigDecimal;
import com.vertica.core.types.PGBoolean;
import com.vertica.core.types.PGByte;
import com.vertica.core.types.PGDouble;
import com.vertica.core.types.PGFloat;
import com.vertica.core.types.PGInteger;
import com.vertica.core.types.PGLong;
import com.vertica.core.types.PGNumber;
import com.vertica.core.types.PGShort;
import com.vertica.core.types.PGString;
import com.vertica.core.types.PGType;
import com.vertica.core.types.PGUnknown;
import com.vertica.jdbc2.AbstractJdbc2Connection;
import com.vertica.jdbc2.AbstractJdbc2ResultSet;
import com.vertica.jdbc2.EscapedFunctions;
import com.vertica.jdbc2.ResultWrapper;
import com.vertica.largeobject.LargeObject;
import com.vertica.largeobject.LargeObjectManager;
import com.vertica.util.GT;
import com.vertica.util.IOStream;
import com.vertica.util.PGbytea;
import com.vertica.util.PGobject;
import com.vertica.util.PSQLException;
import com.vertica.util.PSQLState;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.sql.Array;
import java.sql.BatchUpdateException;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.Date;
import java.sql.Ref;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Statement;
import java.sql.Time;
import java.sql.Timestamp;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Map;

public abstract class AbstractJdbc2Statement
implements BaseStatement {
    protected ArrayList batchStatements = null;
    protected ArrayList batchParameters = null;
    protected final int resultsettype;
    protected final int concurrency;
    protected int fetchdirection = 1000;
    protected BaseConnection connection;
    protected SQLWarning warnings = null;
    protected int maxrows = 0;
    protected int fetchSize = 0;
    protected int timeout = 0;
    protected boolean replaceProcessingEnabled = true;
    protected ResultWrapper result = null;
    protected ResultWrapper firstUnclosedResult = null;
    protected boolean adjustIndex = false;
    protected boolean outParmBeforeFunc = false;
    private static final short IN_SQLCODE = 0;
    private static final short IN_STRING = 1;
    private static final short IN_IDENTIFIER = 6;
    private static final short BACKSLASH = 2;
    private static final short ESC_TIMEDATE = 3;
    private static final short ESC_FUNCTION = 4;
    private static final short ESC_OUTERJOIN = 5;
    private static final short ESC_ESCAPECHAR = 7;
    private StringBuffer sbuf = new StringBuffer(35);
    protected Query preparedQuery;
    protected ParameterList preparedParameters;
    protected Query lastSimpleQuery;
    protected int m_prepareThreshold;
    protected boolean streamingLRS;
    protected int maxLRSMemory;
    protected boolean directBatchInsert;
    protected boolean batchInsertEnforceLength;
    protected String batchInsertRecordTerminator;
    protected boolean abortBatchInsertOnError;
    protected boolean binaryBatchInsert;
    protected boolean use35CopyFormat;
    protected int m_useCount = 0;
    private boolean isFunction;
    private int[] functionReturnType;
    private int[] testReturn;
    private boolean returnTypeSet;
    protected Object[] callResult;
    protected int maxfieldSize = 0;
    protected boolean batchInsert = false;
    protected int batchTotalRows = 0;
    protected String batchTableName = null;
    protected String batchColumns = null;
    protected int batchInsertCount = 0;
    protected long numAcceptedRows = 0L;
    protected long numRejectedRows = 0L;
    private boolean updateCountCleared;
    private ByteArrayInputStream baiStream;
    private IOStream ioStream;
    private boolean isClosed = false;
    private int lastIndex = 0;

    public ResultSet createDriverResultSet(Field[] fieldArray, VectorTuple vectorTuple) throws SQLException {
        return this.createResultSet(null, fieldArray, vectorTuple, null);
    }

    public AbstractJdbc2Statement(AbstractJdbc2Connection abstractJdbc2Connection, int n, int n2) throws SQLException {
        this.connection = abstractJdbc2Connection;
        this.preparedQuery = null;
        this.preparedParameters = null;
        this.lastSimpleQuery = null;
        if (!this.connection.getMetaData().supportsResultSetType(n)) {
            throw new PSQLException(GT.tr("Specified result set type is not supported."), PSQLState.INVALID_PARAMETER_VALUE);
        }
        if (!this.connection.getMetaData().supportsResultSetConcurrency(n, n2)) {
            throw new PSQLException(GT.tr("Specified result set concurrency for the specified result set type is not supported."), PSQLState.INVALID_PARAMETER_VALUE);
        }
        this.resultsettype = n;
        this.concurrency = n2;
        this.batchInsertCount = 0;
    }

    public AbstractJdbc2Statement(AbstractJdbc2Connection abstractJdbc2Connection, String string, boolean bl, int n, int n2) throws SQLException {
        this(abstractJdbc2Connection, n, n2);
        String string2 = this.replaceProcessing(string);
        if (bl) {
            string2 = this.modifyJdbcCall(string2);
        }
        this.preparedQuery = abstractJdbc2Connection.getQueryExecutor().createParameterizedQuery(string2);
        this.preparedParameters = this.preparedQuery.createParameterList();
        this.checkBatchInsert(string);
        int n3 = this.preparedParameters.getInParameterCount() + 1;
        this.testReturn = new int[n3];
        this.functionReturnType = new int[n3];
    }

    private void checkBatchInsert(String string) {
        String string2 = null;
        String string3 = null;
        String string4 = null;
        String string5 = null;
        int n = 0;
        this.batchTableName = null;
        this.batchColumns = null;
        this.batchInsert = false;
        String[] stringArray = (string = string.replaceAll("\\(", " (").trim()).split("\\s+", 4);
        if (stringArray.length < 4) {
            return;
        }
        if (!stringArray[0].equalsIgnoreCase("INSERT") || !stringArray[1].equalsIgnoreCase("INTO")) {
            return;
        }
        string2 = stringArray[2];
        if (stringArray[3].startsWith("(")) {
            n = stringArray[3].indexOf(41);
            if (n < 0) {
                return;
            }
            string3 = stringArray[3].substring(0, n + 1);
            string5 = stringArray[3].substring(n + 1).trim();
        } else {
            string5 = stringArray[3].trim();
        }
        stringArray = string5.split("\\s+", 2);
        if (stringArray.length < 2) {
            return;
        }
        if (!stringArray[0].equalsIgnoreCase("VALUES")) {
            return;
        }
        if (!stringArray[1].startsWith("(")) {
            return;
        }
        n = stringArray[1].indexOf(41);
        if (n < 2) {
            return;
        }
        string4 = stringArray[1].substring(1, n).trim();
        string5 = stringArray[1].substring(n + 1).trim();
        stringArray = string4.split("[\\s,]+");
        for (int i = 0; i < stringArray.length; ++i) {
            if (stringArray[i].equalsIgnoreCase("?")) continue;
            return;
        }
        if (string5 != null && !string5.equalsIgnoreCase("") && !string5.startsWith(";")) {
            return;
        }
        this.batchTableName = string2;
        this.batchColumns = string3;
        this.batchInsert = true;
        this.batchInsertCount = 0;
    }

    public abstract ResultSet createResultSet(Query var1, Field[] var2, VectorTuple var3, ResultCursor var4) throws SQLException;

    public BaseConnection getPGConnection() {
        return this.connection;
    }

    public String getFetchingCursorName() {
        return null;
    }

    public int getFetchSize() {
        return this.fetchSize;
    }

    protected boolean wantsScrollableResultSet() {
        return this.resultsettype != 1003;
    }

    protected boolean wantsHoldableResultSet() {
        return false;
    }

    public ResultSet executeQuery(String string) throws SQLException {
        if (this.preparedQuery != null) {
            throw new PSQLException(GT.tr("Can''t use query methods that take a query string on a PreparedStatement."), PSQLState.WRONG_OBJECT_TYPE);
        }
        if (!this.executeWithFlags(string, 0)) {
            throw new PSQLException(GT.tr("No results were returned by the query."), PSQLState.NO_DATA);
        }
        if (this.result.getNext() != null) {
            throw new PSQLException(GT.tr("Multiple ResultSets were returned by the query."), PSQLState.TOO_MANY_RESULTS);
        }
        return this.result.getResultSet();
    }

    public ResultSet executeQuery() throws SQLException {
        if (!this.executeWithFlags(0)) {
            throw new PSQLException(GT.tr("No results were returned by the query."), PSQLState.NO_DATA);
        }
        if (this.result.getNext() != null) {
            throw new PSQLException(GT.tr("Multiple ResultSets were returned by the query."), PSQLState.TOO_MANY_RESULTS);
        }
        return this.result.getResultSet();
    }

    public int executeUpdate(String string) throws SQLException {
        if (this.preparedQuery != null) {
            throw new PSQLException(GT.tr("Can''t use query methods that take a query string on a PreparedStatement."), PSQLState.WRONG_OBJECT_TYPE);
        }
        if (this.isFunction) {
            this.executeWithFlags(string, 0);
            return 0;
        }
        this.executeWithFlags(string, 0);
        return this.getUpdateCount();
    }

    public int executeUpdate() throws SQLException {
        if (this.isFunction) {
            this.executeWithFlags(0);
            return 0;
        }
        this.executeWithFlags(4);
        return this.getUpdateCount();
    }

    public boolean execute(String string) throws SQLException {
        if (this.preparedQuery != null) {
            throw new PSQLException(GT.tr("Can''t use query methods that take a query string on a PreparedStatement."), PSQLState.WRONG_OBJECT_TYPE);
        }
        return this.executeWithFlags(string, 0);
    }

    public boolean executeWithFlags(String string, int n) throws SQLException {
        this.checkClosed();
        string = this.replaceProcessing(string);
        Query query = this.connection.getQueryExecutor().createSimpleQuery(string);
        this.execute(query, null, 1 | n);
        this.lastSimpleQuery = query;
        return this.result != null && this.result.getResultSet() != null;
    }

    public boolean execute() throws SQLException {
        return this.executeWithFlags(0);
    }

    public boolean executeWithFlags(int n) throws SQLException {
        this.checkClosed();
        this.execute(this.preparedQuery, this.preparedParameters, n);
        if (this.isFunction && this.returnTypeSet) {
            int n2;
            if (this.result == null || this.result.getResultSet() == null) {
                throw new PSQLException(GT.tr("A CallableStatement was executed with nothing returned."), PSQLState.NO_DATA);
            }
            ResultSet resultSet = this.result.getResultSet();
            if (!resultSet.next()) {
                throw new PSQLException(GT.tr("A CallableStatement was executed with nothing returned."), PSQLState.NO_DATA);
            }
            int n3 = resultSet.getMetaData().getColumnCount();
            if (n3 != (n2 = this.preparedParameters.getOutParameterCount())) {
                throw new PSQLException(GT.tr("A CallableStatement was excecuted with an invalid number of parameters"), PSQLState.SYNTAX_ERROR);
            }
            this.callResult = new Object[this.preparedParameters.getParameterCount() + 1];
            int n4 = 0;
            int n5 = 0;
            while (n4 < n3) {
                while (n5 < this.functionReturnType.length && this.functionReturnType[n5] == 0) {
                    ++n5;
                }
                this.callResult[n5] = resultSet.getObject(n4 + 1);
                int n6 = resultSet.getMetaData().getColumnType(n4 + 1);
                if (n6 != this.functionReturnType[n5]) {
                    if (n6 == 8 && this.functionReturnType[n5] == 7) {
                        if (this.callResult[n5] != null) {
                            this.callResult[n5] = new Float(((Double)this.callResult[n5]).floatValue());
                        }
                    } else {
                        throw new PSQLException(GT.tr("A CallableStatement function was executed and the out parameter {0} was of type {1} however type {2} was registered.", new Object[]{"" + n4 + 1, "java.sql.Types=" + n6, "java.sql.Types=" + this.functionReturnType[n5]}), PSQLState.DATA_TYPE_MISMATCH);
                    }
                }
                ++n4;
                ++n5;
            }
            resultSet.close();
            this.result = null;
            return false;
        }
        return this.result != null && this.result.getResultSet() != null;
    }

    protected void execute(Query query, ParameterList parameterList, int n) throws SQLException {
        this.clearWarnings();
        if (this.connection.isInLRS()) {
            throw new PSQLException(GT.tr("Can not execute a query while retrieving a large result set"), PSQLState.OBJECT_NOT_IN_STATE);
        }
        while (this.firstUnclosedResult != null) {
            if (this.firstUnclosedResult.getResultSet() != null) {
                this.firstUnclosedResult.getResultSet().close();
            }
            this.firstUnclosedResult = this.firstUnclosedResult.getNext();
        }
        if (this.lastSimpleQuery != null) {
            this.lastSimpleQuery.close();
            this.lastSimpleQuery = null;
        }
        this.finishLoad(false);
        if (!(this.fetchSize <= 0 || this.wantsScrollableResultSet() || this.connection.getAutoCommit() || this.wantsHoldableResultSet())) {
            n |= 8;
        }
        if (this.preparedQuery != null) {
            ++this.m_useCount;
        }
        if (this.connection.getAutoCommit()) {
            n |= 0x10;
        }
        if (this.getStreamingLRS()) {
            n |= 0x200;
        }
        StatementResultHandler statementResultHandler = new StatementResultHandler();
        this.result = null;
        this.connection.getQueryExecutor().setMaxLRSMemory(this.getMaxLRSMemory());
        this.connection.getQueryExecutor().setCurrentStatement(this);
        if (query.toString(null).toUpperCase().startsWith("COPY ")) {
            this.clearAcceptedRejectedRows();
        }
        this.connection.getQueryExecutor().execute(query, parameterList, (ResultHandler)statementResultHandler, this.maxrows, this.fetchSize, n);
        this.result = this.firstUnclosedResult = statementResultHandler.getResults();
    }

    protected void executeWithStream(Query query, IOStream iOStream, int n) throws SQLException {
        this.clearWarnings();
        while (this.firstUnclosedResult != null) {
            if (this.firstUnclosedResult.getResultSet() != null) {
                this.firstUnclosedResult.getResultSet().close();
            }
            this.firstUnclosedResult = this.firstUnclosedResult.getNext();
        }
        if (this.lastSimpleQuery != null) {
            this.lastSimpleQuery.close();
            this.lastSimpleQuery = null;
        }
        if (this.connection.getAutoCommit()) {
            n |= 0x10;
        }
        StatementResultHandler statementResultHandler = new StatementResultHandler();
        this.result = null;
        this.connection.getQueryExecutor().setCurrentStatement(this);
        this.connection.getQueryExecutor().executeWithStream(query, iOStream, statementResultHandler, n);
        this.result = this.firstUnclosedResult = statementResultHandler.getResults();
    }

    public void setCursorName(String string) throws SQLException {
        this.checkClosed();
    }

    public int getUpdateCount() throws SQLException {
        this.checkClosed();
        if (this.result == null) {
            return -1;
        }
        if (this.isFunction) {
            return 1;
        }
        if (!this.updateCountCleared) {
            return this.result.getUpdateCount();
        }
        return this.getNumAcceptedRows();
    }

    public boolean getMoreResults() throws SQLException {
        if (this.result == null) {
            return false;
        }
        this.result = this.result.getNext();
        while (this.firstUnclosedResult != this.result) {
            if (this.firstUnclosedResult.getResultSet() != null) {
                this.firstUnclosedResult.getResultSet().close();
            }
            this.firstUnclosedResult = this.firstUnclosedResult.getNext();
        }
        return this.result != null && this.result.getResultSet() != null;
    }

    public int getMaxRows() throws SQLException {
        this.checkClosed();
        return this.maxrows;
    }

    public void setMaxRows(int n) throws SQLException {
        this.checkClosed();
        if (n < 0) {
            throw new PSQLException(GT.tr("Maximum number of rows must be a value grater than or equal to 0."), PSQLState.INVALID_PARAMETER_VALUE);
        }
        this.maxrows = n;
    }

    public void setEscapeProcessing(boolean bl) throws SQLException {
        this.checkClosed();
        this.replaceProcessingEnabled = bl;
    }

    public int getQueryTimeout() throws SQLException {
        this.checkClosed();
        return this.timeout;
    }

    public void setQueryTimeout(int n) throws SQLException {
        this.checkClosed();
        if (n != 0) {
            throw Driver.notImplemented(this.getClass(), "setQueryTimeout(int)");
        }
    }

    public void addWarning(SQLWarning sQLWarning) {
        if (this.warnings != null) {
            this.warnings.setNextWarning(sQLWarning);
        } else {
            this.warnings = sQLWarning;
        }
    }

    public SQLWarning getWarnings() throws SQLException {
        this.checkClosed();
        return this.warnings;
    }

    public int getMaxFieldSize() throws SQLException {
        return this.maxfieldSize;
    }

    public void setMaxFieldSize(int n) throws SQLException {
        this.checkClosed();
        if (n < 0) {
            throw new PSQLException(GT.tr("The maximum field size must be a value greater than or equal to 0."), PSQLState.INVALID_PARAMETER_VALUE);
        }
        this.maxfieldSize = n;
    }

    public void clearWarnings() throws SQLException {
        this.warnings = null;
    }

    public ResultSet getResultSet() throws SQLException {
        this.checkClosed();
        if (this.result == null) {
            return null;
        }
        return this.result.getResultSet();
    }

    public void close() throws SQLException {
        if (this.isClosed) {
            return;
        }
        if (this.connection.getQueryExecutor().getCurrentStatement() == this) {
            this.finishLoad(true);
        }
        while (this.firstUnclosedResult != null) {
            if (this.firstUnclosedResult.getResultSet() != null) {
                this.firstUnclosedResult.getResultSet().close();
            }
            this.firstUnclosedResult = this.firstUnclosedResult.getNext();
        }
        if (this.lastSimpleQuery != null) {
            this.lastSimpleQuery.close();
        }
        if (this.preparedQuery != null) {
            this.preparedQuery.close();
        }
        this.firstUnclosedResult = null;
        this.result = null;
        this.isClosed = true;
    }

    public void finishLoad(boolean bl) throws SQLException {
        if (this.connection.isInLoad() && (bl || !this.connection.isInCopyIn())) {
            if (this.connection.loadingBatches()) {
                // empty if block
            }
            this.finishCopyIn();
            this.batchInsertCount = 0;
            if (this.connection.loadingBatches()) {
                AbstractJdbc2ResultSet abstractJdbc2ResultSet = (AbstractJdbc2ResultSet)this.getResultSet();
                if (abstractJdbc2ResultSet != null) {
                    abstractJdbc2ResultSet.ignoreMaxRows(true);
                    while (abstractJdbc2ResultSet.next()) {
                    }
                    abstractJdbc2ResultSet.ignoreMaxRows(false);
                }
                this.connection.setInLRS(false);
            }
        }
    }

    protected void finalize() {
        try {
            this.close();
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
    }

    protected String replaceProcessing(String string) throws SQLException {
        if (this.replaceProcessingEnabled) {
            int n = string.length();
            StringBuffer stringBuffer = new StringBuffer(n);
            int n2 = 0;
            while (n2 < n) {
                if ((n2 = AbstractJdbc2Statement.parseSql(string, n2, stringBuffer, false)) >= n) continue;
                stringBuffer.append(string.charAt(n2));
                ++n2;
            }
            return stringBuffer.toString();
        }
        return string;
    }

    protected static int parseSql(String string, int n, StringBuffer stringBuffer, boolean bl) throws SQLException {
        int n2 = 0;
        int n3 = string.length();
        int n4 = 0;
        boolean bl2 = false;
        --n;
        while (!bl2 && ++n < n3) {
            char c = string.charAt(n);
            switch (n2) {
                case 0: {
                    int n5;
                    if (c == '\'') {
                        n2 = 1;
                    } else if (c == '\"') {
                        n2 = 6;
                    } else if (c == '(') {
                        ++n4;
                    } else if (c == ')') {
                        if (--n4 < 0) {
                            bl2 = true;
                            break;
                        }
                    } else {
                        if (bl && c == ',' && n4 == 0) {
                            bl2 = true;
                            break;
                        }
                        if (c == '{' && n + 1 < n3) {
                            char c2 = string.charAt(n + 1);
                            int n6 = n5 = n + 2 < n3 ? (int)string.charAt(n + 2) : 0;
                            if (c2 == 'd' || c2 == 'D') {
                                n2 = 3;
                                ++n;
                                stringBuffer.append("DATE ");
                                break;
                            }
                            if (c2 == 't' || c2 == 'T') {
                                n2 = 3;
                                if (n5 == 115 || n5 == 83) {
                                    n += 2;
                                    stringBuffer.append("TIMESTAMP ");
                                    break;
                                }
                                ++n;
                                stringBuffer.append("TIME ");
                                break;
                            }
                            if (c2 == 'f' || c2 == 'F') {
                                n2 = 4;
                                n += n5 == 110 || n5 == 78 ? 2 : 1;
                                break;
                            }
                            if (c2 == 'o' || c2 == 'O') {
                                n2 = 5;
                                n += n5 == 106 || n5 == 74 ? 2 : 1;
                                break;
                            }
                            if (c2 == 'e' || c2 == 'E') {
                                n2 = 7;
                                break;
                            }
                        }
                    }
                    stringBuffer.append(c);
                    break;
                }
                case 1: {
                    if (c == '\'') {
                        n2 = 0;
                    } else if (c == '\\') {
                        n2 = 2;
                    }
                    stringBuffer.append(c);
                    break;
                }
                case 6: {
                    if (c == '\"') {
                        n2 = 0;
                    }
                    stringBuffer.append(c);
                    break;
                }
                case 2: {
                    n2 = 1;
                    stringBuffer.append(c);
                    break;
                }
                case 4: {
                    int n5 = string.indexOf(40, n);
                    if (n5 != -1) {
                        String string2 = string.substring(n, n5).trim();
                        n = n5 + 1;
                        StringBuffer stringBuffer2 = new StringBuffer();
                        n = AbstractJdbc2Statement.parseSql(string, n, stringBuffer2, false);
                        stringBuffer.append(AbstractJdbc2Statement.escapeFunction(string2, stringBuffer2.toString()));
                    }
                    ++n;
                    while (n < n3 && string.charAt(n) != '}') {
                        stringBuffer.append(string.charAt(n));
                    }
                    n2 = 0;
                    break;
                }
                case 3: 
                case 5: 
                case 7: {
                    if (c == '}') {
                        n2 = 0;
                        break;
                    }
                    stringBuffer.append(c);
                }
            }
        }
        return n;
    }

    protected static String escapeFunction(String string, String string2) throws SQLException {
        Object object;
        int n = string2.length();
        ArrayList<Object> arrayList = new ArrayList<Object>();
        for (int i = 0; i < n; ++i) {
            int n2 = i;
            object = new StringBuffer();
            if (n2 == (i = AbstractJdbc2Statement.parseSql(string2, i, (StringBuffer)object, true))) continue;
            arrayList.add(object);
        }
        try {
            object = EscapedFunctions.getFunction(string);
            return (String)((Method)object).invoke(null, arrayList);
        }
        catch (InvocationTargetException invocationTargetException) {
            if (invocationTargetException.getTargetException() instanceof SQLException) {
                throw (SQLException)invocationTargetException.getTargetException();
            }
            throw new PSQLException(invocationTargetException.getTargetException().getMessage(), PSQLState.SYSTEM_ERROR);
        }
        catch (Exception exception) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append(string).append('(');
            for (int i = 0; i < arrayList.size(); ++i) {
                stringBuffer.append(arrayList.get(i));
                if (i == arrayList.size() - 1) continue;
                stringBuffer.append(',');
            }
            stringBuffer.append(')');
            return stringBuffer.toString();
        }
    }

    public int getInsertedOID() throws SQLException {
        this.checkClosed();
        if (this.result == null) {
            return 0;
        }
        return (int)this.result.getInsertOID();
    }

    public long getLastOID() throws SQLException {
        this.checkClosed();
        if (this.result == null) {
            return 0L;
        }
        return this.result.getInsertOID();
    }

    public void setNull(int n, int n2) throws SQLException {
        int n3;
        this.checkClosed();
        switch (n2) {
            case -6: 
            case -5: 
            case 4: 
            case 5: {
                n3 = 6;
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                n3 = 7;
                break;
            }
            case 2: 
            case 3: {
                n3 = 16;
                break;
            }
            case 1: {
                n3 = 8;
                break;
            }
            case 12: {
                n3 = 9;
                break;
            }
            case 91: {
                n3 = 10;
                break;
            }
            case 92: {
                n3 = 11;
                break;
            }
            case 93: {
                n3 = 12;
                break;
            }
            case -7: {
                n3 = 5;
                break;
            }
            case -3: 
            case -2: {
                n3 = 117;
                break;
            }
            case -4: {
                n3 = 17;
                break;
            }
            case 0: 
            case 1111: 
            case 2001: 
            case 2002: 
            case 2003: {
                n3 = 0;
                break;
            }
            default: {
                throw new PSQLException(GT.tr("Unknown Types value."), PSQLState.INVALID_PARAMETER_TYPE);
            }
        }
        if (this.adjustIndex) {
            --n;
        }
        this.preparedParameters.setNull(n, n3);
    }

    public void setBoolean(int n, boolean bl) throws SQLException {
        this.checkClosed();
        this.bindString(n, bl ? "1" : "0", 5);
    }

    public void setByte(int n, byte by) throws SQLException {
        this.checkClosed();
        this.bindLiteral(n, Integer.toString(by), 6);
    }

    public void setShort(int n, short s) throws SQLException {
        this.checkClosed();
        this.bindLiteral(n, Integer.toString(s), 6);
    }

    public void setInt(int n, int n2) throws SQLException {
        this.checkClosed();
        this.bindLiteral(n, Integer.toString(n2), 6);
    }

    public void setLong(int n, long l) throws SQLException {
        this.checkClosed();
        this.bindLiteral(n, Long.toString(l), 6);
    }

    public void setFloat(int n, float f) throws SQLException {
        this.checkClosed();
        this.bindLiteral(n, Float.toString(f), 7);
    }

    public void setDouble(int n, double d) throws SQLException {
        this.checkClosed();
        NumberFormat numberFormat = NumberFormat.getInstance();
        numberFormat.setMaximumIntegerDigits(15);
        numberFormat.setMaximumFractionDigits(15);
        numberFormat.setGroupingUsed(false);
        this.bindLiteral(n, numberFormat.format(d), 7);
    }

    public void setBigDecimal(int n, BigDecimal bigDecimal) throws SQLException {
        this.checkClosed();
        if (bigDecimal == null) {
            this.setNull(n, 3);
        } else {
            this.bindLiteral(n, bigDecimal.toString(), 16);
        }
    }

    public void setString(int n, String string) throws SQLException {
        this.checkClosed();
        this.setString(n, string, this.connection.getStringVarcharFlag() ? 9 : 0);
    }

    protected void setString(int n, String string, int n2) throws SQLException {
        this.checkClosed();
        if (string == null) {
            if (this.adjustIndex) {
                --n;
            }
            this.preparedParameters.setNull(n, n2);
        } else {
            this.bindString(n, string, n2);
        }
    }

    public void setBytes(int n, byte[] byArray) throws SQLException {
        this.checkClosed();
        if (null == byArray) {
            this.setNull(n, 17);
            return;
        }
        this.setString(n, PGbytea.toPGString(byArray), 17);
    }

    public void setDate(int n, Date date) throws SQLException {
        this.setDate(n, date, null);
    }

    public void setTime(int n, Time time) throws SQLException {
        this.setTime(n, time, null);
    }

    public void setTimestamp(int n, Timestamp timestamp) throws SQLException {
        this.setTimestamp(n, timestamp, null);
    }

    private void setCharacterStreamPost71(int n, InputStream inputStream, int n2, String string) throws SQLException {
        if (inputStream == null) {
            this.setNull(n, 12);
            return;
        }
        if (n2 < 0) {
            throw new PSQLException(GT.tr("Invalid stream length {0}.", new Integer(n2)), PSQLState.INVALID_PARAMETER_VALUE);
        }
        try {
            int n3;
            InputStreamReader inputStreamReader = new InputStreamReader(inputStream, string);
            char[] cArray = new char[n2];
            int n4 = 0;
            while ((n3 = inputStreamReader.read(cArray, n4, n2 - n4)) != -1 && (n4 += n3) != n2) {
            }
            this.setString(n, new String(cArray, 0, n4), 9);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new PSQLException(GT.tr("The JVM claims not to support the {0} encoding.", string), PSQLState.UNEXPECTED_ERROR, (Throwable)unsupportedEncodingException);
        }
        catch (IOException iOException) {
            throw new PSQLException(GT.tr("Provided InputStream failed."), PSQLState.UNEXPECTED_ERROR, (Throwable)iOException);
        }
    }

    public void setAsciiStream(int n, InputStream inputStream, int n2) throws SQLException {
        this.checkClosed();
        if (inputStream == null) {
            this.setNull(n, 12);
            return;
        }
        if (n2 < 0) {
            throw new PSQLException(GT.tr("Invalid stream length {0}.", new Integer(n2)), PSQLState.INVALID_PARAMETER_VALUE);
        }
        byte[] byArray = new byte[n2];
        int n3 = 0;
        try {
            n3 = inputStream.read(byArray, 0, n2);
        }
        catch (IOException iOException) {
            throw new PSQLException(GT.tr("Can not read from the stream."), PSQLState.INVALID_PARAMETER_VALUE);
        }
        if (n3 < n2) {
            throw new PSQLException(GT.tr("Can not read from the stream."), PSQLState.INVALID_PARAMETER_VALUE);
        }
        this.setString(n, new String(byArray), 9);
    }

    public void setUnicodeStream(int n, InputStream inputStream, int n2) throws SQLException {
        this.checkClosed();
        if (this.connection.haveMinimumCompatibleVersion("7.2")) {
            this.setCharacterStreamPost71(n, inputStream, n2, "UTF-8");
        } else {
            this.setBinaryStream(n, inputStream, n2);
        }
    }

    public void setBinaryStream(int n, InputStream inputStream, int n2) throws SQLException {
        this.checkClosed();
        if (inputStream == null) {
            this.setNull(n, -3);
            return;
        }
        if (n2 < 0) {
            throw new PSQLException(GT.tr("Invalid stream length {0}.", new Integer(n2)), PSQLState.INVALID_PARAMETER_VALUE);
        }
        byte[] byArray = new byte[n2];
        int n3 = 0;
        try {
            n3 = inputStream.read(byArray, 0, n2);
        }
        catch (IOException iOException) {
            throw new PSQLException(GT.tr("Can not read from the stream."), PSQLState.INVALID_PARAMETER_VALUE);
        }
        if (n3 < n2) {
            throw new PSQLException(GT.tr("Can not read from the stream."), PSQLState.INVALID_PARAMETER_VALUE);
        }
        this.setString(n, PGbytea.toPGString(byArray), 17);
    }

    public void clearParameters() throws SQLException {
        this.preparedParameters.clear();
    }

    private PGType createInternalType(Object object, int n) throws PSQLException {
        if (object instanceof Byte) {
            return PGByte.castToServerType((Byte)object, n);
        }
        if (object instanceof Short) {
            return PGShort.castToServerType((Short)object, n);
        }
        if (object instanceof Integer) {
            return PGInteger.castToServerType((Integer)object, n);
        }
        if (object instanceof Long) {
            return PGLong.castToServerType((Long)object, n);
        }
        if (object instanceof Double) {
            return PGDouble.castToServerType((Double)object, n);
        }
        if (object instanceof Float) {
            return PGFloat.castToServerType((Float)object, n);
        }
        if (object instanceof String) {
            return PGString.castToServerType((String)object, n);
        }
        if (object instanceof BigDecimal) {
            return PGBigDecimal.castToServerType((BigDecimal)object, n);
        }
        if (object instanceof Number) {
            return PGNumber.castToServerType((Number)object, n);
        }
        if (object instanceof Boolean) {
            return PGBoolean.castToServerType((Boolean)object, n);
        }
        return new PGUnknown(object);
    }

    private void setPGobject(int n, PGobject pGobject) throws SQLException {
        String string = pGobject.getType();
        int n2 = this.connection.getPGType(string);
        if (n2 == 0) {
            throw new PSQLException(GT.tr("Unknown type {0}.", string), PSQLState.INVALID_PARAMETER_TYPE);
        }
        this.setString(n, pGobject.getValue(), n2);
    }

    public void setObject(int n, Object object, int n2, int n3) throws SQLException {
        this.checkClosed();
        if (object == null) {
            this.setNull(n, n2);
            return;
        }
        PGType pGType = this.createInternalType(object, n2);
        switch (n2) {
            case -5: {
                this.bindLiteral(n, ((Object)pGType).toString(), 6);
                break;
            }
            case 6: 
            case 8: {
                this.bindLiteral(n, ((Object)pGType).toString(), 7);
                break;
            }
            case 2: 
            case 3: {
                this.bindLiteral(n, ((Object)pGType).toString(), 16);
                break;
            }
            case 1: {
                this.setString(n, ((Object)pGType).toString(), 8);
                break;
            }
            case 12: {
                this.setString(n, ((Object)pGType).toString(), 9);
                break;
            }
            case 91: {
                if (object instanceof Date) {
                    this.setDate(n, (Date)object);
                    break;
                }
                Date date = object instanceof java.util.Date ? new Date(((java.util.Date)object).getTime()) : this.connection.getTimestampUtils().toDate(null, object.toString());
                this.setDate(n, date);
                break;
            }
            case 92: {
                if (object instanceof Time) {
                    this.setTime(n, (Time)object);
                    break;
                }
                Time time = object instanceof java.util.Date ? new Time(((java.util.Date)object).getTime()) : this.connection.getTimestampUtils().toTime(null, object.toString());
                this.setTime(n, time);
                break;
            }
            case 93: {
                if (object instanceof Timestamp) {
                    this.setTimestamp(n, (Timestamp)object);
                    break;
                }
                Timestamp timestamp = object instanceof java.util.Date ? new Timestamp(((java.util.Date)object).getTime()) : this.connection.getTimestampUtils().toTimestamp(null, object.toString());
                this.setTimestamp(n, timestamp);
                break;
            }
            case -7: {
                this.bindLiteral(n, ((Object)pGType).toString(), 5);
                break;
            }
            case -4: 
            case -3: 
            case -2: {
                this.setObject(n, object);
                break;
            }
            case 2003: {
                if (object instanceof Array) {
                    this.setArray(n, (Array)object);
                    break;
                }
                throw new PSQLException(GT.tr("Cannot cast an instance of {0} to type {1}", new Object[]{object.getClass().getName(), "Types.ARRAY"}), PSQLState.INVALID_PARAMETER_TYPE);
            }
            case 1111: {
                if (object instanceof PGobject) {
                    this.setPGobject(n, (PGobject)object);
                    break;
                }
                throw new PSQLException(GT.tr("Cannot cast an instance of {0} to type {1}", new Object[]{object.getClass().getName(), "Types.OTHER"}), PSQLState.INVALID_PARAMETER_TYPE);
            }
            default: {
                throw new PSQLException(GT.tr("Unsupported Types value: {0}", new Integer(n2)), PSQLState.INVALID_PARAMETER_TYPE);
            }
        }
    }

    public void setObject(int n, Object object, int n2) throws SQLException {
        this.setObject(n, object, n2, 0);
    }

    public void setObject(int n, Object object) throws SQLException {
        this.checkClosed();
        if (object == null) {
            this.setNull(n, 1111);
        } else if (object instanceof String) {
            this.setString(n, (String)object);
        } else if (object instanceof BigDecimal) {
            this.setBigDecimal(n, (BigDecimal)object);
        } else if (object instanceof Short) {
            this.setShort(n, (Short)object);
        } else if (object instanceof Integer) {
            this.setInt(n, (Integer)object);
        } else if (object instanceof Long) {
            this.setLong(n, (Long)object);
        } else if (object instanceof Float) {
            this.setFloat(n, ((Float)object).floatValue());
        } else if (object instanceof Double) {
            this.setDouble(n, (Double)object);
        } else if (object instanceof byte[]) {
            this.setBytes(n, (byte[])object);
        } else if (object instanceof Date) {
            this.setDate(n, (Date)object);
        } else if (object instanceof Time) {
            this.setTime(n, (Time)object);
        } else if (object instanceof Timestamp) {
            this.setTimestamp(n, (Timestamp)object);
        } else if (object instanceof Boolean) {
            this.setBoolean(n, (Boolean)object);
        } else if (object instanceof Array) {
            this.setArray(n, (Array)object);
        } else if (object instanceof PGobject) {
            this.setPGobject(n, (PGobject)object);
        } else {
            throw new PSQLException(GT.tr("Can''t infer the SQL type to use for an instance of {0}. Use setObject() with an explicit Types value to specify the type to use.", object.getClass().getName()), PSQLState.INVALID_PARAMETER_TYPE);
        }
    }

    public void registerOutParameter(int n, int n2, boolean bl) throws SQLException {
        this.checkClosed();
        switch (n2) {
            case 6: {
                n2 = 8;
                break;
            }
            case -4: 
            case -3: {
                n2 = -2;
                break;
            }
        }
        if (!this.isFunction) {
            throw new PSQLException(GT.tr("This statement does not declare an OUT parameter.  Use '{' ?= call ... '}' to declare one."), PSQLState.STATEMENT_NOT_ALLOWED_IN_FUNCTION_CALL);
        }
        this.checkIndex(n);
        if (bl) {
            this.preparedParameters.registerOutParameter(n, n2);
        }
        this.functionReturnType[n - 1] = n2;
        this.testReturn[n - 1] = n2;
        if (this.functionReturnType[n - 1] == 1 || this.functionReturnType[n - 1] == -1) {
            this.testReturn[n - 1] = 12;
        } else if (this.functionReturnType[n - 1] == 6) {
            this.testReturn[n - 1] = 7;
        }
        this.returnTypeSet = true;
    }

    public void registerOutParameter(int n, int n2, int n3, boolean bl) throws SQLException {
        this.registerOutParameter(n, n2, bl);
    }

    public boolean wasNull() throws SQLException {
        return this.callResult[this.lastIndex - 1] == null;
    }

    public String getString(int n) throws SQLException {
        this.checkClosed();
        this.checkIndex(n, 12, "String");
        return (String)this.callResult[n - 1];
    }

    public boolean getBoolean(int n) throws SQLException {
        this.checkClosed();
        this.checkIndex(n, -7, "Boolean");
        if (this.callResult[n - 1] == null) {
            return false;
        }
        return (Boolean)this.callResult[n - 1];
    }

    public byte getByte(int n) throws SQLException {
        throw new PSQLException(GT.tr("getByte is not supported."), PSQLState.NOT_IMPLEMENTED);
    }

    public short getShort(int n) throws SQLException {
        throw new PSQLException(GT.tr("getShort is not supported."), PSQLState.NOT_IMPLEMENTED);
    }

    public int getInt(int n) throws SQLException {
        throw new PSQLException(GT.tr("getInt is not supported."), PSQLState.NOT_IMPLEMENTED);
    }

    public long getLong(int n) throws SQLException {
        this.checkClosed();
        this.checkIndex(n, -5, "Long");
        if (this.callResult[n - 1] == null) {
            return 0L;
        }
        return (Long)this.callResult[n - 1];
    }

    public float getFloat(int n) throws SQLException {
        throw new PSQLException(GT.tr("getFloat is not supported."), PSQLState.NOT_IMPLEMENTED);
    }

    public double getDouble(int n) throws SQLException {
        this.checkClosed();
        this.checkIndex(n, 8, "Double");
        if (this.callResult[n - 1] == null) {
            return 0.0;
        }
        return (Double)this.callResult[n - 1];
    }

    public BigDecimal getBigDecimal(int n, int n2) throws SQLException {
        this.checkClosed();
        this.checkIndex(n, 2, "BigDecimal");
        return (BigDecimal)this.callResult[n - 1];
    }

    public byte[] getBytes(int n) throws SQLException {
        this.checkClosed();
        this.checkIndex(n, -3, -2, "Bytes");
        return (byte[])this.callResult[n - 1];
    }

    public Date getDate(int n) throws SQLException {
        this.checkClosed();
        this.checkIndex(n, 91, "Date");
        return (Date)this.callResult[n - 1];
    }

    public Time getTime(int n) throws SQLException {
        this.checkClosed();
        this.checkIndex(n, 92, "Time");
        return (Time)this.callResult[n - 1];
    }

    public Timestamp getTimestamp(int n) throws SQLException {
        this.checkClosed();
        this.checkIndex(n, 93, "Timestamp");
        return (Timestamp)this.callResult[n - 1];
    }

    public Object getObject(int n) throws SQLException {
        this.checkClosed();
        this.checkIndex(n);
        return this.callResult[n - 1];
    }

    public String toString() {
        if (this.preparedQuery == null) {
            return super.toString();
        }
        return this.preparedQuery.toString(this.preparedParameters);
    }

    private void bindLiteral(int n, String string, int n2) throws SQLException {
        if (this.adjustIndex) {
            --n;
        }
        this.preparedParameters.setLiteralParameter(n, string, n2);
    }

    private void bindString(int n, String string, int n2) throws SQLException {
        if (this.adjustIndex) {
            --n;
        }
        this.preparedParameters.setStringParameter(n, string, n2);
    }

    private String modifyJdbcCall(String string) throws SQLException {
        this.checkClosed();
        this.isFunction = false;
        int n = string.length();
        int n2 = 1;
        boolean bl = false;
        boolean bl2 = false;
        this.outParmBeforeFunc = false;
        int n3 = -1;
        int n4 = -1;
        boolean bl3 = false;
        int n5 = 0;
        block10: while (n5 < n && !bl3) {
            char c = string.charAt(n5);
            switch (n2) {
                case 1: {
                    if (c == '{') {
                        ++n5;
                        ++n2;
                        continue block10;
                    }
                    if (Character.isWhitespace(c)) {
                        ++n5;
                        continue block10;
                    }
                    n5 = n;
                    continue block10;
                }
                case 2: {
                    if (c == '?') {
                        this.isFunction = true;
                        this.outParmBeforeFunc = true;
                        ++n5;
                        ++n2;
                        continue block10;
                    }
                    if (c == 'c') {
                        n2 += 3;
                        continue block10;
                    }
                    if (Character.isWhitespace(c)) {
                        ++n5;
                        continue block10;
                    }
                    bl3 = true;
                    continue block10;
                }
                case 3: {
                    if (c == '=') {
                        ++n5;
                        ++n2;
                        continue block10;
                    }
                    if (Character.isWhitespace(c)) {
                        ++n5;
                        continue block10;
                    }
                    bl3 = true;
                    continue block10;
                }
                case 4: {
                    if (c == 'c' || c == 'C') {
                        ++n2;
                        continue block10;
                    }
                    if (Character.isWhitespace(c)) {
                        ++n5;
                        continue block10;
                    }
                    bl3 = true;
                    continue block10;
                }
                case 5: {
                    if ((c == 'c' || c == 'C') && n5 + 4 <= n && string.substring(n5, n5 + 4).equalsIgnoreCase("call")) {
                        this.isFunction = true;
                        n5 += 4;
                        ++n2;
                        continue block10;
                    }
                    if (Character.isWhitespace(c)) {
                        ++n5;
                        continue block10;
                    }
                    bl3 = true;
                    continue block10;
                }
                case 6: {
                    if (Character.isWhitespace(c)) {
                        ++n2;
                        n3 = ++n5;
                        continue block10;
                    }
                    bl3 = true;
                    continue block10;
                }
                case 7: {
                    if (c == '\'') {
                        bl = !bl;
                        ++n5;
                        continue block10;
                    }
                    if (bl && c == '\\') {
                        n5 += 2;
                        continue block10;
                    }
                    if (!bl && c == '{') {
                        bl2 = !bl2;
                        ++n5;
                        continue block10;
                    }
                    if (!bl && c == '}') {
                        if (!bl2) {
                            n4 = n5++;
                            ++n2;
                            continue block10;
                        }
                        bl2 = false;
                        continue block10;
                    }
                    if (!bl && c == ';') {
                        bl3 = true;
                        continue block10;
                    }
                    ++n5;
                    continue block10;
                }
                case 8: {
                    if (Character.isWhitespace(c)) {
                        ++n5;
                        continue block10;
                    }
                    bl3 = true;
                    continue block10;
                }
            }
            throw new IllegalStateException("somehow got into bad state " + n2);
        }
        if (n5 == n && !bl3) {
            if (n2 == 1) {
                return string;
            }
            if (n2 != 8) {
                bl3 = true;
            }
        }
        if (bl3) {
            throw new PSQLException(GT.tr("Malformed function or procedure escape syntax at offset {0}.", new Integer(n5)), PSQLState.STATEMENT_NOT_ALLOWED_IN_FUNCTION_CALL);
        }
        if (this.connection.haveMinimumServerVersion("8.1") && ((AbstractJdbc2Connection)this.connection).getProtocolVersion() == 3) {
            String string2 = string.substring(n3, n4);
            StringBuffer stringBuffer = new StringBuffer(string2);
            if (this.outParmBeforeFunc) {
                boolean bl4 = false;
                int n6 = string2.indexOf(40) + 1;
                int n7 = string2.indexOf(41);
                for (int i = n6; i < n7; ++i) {
                    if (Character.isWhitespace(stringBuffer.charAt(i))) continue;
                    bl4 = true;
                    break;
                }
                if (bl4) {
                    stringBuffer.insert(n6, "?,");
                } else {
                    stringBuffer.insert(n6, "?");
                }
            }
            return "select * from " + stringBuffer.toString() + " as result";
        }
        return "select " + string.substring(n3, n4) + " as result";
    }

    protected void checkIndex(int n, int n2, int n3, String string) throws SQLException {
        this.checkIndex(n);
        if (n2 != this.testReturn[n - 1] && n3 != this.testReturn[n - 1]) {
            throw new PSQLException(GT.tr("Parameter of type {0} was registered, but call to get{1} (sqltype={2}) was made.", new Object[]{"java.sql.Types=" + this.testReturn, string, "java.sql.Types=" + n2}), PSQLState.MOST_SPECIFIC_TYPE_DOES_NOT_MATCH);
        }
    }

    protected void checkIndex(int n, int n2, String string) throws SQLException {
        this.checkIndex(n);
        if (n2 != this.testReturn[n - 1]) {
            throw new PSQLException(GT.tr("Parameter of type {0} was registered, but call to get{1} (sqltype={2}) was made.", new Object[]{"java.sql.Types=" + this.testReturn[n - 1], string, "java.sql.Types=" + n2}), PSQLState.MOST_SPECIFIC_TYPE_DOES_NOT_MATCH);
        }
    }

    private void checkIndex(int n) throws SQLException {
        if (!this.isFunction) {
            throw new PSQLException(GT.tr("A CallableStatement was declared, but no call to registerOutParameter(1, <some type>) was made."), PSQLState.STATEMENT_NOT_ALLOWED_IN_FUNCTION_CALL);
        }
        this.lastIndex = n;
    }

    public void setPrepareThreshold(int n) throws SQLException {
        this.checkClosed();
        if (n < 0) {
            n = 0;
        }
        this.m_prepareThreshold = n;
    }

    public int getPrepareThreshold() {
        return this.m_prepareThreshold;
    }

    public void setUseServerPrepare(boolean bl) throws SQLException {
        this.setPrepareThreshold(bl ? 1 : 0);
    }

    public boolean isUseServerPrepare() {
        return this.preparedQuery != null;
    }

    public void setStreamingLRS(boolean bl) {
        this.streamingLRS = bl;
    }

    public boolean getStreamingLRS() {
        return this.streamingLRS;
    }

    public void setMaxLRSMemory(int n) {
        this.maxLRSMemory = n < 16384 ? 16384 : n;
    }

    public int getMaxLRSMemory() {
        return this.maxLRSMemory;
    }

    public void setDirectBatchInsert(boolean bl) {
        this.directBatchInsert = bl;
    }

    public boolean getDirectBatchInsert() {
        return this.directBatchInsert;
    }

    public void setBatchInsertEnforceLength(boolean bl) {
        this.batchInsertEnforceLength = bl;
    }

    public boolean getBatchInsertEnforceLength() {
        return this.batchInsertEnforceLength;
    }

    public void setBatchInsertRecordTerminator(String string) {
        this.batchInsertRecordTerminator = string;
    }

    public String getBatchInsertRecordTerminator() {
        return this.batchInsertRecordTerminator;
    }

    public void setAbortBatchInsertOnError(boolean bl) {
        this.abortBatchInsertOnError = bl;
    }

    public boolean getAbortBatchInsertOnError() {
        return this.abortBatchInsertOnError;
    }

    public void setManagedBatchInsert(boolean bl) {
    }

    public boolean getManagedBatchInsert() {
        return false;
    }

    public void setBinaryBatchInsert(boolean bl) {
        this.binaryBatchInsert = bl;
    }

    public boolean getBinaryBatchInsert() {
        return this.binaryBatchInsert;
    }

    public void setUse35CopyParameters(boolean bl) {
    }

    public boolean getUse35CopyParameters() {
        return false;
    }

    public void setUse35CopyFormat(boolean bl) {
        this.use35CopyFormat = bl;
    }

    public boolean getUse35CopyFormat() {
        return this.use35CopyFormat;
    }

    protected void checkClosed() throws SQLException {
        if (this.isClosed) {
            throw new PSQLException(GT.tr("This statement has been closed."), PSQLState.OBJECT_NOT_IN_STATE);
        }
    }

    public void addBatch(String string) throws SQLException {
        this.checkClosed();
        if (this.preparedQuery != null) {
            throw new PSQLException(GT.tr("Can''t use query methods that take a query string on a PreparedStatement."), PSQLState.WRONG_OBJECT_TYPE);
        }
        if (this.batchStatements == null) {
            this.batchStatements = new ArrayList();
            this.batchParameters = new ArrayList();
        }
        this.batchStatements.add(this.connection.getQueryExecutor().createSimpleQuery(string));
        this.batchParameters.add(null);
    }

    public void clearBatch() throws SQLException {
        if (this.batchStatements != null) {
            this.batchStatements.clear();
            this.batchParameters.clear();
        }
    }

    private void updateAcceptedRejectedRows() {
        this.clearAcceptedRejectedRows();
        try {
            Statement statement = this.connection.createStatement();
            ResultSet resultSet = statement.executeQuery("select get_num_accepted_rows()");
            if (resultSet.next()) {
                this.numAcceptedRows = resultSet.getLong(1);
            }
            resultSet.close();
            resultSet = statement.executeQuery("select get_num_rejected_rows()");
            if (resultSet.next()) {
                this.numRejectedRows = resultSet.getLong(1);
            }
            resultSet.close();
            statement.close();
        }
        catch (Exception exception) {
            this.clearAcceptedRejectedRows();
        }
    }

    protected void clearAcceptedRejectedRows() {
        this.updateCountCleared = true;
        this.numAcceptedRows = 0L;
        this.numRejectedRows = 0L;
    }

    public int[] executeBatch() throws SQLException {
        this.checkClosed();
        if (this.batchInsert) {
            int[] nArray = new int[this.batchInsertCount];
            if (this.result != null) {
                this.result.setUpdateCount(this.batchInsertCount);
                this.updateCountCleared = false;
            }
            if (this.connection.loadingBatches()) {
                ResultSet resultSet;
                for (int i = 0; i < this.batchInsertCount; ++i) {
                    nArray[i] = 1;
                }
                try {
                    if (this.connection.getAutoCommit()) {
                        this.executeWithStream(null, null, 256);
                    } else {
                        this.executeWithStream(null, null, 4096);
                    }
                }
                catch (SQLException sQLException) {
                    this.batchInsertCount = 0;
                    throw sQLException;
                }
                if (this.result != null && (resultSet = this.result.getResultSet()) != null) {
                    int n = 0;
                    while (resultSet.next()) {
                        int n2 = Integer.parseInt(new String(resultSet.getBytes(1))) - 1;
                        if ((n2 -= this.batchTotalRows) >= 0 && n2 < this.batchInsertCount) {
                            nArray[n2] = -3;
                            ++n;
                            continue;
                        }
                        this.batchInsertCount = 0;
                        throw new PSQLException(GT.tr("Error: server reported out-of-range rejected row."), PSQLState.DATA_ERROR);
                    }
                    resultSet.close();
                    this.result.setUpdateCount(this.batchInsertCount - n);
                    this.updateCountCleared = false;
                }
                this.batchTotalRows += this.batchInsertCount;
            }
            this.batchInsertCount = 0;
            return nArray;
        }
        this.clearWarnings();
        if (this.batchStatements == null || this.batchStatements.isEmpty()) {
            return new int[0];
        }
        int n = this.batchStatements.size();
        int[] nArray = new int[n];
        Query[] queryArray = this.batchStatements.toArray(new Query[this.batchStatements.size()]);
        ParameterList[] parameterListArray = this.batchParameters.toArray(new ParameterList[this.batchParameters.size()]);
        this.batchStatements.clear();
        this.batchParameters.clear();
        while (this.firstUnclosedResult != null) {
            if (this.firstUnclosedResult.getResultSet() != null) {
                this.firstUnclosedResult.getResultSet().close();
            }
            this.firstUnclosedResult = this.firstUnclosedResult.getNext();
        }
        if (this.lastSimpleQuery != null) {
            this.lastSimpleQuery.close();
            this.lastSimpleQuery = null;
        }
        int n3 = 4;
        n3 |= 1;
        if (this.connection.getAutoCommit()) {
            n3 |= 0x10;
        }
        this.result = null;
        BatchResultHandler batchResultHandler = new BatchResultHandler(queryArray, parameterListArray, nArray);
        this.connection.getQueryExecutor().setCurrentStatement(this);
        this.connection.getQueryExecutor().execute(queryArray, parameterListArray, (ResultHandler)batchResultHandler, this.maxrows, this.fetchSize, n3);
        return nArray;
    }

    public void cancel() throws SQLException {
        this.batchInsertCount = 0;
        this.connection.getQueryExecutor().resetCopyIn(true);
        this.connection.cancelQuery();
        if (this.connection.isInLRS()) {
            AbstractJdbc2ResultSet abstractJdbc2ResultSet = (AbstractJdbc2ResultSet)this.getResultSet();
            if (abstractJdbc2ResultSet != null) {
                abstractJdbc2ResultSet.ignoreMaxRows(true);
                while (abstractJdbc2ResultSet.next()) {
                }
                abstractJdbc2ResultSet.ignoreMaxRows(false);
            }
            this.connection.setInLRS(false);
        }
    }

    public Connection getConnection() throws SQLException {
        return this.connection;
    }

    public int getFetchDirection() {
        return this.fetchdirection;
    }

    public int getResultSetConcurrency() {
        return this.concurrency;
    }

    public int getResultSetType() {
        return this.resultsettype;
    }

    public void setFetchDirection(int n) throws SQLException {
        switch (n) {
            case 1000: 
            case 1001: 
            case 1002: {
                this.fetchdirection = n;
                break;
            }
            default: {
                throw new PSQLException(GT.tr("Invalid fetch direction constant: {0}.", new Integer(n)), PSQLState.INVALID_PARAMETER_VALUE);
            }
        }
    }

    public void setFetchSize(int n) throws SQLException {
        this.checkClosed();
        if (n < 0) {
            throw new PSQLException(GT.tr("Fetch size must be a value greater to or equal to 0."), PSQLState.INVALID_PARAMETER_VALUE);
        }
        this.fetchSize = n;
    }

    public void addBatch() throws SQLException {
        this.checkClosed();
        boolean bl = true;
        if (this.use35CopyFormat && !this.binaryBatchInsert) {
            bl = false;
        }
        if (this.connection.getQueryExecutor().getCurrentStatement() != this) {
            this.finishLoad(false);
        }
        ++this.batchInsertCount;
        if (this.batchInsert) {
            if (!this.connection.isInLoad()) {
                Query query;
                Object object;
                this.batchTotalRows = 0;
                this.clearAcceptedRejectedRows();
                if (this.batchColumns == null) {
                    object = null;
                    int n = 49;
                    StatementResultHandler statementResultHandler = new StatementResultHandler();
                    Query query2 = this.connection.getQueryExecutor().createSimpleQuery("SELECT * FROM " + this.batchTableName);
                    this.connection.getQueryExecutor().execute(query2, null, (ResultHandler)statementResultHandler, 0, 0, n);
                    ResultWrapper resultWrapper = statementResultHandler.getResults();
                    if (resultWrapper != null) {
                        object = resultWrapper.getResultSet();
                    }
                    if (object != null) {
                        ResultSetMetaData resultSetMetaData = object.getMetaData();
                        if (resultSetMetaData != null && this.preparedParameters != null) {
                            if (resultSetMetaData.getColumnCount() < this.preparedParameters.getParameterCount()) {
                                throw new PSQLException(GT.tr("Number of parameters exceeds number of table columns"), PSQLState.INVALID_PARAMETER_VALUE);
                            }
                            for (int i = 1; i <= this.preparedParameters.getParameterCount(); ++i) {
                                this.batchColumns = i == 1 ? resultSetMetaData.getColumnName(i) : this.batchColumns + ", " + resultSetMetaData.getColumnName(i);
                            }
                            if (this.batchColumns != null) {
                                this.batchColumns = "(" + this.batchColumns + ")";
                            }
                        }
                        object.close();
                    }
                }
                object = " AUTO";
                if (this.directBatchInsert) {
                    object = " DIRECT";
                }
                if (bl) {
                    query = this.connection.getQueryExecutor().createSimpleQuery("COPY " + this.batchTableName + (this.batchColumns != null ? " " + this.batchColumns : "") + " FROM STDIN NATIVE VARCHAR RETURNREJECTED" + (String)object + (this.batchInsertEnforceLength ? " ENFORCELENGTH" : "") + (this.abortBatchInsertOnError ? " ABORT ON ERROR" : "") + (this.connection.getAutoCommit() ? "" : " NO COMMIT"));
                    this.baiStream = new ByteArrayInputStream(this.preparedParameters.toNativeBatchString(true));
                    this.ioStream = new IOStream(this.baiStream);
                    if (this.ioStream != null) {
                        this.executeWithStream(query, this.ioStream, 1092);
                    }
                } else {
                    query = this.connection.getQueryExecutor().createSimpleQuery("COPY " + this.batchTableName + (this.batchColumns != null ? " " + this.batchColumns : "") + " FROM STDIN DELIMITER '|' NULL '' RECORD TERMINATOR '" + this.batchInsertRecordTerminator + "' RETURNREJECTED" + (String)object + (this.batchInsertEnforceLength ? " ENFORCELENGTH" : "") + (this.abortBatchInsertOnError ? " ABORT ON ERROR" : "") + (this.connection.getAutoCommit() ? "" : " NO COMMIT"));
                    try {
                        this.baiStream = new ByteArrayInputStream(this.preparedParameters.toBatchString(this.batchInsertRecordTerminator).getBytes("UTF-8"));
                    }
                    catch (UnsupportedEncodingException unsupportedEncodingException) {
                        throw new PSQLException(GT.tr("Can not convert parameter value"), PSQLState.INVALID_PARAMETER_VALUE);
                    }
                    this.ioStream = new IOStream(this.baiStream);
                    if (this.ioStream != null) {
                        this.executeWithStream(query, this.ioStream, 68);
                    }
                }
                this.lastSimpleQuery = query;
                this.connection.setLoadingBatches(true);
                return;
            }
            if (!this.connection.isInLoad()) {
                throw new PSQLException(GT.tr("Internal error, loading batch but not running COPY"), PSQLState.PROTOCOL_VIOLATION);
            }
            if (bl) {
                this.baiStream = new ByteArrayInputStream(this.preparedParameters.toNativeBatchString(false));
                this.ioStream = new IOStream(this.baiStream);
                this.connection.setLoadingBatches(true);
                if (this.ioStream != null) {
                    this.executeWithStream(null, this.ioStream, 1156);
                }
            } else {
                try {
                    this.baiStream = new ByteArrayInputStream(this.preparedParameters.toBatchString(this.batchInsertRecordTerminator).getBytes("UTF-8"));
                }
                catch (UnsupportedEncodingException unsupportedEncodingException) {
                    throw new PSQLException(GT.tr("Can not convert parameter value"), PSQLState.INVALID_PARAMETER_VALUE);
                }
                this.ioStream = new IOStream(this.baiStream);
                this.connection.setLoadingBatches(true);
                if (this.ioStream != null) {
                    this.executeWithStream(null, this.ioStream, 132);
                }
            }
            return;
        }
        if (this.batchStatements == null) {
            this.batchStatements = new ArrayList();
            this.batchParameters = new ArrayList();
        }
        this.batchStatements.add(this.preparedQuery);
        this.batchParameters.add(this.preparedParameters.copy());
    }

    public ResultSetMetaData getMetaData() throws SQLException {
        this.checkClosed();
        ResultSet resultSet = this.getResultSet();
        if (resultSet == null) {
            int n = 49;
            StatementResultHandler statementResultHandler = new StatementResultHandler();
            this.connection.getQueryExecutor().setCurrentStatement(this);
            this.connection.getQueryExecutor().execute(this.preparedQuery, this.preparedParameters, (ResultHandler)statementResultHandler, 0, 0, n);
            ResultWrapper resultWrapper = statementResultHandler.getResults();
            if (resultWrapper != null) {
                resultSet = resultWrapper.getResultSet();
            }
        }
        if (resultSet != null) {
            return resultSet.getMetaData();
        }
        return null;
    }

    public void setArray(int n, Array array) throws SQLException {
        this.checkClosed();
        if (null == array) {
            this.setNull(n, 2003);
            return;
        }
        String string = "_" + array.getBaseTypeName();
        int n2 = this.connection.getPGType(string);
        if (n2 == 0) {
            throw new PSQLException(GT.tr("Unknown type {0}.", string), PSQLState.INVALID_PARAMETER_TYPE);
        }
        this.setString(n, array.toString(), n2);
    }

    public void setBlob(int n, Blob blob) throws SQLException {
        this.checkClosed();
        if (blob == null) {
            this.setNull(n, 2004);
            return;
        }
        InputStream inputStream = blob.getBinaryStream();
        LargeObjectManager largeObjectManager = this.connection.getLargeObjectAPI();
        int n2 = largeObjectManager.create();
        LargeObject largeObject = largeObjectManager.open(n2);
        OutputStream outputStream = largeObject.getOutputStream();
        byte[] byArray = new byte[4096];
        try {
            int n3 = (int)blob.length();
            int n4 = inputStream.read(byArray, 0, Math.min(byArray.length, n3));
            while (n4 != -1 && n3 > 0) {
                n3 -= n4;
                if (n4 == byArray.length) {
                    outputStream.write(byArray);
                } else {
                    outputStream.write(byArray, 0, n4);
                }
                n4 = inputStream.read(byArray, 0, Math.min(byArray.length, n3));
            }
        }
        catch (IOException iOException) {
            throw new PSQLException(GT.tr("Unexpected error writing large object to database."), PSQLState.UNEXPECTED_ERROR, (Throwable)iOException);
        }
        finally {
            try {
                outputStream.close();
                inputStream.close();
            }
            catch (Exception exception) {}
        }
        this.setInt(n, n2);
    }

    public void setCharacterStream(int n, Reader reader, int n2) throws SQLException {
        this.checkClosed();
        if (reader == null) {
            this.setNull(n, 12);
            return;
        }
        if (n2 < 0) {
            throw new PSQLException(GT.tr("Invalid stream length {0}.", new Integer(n2)), PSQLState.INVALID_PARAMETER_VALUE);
        }
        char[] cArray = new char[n2];
        int n3 = 0;
        try {
            int n4;
            while ((n4 = reader.read(cArray, n3, n2 - n3)) != -1 && (n3 += n4) != n2) {
            }
        }
        catch (IOException iOException) {
            throw new PSQLException(GT.tr("Provided Reader failed."), PSQLState.UNEXPECTED_ERROR, (Throwable)iOException);
        }
        this.setString(n, new String(cArray, 0, n3));
    }

    public void setClob(int n, Clob clob) throws SQLException {
        this.checkClosed();
        if (clob == null) {
            this.setNull(n, 2005);
            return;
        }
        InputStream inputStream = clob.getAsciiStream();
        int n2 = (int)clob.length();
        LargeObjectManager largeObjectManager = this.connection.getLargeObjectAPI();
        int n3 = largeObjectManager.create();
        LargeObject largeObject = largeObjectManager.open(n3);
        OutputStream outputStream = largeObject.getOutputStream();
        try {
            int n4 = inputStream.read();
            for (int i = 0; n4 > -1 && i < n2; ++i) {
                outputStream.write(n4);
                n4 = inputStream.read();
            }
            outputStream.close();
        }
        catch (IOException iOException) {
            throw new PSQLException(GT.tr("Unexpected error writing large object to database."), PSQLState.UNEXPECTED_ERROR, (Throwable)iOException);
        }
        this.setInt(n, n3);
    }

    public void setNull(int n, int n2, String string) throws SQLException {
        this.checkClosed();
        this.setNull(n, n2);
    }

    public void setRef(int n, Ref ref) throws SQLException {
        throw Driver.notImplemented(this.getClass(), "setRef(int,Ref)");
    }

    public void setDate(int n, Date date, Calendar calendar) throws SQLException {
        this.checkClosed();
        if (date == null) {
            this.setNull(n, 91);
            return;
        }
        if (calendar != null) {
            calendar = (Calendar)calendar.clone();
        }
        this.bindString(n, this.connection.getTimestampUtils().toString(calendar, date), 0);
    }

    public void setTime(int n, Time time, Calendar calendar) throws SQLException {
        this.checkClosed();
        if (time == null) {
            this.setNull(n, 92);
            return;
        }
        if (calendar != null) {
            calendar = (Calendar)calendar.clone();
        }
        this.bindString(n, this.connection.getTimestampUtils().toString(calendar, time), 0);
    }

    public void setTimestamp(int n, Timestamp timestamp, Calendar calendar) throws SQLException {
        this.checkClosed();
        if (timestamp == null) {
            this.setNull(n, 93);
            return;
        }
        if (calendar != null) {
            calendar = (Calendar)calendar.clone();
        }
        this.bindString(n, this.connection.getTimestampUtils().toString(calendar, timestamp), 12);
    }

    public Array getArray(int n) throws SQLException {
        this.checkClosed();
        this.checkIndex(n, 2003, "Array");
        return (Array)this.callResult[n - 1];
    }

    public BigDecimal getBigDecimal(int n) throws SQLException {
        this.checkClosed();
        this.checkIndex(n, 2, "BigDecimal");
        return (BigDecimal)this.callResult[n - 1];
    }

    public Blob getBlob(int n) throws SQLException {
        throw Driver.notImplemented(this.getClass(), "getBlob(int)");
    }

    public Clob getClob(int n) throws SQLException {
        throw Driver.notImplemented(this.getClass(), "getClob(int)");
    }

    public Object getObjectImpl(int n, Map map) throws SQLException {
        if (map == null || map.isEmpty()) {
            return this.getObject(n);
        }
        throw Driver.notImplemented(this.getClass(), "getObjectImpl(int,Map)");
    }

    public Ref getRef(int n) throws SQLException {
        throw Driver.notImplemented(this.getClass(), "getRef(int)");
    }

    public Date getDate(int n, Calendar calendar) throws SQLException {
        if (calendar == null) {
            return this.getDate(n);
        }
        Date date = this.getDate(n);
        if (date == null) {
            return null;
        }
        calendar = AbstractJdbc2Statement.changeTime(date, calendar, false);
        return new Date(calendar.getTime().getTime());
    }

    public Time getTime(int n, Calendar calendar) throws SQLException {
        if (calendar == null) {
            return this.getTime(n);
        }
        Time time = this.getTime(n);
        if (time == null) {
            return null;
        }
        calendar = AbstractJdbc2Statement.changeTime(time, calendar, false);
        return new Time(calendar.getTime().getTime());
    }

    public Timestamp getTimestamp(int n, Calendar calendar) throws SQLException {
        if (calendar == null) {
            return this.getTimestamp(n);
        }
        Timestamp timestamp = this.getTimestamp(n);
        if (timestamp == null) {
            return null;
        }
        calendar = AbstractJdbc2Statement.changeTime(timestamp, calendar, false);
        return new Timestamp(calendar.getTime().getTime());
    }

    public void registerOutParameter(int n, int n2, String string) throws SQLException {
        throw Driver.notImplemented(this.getClass(), "registerOutParameter(int,int,String)");
    }

    static Calendar changeTime(java.util.Date date, Calendar calendar, boolean bl) {
        long l = date.getTime();
        if (l == 9223372036825200000L || l == -9223372036832400000L) {
            calendar.setTime(date);
            return calendar;
        }
        int n = date.getTimezoneOffset() * 60 * 1000 * -1;
        int n2 = calendar.getTimeZone().getRawOffset();
        if (calendar.getTimeZone().inDaylightTime(date)) {
            l += 3600000L;
        }
        n2 = bl ? n2 - n : -1 * (n2 - n);
        java.util.Date date2 = new java.util.Date();
        date2.setTime(l - (long)n2);
        calendar.setTime(date2);
        date2 = null;
        return calendar;
    }

    public int getNumAcceptedRows() {
        if (this.numAcceptedRows == 0L && this.numRejectedRows == 0L) {
            this.updateAcceptedRejectedRows();
        }
        return (int)this.numAcceptedRows;
    }

    public int getNumRejectedRows() {
        if (this.numAcceptedRows == 0L && this.numRejectedRows == 0L) {
            this.updateAcceptedRejectedRows();
        }
        return (int)this.numRejectedRows;
    }

    public long getLongNumAcceptedRows() {
        if (this.numAcceptedRows == 0L && this.numRejectedRows == 0L) {
            this.updateAcceptedRejectedRows();
        }
        return this.numAcceptedRows;
    }

    public long getLongNumRejectedRows() {
        if (this.numAcceptedRows == 0L && this.numRejectedRows == 0L) {
            this.updateAcceptedRejectedRows();
        }
        return this.numRejectedRows;
    }

    private class BatchResultHandler
    implements ResultHandler {
        private BatchUpdateException batchException = null;
        private int resultIndex = 0;
        private final Query[] queries;
        private final ParameterList[] parameterLists;
        private int[] updateCounts;

        BatchResultHandler(Query[] queryArray, ParameterList[] parameterListArray, int[] nArray) {
            this.queries = queryArray;
            this.parameterLists = parameterListArray;
            this.updateCounts = nArray;
        }

        public void handleResultRows(Query query, Field[] fieldArray, VectorTuple vectorTuple, ResultCursor resultCursor) {
        }

        public void handleCommandStatus(String string, int n, long l) {
            if (this.resultIndex >= this.updateCounts.length) {
                int[] nArray = new int[this.resultIndex + 1];
                System.arraycopy(nArray, 0, this.updateCounts, 0, this.resultIndex);
                this.updateCounts = nArray;
            }
            this.updateCounts[this.resultIndex++] = n;
        }

        public void handleWarning(SQLWarning sQLWarning) {
            AbstractJdbc2Statement.this.addWarning(sQLWarning);
        }

        public void handleError(SQLException sQLException) {
            if (this.batchException == null) {
                int[] nArray;
                if (this.resultIndex >= this.updateCounts.length) {
                    nArray = this.updateCounts;
                } else {
                    nArray = new int[this.resultIndex];
                    System.arraycopy(this.updateCounts, 0, nArray, 0, this.resultIndex);
                }
                String string = "<unknown>";
                if (this.resultIndex < this.queries.length) {
                    string = this.queries[this.resultIndex].toString(this.parameterLists[this.resultIndex]);
                }
                this.batchException = new BatchUpdateException(GT.tr("Batch entry {0} {1} was aborted.  Call getNextException to see the cause.", new Object[]{new Integer(this.resultIndex), string}), nArray);
            }
            this.batchException.setNextException(sQLException);
        }

        public void handleCompletion() throws SQLException {
            if (this.batchException != null) {
                throw this.batchException;
            }
        }
    }

    public class StatementResultHandler
    implements ResultHandler {
        private SQLException error;
        private ResultWrapper results;

        ResultWrapper getResults() {
            return this.results;
        }

        private void append(ResultWrapper resultWrapper) {
            if (this.results == null) {
                this.results = resultWrapper;
            } else {
                this.results.append(resultWrapper);
            }
        }

        public void handleResultRows(Query query, Field[] fieldArray, VectorTuple vectorTuple, ResultCursor resultCursor) {
            try {
                if (vectorTuple == null) {
                    vectorTuple = new VectorTuple(AbstractJdbc2Statement.this.connection.getLogger());
                }
                ResultSet resultSet = AbstractJdbc2Statement.this.createResultSet(query, fieldArray, vectorTuple, resultCursor);
                this.append(new ResultWrapper(resultSet));
            }
            catch (SQLException sQLException) {
                this.handleError(sQLException);
            }
        }

        public void handleCommandStatus(String string, int n, long l) {
            if (this.results != null) {
                this.results.setUpdateCount(n);
            } else {
                this.append(new ResultWrapper(n, l));
            }
        }

        public void handleWarning(SQLWarning sQLWarning) {
            AbstractJdbc2Statement.this.addWarning(sQLWarning);
        }

        public void handleError(SQLException sQLException) {
            if (this.error == null) {
                this.error = sQLException;
            } else {
                this.error.setNextException(sQLException);
            }
        }

        public void handleCompletion() throws SQLException {
            if (this.error != null) {
                throw this.error;
            }
        }
    }
}

