/*
 * Decompiled with CFR 0.152.
 */
package com.vertica.jdbc2;

import com.vertica.Driver;
import com.vertica.core.BaseStatement;
import com.vertica.core.Field;
import com.vertica.core.VectorTuple;
import com.vertica.jdbc2.AbstractJdbc2Connection;
import com.vertica.jdbc2.TypeInfoCache;
import com.vertica.util.GT;
import com.vertica.util.PSQLException;
import com.vertica.util.PSQLState;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Vector;

public abstract class AbstractJdbc2DatabaseMetaData {
    private static final String PRIMARY_KEY_CONSTRAINT_TYPE = "p";
    private static final String FOREIGN_KEY_CONSTRAINT_TYPE = "f";
    private static final String keywords = "abort,acl,add,aggregate,append,archive,arch_store,backward,binary,boolean,change,cluster,copy,database,delimiter,delimiters,do,extend,explain,forward,heavy,index,inherits,isnull,light,listen,load,merge,nothing,notify,notnull,oids,purge,rename,replace,retrieve,returns,rule,recipe,setof,stdin,stdout,store,vacuum,verbose,version";
    protected final AbstractJdbc2Connection connection;
    private int NAMEDATALEN = 64;
    private int INDEX_MAX_KEYS = 0;
    private static final Hashtable tableTypeClauses = new Hashtable();

    public AbstractJdbc2DatabaseMetaData(AbstractJdbc2Connection abstractJdbc2Connection) {
        this.connection = abstractJdbc2Connection;
    }

    protected int getMaxIndexKeys() throws SQLException {
        return this.INDEX_MAX_KEYS;
    }

    protected int getMaxNameLength() throws SQLException {
        if (this.NAMEDATALEN == 0) {
            String string = "SELECT typlen FROM some_vertica_table_which_returns_typelen";
            ResultSet resultSet = this.connection.createStatement().executeQuery(string);
            if (!resultSet.next()) {
                throw new PSQLException(GT.tr("Unable to find name datatype in the system catalogs."), PSQLState.UNEXPECTED_ERROR);
            }
            this.NAMEDATALEN = resultSet.getInt("typlen");
            resultSet.close();
        }
        return this.NAMEDATALEN - 1;
    }

    public boolean allProceduresAreCallable() throws SQLException {
        return true;
    }

    public boolean allTablesAreSelectable() throws SQLException {
        return true;
    }

    public String getURL() throws SQLException {
        return this.connection.getURL();
    }

    public String getUserName() throws SQLException {
        return this.connection.getUserName();
    }

    public boolean isReadOnly() throws SQLException {
        return this.connection.isReadOnly();
    }

    public boolean nullsAreSortedHigh() throws SQLException {
        return false;
    }

    public boolean nullsAreSortedLow() throws SQLException {
        return false;
    }

    public boolean nullsAreSortedAtStart() throws SQLException {
        return false;
    }

    public boolean nullsAreSortedAtEnd() throws SQLException {
        return false;
    }

    public String getDatabaseProductName() throws SQLException {
        return "Vertica Database";
    }

    public String getDatabaseProductVersion() throws SQLException {
        return this.connection.getVTVersionNumber();
    }

    public String getDriverName() throws SQLException {
        return "Vertica JDBC Driver";
    }

    public String getDriverVersion() throws SQLException {
        return Driver.getVersion();
    }

    public int getDriverMajorVersion() {
        return Driver.getMajorVersionStatic();
    }

    public int getDriverMinorVersion() {
        return Driver.getMinorVersionStatic();
    }

    public boolean usesLocalFiles() throws SQLException {
        return false;
    }

    public boolean usesLocalFilePerTable() throws SQLException {
        return false;
    }

    public boolean supportsMixedCaseIdentifiers() throws SQLException {
        return false;
    }

    public boolean storesUpperCaseIdentifiers() throws SQLException {
        return false;
    }

    public boolean storesLowerCaseIdentifiers() throws SQLException {
        return true;
    }

    public boolean storesMixedCaseIdentifiers() throws SQLException {
        return false;
    }

    public boolean supportsMixedCaseQuotedIdentifiers() throws SQLException {
        return true;
    }

    public boolean storesUpperCaseQuotedIdentifiers() throws SQLException {
        return false;
    }

    public boolean storesLowerCaseQuotedIdentifiers() throws SQLException {
        return false;
    }

    public boolean storesMixedCaseQuotedIdentifiers() throws SQLException {
        return false;
    }

    public String getIdentifierQuoteString() throws SQLException {
        return "\"";
    }

    public String getSQLKeywords() throws SQLException {
        return keywords;
    }

    public String getNumericFunctions() throws SQLException {
        return "abs,acos,asin,atan,atan2,ceiling,cos,cot,degrees,exp,floor,log,log10,mod,pi,power,radians,rand,round,sign,sin,sqrt,tan,truncate";
    }

    public String getStringFunctions() throws SQLException {
        String string = "ascii,char,concat,lcase,left,length,ltrim,repeat,rtrim,space,substring,ucase";
        if (this.connection.haveMinimumServerVersion("7.3")) {
            string = string + ",replace";
        }
        return string;
    }

    public String getSystemFunctions() throws SQLException {
        if (this.connection.haveMinimumServerVersion("7.3")) {
            return "database,ifnull,user";
        }
        return "ifnull,user";
    }

    public String getTimeDateFunctions() throws SQLException {
        String string = "curdate,curtime,dayname,dayofmonth,dayofweek,dayofyear,hour,minute,month,monthname,now,quarter,second,week,year";
        if (this.connection.haveMinimumServerVersion("8.0")) {
            string = string + ",timestampadd";
        }
        return string;
    }

    public String getSearchStringEscape() throws SQLException {
        return "\\\\";
    }

    public String getExtraNameCharacters() throws SQLException {
        return "";
    }

    public boolean supportsAlterTableWithAddColumn() throws SQLException {
        return true;
    }

    public boolean supportsAlterTableWithDropColumn() throws SQLException {
        return false;
    }

    public boolean supportsColumnAliasing() throws SQLException {
        return true;
    }

    public boolean nullPlusNonNullIsNull() throws SQLException {
        return true;
    }

    public boolean supportsConvert() throws SQLException {
        return false;
    }

    public boolean supportsConvert(int n, int n2) throws SQLException {
        return false;
    }

    public boolean supportsTableCorrelationNames() throws SQLException {
        return true;
    }

    public boolean supportsDifferentTableCorrelationNames() throws SQLException {
        return false;
    }

    public boolean supportsExpressionsInOrderBy() throws SQLException {
        return true;
    }

    public boolean supportsOrderByUnrelated() throws SQLException {
        return this.connection.haveMinimumServerVersion("6.4");
    }

    public boolean supportsGroupBy() throws SQLException {
        return true;
    }

    public boolean supportsGroupByUnrelated() throws SQLException {
        return this.connection.haveMinimumServerVersion("6.4");
    }

    public boolean supportsGroupByBeyondSelect() throws SQLException {
        return this.connection.haveMinimumServerVersion("6.4");
    }

    public boolean supportsLikeEscapeClause() throws SQLException {
        return this.connection.haveMinimumServerVersion("7.1");
    }

    public boolean supportsMultipleResultSets() throws SQLException {
        return false;
    }

    public boolean supportsMultipleTransactions() throws SQLException {
        return true;
    }

    public boolean supportsNonNullableColumns() throws SQLException {
        return true;
    }

    public boolean supportsMinimumSQLGrammar() throws SQLException {
        return true;
    }

    public boolean supportsCoreSQLGrammar() throws SQLException {
        return false;
    }

    public boolean supportsExtendedSQLGrammar() throws SQLException {
        return false;
    }

    public boolean supportsANSI92EntryLevelSQL() throws SQLException {
        return true;
    }

    public boolean supportsANSI92IntermediateSQL() throws SQLException {
        return false;
    }

    public boolean supportsANSI92FullSQL() throws SQLException {
        return false;
    }

    public boolean supportsIntegrityEnhancementFacility() throws SQLException {
        return true;
    }

    public boolean supportsOuterJoins() throws SQLException {
        return true;
    }

    public boolean supportsFullOuterJoins() throws SQLException {
        return true;
    }

    public boolean supportsLimitedOuterJoins() throws SQLException {
        return true;
    }

    public String getSchemaTerm() throws SQLException {
        return "schema";
    }

    public String getProcedureTerm() throws SQLException {
        return "function";
    }

    public String getCatalogTerm() throws SQLException {
        return "database";
    }

    public boolean isCatalogAtStart() throws SQLException {
        return true;
    }

    public String getCatalogSeparator() throws SQLException {
        return ".";
    }

    public boolean supportsSchemasInDataManipulation() throws SQLException {
        return true;
    }

    public boolean supportsSchemasInProcedureCalls() throws SQLException {
        return true;
    }

    public boolean supportsSchemasInTableDefinitions() throws SQLException {
        return true;
    }

    public boolean supportsSchemasInIndexDefinitions() throws SQLException {
        return false;
    }

    public boolean supportsSchemasInPrivilegeDefinitions() throws SQLException {
        return true;
    }

    public boolean supportsCatalogsInDataManipulation() throws SQLException {
        return false;
    }

    public boolean supportsCatalogsInProcedureCalls() throws SQLException {
        return false;
    }

    public boolean supportsCatalogsInTableDefinitions() throws SQLException {
        return false;
    }

    public boolean supportsCatalogsInIndexDefinitions() throws SQLException {
        return false;
    }

    public boolean supportsCatalogsInPrivilegeDefinitions() throws SQLException {
        return false;
    }

    public boolean supportsPositionedDelete() throws SQLException {
        return false;
    }

    public boolean supportsPositionedUpdate() throws SQLException {
        return false;
    }

    public boolean supportsSelectForUpdate() throws SQLException {
        return false;
    }

    public boolean supportsStoredProcedures() throws SQLException {
        return false;
    }

    public boolean supportsSubqueriesInComparisons() throws SQLException {
        return true;
    }

    public boolean supportsSubqueriesInExists() throws SQLException {
        return true;
    }

    public boolean supportsSubqueriesInIns() throws SQLException {
        return true;
    }

    public boolean supportsSubqueriesInQuantifieds() throws SQLException {
        return true;
    }

    public boolean supportsCorrelatedSubqueries() throws SQLException {
        return true;
    }

    public boolean supportsUnion() throws SQLException {
        return true;
    }

    public boolean supportsUnionAll() throws SQLException {
        return true;
    }

    public boolean supportsOpenCursorsAcrossCommit() throws SQLException {
        return false;
    }

    public boolean supportsOpenCursorsAcrossRollback() throws SQLException {
        return false;
    }

    public boolean supportsOpenStatementsAcrossCommit() throws SQLException {
        return true;
    }

    public boolean supportsOpenStatementsAcrossRollback() throws SQLException {
        return true;
    }

    public int getMaxBinaryLiteralLength() throws SQLException {
        return 0;
    }

    public int getMaxCharLiteralLength() throws SQLException {
        return 0;
    }

    public int getMaxColumnNameLength() throws SQLException {
        return this.getMaxNameLength();
    }

    public int getMaxColumnsInGroupBy() throws SQLException {
        return 0;
    }

    public int getMaxColumnsInIndex() throws SQLException {
        return this.getMaxIndexKeys();
    }

    public int getMaxColumnsInOrderBy() throws SQLException {
        return 0;
    }

    public int getMaxColumnsInSelect() throws SQLException {
        return 0;
    }

    public int getMaxColumnsInTable() throws SQLException {
        return 1600;
    }

    public int getMaxConnections() throws SQLException {
        return 8192;
    }

    public int getMaxCursorNameLength() throws SQLException {
        return this.getMaxNameLength();
    }

    public int getMaxIndexLength() throws SQLException {
        return 0;
    }

    public int getMaxSchemaNameLength() throws SQLException {
        return this.getMaxNameLength();
    }

    public int getMaxProcedureNameLength() throws SQLException {
        return this.getMaxNameLength();
    }

    public int getMaxCatalogNameLength() throws SQLException {
        return this.getMaxNameLength();
    }

    public int getMaxRowSize() throws SQLException {
        if (this.connection.haveMinimumServerVersion("7.1")) {
            return 0x40000000;
        }
        return 8192;
    }

    public boolean doesMaxRowSizeIncludeBlobs() throws SQLException {
        return false;
    }

    public int getMaxStatementLength() throws SQLException {
        if (this.connection.haveMinimumServerVersion("7.0")) {
            return 0;
        }
        return 16384;
    }

    public int getMaxStatements() throws SQLException {
        return 0;
    }

    public int getMaxTableNameLength() throws SQLException {
        return this.getMaxNameLength();
    }

    public int getMaxTablesInSelect() throws SQLException {
        return 0;
    }

    public int getMaxUserNameLength() throws SQLException {
        return this.getMaxNameLength();
    }

    public int getDefaultTransactionIsolation() throws SQLException {
        return this.connection.getTransactionIsolation();
    }

    public boolean supportsTransactions() throws SQLException {
        return true;
    }

    public boolean supportsTransactionIsolationLevel(int n) throws SQLException {
        if (n == 8 || n == 2) {
            return true;
        }
        return this.connection.haveMinimumServerVersion("8.0") && (n == 1 || n == 4);
    }

    public boolean supportsDataDefinitionAndDataManipulationTransactions() throws SQLException {
        return true;
    }

    public boolean supportsDataManipulationTransactionsOnly() throws SQLException {
        return false;
    }

    public boolean dataDefinitionCausesTransactionCommit() throws SQLException {
        return true;
    }

    public boolean dataDefinitionIgnoredInTransactions() throws SQLException {
        return false;
    }

    protected static String escapeQuotes(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        int n = string.length();
        for (int i = 0; i < n; ++i) {
            char c = string.charAt(i);
            if (c == '\'' || c == '\\') {
                stringBuffer.append('\\');
            }
            stringBuffer.append(c);
        }
        return stringBuffer.toString();
    }

    protected static String replaceLikeWithRegExpr(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        int n = string.length();
        boolean bl = false;
        for (int i = 0; i < n; ++i) {
            char c = string.charAt(i);
            if (c == '%' && string.charAt(i == 0 ? 0 : i - 1) != '\\') {
                stringBuffer.append('.').append('*');
                continue;
            }
            if (c == '_' && string.charAt(i == 0 ? 0 : i - 1) != '\\') {
                stringBuffer.append('.');
                continue;
            }
            stringBuffer.append(c);
        }
        return stringBuffer.toString();
    }

    public ResultSet getProcedures(String string, String string2, String string3) throws SQLException {
        Field[] fieldArray = new Field[8];
        VectorTuple vectorTuple = new VectorTuple(this.connection.getLogger());
        fieldArray[0] = new Field("PROCEDURE_CAT", 9);
        fieldArray[1] = new Field("PROCEDURE_SCHEM", 9);
        fieldArray[2] = new Field("PROCEDURE_NAME", 9);
        fieldArray[3] = new Field("NULL", 9);
        fieldArray[4] = new Field("NULL", 9);
        fieldArray[5] = new Field("NULL", 9);
        fieldArray[6] = new Field("REMARKS", 9);
        fieldArray[7] = new Field("PROCEDURE_TYPE", 23);
        return ((BaseStatement)this.createMetaDataStatement()).createDriverResultSet(fieldArray, vectorTuple);
    }

    public ResultSet getProcedureColumns(String string, String string2, String string3, String string4) throws SQLException {
        Field[] fieldArray = new Field[13];
        VectorTuple vectorTuple = new VectorTuple(this.connection.getLogger());
        fieldArray[0] = new Field("PROCEDURE_CAT", 9);
        fieldArray[1] = new Field("PROCEDURE_SCHEM", 9);
        fieldArray[2] = new Field("PROCEDURE_NAME", 9);
        fieldArray[3] = new Field("COLUMN_NAME", 9);
        fieldArray[4] = new Field("COLUMN_TYPE", 21);
        fieldArray[5] = new Field("DATA_TYPE", 21);
        fieldArray[6] = new Field("TYPE_NAME", 9);
        fieldArray[7] = new Field("PRECISION", 23);
        fieldArray[8] = new Field("LENGTH", 23);
        fieldArray[9] = new Field("SCALE", 21);
        fieldArray[10] = new Field("RADIX", 21);
        fieldArray[11] = new Field("NULLABLE", 21);
        fieldArray[12] = new Field("REMARKS", 9);
        return ((BaseStatement)this.createMetaDataStatement()).createDriverResultSet(fieldArray, vectorTuple);
    }

    public ResultSet getTables(String string, String string2, String string3, String[] stringArray) throws SQLException {
        return this.getTables(2, string, string2, string3, stringArray);
    }

    private void addTableType(int n, String string, String string2, String string3, VectorTuple vectorTuple) throws SQLException {
        int n2 = n >= 3 ? 11 : 6;
        String string4 = "select table_schema, table_name, owner_name from v_catalog." + string + "s";
        ResultSet resultSet = this.connection.createStatement().executeQuery(string4);
        String string5 = null;
        if (string2 != null && !"".equals(string2)) {
            string5 = AbstractJdbc2DatabaseMetaData.replaceLikeWithRegExpr(string2);
        }
        String string6 = null;
        if (string3 != null) {
            string6 = AbstractJdbc2DatabaseMetaData.replaceLikeWithRegExpr(string3);
        }
        while (resultSet.next()) {
            String string7 = resultSet.getString(1);
            String string8 = resultSet.getString(2);
            String string9 = resultSet.getString(3);
            byte[][] byArrayArray = new byte[n2][];
            byArrayArray[0] = null;
            byArrayArray[1] = string7.getBytes();
            byArrayArray[2] = string8.getBytes();
            byArrayArray[3] = this.connection.encodeString(string.toUpperCase());
            byArrayArray[4] = null;
            if (n >= 3) {
                byArrayArray[5] = null;
                byArrayArray[6] = null;
                byArrayArray[7] = null;
                byArrayArray[8] = null;
                byArrayArray[9] = null;
            }
            byte[] byArray = byArrayArray[n2 - 1] = string9 == null ? null : string9.getBytes();
            if (string5 != null && !string7.matches(string5) || string6 != null && !string8.matches(string6)) continue;
            vectorTuple.addElement(byArrayArray);
        }
        resultSet.close();
    }

    protected ResultSet getTables(int n, String string, String string2, String string3, String[] stringArray) throws SQLException {
        int n2 = n >= 3 ? 11 : 6;
        Field[] fieldArray = new Field[n2];
        VectorTuple vectorTuple = new VectorTuple(this.connection.getLogger());
        fieldArray[0] = new Field("TABLE_CAT", 9);
        fieldArray[1] = new Field("TABLE_SCHEM", 9);
        fieldArray[2] = new Field("TABLE_NAME", 9);
        fieldArray[3] = new Field("TABLE_TYPE", 9);
        fieldArray[4] = new Field("REMARKS", 9);
        if (n >= 3) {
            fieldArray[5] = new Field("TYPE_CAT", 9);
            fieldArray[6] = new Field("TYPE_SCHEM", 9);
            fieldArray[7] = new Field("TYPE_NAME", 9);
            fieldArray[8] = new Field("SELF_REFERENCING_COL_NAME", 9);
            fieldArray[9] = new Field("REF_GENERATION", 9);
        }
        fieldArray[n2 - 1] = new Field("TABLE_OWNER", 9);
        boolean bl = true;
        boolean bl2 = true;
        if (stringArray != null) {
            bl = false;
            bl2 = false;
            for (int i = 0; i < stringArray.length; ++i) {
                if (stringArray[i].equals("TABLE")) {
                    bl = true;
                }
                if (!stringArray[i].equals("VIEW")) continue;
                bl2 = true;
            }
        }
        if (bl) {
            this.addTableType(n, "table", string2, string3, vectorTuple);
        }
        if (bl2) {
            this.addTableType(n, "view", string2, string3, vectorTuple);
        }
        return ((BaseStatement)this.createMetaDataStatement()).createDriverResultSet(fieldArray, vectorTuple);
    }

    public ResultSet getSchemas() throws SQLException {
        Field[] fieldArray = new Field[3];
        VectorTuple vectorTuple = new VectorTuple(this.connection.getLogger());
        fieldArray[0] = new Field("TABLE_SCHEM", 9);
        fieldArray[1] = new Field("TABLE_CATALOG", 9);
        fieldArray[2] = new Field("TABLE_OWNER", 9);
        String string = "select vs_schemata.name as schemaname, users.user_name as ownername from v_internal.vs_schemata join v_catalog.users on v_catalog.users.user_id = v_internal.vs_schemata.nspowner where vs_schemata.name != 'v_internal'";
        ResultSet resultSet = this.connection.createStatement().executeQuery(string);
        while (resultSet.next()) {
            String string2 = resultSet.getString("schemaname");
            String string3 = resultSet.getString("ownername");
            byte[][] byArrayArray = new byte[][]{string2.getBytes(), null, string3 == null ? null : string3.getBytes()};
            vectorTuple.addElement(byArrayArray);
        }
        resultSet.close();
        return ((BaseStatement)this.createMetaDataStatement()).createDriverResultSet(fieldArray, vectorTuple);
    }

    public ResultSet getCatalogs() throws SQLException {
        Field[] fieldArray = new Field[1];
        VectorTuple vectorTuple = new VectorTuple(this.connection.getLogger());
        fieldArray[0] = new Field(new String("TABLE_CAT"), 9);
        byte[][] byArrayArray = new byte[][]{this.connection.encodeString(this.connection.getCatalog())};
        vectorTuple.addElement(byArrayArray);
        return ((BaseStatement)this.createMetaDataStatement()).createDriverResultSet(fieldArray, vectorTuple);
    }

    public ResultSet getTableTypes() throws SQLException {
        Object object;
        Field[] fieldArray;
        ArrayList<Field[]> arrayList = new ArrayList<Field[]>();
        Iterator iterator = tableTypeClauses.keySet().iterator();
        int n = 0;
        while (iterator.hasNext()) {
            fieldArray = (Field[])iterator.next();
            object = (Boolean)tableTypeClauses.get(fieldArray);
            if (!((Boolean)object).booleanValue()) continue;
            arrayList.add(fieldArray);
        }
        Collections.sort(arrayList);
        fieldArray = new Field[1];
        object = new VectorTuple(this.connection.getLogger());
        fieldArray[0] = new Field(new String("TABLE_TYPE"), 9);
        for (n = 0; n < arrayList.size(); ++n) {
            byte[][] byArrayArray = new byte[][]{this.connection.encodeString((String)arrayList.get(n))};
            ((VectorTuple)object).addElement(byArrayArray);
        }
        return ((BaseStatement)this.createMetaDataStatement()).createDriverResultSet(fieldArray, (VectorTuple)object);
    }

    public ResultSet getColumns(String string, String string2, String string3, String string4) throws SQLException {
        return this.getColumns(2, string, string2, string3, string4);
    }

    protected ResultSet getColumns(int n, String string, String string2, String string3, String string4) throws SQLException {
        int n2;
        String string5;
        String string6;
        String string7;
        String string8;
        int n3;
        int n4;
        int n5;
        byte[][] byArrayArray;
        VectorTuple vectorTuple = new VectorTuple(this.connection.getLogger());
        int n6 = n >= 3 ? 22 : 18;
        Field[] fieldArray = new Field[n6];
        fieldArray[0] = new Field("TABLE_CAT", 9);
        fieldArray[1] = new Field("TABLE_SCHEM", 9);
        fieldArray[2] = new Field("TABLE_NAME", 9);
        fieldArray[3] = new Field("COLUMN_NAME", 9);
        fieldArray[4] = new Field("DATA_TYPE", 6);
        fieldArray[5] = new Field("TYPE_NAME", 9);
        fieldArray[6] = new Field("COLUMN_SIZE", 6);
        fieldArray[7] = new Field("BUFFER_LENGTH", 6);
        fieldArray[8] = new Field("DECIMAL_DIGITS", 6);
        fieldArray[9] = new Field("NUM_PREC_RADIX", 6);
        fieldArray[10] = new Field("NULLABLE", 6);
        fieldArray[11] = new Field("REMARKS", 9);
        fieldArray[12] = new Field("COLUMN_DEF", 9);
        fieldArray[13] = new Field("SQL_DATA_TYPE", 6);
        fieldArray[14] = new Field("SQL_DATETIME_SUB", 6);
        fieldArray[15] = new Field("CHAR_OCTET_LENGTH", 9);
        fieldArray[16] = new Field("ORDINAL_POSITION", 6);
        fieldArray[17] = new Field("IS_NULLABLE", 9);
        if (n >= 3) {
            fieldArray[18] = new Field("SCOPE_CATALOG", 9);
            fieldArray[19] = new Field("SCOPE_SCHEMA", 9);
            fieldArray[20] = new Field("SCOPE_TABLE", 9);
            fieldArray[21] = new Field("SOURCE_DATA_TYPE", 21);
        }
        String string9 = "SELECT nspname, relname, attname, atttypid,attnotnull, atttypmod, attlen, attnum, adsrc FROM  v_internal.vs_columns";
        String string10 = null;
        if (string2 != null && !"".equals(string2)) {
            string10 = AbstractJdbc2DatabaseMetaData.replaceLikeWithRegExpr(string2);
        }
        String string11 = null;
        if (string3 != null) {
            string11 = AbstractJdbc2DatabaseMetaData.replaceLikeWithRegExpr(string3);
        }
        String string12 = null;
        if (string4 != null) {
            string12 = AbstractJdbc2DatabaseMetaData.replaceLikeWithRegExpr(string4);
        }
        ResultSet resultSet = this.connection.createStatement().executeQuery(string9);
        while (resultSet.next()) {
            int n7;
            byArrayArray = new byte[n6][];
            n5 = resultSet.getInt("atttypid");
            n4 = resultSet.getInt("atttypmod");
            n3 = resultSet.getInt("attlen");
            byArrayArray[0] = null;
            string8 = resultSet.getString("nspname");
            byArrayArray[1] = string8.getBytes();
            if (string10 != null && !string8.matches(string10)) continue;
            string7 = resultSet.getString("relname");
            if (string11 != null && !string7.matches(string11)) continue;
            byArrayArray[2] = string7.getBytes();
            string6 = resultSet.getString("attname");
            byArrayArray[3] = string6.getBytes();
            if (string12 != null && !string6.matches(string12)) continue;
            byArrayArray[4] = this.connection.encodeString(Integer.toString(this.connection.getSQLType(n5)));
            string5 = this.connection.getPGType(n5);
            byArrayArray[5] = this.connection.encodeString(string5);
            byArrayArray[7] = this.connection.encodeString(Integer.toString(resultSet.getInt("attlen")));
            String string13 = resultSet.getString("adsrc");
            if (string13 != null) {
                if (string5.equals("int4")) {
                    if (string13.indexOf("nextval(") != -1) {
                        byArrayArray[5] = this.connection.encodeString("serial");
                    }
                } else if (string5.equals("int8") && string13.indexOf("nextval(") != -1) {
                    byArrayArray[5] = this.connection.encodeString("bigserial");
                }
            }
            if (n5 == 16) {
                n2 = TypeInfoCache.getScale(n5, n4);
                n7 = TypeInfoCache.getPrecision(n5, n4);
            } else {
                n2 = TypeInfoCache.getScale(n5, n3);
                n7 = TypeInfoCache.getPrecision(n5, n3);
            }
            if (n7 == 0) {
                n7 = TypeInfoCache.getDisplaySize(n5, n3);
            }
            byArrayArray[6] = this.connection.encodeString(Integer.toString(n7));
            byArrayArray[8] = this.connection.encodeString(Integer.toString(n2));
            byArrayArray[9] = this.connection.encodeString("10");
            if (string5.equals("bit") || string5.equals("varbit")) {
                byArrayArray[9] = this.connection.encodeString("2");
            }
            byArrayArray[10] = this.connection.encodeString(Integer.toString(resultSet.getBoolean("attnotnull") ? 0 : 1));
            byArrayArray[11] = null;
            byArrayArray[12] = resultSet.getBytes("adsrc");
            byArrayArray[13] = null;
            byArrayArray[14] = null;
            byArrayArray[15] = byArrayArray[6];
            byArrayArray[16] = this.connection.encodeString(Integer.toString(resultSet.getInt("attnum")));
            byArrayArray[17] = this.connection.encodeString(resultSet.getBoolean("attnotnull") ? "NO" : "YES");
            if (n >= 3) {
                byArrayArray[18] = null;
                byArrayArray[19] = null;
                byArrayArray[20] = null;
                byArrayArray[21] = null;
            }
            vectorTuple.addElement(byArrayArray);
        }
        resultSet.close();
        string9 = "SELECT table_schema, table_name, column_name, data_type_id,data_type_length, ordinal_position FROM v_catalog.view_columns";
        resultSet = this.connection.createStatement().executeQuery(string9);
        while (resultSet.next()) {
            byArrayArray = new byte[n6][];
            n5 = resultSet.getInt("data_type_id");
            n4 = 0;
            n3 = resultSet.getInt("data_type_length");
            byArrayArray[0] = null;
            string8 = resultSet.getString("table_schema");
            byArrayArray[1] = string8.getBytes();
            if (string10 != null && !string8.matches(string10)) continue;
            string7 = resultSet.getString("table_name");
            if (string11 != null && !string7.matches(string11)) continue;
            byArrayArray[2] = string7.getBytes();
            string6 = resultSet.getString("column_name");
            byArrayArray[3] = string6.getBytes();
            if (string12 != null && !string6.matches(string12)) continue;
            byArrayArray[4] = this.connection.encodeString(Integer.toString(this.connection.getSQLType(n5)));
            string5 = this.connection.getPGType(n5);
            byArrayArray[5] = this.connection.encodeString(string5);
            byArrayArray[7] = this.connection.encodeString(Integer.toString(resultSet.getInt("data_type_length")));
            int n8 = TypeInfoCache.getScale(n5, n3);
            n2 = TypeInfoCache.getPrecision(n5, n3);
            if (n2 == 0) {
                n2 = TypeInfoCache.getDisplaySize(n5, n3);
            }
            byArrayArray[6] = this.connection.encodeString(Integer.toString(n2));
            byArrayArray[8] = this.connection.encodeString(Integer.toString(n8));
            byArrayArray[9] = this.connection.encodeString("10");
            if (string5.equals("bit") || string5.equals("varbit")) {
                byArrayArray[9] = this.connection.encodeString("2");
            }
            byArrayArray[10] = this.connection.encodeString(Integer.toString(1));
            byArrayArray[11] = null;
            byArrayArray[12] = null;
            byArrayArray[13] = null;
            byArrayArray[14] = null;
            byArrayArray[15] = byArrayArray[6];
            byArrayArray[16] = this.connection.encodeString(Integer.toString(resultSet.getInt("ordinal_position")));
            byArrayArray[17] = this.connection.encodeString("YES");
            if (n >= 3) {
                byArrayArray[18] = null;
                byArrayArray[19] = null;
                byArrayArray[20] = null;
                byArrayArray[21] = null;
            }
            vectorTuple.addElement(byArrayArray);
        }
        resultSet.close();
        return ((BaseStatement)this.createMetaDataStatement()).createDriverResultSet(fieldArray, vectorTuple);
    }

    public ResultSet getColumnPrivileges(String string, String string2, String string3, String string4) throws SQLException {
        Field[] fieldArray = new Field[8];
        VectorTuple vectorTuple = new VectorTuple(this.connection.getLogger());
        if (string3 == null) {
            string3 = "%";
        }
        if (string4 == null) {
            string4 = "%";
        }
        fieldArray[0] = new Field("TABLE_CAT", 9);
        fieldArray[1] = new Field("TABLE_SCHEM", 9);
        fieldArray[2] = new Field("TABLE_NAME", 9);
        fieldArray[3] = new Field("COLUMN_NAME", 9);
        fieldArray[4] = new Field("GRANTOR", 9);
        fieldArray[5] = new Field("GRANTEE", 9);
        fieldArray[6] = new Field("PRIVILEGE", 9);
        fieldArray[7] = new Field("IS_GRANTABLE", 9);
        return ((BaseStatement)this.createMetaDataStatement()).createDriverResultSet(fieldArray, vectorTuple);
    }

    public ResultSet getTablePrivileges(String string, String string2, String string3) throws SQLException {
        Field[] fieldArray = new Field[7];
        VectorTuple vectorTuple = new VectorTuple(this.connection.getLogger());
        fieldArray[0] = new Field("TABLE_CAT", 9);
        fieldArray[1] = new Field("TABLE_SCHEM", 9);
        fieldArray[2] = new Field("TABLE_NAME", 9);
        fieldArray[3] = new Field("GRANTOR", 9);
        fieldArray[4] = new Field("GRANTEE", 9);
        fieldArray[5] = new Field("PRIVILEGE", 9);
        fieldArray[6] = new Field("IS_GRANTABLE", 9);
        return ((BaseStatement)this.createMetaDataStatement()).createDriverResultSet(fieldArray, vectorTuple);
    }

    private static void sortStringArray(String[] stringArray) {
        for (int i = 0; i < stringArray.length - 1; ++i) {
            for (int j = i + 1; j < stringArray.length; ++j) {
                if (stringArray[i].compareTo(stringArray[j]) <= 0) continue;
                String string = stringArray[i];
                stringArray[i] = stringArray[j];
                stringArray[j] = string;
            }
        }
    }

    private static Vector parseACLArray(String string) {
        int n;
        Vector<String> vector = new Vector<String>();
        if (string == null || string.length() == 0) {
            return vector;
        }
        boolean bl = false;
        int n2 = 1;
        int n3 = 32;
        for (n = n2; n < string.length(); ++n) {
            char c = string.charAt(n);
            if (c == '\"' && n3 != 92) {
                bl = !bl;
            } else if (c == ',' && !bl) {
                vector.addElement(string.substring(n2, n));
                n2 = n + 1;
            }
            n3 = c;
        }
        vector.addElement(string.substring(n2, string.length() - 1));
        for (n = 0; n < vector.size(); ++n) {
            String string2 = (String)vector.elementAt(n);
            if (!string2.startsWith("\"") || !string2.endsWith("\"")) continue;
            string2 = string2.substring(1, string2.length() - 1);
            vector.setElementAt(string2, n);
        }
        return vector;
    }

    private void addACLPrivileges(String string, Hashtable hashtable) {
        int n = string.lastIndexOf("=");
        String string2 = string.substring(0, n);
        if (string2.length() == 0) {
            string2 = "PUBLIC";
        }
        String string3 = string.substring(n + 1);
        for (int i = 0; i < string3.length(); ++i) {
            String string4;
            char c = string3.charAt(i);
            switch (c) {
                case 'a': {
                    string4 = "INSERT";
                    break;
                }
                case 'r': {
                    string4 = "SELECT";
                    break;
                }
                case 'w': {
                    string4 = "UPDATE";
                    break;
                }
                case 'd': {
                    string4 = "DELETE";
                    break;
                }
                case 'R': {
                    string4 = "RULE";
                    break;
                }
                case 'x': {
                    string4 = "REFERENCES";
                    break;
                }
                case 't': {
                    string4 = "TRIGGER";
                    break;
                }
                case 'X': {
                    string4 = "EXECUTE";
                    break;
                }
                case 'U': {
                    string4 = "USAGE";
                    break;
                }
                case 'C': {
                    string4 = "CREATE";
                    break;
                }
                case 'T': {
                    string4 = "CREATE TEMP";
                    break;
                }
                default: {
                    string4 = "UNKNOWN";
                }
            }
            Vector<String> vector = (Vector<String>)hashtable.get(string4);
            if (vector == null) {
                vector = new Vector<String>();
                hashtable.put(string4, vector);
            }
            vector.addElement(string2);
        }
    }

    protected Hashtable parseACL(String string, String string2) {
        if (string == null || string == "") {
            string = "{" + string2 + "=arwdRxt}";
        }
        Vector vector = AbstractJdbc2DatabaseMetaData.parseACLArray(string);
        Hashtable hashtable = new Hashtable();
        for (int i = 0; i < vector.size(); ++i) {
            String string3 = (String)vector.elementAt(i);
            this.addACLPrivileges(string3, hashtable);
        }
        return hashtable;
    }

    public ResultSet getBestRowIdentifier(String string, String string2, String string3, int n, boolean bl) throws SQLException {
        Object object;
        Field[] fieldArray;
        Hashtable<Field[], Object> hashtable = new Hashtable<Field[], Object>();
        String string4 = "select table_schema, table_name, column_name from v_catalog.primary_keys";
        Statement statement = this.connection.createStatement();
        ResultSet resultSet = statement.executeQuery(string4);
        while (resultSet.next()) {
            fieldArray = resultSet.getString("table_schema") + "." + resultSet.getString("table_name");
            object = new LinkedList();
            if (hashtable.containsKey(fieldArray)) {
                object = (List)hashtable.get(fieldArray);
            }
            object.add(resultSet.getString("column_name"));
            hashtable.put(fieldArray, object);
        }
        resultSet.close();
        fieldArray = new Field[8];
        object = new VectorTuple(this.connection.getLogger());
        fieldArray[0] = new Field("SCOPE", 21);
        fieldArray[1] = new Field("COLUMN_NAME", 9);
        fieldArray[2] = new Field("DATA_TYPE", 21);
        fieldArray[3] = new Field("TYPE_NAME", 9);
        fieldArray[4] = new Field("COLUMN_SIZE", 23);
        fieldArray[5] = new Field("BUFFER_LENGTH", 23);
        fieldArray[6] = new Field("DECIMAL_DIGITS", 21);
        fieldArray[7] = new Field("PSEUDO_COLUMN", 21);
        String string5 = "SELECT nspname, relname, attname, atttypid, atttypmod, attlen from v_internal.vs_columns";
        String string6 = null;
        if (string2 != null && !"".equals(string2)) {
            string6 = AbstractJdbc2DatabaseMetaData.replaceLikeWithRegExpr(string2);
        }
        String string7 = null;
        if (string3 != null) {
            string7 = AbstractJdbc2DatabaseMetaData.replaceLikeWithRegExpr(string3);
        }
        resultSet = this.connection.createStatement().executeQuery(string5);
        while (resultSet.next()) {
            List list;
            String string8 = resultSet.getString("nspname");
            if (string6 != null && !string8.matches(string6)) continue;
            String string9 = resultSet.getString("relname");
            if (string7 != null && !string9.matches(string7) || (list = (List)hashtable.get(string8 + "." + string9)) == null || !list.contains(resultSet.getString("attname"))) continue;
            byte[][] byArrayArray = new byte[8][];
            int n2 = resultSet.getInt("atttypid");
            boolean bl2 = false;
            int n3 = resultSet.getInt("attlen");
            int n4 = TypeInfoCache.getScale(n2, n3);
            int n5 = TypeInfoCache.getPrecision(n2, n3);
            if (n5 == 0) {
                n5 = TypeInfoCache.getDisplaySize(n2, n3);
            }
            byArrayArray[0] = this.connection.encodeString(Integer.toString(n));
            byArrayArray[1] = resultSet.getBytes("attname");
            byArrayArray[2] = this.connection.encodeString(Integer.toString(this.connection.getSQLType(n2)));
            byArrayArray[3] = this.connection.encodeString(this.connection.getPGType(n2));
            byArrayArray[4] = this.connection.encodeString(Integer.toString(n5));
            byArrayArray[5] = this.connection.encodeString(Integer.toString(resultSet.getInt("attlen")));
            byArrayArray[6] = this.connection.encodeString(Integer.toString(n4));
            byArrayArray[7] = this.connection.encodeString(Integer.toString(1));
            ((VectorTuple)object).addElement(byArrayArray);
        }
        resultSet.close();
        return ((BaseStatement)this.createMetaDataStatement()).createDriverResultSet(fieldArray, (VectorTuple)object);
    }

    public ResultSet getVersionColumns(String string, String string2, String string3) throws SQLException {
        Field[] fieldArray = new Field[8];
        VectorTuple vectorTuple = new VectorTuple(this.connection.getLogger());
        fieldArray[0] = new Field("SCOPE", 21);
        fieldArray[1] = new Field("COLUMN_NAME", 9);
        fieldArray[2] = new Field("DATA_TYPE", 21);
        fieldArray[3] = new Field("TYPE_NAME", 9);
        fieldArray[4] = new Field("COLUMN_SIZE", 23);
        fieldArray[5] = new Field("BUFFER_LENGTH", 23);
        fieldArray[6] = new Field("DECIMAL_DIGITS", 21);
        fieldArray[7] = new Field("PSEUDO_COLUMN", 21);
        byte[][] byArrayArray = new byte[][]{null, this.connection.encodeString("epoch"), this.connection.encodeString(Integer.toString(this.connection.getSQLType("int8"))), this.connection.encodeString("int8"), this.connection.encodeString(Integer.toString(19)), this.connection.encodeString(Integer.toString(8)), this.connection.encodeString(Integer.toString(0)), this.connection.encodeString(Integer.toString(2))};
        vectorTuple.addElement(byArrayArray);
        return ((BaseStatement)this.createMetaDataStatement()).createDriverResultSet(fieldArray, vectorTuple);
    }

    public ResultSet getPrimaryKeys(String string, String string2, String string3) throws SQLException {
        Field[] fieldArray = new Field[6];
        VectorTuple vectorTuple = new VectorTuple(this.connection.getLogger());
        fieldArray[0] = new Field("TABLE_CAT", 9);
        fieldArray[1] = new Field("TABLE_SCHEM", 9);
        fieldArray[2] = new Field("TABLE_NAME", 9);
        fieldArray[3] = new Field("COLUMN_NAME", 9);
        fieldArray[4] = new Field("KEY_SEQ", 23);
        fieldArray[5] = new Field("PK_NAME", 9);
        int n = 0;
        String string4 = "select table_schema, table_name, column_name, constraint_name from v_catalog.primary_keys";
        ResultSet resultSet = this.connection.createStatement().executeQuery(string4);
        String string5 = null;
        if (string2 != null && !"".equals(string2)) {
            string5 = AbstractJdbc2DatabaseMetaData.replaceLikeWithRegExpr(string2.toLowerCase());
        }
        String string6 = null;
        if (string3 != null) {
            string6 = AbstractJdbc2DatabaseMetaData.replaceLikeWithRegExpr(string3.toLowerCase());
        }
        String string7 = null;
        String string8 = null;
        while (resultSet.next()) {
            String string9 = resultSet.getString("table_schema");
            String string10 = resultSet.getString("table_name");
            string9 = string9.toLowerCase();
            string10 = string10.toLowerCase();
            if (!string9.equalsIgnoreCase(string7) || !string10.equalsIgnoreCase(string8)) {
                n = 0;
            }
            string7 = string9;
            string8 = string10;
            byte[][] byArrayArray = new byte[][]{null, string9.getBytes(), string10.getBytes(), resultSet.getString("column_name").getBytes(), this.connection.encodeString(Integer.toString(++n)), resultSet.getString("constraint_name").getBytes()};
            if (string5 != null && !string9.matches(string5) || string6 != null && !string10.matches(string6)) continue;
            vectorTuple.addElement(byArrayArray);
        }
        resultSet.close();
        return ((BaseStatement)this.createMetaDataStatement()).createDriverResultSet(fieldArray, vectorTuple);
    }

    protected ResultSet getImportedExportedKeys(String string, String string2, String string3, String string4, String string5, String string6) throws SQLException {
        Field[] fieldArray = new Field[]{new Field("PKTABLE_CAT", 9), new Field("PKTABLE_SCHEM", 9), new Field("PKTABLE_NAME", 9), new Field("PKCOLUMN_NAME", 9), new Field("FKTABLE_CAT", 9), new Field("FKTABLE_SCHEM", 9), new Field("FKTABLE_NAME", 9), new Field("FKCOLUMN_NAME", 9), new Field("KEY_SEQ", 21), new Field("UPDATE_RULE", 21), new Field("DELETE_RULE", 21), new Field("FK_NAME", 9), new Field("PK_NAME", 9), new Field("DEFERRABILITY", 21)};
        String string7 = "";
        String string8 = null;
        if (string2 != null && !"".equals(string2)) {
            string8 = AbstractJdbc2DatabaseMetaData.replaceLikeWithRegExpr(string2);
        }
        String string9 = null;
        if (string3 != null) {
            string9 = AbstractJdbc2DatabaseMetaData.replaceLikeWithRegExpr(string3);
        }
        String string10 = null;
        if (string5 != null && !"".equals(string5)) {
            string10 = AbstractJdbc2DatabaseMetaData.replaceLikeWithRegExpr(string5);
        }
        String string11 = null;
        if (string6 != null) {
            string11 = AbstractJdbc2DatabaseMetaData.replaceLikeWithRegExpr(string6);
        }
        String string12 = "select constraint_name, column_name, ordinal_position, table_name, reference_table_name, reference_column_name, table_schema, reference_table_schema from v_catalog.foreign_keys";
        Hashtable hashtable = this.getPrimaryKeyNames();
        ResultSet resultSet = this.connection.createStatement().executeQuery(string12);
        VectorTuple vectorTuple = new VectorTuple(this.connection.getLogger());
        String string13 = null;
        String string14 = null;
        String string15 = null;
        String string16 = null;
        int n = 0;
        while (resultSet.next()) {
            String string17 = resultSet.getString("reference_table_name");
            String string18 = resultSet.getString("table_name");
            String string19 = resultSet.getString("reference_table_schema");
            String string20 = resultSet.getString("table_schema");
            if (!(string17.equalsIgnoreCase(string13) && string18.equalsIgnoreCase(string14) && string19.equalsIgnoreCase(string15) && string20.equalsIgnoreCase(string16))) {
                n = 0;
            }
            string13 = string17;
            string14 = string18;
            string15 = string19;
            string16 = string20;
            if (string9 != null && !string17.matches(string9) || string11 != null && !string18.matches(string11) || string8 != null && !string19.matches(string8) || string10 != null && !string20.matches(string10)) continue;
            byte[][] byArrayArray = new byte[14][];
            byArrayArray[0] = null;
            byArrayArray[1] = string19.getBytes();
            byArrayArray[2] = string17.getBytes();
            byArrayArray[3] = this.connection.encodeString(resultSet.getString("reference_column_name"));
            byArrayArray[4] = null;
            byArrayArray[5] = string20.getBytes();
            byArrayArray[6] = string18.getBytes();
            byArrayArray[7] = this.connection.encodeString(resultSet.getString("column_name"));
            byArrayArray[8] = this.connection.encodeString(Integer.toString(++n));
            int n2 = 0;
            byArrayArray[9] = this.connection.encodeString(Integer.toString(n2));
            byArrayArray[10] = this.connection.encodeString(Integer.toString(n2));
            byArrayArray[11] = this.connection.encodeString(resultSet.getString("constraint_name"));
            byArrayArray[12] = (byte[])(hashtable.get(string17) != null ? ((String)hashtable.get(string17)).getBytes() : null);
            int n3 = 7;
            byArrayArray[13] = this.connection.encodeString(Integer.toString(n3));
            vectorTuple.addElement(byArrayArray);
        }
        return ((BaseStatement)this.createMetaDataStatement()).createDriverResultSet(fieldArray, vectorTuple);
    }

    public ResultSet getImportedKeys(String string, String string2, String string3) throws SQLException {
        return this.getImportedExportedKeys(null, null, null, string, string2, string3);
    }

    public ResultSet getExportedKeys(String string, String string2, String string3) throws SQLException {
        return this.getImportedExportedKeys(string, string2, string3, null, null, null);
    }

    public ResultSet getCrossReference(String string, String string2, String string3, String string4, String string5, String string6) throws SQLException {
        return this.getImportedExportedKeys(string, string2, string3, string4, string5, string6);
    }

    public ResultSet getTypeInfo() throws SQLException {
        Field[] fieldArray = new Field[18];
        VectorTuple vectorTuple = new VectorTuple(this.connection.getLogger());
        fieldArray[0] = new Field("TYPE_NAME", 9);
        fieldArray[1] = new Field("DATA_TYPE", 21);
        fieldArray[2] = new Field("PRECISION", 23);
        fieldArray[3] = new Field("LITERAL_PREFIX", 9);
        fieldArray[4] = new Field("LITERAL_SUFFIX", 9);
        fieldArray[5] = new Field("CREATE_PARAMS", 9);
        fieldArray[6] = new Field("NULLABLE", 21);
        fieldArray[7] = new Field("CASE_SENSITIVE", 5);
        fieldArray[8] = new Field("SEARCHABLE", 21);
        fieldArray[9] = new Field("UNSIGNED_ATTRIBUTE", 5);
        fieldArray[10] = new Field("FIXED_PREC_SCALE", 5);
        fieldArray[11] = new Field("AUTO_INCREMENT", 5);
        fieldArray[12] = new Field("LOCAL_TYPE_NAME", 9);
        fieldArray[13] = new Field("MINIMUM_SCALE", 21);
        fieldArray[14] = new Field("MAXIMUM_SCALE", 21);
        fieldArray[15] = new Field("SQL_DATA_TYPE", 23);
        fieldArray[16] = new Field("SQL_DATETIME_SUB", 23);
        fieldArray[17] = new Field("NUM_PREC_RADIX", 23);
        byte[] byArray = this.connection.encodeString("0");
        byte[] byArray2 = this.connection.encodeString("10");
        byte[] byArray3 = this.connection.encodeString(FOREIGN_KEY_CONSTRAINT_TYPE);
        byte[] byArray4 = this.connection.encodeString("t");
        byte[] byArray5 = this.connection.encodeString(Integer.toString(1));
        byte[] byArray6 = this.connection.encodeString(Integer.toString(3));
        for (int i = 0; i < TypeInfoCache.types.length; ++i) {
            byte[][] byArrayArray = new byte[18][];
            String string = (String)TypeInfoCache.types[i][0];
            int n = (Integer)TypeInfoCache.types[i][1];
            byArrayArray[0] = this.connection.encodeString(string);
            byArrayArray[1] = this.connection.encodeString(Integer.toString(this.connection.getSQLType(string)));
            byArrayArray[2] = this.connection.encodeString(Integer.toString(TypeInfoCache.getMaximumPrecision(n)));
            byArrayArray[6] = byArray5;
            byArrayArray[7] = TypeInfoCache.isCaseSensitive(n) ? byArray4 : byArray3;
            byArrayArray[8] = byArray6;
            byArrayArray[9] = TypeInfoCache.isSigned(n) ? byArray4 : byArray3;
            byArrayArray[10] = byArray3;
            byArrayArray[11] = byArray3;
            byArrayArray[13] = byArray;
            byArrayArray[14] = n == 16 ? this.connection.encodeString("1000") : byArray;
            byArrayArray[14] = byArray;
            byArrayArray[17] = byArray2;
            vectorTuple.addElement(byArrayArray);
        }
        return ((BaseStatement)this.createMetaDataStatement()).createDriverResultSet(fieldArray, vectorTuple);
    }

    public ResultSet getIndexInfo(String string, String string2, String string3, boolean bl, boolean bl2) throws SQLException {
        Field[] fieldArray = new Field[]{new Field("TABLE_CAT", 9), new Field("TABLE_SCHEME", 9), new Field("TABLE_NAME", 9), new Field("NON_UNIQUE", 5), new Field("INDEX_QUALIFIER", 9), new Field("INDEX_NAME", 9), new Field("TYPE", 21), new Field("ORDINAL_POSITION", 21), new Field("COLUMN_NAME", 9), new Field("ASC_OR_DESC", 9), new Field("CARDINALITY", 6), new Field("PAGES", 6), new Field("FILTER_CONDITION", 9)};
        VectorTuple vectorTuple = new VectorTuple(this.connection.getLogger());
        return ((BaseStatement)this.createMetaDataStatement()).createDriverResultSet(fieldArray, vectorTuple);
    }

    private static Vector tokenize(String string, String string2) {
        Vector<String> vector = new Vector<String>();
        int n = 0;
        int n2 = string.length();
        int n3 = string2.length();
        while (n < n2) {
            int n4 = string.indexOf(string2, n);
            if (n4 < 0) {
                vector.addElement(string.substring(n));
                break;
            }
            String string3 = string.substring(n, n4);
            vector.addElement(string3);
            n = n4 + n3;
        }
        return vector;
    }

    public boolean supportsResultSetType(int n) throws SQLException {
        return n == 1003;
    }

    public boolean supportsResultSetConcurrency(int n, int n2) throws SQLException {
        if (n == 1005) {
            return false;
        }
        if (n2 == 1008) {
            return true;
        }
        return true;
    }

    public boolean ownUpdatesAreVisible(int n) throws SQLException {
        return true;
    }

    public boolean ownDeletesAreVisible(int n) throws SQLException {
        return true;
    }

    public boolean ownInsertsAreVisible(int n) throws SQLException {
        return true;
    }

    public boolean othersUpdatesAreVisible(int n) throws SQLException {
        return false;
    }

    public boolean othersDeletesAreVisible(int n) throws SQLException {
        return false;
    }

    public boolean othersInsertsAreVisible(int n) throws SQLException {
        return false;
    }

    public boolean updatesAreDetected(int n) throws SQLException {
        return false;
    }

    public boolean deletesAreDetected(int n) throws SQLException {
        return false;
    }

    public boolean insertsAreDetected(int n) throws SQLException {
        return false;
    }

    public boolean supportsBatchUpdates() throws SQLException {
        return true;
    }

    public ResultSet getUDTs(String string, String string2, String string3, int[] nArray) throws SQLException {
        Field[] fieldArray = new Field[1];
        VectorTuple vectorTuple = new VectorTuple(this.connection.getLogger());
        return ((BaseStatement)this.createMetaDataStatement()).createDriverResultSet(fieldArray, vectorTuple);
    }

    public Connection getConnection() throws SQLException {
        return this.connection;
    }

    public boolean rowChangesAreDetected(int n) throws SQLException {
        return false;
    }

    public boolean rowChangesAreVisible(int n) throws SQLException {
        return false;
    }

    protected Statement createMetaDataStatement() throws SQLException {
        return this.connection.createStatement(1003, 1007);
    }

    private Hashtable getForeignKeyNames() {
        return this.getKeyNames(FOREIGN_KEY_CONSTRAINT_TYPE);
    }

    private Hashtable getPrimaryKeyNames() {
        return this.getKeyNames(PRIMARY_KEY_CONSTRAINT_TYPE);
    }

    private Hashtable getKeyNames(String string) {
        Hashtable<String, String> hashtable = new Hashtable<String, String>();
        try {
            String string2 = "select relid, name, constrtype from v_internal.vs_constraints";
            String string3 = "select table_id, table_name from v_catalog.tables";
            Statement statement = this.connection.createStatement();
            ResultSet resultSet = statement.executeQuery(string3);
            while (resultSet.next()) {
                hashtable.put(Integer.toString(resultSet.getInt(1)), resultSet.getString(2));
            }
            resultSet.close();
            resultSet = statement.executeQuery(string2);
            while (resultSet.next()) {
                if (resultSet.getString("constrtype").compareTo(string) != 0) continue;
                String string4 = Integer.toString(resultSet.getInt("relid"));
                String string5 = (String)hashtable.get(string4);
                hashtable.remove(string4);
                hashtable.put(string5, resultSet.getString("name"));
            }
            resultSet.close();
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        return hashtable;
    }

    static {
        tableTypeClauses.put("TABLE", true);
        tableTypeClauses.put("VIEW", true);
        tableTypeClauses.put("INDEX", false);
        tableTypeClauses.put("SEQUENCE", false);
        tableTypeClauses.put("SYSTEM TABLE", false);
        tableTypeClauses.put("SYSTEM TOAST TABLE", false);
        tableTypeClauses.put("SYSTEM TOAST INDEX", false);
        tableTypeClauses.put("SYSTEM VIEW", false);
        tableTypeClauses.put("SYSTEM INDEX", false);
        tableTypeClauses.put("TEMPORARY TABLE", false);
        tableTypeClauses.put("TEMPORARY INDEX", false);
    }
}

