/*
 * Decompiled with CFR 0.152.
 */
package com.vertica.jdbc2;

import com.vertica.Driver;
import com.vertica.core.BaseConnection;
import com.vertica.core.BaseResultSet;
import com.vertica.core.BaseStatement;
import com.vertica.core.Field;
import com.vertica.core.VectorTuple;
import com.vertica.jdbc2.AbstractJdbc2ResultSet;
import com.vertica.util.GT;
import com.vertica.util.PSQLException;
import com.vertica.util.PSQLState;
import java.math.BigDecimal;
import java.sql.Date;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Map;
import java.util.Vector;

public class AbstractJdbc2Array {
    private BaseConnection conn = null;
    private Field field = null;
    private BaseResultSet rs;
    private int idx = 0;
    private String rawString = null;

    public AbstractJdbc2Array(BaseConnection baseConnection, int n, Field field, BaseResultSet baseResultSet) throws SQLException {
        this.conn = baseConnection;
        this.field = field;
        this.rs = baseResultSet;
        this.idx = n;
        this.rawString = baseResultSet.getFixedString(n);
    }

    public Object getArray() throws SQLException {
        return this.getArrayImpl(1L, 0, null);
    }

    public Object getArray(long l, int n) throws SQLException {
        return this.getArrayImpl(l, n, null);
    }

    public Object getArrayImpl(Map map) throws SQLException {
        return this.getArrayImpl(1L, 0, map);
    }

    public Object getArrayImpl(long l, int n, Map map) throws SQLException {
        Object[] objectArray;
        if (map != null && !map.isEmpty()) {
            throw Driver.notImplemented(this.getClass(), "getArrayImpl(long,int,Map)");
        }
        if (l < 1L) {
            throw new PSQLException(GT.tr("The array index is out of range: {0}", new Long(l)), PSQLState.DATA_ERROR);
        }
        Object[] objectArray2 = null;
        ArrayList<String> arrayList = new ArrayList<String>();
        if (this.rawString != null && !this.rawString.equals("{}")) {
            objectArray = this.rawString.toCharArray();
            StringBuffer stringBuffer = new StringBuffer();
            boolean bl = false;
            boolean bl2 = false;
            int n2 = 0;
            if (objectArray[0] == 91) {
                while (objectArray[n2] != 61) {
                    ++n2;
                }
                ++n2;
            }
            for (int i = n2; i < objectArray.length; ++i) {
                if (objectArray[i] == 92) {
                    ++i;
                } else {
                    if (!bl2 && objectArray[i] == 123) {
                        if (bl) {
                            throw new PSQLException(GT.tr("Multi-dimensional arrays are currently not supported."), PSQLState.NOT_IMPLEMENTED);
                        }
                        bl = true;
                        continue;
                    }
                    if (objectArray[i] == 34) {
                        bl2 = !bl2;
                        continue;
                    }
                    if (!bl2 && (objectArray[i] == 44 || objectArray[i] == 125) || i == objectArray.length - 1) {
                        if (objectArray[i] != 34 && objectArray[i] != 125 && objectArray[i] != 44) {
                            stringBuffer.append((char)objectArray[i]);
                        }
                        arrayList.add(stringBuffer.toString());
                        stringBuffer = new StringBuffer();
                        continue;
                    }
                }
                stringBuffer.append((char)objectArray[i]);
            }
        }
        objectArray = arrayList.toArray(new String[arrayList.size()]);
        if (n == 0) {
            n = objectArray.length;
        }
        if (--l + (long)n > (long)objectArray.length) {
            throw new PSQLException(GT.tr("The array index is out of range: {0}, number of elements: {1}.", new Object[]{new Long(l + (long)n), new Long(objectArray.length)}), PSQLState.DATA_ERROR);
        }
        int n3 = 0;
        Object var9_10 = null;
        switch (this.getBaseType()) {
            case -7: {
                objectArray2 = new boolean[n];
                while (n > 0) {
                    objectArray2[n3++] = AbstractJdbc2ResultSet.toBoolean(objectArray[(int)l++]);
                    --n;
                }
                break;
            }
            case -5: {
                objectArray2 = new long[n];
                while (n > 0) {
                    ((long[])objectArray2)[n3++] = AbstractJdbc2ResultSet.toLong(objectArray[(int)l++]);
                    --n;
                }
                break;
            }
            case 2: {
                objectArray2 = new BigDecimal[n];
                while (n > 0) {
                    ((BigDecimal[])objectArray2)[n3++] = AbstractJdbc2ResultSet.toBigDecimal(objectArray[(int)l++], -1);
                    --n;
                }
                break;
            }
            case 8: {
                objectArray2 = new double[n];
                while (n > 0) {
                    ((double[])objectArray2)[n3++] = AbstractJdbc2ResultSet.toDouble(objectArray[(int)l++]);
                    --n;
                }
                break;
            }
            case 1: 
            case 12: {
                objectArray2 = new String[n];
                while (n > 0) {
                    ((String[])objectArray2)[n3++] = objectArray[(int)l++];
                    --n;
                }
                break;
            }
            case 91: {
                objectArray2 = new Date[n];
                while (n > 0) {
                    ((Date[])objectArray2)[n3++] = this.conn.getTimestampUtils().toDate(null, objectArray[(int)l++]);
                    --n;
                }
                break;
            }
            case 92: {
                objectArray2 = new Time[n];
                while (n > 0) {
                    ((Time[])objectArray2)[n3++] = this.conn.getTimestampUtils().toTime(null, objectArray[(int)l++]);
                    --n;
                }
                break;
            }
            case 93: {
                objectArray2 = new Timestamp[n];
                while (n > 0) {
                    ((Timestamp[])objectArray2)[n3++] = this.conn.getTimestampUtils().toTimestamp(null, objectArray[(int)l++]);
                    --n;
                }
                break;
            }
            default: {
                if (this.conn.getLogger().logDebug()) {
                    this.conn.getLogger().debug("getArrayImpl(long,int,Map) with " + this.getBaseTypeName());
                }
                throw Driver.notImplemented(this.getClass(), "getArrayImpl(long,int,Map)");
            }
        }
        return objectArray2;
    }

    public int getBaseType() throws SQLException {
        return this.conn.getSQLType(this.getBaseTypeName());
    }

    public String getBaseTypeName() throws SQLException {
        String string = this.conn.getPGType(this.field.getOID());
        if (string.charAt(0) == '_') {
            string = string.substring(1);
        }
        return string;
    }

    public ResultSet getResultSet() throws SQLException {
        return this.getResultSetImpl(1L, 0, null);
    }

    public ResultSet getResultSet(long l, int n) throws SQLException {
        return this.getResultSetImpl(l, n, null);
    }

    public ResultSet getResultSetImpl(Map map) throws SQLException {
        return this.getResultSetImpl(1L, 0, map);
    }

    private void fillIntegerResultSet(long l, int[] nArray, Vector vector) throws SQLException {
        for (int i = 0; i < nArray.length; ++i) {
            byte[][] byArray = new byte[2][0];
            byArray[0] = this.conn.encodeString(Integer.toString((int)l + i));
            byArray[1] = this.conn.encodeString(Integer.toString(nArray[i]));
            vector.addElement(byArray);
        }
    }

    private void fillStringResultSet(long l, String[] stringArray, VectorTuple vectorTuple) throws SQLException {
        for (int i = 0; i < stringArray.length; ++i) {
            byte[][] byArray = new byte[2][0];
            byArray[0] = this.conn.encodeString(Integer.toString((int)l + i));
            byArray[1] = this.conn.encodeString(stringArray[i]);
            vectorTuple.addElement(byArray);
        }
    }

    public ResultSet getResultSetImpl(long l, int n, Map map) throws SQLException {
        Object object;
        Object object2 = this.getArrayImpl(l, n, map);
        VectorTuple vectorTuple = new VectorTuple(this.conn.getLogger());
        Field[] fieldArray = new Field[2];
        fieldArray[0] = new Field("INDEX", 21);
        switch (this.getBaseType()) {
            case -7: {
                object = (boolean[])object2;
                fieldArray[1] = new Field("VALUE", 5);
                for (int i = 0; i < ((boolean[])object).length; ++i) {
                    byte[][] byArray = new byte[2][0];
                    byArray[0] = this.conn.encodeString(Integer.toString((int)l + i));
                    byArray[1] = this.conn.encodeString(object[i] != false ? "YES" : "NO");
                    vectorTuple.addElement(byArray);
                }
                break;
            }
            case -5: {
                long[] lArray = (long[])object2;
                fieldArray[1] = new Field("VALUE", 6);
                for (int i = 0; i < lArray.length; ++i) {
                    byte[][] byArray = new byte[2][0];
                    byArray[0] = this.conn.encodeString(Integer.toString((int)l + i));
                    byArray[1] = this.conn.encodeString(Long.toString(lArray[i]));
                    vectorTuple.addElement(byArray);
                }
                break;
            }
            case 2: {
                BigDecimal[] bigDecimalArray = (BigDecimal[])object2;
                fieldArray[1] = new Field("VALUE", 16);
                for (int i = 0; i < bigDecimalArray.length; ++i) {
                    byte[][] byArray = new byte[2][0];
                    byArray[0] = this.conn.encodeString(Integer.toString((int)l + i));
                    byArray[1] = this.conn.encodeString(bigDecimalArray[i].toString());
                    vectorTuple.addElement(byArray);
                }
                break;
            }
            case 8: {
                double[] dArray = (double[])object2;
                fieldArray[1] = new Field("VALUE", 7);
                for (int i = 0; i < dArray.length; ++i) {
                    byte[][] byArray = new byte[2][0];
                    byArray[0] = this.conn.encodeString(Integer.toString((int)l + i));
                    byArray[1] = this.conn.encodeString(Double.toString(dArray[i]));
                    vectorTuple.addElement(byArray);
                }
                break;
            }
            case 1: {
                fieldArray[1] = new Field("VALUE", 8);
                this.fillStringResultSet(l, (String[])object2, vectorTuple);
                break;
            }
            case 12: {
                fieldArray[1] = new Field("VALUE", 9);
                this.fillStringResultSet(l, (String[])object2, vectorTuple);
                break;
            }
            case 91: {
                Date[] dateArray = (Date[])object2;
                fieldArray[1] = new Field("VALUE", 10);
                for (int i = 0; i < dateArray.length; ++i) {
                    byte[][] byArray = new byte[2][0];
                    byArray[0] = this.conn.encodeString(Integer.toString((int)l + i));
                    byArray[1] = this.conn.encodeString(this.conn.getTimestampUtils().toString(null, dateArray[i]));
                    vectorTuple.addElement(byArray);
                }
                break;
            }
            case 92: {
                Time[] timeArray = (Time[])object2;
                fieldArray[1] = new Field("VALUE", 11);
                for (int i = 0; i < timeArray.length; ++i) {
                    byte[][] byArray = new byte[2][0];
                    byArray[0] = this.conn.encodeString(Integer.toString((int)l + i));
                    byArray[1] = this.conn.encodeString(this.conn.getTimestampUtils().toString(null, timeArray[i]));
                    vectorTuple.addElement(byArray);
                }
                break;
            }
            case 93: {
                Timestamp[] timestampArray = (Timestamp[])object2;
                fieldArray[1] = new Field("VALUE", 13);
                for (int i = 0; i < timestampArray.length; ++i) {
                    byte[][] byArray = new byte[2][0];
                    byArray[0] = this.conn.encodeString(Integer.toString((int)l + i));
                    byArray[1] = this.conn.encodeString(this.conn.getTimestampUtils().toString(null, timestampArray[i]));
                    vectorTuple.addElement(byArray);
                }
                break;
            }
            default: {
                if (this.conn.getLogger().logDebug()) {
                    this.conn.getLogger().debug("getResultSetImpl(long,int,Map) with " + this.getBaseTypeName());
                }
                throw Driver.notImplemented(this.getClass(), "getResultSetImpl(long,int,Map)");
            }
        }
        object = (BaseStatement)this.conn.createStatement(1003, 1007);
        return object.createDriverResultSet(fieldArray, vectorTuple);
    }

    public String toString() {
        return this.rawString;
    }
}

