/*
 * Decompiled with CFR 0.152.
 */
package com.vertica.geometric;

import com.vertica.geometric.PGpoint;
import com.vertica.util.GT;
import com.vertica.util.PGobject;
import com.vertica.util.PGtokenizer;
import com.vertica.util.PSQLException;
import com.vertica.util.PSQLState;
import java.io.Serializable;
import java.sql.SQLException;

public class PGpath
extends PGobject
implements Serializable,
Cloneable {
    public boolean open;
    public PGpoint[] points;

    public PGpath(PGpoint[] pGpointArray, boolean bl) {
        this();
        this.points = pGpointArray;
        this.open = bl;
    }

    public PGpath() {
        this.setType("path");
    }

    public PGpath(String string) throws SQLException {
        this();
        this.setValue(string);
    }

    public void setValue(String string) throws SQLException {
        if (string.startsWith("[") && string.endsWith("]")) {
            this.open = true;
            string = PGtokenizer.removeBox(string);
        } else if (string.startsWith("(") && string.endsWith(")")) {
            this.open = false;
            string = PGtokenizer.removePara(string);
        } else {
            throw new PSQLException(GT.tr("Cannot tell if path is open or closed: {0}.", string), PSQLState.DATA_TYPE_MISMATCH);
        }
        PGtokenizer pGtokenizer = new PGtokenizer(string, ',');
        int n = pGtokenizer.getSize();
        this.points = new PGpoint[n];
        for (int i = 0; i < n; ++i) {
            this.points[i] = new PGpoint(pGtokenizer.getToken(i));
        }
    }

    public boolean equals(Object object) {
        if (object instanceof PGpath) {
            PGpath pGpath = (PGpath)object;
            if (pGpath.points.length != this.points.length) {
                return false;
            }
            if (pGpath.open != this.open) {
                return false;
            }
            for (int i = 0; i < this.points.length; ++i) {
                if (this.points[i].equals(pGpath.points[i])) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public int hashCode() {
        int n = 0;
        for (int i = 0; i < this.points.length && i < 5; ++i) {
            n ^= this.points[i].hashCode();
        }
        return n;
    }

    public Object clone() {
        PGpoint[] pGpointArray = new PGpoint[this.points.length];
        for (int i = 0; i < this.points.length; ++i) {
            pGpointArray[i] = (PGpoint)this.points[i].clone();
        }
        return new PGpath(pGpointArray, this.open);
    }

    public String getValue() {
        StringBuffer stringBuffer = new StringBuffer(this.open ? "[" : "(");
        for (int i = 0; i < this.points.length; ++i) {
            if (i > 0) {
                stringBuffer.append(",");
            }
            stringBuffer.append(this.points[i].toString());
        }
        stringBuffer.append(this.open ? "]" : ")");
        return stringBuffer.toString();
    }

    public boolean isOpen() {
        return this.open;
    }

    public boolean isClosed() {
        return !this.open;
    }

    public void closePath() {
        this.open = false;
    }

    public void openPath() {
        this.open = true;
    }
}

