/*
 * Decompiled with CFR 0.152.
 */
package com.vertica.geometric;

import com.vertica.geometric.PGpoint;
import com.vertica.util.GT;
import com.vertica.util.PGobject;
import com.vertica.util.PGtokenizer;
import com.vertica.util.PSQLException;
import com.vertica.util.PSQLState;
import java.io.Serializable;
import java.sql.SQLException;

public class PGcircle
extends PGobject
implements Serializable,
Cloneable {
    public PGpoint center;
    public double radius;

    public PGcircle(double d, double d2, double d3) {
        this(new PGpoint(d, d2), d3);
    }

    public PGcircle(PGpoint pGpoint, double d) {
        this();
        this.center = pGpoint;
        this.radius = d;
    }

    public PGcircle(String string) throws SQLException {
        this();
        this.setValue(string);
    }

    public PGcircle() {
        this.setType("circle");
    }

    public void setValue(String string) throws SQLException {
        PGtokenizer pGtokenizer = new PGtokenizer(PGtokenizer.removeAngle(string), ',');
        if (pGtokenizer.getSize() != 2) {
            throw new PSQLException(GT.tr("Conversion to type {0} failed: {1}.", new Object[]{this.type, string}), PSQLState.DATA_TYPE_MISMATCH);
        }
        try {
            this.center = new PGpoint(pGtokenizer.getToken(0));
            this.radius = Double.valueOf(pGtokenizer.getToken(1));
        }
        catch (NumberFormatException numberFormatException) {
            throw new PSQLException(GT.tr("Conversion to type {0} failed: {1}.", new Object[]{this.type, string}), PSQLState.DATA_TYPE_MISMATCH, (Throwable)numberFormatException);
        }
    }

    public boolean equals(Object object) {
        if (object instanceof PGcircle) {
            PGcircle pGcircle = (PGcircle)object;
            return pGcircle.center.equals(this.center) && pGcircle.radius == this.radius;
        }
        return false;
    }

    public int hashCode() {
        long l = Double.doubleToLongBits(this.radius);
        return (int)((long)this.center.hashCode() ^ l ^ l >>> 32);
    }

    public Object clone() {
        return new PGcircle((PGpoint)this.center.clone(), this.radius);
    }

    public String getValue() {
        return "<" + this.center + "," + this.radius + ">";
    }
}

