/*
 * Decompiled with CFR 0.152.
 */
package com.vertica.core.v3;

import com.vertica.core.Field;
import com.vertica.core.ParameterList;
import com.vertica.core.Utils;
import com.vertica.core.v3.SimpleParameterList;
import com.vertica.core.v3.V3Query;
import java.lang.ref.PhantomReference;

class SimpleQuery
implements V3Query {
    private Field[] fields;
    private final String[] fragments;
    private String statementName;
    private byte[] encodedStatementName;
    private PhantomReference cleanupRef;
    private int[] preparedTypes;
    private final boolean isDML;
    static final SimpleParameterList NO_PARAMETERS = new SimpleParameterList(0);

    SimpleQuery(String[] stringArray) {
        int n;
        String string;
        this.fragments = stringArray;
        this.isDML = stringArray != null && stringArray[0] != null ? (string = (n = stringArray[0].indexOf(" ")) > 0 ? stringArray[0].substring(0, n).toUpperCase() : stringArray[0].toUpperCase()).compareTo("INSERT") == 0 || string.compareTo("UPDATE") == 0 || string.compareTo("DELETE") == 0 : false;
    }

    public ParameterList createParameterList() {
        if (this.fragments.length == 1) {
            return NO_PARAMETERS;
        }
        return new SimpleParameterList(this.fragments.length - 1);
    }

    public String toString(ParameterList parameterList) {
        StringBuffer stringBuffer = new StringBuffer(this.fragments[0]);
        for (int i = 1; i < this.fragments.length; ++i) {
            if (parameterList == null) {
                stringBuffer.append('?');
            } else {
                stringBuffer.append(parameterList.toString(i));
            }
            stringBuffer.append(this.fragments[i]);
        }
        return stringBuffer.toString();
    }

    public String toString() {
        return this.toString(null);
    }

    public void close() {
        this.unprepare();
    }

    Field[] getFields() {
        return this.fields;
    }

    void setFields(Field[] fieldArray) {
        this.fields = fieldArray;
    }

    public SimpleQuery[] getSubqueries() {
        return null;
    }

    String[] getFragments() {
        return this.fragments;
    }

    void setStatementName(String string) {
        this.statementName = string;
        this.encodedStatementName = Utils.encodeUTF8(string);
    }

    void setStatementTypes(int[] nArray) {
        this.preparedTypes = nArray;
    }

    String getStatementName() {
        return this.statementName;
    }

    boolean isPreparedFor(int[] nArray) {
        if (this.statementName == null) {
            return false;
        }
        for (int i = 0; i < nArray.length; ++i) {
            if (nArray[i] == this.preparedTypes[i]) continue;
            return false;
        }
        return true;
    }

    byte[] getEncodedStatementName() {
        return this.encodedStatementName;
    }

    void setCleanupRef(PhantomReference phantomReference) {
        if (this.cleanupRef != null) {
            this.cleanupRef.clear();
            this.cleanupRef.enqueue();
        }
        this.cleanupRef = phantomReference;
    }

    void unprepare() {
        if (this.cleanupRef != null) {
            this.cleanupRef.clear();
            this.cleanupRef.enqueue();
            this.cleanupRef = null;
        }
        this.statementName = null;
        this.encodedStatementName = null;
    }

    public boolean isDML() {
        return this.isDML;
    }
}

