/*
 * Decompiled with CFR 0.152.
 */
package com.vertica.core.v3;

import com.vertica.core.PGStream;
import com.vertica.core.ParameterList;
import com.vertica.core.Utils;
import com.vertica.core.v3.V3ParameterList;
import com.vertica.util.GT;
import com.vertica.util.PSQLException;
import com.vertica.util.PSQLState;
import com.vertica.util.StreamWrapper;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;

class SimpleParameterList
implements V3ParameterList {
    private static final int IN = 1;
    private static final int OUT = 2;
    private static final int INOUT = 3;
    private final Object[] paramValues;
    private final int[] paramTypes;
    private final int[] direction;
    private final byte[][] encoded;
    private StringBuffer row;
    private ByteArrayOutputStream resultBuffer;
    private static final Object NULL_OBJECT = new Object();

    SimpleParameterList(int n) {
        this.paramValues = new Object[n];
        this.paramTypes = new int[n];
        this.encoded = new byte[n][];
        this.direction = new int[n];
        this.row = new StringBuffer();
        this.row.ensureCapacity(10240);
    }

    public void registerOutParameter(int n, int n2) throws SQLException {
        if (n < 1 || n > this.paramValues.length) {
            throw new PSQLException(GT.tr("The column index is out of range: {0}, number of columns: {1}.", new Object[]{new Integer(n), new Integer(this.paramValues.length)}), PSQLState.INVALID_PARAMETER_VALUE);
        }
        int n3 = n - 1;
        this.direction[n3] = this.direction[n3] | 2;
    }

    private void bind(int n, Object object, int n2) throws SQLException {
        if (n < 1 || n > this.paramValues.length) {
            throw new PSQLException(GT.tr("The column index is out of range: {0}, number of columns: {1}.", new Object[]{new Integer(n), new Integer(this.paramValues.length)}), PSQLState.INVALID_PARAMETER_VALUE);
        }
        this.encoded[--n] = null;
        this.paramValues[n] = object;
        int n3 = n;
        this.direction[n3] = this.direction[n3] | 1;
        if (n2 == 0 && this.paramTypes[n] != 0 && object == NULL_OBJECT) {
            return;
        }
        this.paramTypes[n] = n2;
    }

    public int getParameterCount() {
        return this.paramValues.length;
    }

    public int getOutParameterCount() {
        int n = 0;
        int n2 = this.paramTypes.length;
        while (--n2 >= 0) {
            if ((this.direction[n2] & 2) != 2) continue;
            ++n;
        }
        if (n == 0) {
            n = 1;
        }
        return n;
    }

    public int getInParameterCount() {
        int n = 0;
        for (int i = 0; i < this.paramTypes.length; ++i) {
            if (this.direction[i] == 2) continue;
            ++n;
        }
        return n;
    }

    public void setIntParameter(int n, int n2) throws SQLException {
        byte[] byArray = new byte[4];
        byArray[3] = (byte)n2;
        byArray[2] = (byte)(n2 >> 8);
        byArray[1] = (byte)(n2 >> 16);
        byArray[0] = (byte)(n2 >> 24);
        this.bind(n, byArray, 23);
    }

    public void setLiteralParameter(int n, String string, int n2) throws SQLException {
        this.bind(n, string, n2);
    }

    public void setStringParameter(int n, String string, int n2) throws SQLException {
        this.bind(n, string, n2);
    }

    public void setBytea(int n, byte[] byArray, int n2, int n3) throws SQLException {
        this.bind(n, new StreamWrapper(byArray, n2, n3), 117);
    }

    public void setBytea(int n, InputStream inputStream, int n2) throws SQLException {
        this.bind(n, new StreamWrapper(inputStream, n2), 117);
    }

    public void setNull(int n, int n2) throws SQLException {
        this.bind(n, NULL_OBJECT, n2);
    }

    public String toString(int n) {
        if (this.paramValues[--n] == null) {
            return "?";
        }
        if (this.paramValues[n] == NULL_OBJECT) {
            return "NULL";
        }
        return this.paramValues[n].toString();
    }

    public void checkAllParametersSet() throws SQLException {
        for (int i = 0; i < this.paramTypes.length; ++i) {
            if (this.direction[i] == 2 || this.paramValues[i] != null) continue;
            throw new PSQLException(GT.tr("No value specified for parameter {0}.", new Integer(i + 1)), PSQLState.INVALID_PARAMETER_VALUE);
        }
    }

    private static void streamBytea(PGStream pGStream, StreamWrapper streamWrapper) throws IOException {
        byte[] byArray = streamWrapper.getBytes();
        if (byArray != null) {
            pGStream.Send(byArray, streamWrapper.getOffset(), streamWrapper.getLength());
            return;
        }
        pGStream.SendStream(streamWrapper.getStream(), streamWrapper.getLength());
    }

    public int[] getTypeOIDs() {
        return this.paramTypes;
    }

    int getTypeOID(int n) {
        if (this.direction[n - 1] == 2) {
            this.paramTypes[n - 1] = 2278;
            this.paramValues[n - 1] = "null";
        }
        return this.paramTypes[n - 1];
    }

    boolean hasUnresolvedTypes() {
        for (int i = 0; i < this.paramTypes.length; ++i) {
            if (this.paramTypes[i] != 0) continue;
            return true;
        }
        return false;
    }

    void setResolvedType(int n, int n2) {
        if (this.paramTypes[n - 1] == 0) {
            this.paramTypes[n - 1] = n2;
        }
    }

    boolean isNull(int n) {
        return this.paramValues[n - 1] == NULL_OBJECT;
    }

    boolean isBinary(int n) {
        return this.paramValues[n - 1] instanceof StreamWrapper;
    }

    int getV3Length(int n) {
        if (this.paramValues[--n] == NULL_OBJECT) {
            throw new IllegalArgumentException("can't getV3Length() on a null parameter");
        }
        if (this.paramValues[n] instanceof byte[]) {
            return ((byte[])this.paramValues[n]).length;
        }
        if (this.paramValues[n] instanceof StreamWrapper) {
            return ((StreamWrapper)this.paramValues[n]).getLength();
        }
        if (this.encoded[n] == null) {
            this.encoded[n] = Utils.encodeUTF8(this.paramValues[n].toString());
        }
        return this.encoded[n].length;
    }

    void writeV3Value(int n, PGStream pGStream) throws IOException {
        if (this.paramValues[--n] == NULL_OBJECT) {
            throw new IllegalArgumentException("can't writeV3Value() on a null parameter");
        }
        if (this.paramValues[n] instanceof byte[]) {
            pGStream.Send((byte[])this.paramValues[n]);
            return;
        }
        if (this.paramValues[n] instanceof StreamWrapper) {
            SimpleParameterList.streamBytea(pGStream, (StreamWrapper)this.paramValues[n]);
            return;
        }
        if (this.encoded[n] == null) {
            this.encoded[n] = Utils.encodeUTF8((String)this.paramValues[n]);
        }
        pGStream.Send(this.encoded[n]);
    }

    public ParameterList copy() {
        SimpleParameterList simpleParameterList = new SimpleParameterList(this.paramValues.length);
        System.arraycopy(this.paramValues, 0, simpleParameterList.paramValues, 0, this.paramValues.length);
        System.arraycopy(this.paramTypes, 0, simpleParameterList.paramTypes, 0, this.paramTypes.length);
        System.arraycopy(this.direction, 0, simpleParameterList.direction, 0, this.direction.length);
        return simpleParameterList;
    }

    public void clear() {
        Arrays.fill(this.paramValues, null);
        Arrays.fill(this.paramTypes, 0);
        Arrays.fill((Object[])this.encoded, null);
        Arrays.fill(this.direction, 0);
    }

    public SimpleParameterList[] getSubparams() {
        return null;
    }

    public String toBatchString(String string) {
        this.row.delete(0, this.row.length());
        for (int i = 0; i < this.paramValues.length; ++i) {
            if (this.paramValues[i] != null) {
                if ((this.paramTypes[i] == 117 || this.paramTypes[i] == 17 || this.paramTypes[i] == 9 || this.paramTypes[i] == 8 || this.paramTypes[i] == 0) && this.paramValues[i] != NULL_OBJECT) {
                    this.row.append(this.paramValues[i].toString().replace("\\", "\\\\").replace("|", "\\|"));
                } else if (this.paramValues[i] != NULL_OBJECT) {
                    this.row.append(this.paramValues[i].toString());
                }
            }
            if (i >= this.paramValues.length - 1) continue;
            this.row.append("|");
        }
        this.row.append(string);
        return this.row.toString();
    }

    private void writeInt1(byte by) {
        this.resultBuffer.write(by);
    }

    private void writeInt2(short s) {
        this.resultBuffer.write((byte)s);
        this.resultBuffer.write((byte)(s >>> 8));
    }

    private void writeNegativeOneInt4() {
        this.resultBuffer.write(-1);
        this.resultBuffer.write(-1);
        this.resultBuffer.write(-1);
        this.resultBuffer.write(-1);
    }

    private void writeInt4(int n) {
        this.resultBuffer.write((byte)n);
        this.resultBuffer.write((byte)(n >>> 8));
        this.resultBuffer.write((byte)(n >>> 16));
        this.resultBuffer.write((byte)(n >>> 24));
    }

    private byte[] stringToBytes(String string) {
        byte[] byArray = null;
        try {
            byArray = string.getBytes("ISO-8859-1");
        }
        catch (Exception exception) {
            // empty catch block
        }
        return byArray;
    }

    private byte[] UTFStringToBytes(String string) {
        return Utils.encodeUTF8(string);
    }

    public byte[] toNativeBatchString(boolean bl) {
        int n;
        int n2;
        int n3 = this.paramValues.length;
        int n4 = n3 / 8;
        NullMaskBuffer nullMaskBuffer = new NullMaskBuffer(n4 += n3 % 8 > 0 ? 1 : 0);
        if (bl) {
            this.resultBuffer = new ByteArrayOutputStream(131072);
            try {
                this.resultBuffer.write(this.stringToBytes("NATIVE\n\u00ff\r\n\u0000"));
            }
            catch (IOException iOException) {
                throw new RuntimeException("IOException managing memory buffers", iOException);
            }
            this.writeInt4(5 + 4 * n3);
            this.writeInt2((short)1);
            this.writeInt1((byte)0);
            this.writeInt2((short)n3);
            for (n2 = 0; n2 < n3; n2 = (short)(n2 + 1)) {
                this.writeNegativeOneInt4();
            }
        } else {
            this.resultBuffer.reset();
        }
        n2 = 0;
        ArrayList<byte[]> arrayList = new ArrayList<byte[]>();
        for (n = 0; n < n3; n = (short)(n + 1)) {
            if (this.paramValues[n] == null || this.paramValues[n] == NULL_OBJECT) continue;
            String string = this.paramValues[n].toString();
            byte[] byArray = this.paramTypes[n] == 117 || this.paramTypes[n] == 17 ? this.stringToBytes(string) : this.UTFStringToBytes(string);
            arrayList.add(byArray);
            n2 += 4 + byArray.length;
        }
        this.writeInt4(n2);
        for (n = 0; n < n3; n = (short)(n + 1)) {
            if (this.paramValues[n] != null && this.paramValues[n] != NULL_OBJECT) continue;
            nullMaskBuffer.setNull((short)(n + 1));
        }
        for (n = 0; n < n4; n = (short)(n + 1)) {
            this.writeInt1(nullMaskBuffer.getByte((short)n));
        }
        for (n = 0; n < arrayList.size(); n = (int)((short)(n + 1))) {
            try {
                this.writeInt4(((byte[])arrayList.get(n)).length);
                this.resultBuffer.write((byte[])arrayList.get(n));
                continue;
            }
            catch (IOException iOException) {
                throw new RuntimeException("IOException managing memory buffers", iOException);
            }
        }
        return this.resultBuffer.toByteArray();
    }

    private class NullMaskBuffer {
        private byte[] nullsBuffer;

        NullMaskBuffer(int n) {
            this.nullsBuffer = new byte[n];
        }

        void setNull(short s) {
            int n = (s - 1) / 8;
            int n2 = s % 8;
            int n3 = 1;
            if (n2 > 0) {
                n3 = (byte)(n3 << 8 - n2);
            }
            int n4 = n;
            this.nullsBuffer[n4] = (byte)(this.nullsBuffer[n4] | n3);
        }

        byte getByte(short s) {
            return this.nullsBuffer[s];
        }
    }
}

