/*
 * Decompiled with CFR 0.152.
 */
package com.vertica.core.v3;

import com.vertica.core.BaseStatement;
import com.vertica.core.Field;
import com.vertica.core.Logger;
import com.vertica.core.Notification;
import com.vertica.core.PGBindException;
import com.vertica.core.PGStream;
import com.vertica.core.ParameterList;
import com.vertica.core.Query;
import com.vertica.core.QueryExecutor;
import com.vertica.core.ResultCursor;
import com.vertica.core.ResultHandler;
import com.vertica.core.Utils;
import com.vertica.core.VectorTuple;
import com.vertica.core.v3.CompositeQuery;
import com.vertica.core.v3.LRSStreamer;
import com.vertica.core.v3.Portal;
import com.vertica.core.v3.ProtocolConnectionImpl;
import com.vertica.core.v3.SimpleParameterList;
import com.vertica.core.v3.SimpleQuery;
import com.vertica.core.v3.V3ParameterList;
import com.vertica.core.v3.V3Query;
import com.vertica.jdbc2.TypeInfoCache;
import com.vertica.util.ByteConverter;
import com.vertica.util.GT;
import com.vertica.util.IOStream;
import com.vertica.util.PSQLException;
import com.vertica.util.PSQLState;
import com.vertica.util.PSQLWarning;
import com.vertica.util.ServerErrorMessage;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.ref.PhantomReference;
import java.lang.ref.ReferenceQueue;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Properties;

public class QueryExecutorImpl
implements QueryExecutor {
    private static final int MAX_BUFFERED_QUERIES = 256;
    private final HashMap parsedQueryMap = new HashMap();
    private final ReferenceQueue parsedQueryCleanupQueue = new ReferenceQueue();
    private final HashMap openPortalMap = new HashMap();
    private final ReferenceQueue openPortalCleanupQueue = new ReferenceQueue();
    private final ArrayList pendingParseQueue = new ArrayList();
    private final ArrayList pendingBindQueue = new ArrayList();
    private final ArrayList pendingExecuteQueue = new ArrayList();
    private final ArrayList pendingDescribeStatementQueue = new ArrayList();
    private long nextUniqueID = 1L;
    private final ProtocolConnectionImpl protoConnection;
    private final PGStream pgStream;
    private final Logger logger;
    private final boolean allowEncodingChanges;
    private InputStream inStream;
    private OutputStream outStream;
    private int maxLRSMemory;
    private boolean binaryDataTransfer;
    private final SimpleQuery beginTransactionQuery = new SimpleQuery(new String[]{"BEGIN"});
    private static final SimpleQuery EMPTY_QUERY = new SimpleQuery(new String[]{""});
    private BaseStatement stmt;

    public QueryExecutorImpl(ProtocolConnectionImpl protocolConnectionImpl, PGStream pGStream, Properties properties, Logger logger) {
        this.protoConnection = protocolConnectionImpl;
        this.pgStream = pGStream;
        this.logger = logger;
        this.allowEncodingChanges = properties.getProperty("allowEncodingChanges") != null ? Boolean.valueOf(properties.getProperty("allowEncodingChanges")) : false;
        this.binaryDataTransfer = properties.getProperty("BinaryDataTransfer") != null ? Boolean.valueOf(properties.getProperty("BinaryDataTransfer")) : false;
        this.inStream = null;
        this.outStream = null;
    }

    public Query createSimpleQuery(String string) {
        return QueryExecutorImpl.parseQuery(string, false);
    }

    public Query createParameterizedQuery(String string) {
        return QueryExecutorImpl.parseQuery(string, true);
    }

    private static Query parseQuery(String string, boolean bl) {
        ArrayList<String[]> arrayList = new ArrayList<String[]>();
        ArrayList<String> arrayList2 = new ArrayList<String>(15);
        boolean bl2 = false;
        int n = 0;
        boolean bl3 = false;
        boolean bl4 = false;
        int n2 = 0;
        char[] cArray = string.toCharArray();
        block8: for (int i = 0; i < cArray.length; ++i) {
            char c = cArray[i];
            switch (c) {
                case '\\': {
                    if (!bl3) continue block8;
                    ++i;
                    continue block8;
                }
                case '\'': {
                    bl3 = !bl4 && !bl3;
                    continue block8;
                }
                case '\"': {
                    bl4 = !bl3 && !bl4;
                    continue block8;
                }
                case '?': {
                    if (!bl || bl3 || bl4) continue block8;
                    arrayList2.add(string.substring(n, i));
                    n = i + 1;
                    continue block8;
                }
                case '(': {
                    if (bl3 || bl4) continue block8;
                    ++n2;
                    continue block8;
                }
                case ')': {
                    if (bl3 || bl4) continue block8;
                    --n2;
                    continue block8;
                }
            }
        }
        arrayList2.add(string.substring(n));
        if (arrayList2.size() > 1 || ((String)arrayList2.get(0)).trim().length() > 0) {
            arrayList.add(arrayList2.toArray(new String[arrayList2.size()]));
        }
        if (arrayList.isEmpty()) {
            return EMPTY_QUERY;
        }
        if (arrayList.size() == 1) {
            return new SimpleQuery((String[])arrayList.get(0));
        }
        SimpleQuery[] simpleQueryArray = new SimpleQuery[arrayList.size()];
        int[] nArray = new int[arrayList.size()];
        int n3 = 0;
        for (int i = 0; i < arrayList.size(); ++i) {
            String[] stringArray = (String[])arrayList.get(i);
            nArray[i] = n3;
            simpleQueryArray[i] = new SimpleQuery(stringArray);
            n3 += stringArray.length - 1;
        }
        return new CompositeQuery(simpleQueryArray, nArray);
    }

    public synchronized void execute(Query query, ParameterList parameterList, ResultHandler resultHandler, int n, int n2, int n3) throws SQLException {
        boolean bl;
        if (this.logger.logDebug()) {
            this.logger.debug("simple execute, handler=" + resultHandler + ", maxRows=" + n + ", fetchSize=" + n2 + ", flags=" + n3);
        }
        if (parameterList == null) {
            parameterList = SimpleQuery.NO_PARAMETERS;
        }
        boolean bl2 = bl = (0x20 & n3) != 0;
        if (!bl) {
            ((V3ParameterList)parameterList).checkAllParametersSet();
        }
        if (!this.incorrectCopyInWorkflow(resultHandler, n3)) {
            try {
                try {
                    resultHandler = this.sendQueryPreamble(resultHandler, n3);
                    if ((n3 & 0x800) != 0) {
                        this.sendSimpleQuery((SimpleQuery)query);
                    } else {
                        this.sendQuery((V3Query)query, (V3ParameterList)parameterList, n, n2, n3);
                        this.sendSync();
                    }
                    this.processResults(resultHandler, n3);
                }
                catch (PGBindException pGBindException) {
                    this.sendSync();
                    this.processResults(resultHandler, n3);
                    resultHandler.handleError(new PSQLException(GT.tr("Unable to bind parameter values for statement."), PSQLState.INVALID_PARAMETER_VALUE, (Throwable)pGBindException.getIOException()));
                }
            }
            catch (IOException iOException) {
                this.protoConnection.close();
                resultHandler.handleError(new PSQLException(GT.tr("An I/O error occured while sending to the backend."), PSQLState.CONNECTION_FAILURE, (Throwable)iOException));
                this.protoConnection.setInLRS(false);
            }
        }
        resultHandler.handleCompletion();
    }

    public synchronized void executeWithStream(Query query, IOStream iOStream, ResultHandler resultHandler, int n) throws SQLException {
        if (this.logger.logDebug()) {
            this.logger.debug("executeWithStream, handler=" + resultHandler + ", flags=" + n);
        }
        if ((n & 4) != 0 || (n & 0x100) != 0 || (n & 0x1000) != 0) {
            if ((n & 0x100) == 0 && (n & 0x1000) == 0) {
                this.inStream = iOStream.getInputStream();
            }
        } else {
            this.outStream = iOStream.getOutputStream();
        }
        if (!this.incorrectCopyInWorkflow(resultHandler, n)) {
            try {
                if ((n & 0x80) == 0 && (n & 0x1000) == 0 && (n & 0x100) == 0) {
                    this.sendSimpleQuery((SimpleQuery)query);
                }
                this.processResults(resultHandler, n);
            }
            catch (IOException iOException) {
                this.protoConnection.close();
                resultHandler.handleError(new PSQLException(GT.tr("An I/O error occured while sending to the backend."), PSQLState.CONNECTION_FAILURE, (Throwable)iOException));
                this.protoConnection.setInLRS(false);
            }
        }
        resultHandler.handleCompletion();
    }

    public synchronized void execute(Query[] queryArray, ParameterList[] parameterListArray, ResultHandler resultHandler, int n, int n2, int n3) throws SQLException {
        int n4;
        boolean bl;
        if (this.logger.logDebug()) {
            this.logger.debug("batch execute " + queryArray.length + " queries, handler=" + resultHandler + ", maxRows=" + n + ", fetchSize=" + n2 + ", flags=" + n3);
        }
        boolean bl2 = bl = (0x20 & n3) != 0;
        if (!bl) {
            for (n4 = 0; n4 < parameterListArray.length; ++n4) {
                if (parameterListArray[n4] == null) continue;
                ((V3ParameterList)parameterListArray[n4]).checkAllParametersSet();
            }
        }
        if (!this.incorrectCopyInWorkflow(resultHandler, n3)) {
            try {
                n4 = 0;
                resultHandler = this.sendQueryPreamble(resultHandler, n3);
                ErrorTrackingResultHandler errorTrackingResultHandler = new ErrorTrackingResultHandler(resultHandler);
                for (int i = 0; i < queryArray.length; ++i) {
                    if (++n4 >= 256) {
                        this.sendSync();
                        this.processResults(errorTrackingResultHandler, n3);
                        if (errorTrackingResultHandler.hasErrors()) break;
                        n4 = 0;
                    }
                    V3Query v3Query = (V3Query)queryArray[i];
                    V3ParameterList v3ParameterList = (V3ParameterList)parameterListArray[i];
                    if (v3ParameterList == null) {
                        v3ParameterList = SimpleQuery.NO_PARAMETERS;
                    }
                    this.sendQuery(v3Query, v3ParameterList, n, n2, n3);
                }
                if (!errorTrackingResultHandler.hasErrors()) {
                    this.sendSync();
                    this.processResults(resultHandler, n3);
                }
            }
            catch (IOException iOException) {
                this.protoConnection.close();
                resultHandler.handleError(new PSQLException(GT.tr("An I/O error occured while sending to the backend."), PSQLState.CONNECTION_FAILURE, (Throwable)iOException));
                this.protoConnection.setInLRS(false);
            }
        }
        resultHandler.handleCompletion();
    }

    private ResultHandler sendQueryPreamble(ResultHandler resultHandler, int n) throws IOException {
        this.processDeadParsedQueries();
        this.processDeadPortals();
        return resultHandler;
    }

    public synchronized byte[] fastpathCall(int n, ParameterList parameterList, boolean bl) throws SQLException {
        if (this.protoConnection.getTransactionState() == 0 && !bl) {
            if (this.logger.logDebug()) {
                this.logger.debug("Issuing BEGIN before fastpath call.");
            }
            ResultHandler resultHandler = new ResultHandler(){
                private boolean sawBegin = false;
                private SQLException sqle = null;

                public void handleResultRows(Query query, Field[] fieldArray, VectorTuple vectorTuple, ResultCursor resultCursor) {
                }

                public void handleCommandStatus(String string, int n, long l) {
                    if (!this.sawBegin) {
                        if (!string.equals("BEGIN")) {
                            this.handleError(new PSQLException(GT.tr("Expected command status BEGIN, got {0}.", string), PSQLState.PROTOCOL_VIOLATION));
                        }
                        this.sawBegin = true;
                    } else {
                        this.handleError(new PSQLException(GT.tr("Unexpected command status: {0}.", string), PSQLState.PROTOCOL_VIOLATION));
                    }
                }

                public void handleWarning(SQLWarning sQLWarning) {
                    this.handleError(sQLWarning);
                }

                public void handleError(SQLException sQLException) {
                    if (this.sqle == null) {
                        this.sqle = sQLException;
                    } else {
                        this.sqle.setNextException(sQLException);
                    }
                }

                public void handleCompletion() throws SQLException {
                    if (this.sqle != null) {
                        throw this.sqle;
                    }
                }
            };
            try {
                this.sendOneQuery(this.beginTransactionQuery, SimpleQuery.NO_PARAMETERS, 0, 0, 2);
                this.sendSync();
                this.processResults(resultHandler, 0);
            }
            catch (IOException iOException) {
                throw new PSQLException(GT.tr("An I/O error occured while sending to the backend."), PSQLState.CONNECTION_FAILURE, (Throwable)iOException);
            }
        }
        try {
            this.sendFastpathCall(n, (SimpleParameterList)parameterList);
            return this.receiveFastpathResult();
        }
        catch (IOException iOException) {
            this.protoConnection.close();
            throw new PSQLException(GT.tr("An I/O error occured while sending to the backend."), PSQLState.CONNECTION_FAILURE, (Throwable)iOException);
        }
    }

    public ParameterList createFastpathParameters(int n) {
        return new SimpleParameterList(n);
    }

    private void sendFastpathCall(int n, SimpleParameterList simpleParameterList) throws SQLException, IOException {
        int n2;
        if (this.logger.logDebug()) {
            this.logger.debug(" FE=> FunctionCall(" + n + ", " + simpleParameterList.getParameterCount() + " params)");
        }
        int n3 = simpleParameterList.getParameterCount();
        int n4 = 0;
        for (n2 = 1; n2 <= n3; ++n2) {
            if (simpleParameterList.isNull(n2)) {
                n4 += 4;
                continue;
            }
            n4 += 4 + simpleParameterList.getV3Length(n2);
        }
        this.pgStream.SendChar(70);
        this.pgStream.SendInteger4(10 + 2 * n3 + 2 + n4 + 2);
        this.pgStream.SendInteger4(n);
        this.pgStream.SendInteger2(n3);
        for (n2 = 1; n2 <= n3; ++n2) {
            this.pgStream.SendInteger2(simpleParameterList.isBinary(n2) ? 1 : 0);
        }
        this.pgStream.SendInteger2(n3);
        for (n2 = 1; n2 <= n3; ++n2) {
            if (simpleParameterList.isNull(n2)) {
                this.pgStream.SendInteger4(-1);
                continue;
            }
            this.pgStream.SendInteger4(simpleParameterList.getV3Length(n2));
            simpleParameterList.writeV3Value(n2, this.pgStream);
        }
        this.pgStream.SendInteger2(1);
        this.pgStream.flush();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public synchronized void processNotifies() throws SQLException {
        if (this.protoConnection.getTransactionState() != 0) {
            return;
        }
        try {
            int n;
            block7: while (this.pgStream.hasMessagePending()) {
                n = this.pgStream.ReceiveChar();
                switch (n) {
                    case 65: {
                        this.receiveAsyncNotify();
                        continue block7;
                    }
                    case 69: {
                        throw this.receiveErrorResponse();
                    }
                    case 78: {
                        SQLWarning sQLWarning = this.receiveNoticeResponse();
                        this.protoConnection.addWarning(sQLWarning);
                        continue block7;
                    }
                }
            }
            return;
            throw new PSQLException(GT.tr("Unknown Response Type {0}.", new Character((char)n)), PSQLState.CONNECTION_FAILURE);
        }
        catch (IOException iOException) {
            throw new PSQLException(GT.tr("An I/O error occured while sending to the backend."), PSQLState.CONNECTION_FAILURE, (Throwable)iOException);
        }
    }

    private byte[] receiveFastpathResult() throws IOException, SQLException {
        boolean bl = false;
        SQLException sQLException = null;
        byte[] byArray = null;
        block7: while (!bl) {
            int n = this.pgStream.ReceiveChar();
            switch (n) {
                case 65: {
                    this.receiveAsyncNotify();
                    continue block7;
                }
                case 69: {
                    SQLException sQLException2 = this.receiveErrorResponse();
                    if (sQLException == null) {
                        sQLException = sQLException2;
                        continue block7;
                    }
                    sQLException.setNextException(sQLException2);
                    continue block7;
                }
                case 78: {
                    SQLWarning sQLWarning = this.receiveNoticeResponse();
                    this.protoConnection.addWarning(sQLWarning);
                    continue block7;
                }
                case 90: {
                    this.receiveRFQ();
                    bl = true;
                    continue block7;
                }
                case 86: {
                    int n2 = this.pgStream.ReceiveIntegerR(4);
                    int n3 = this.pgStream.ReceiveIntegerR(4);
                    if (this.logger.logDebug()) {
                        this.logger.debug(" <=BE FunctionCallResponse(" + n3 + " bytes)");
                    }
                    if (n3 == -1) continue block7;
                    byte[] byArray2 = new byte[n3];
                    this.pgStream.Receive(byArray2, 0, n3);
                    byArray = byArray2;
                    continue block7;
                }
            }
            throw new PSQLException(GT.tr("Unknown Response Type {0}.", new Character((char)n)), PSQLState.CONNECTION_FAILURE);
        }
        if (sQLException != null) {
            throw sQLException;
        }
        return byArray;
    }

    private void sendQuery(V3Query v3Query, V3ParameterList v3ParameterList, int n, int n2, int n3) throws IOException, SQLException {
        SimpleQuery[] simpleQueryArray = v3Query.getSubqueries();
        SimpleParameterList[] simpleParameterListArray = v3ParameterList.getSubparams();
        if (simpleQueryArray == null) {
            this.sendOneQuery((SimpleQuery)v3Query, (SimpleParameterList)v3ParameterList, n, n2, n3);
        } else {
            for (int i = 0; i < simpleQueryArray.length; ++i) {
                SimpleParameterList simpleParameterList = SimpleQuery.NO_PARAMETERS;
                if (simpleParameterListArray != null) {
                    simpleParameterList = simpleParameterListArray[i];
                }
                this.sendOneQuery(simpleQueryArray[i], simpleParameterList, n, n2, n3);
            }
        }
    }

    private void sendSync() throws IOException {
        if (this.logger.logDebug()) {
            this.logger.debug(" FE=> Sync");
        }
        this.pgStream.SendChar(83);
        this.pgStream.SendInteger4(4);
        this.pgStream.flush();
    }

    private void sendParse(SimpleQuery simpleQuery, SimpleParameterList simpleParameterList, boolean bl) throws IOException {
        int n;
        int n2;
        Object object;
        int[] nArray = simpleParameterList.getTypeOIDs();
        this.processDeadParsedQueries();
        simpleQuery.setFields(null);
        String string = null;
        if (!bl) {
            string = "S_" + this.nextUniqueID++;
            simpleQuery.setStatementName(string);
            simpleQuery.setStatementTypes((int[])nArray.clone());
        }
        byte[] byArray = simpleQuery.getEncodedStatementName();
        String[] stringArray = simpleQuery.getFragments();
        if (bl && stringArray.length > 1) {
            object = new StringBuffer(stringArray[0]);
            for (n2 = 1; n2 < stringArray.length; ++n2) {
                if (simpleParameterList.isNull(n2)) {
                    ((StringBuffer)object).append("null");
                } else {
                    switch (nArray[n2 - 1]) {
                        case 5: {
                            ((StringBuffer)object).append("'");
                            ((StringBuffer)object).append(simpleParameterList.toString(n2) == "0" ? "false" : "true");
                            ((StringBuffer)object).append("'");
                            break;
                        }
                        case 16: {
                            ((StringBuffer)object).append("'");
                            ((StringBuffer)object).append(simpleParameterList.toString(n2));
                            ((StringBuffer)object).append("'");
                            break;
                        }
                        case 0: 
                        case 8: 
                        case 9: 
                        case 10: 
                        case 11: 
                        case 12: 
                        case 13: 
                        case 15: 
                        case 17: 
                        case 18: 
                        case 117: {
                            ((StringBuffer)object).append("'");
                            ((StringBuffer)object).append(simpleParameterList.toString(n2).replace("\\", "\\\\").replace("'", "\\'"));
                            ((StringBuffer)object).append("'");
                            break;
                        }
                        default: {
                            ((StringBuffer)object).append(simpleParameterList.toString(n2));
                        }
                    }
                }
                ((StringBuffer)object).append(stringArray[n2]);
            }
            stringArray = new String[]{((StringBuffer)object).toString()};
            simpleParameterList = new SimpleParameterList(0);
            simpleParameterList = SimpleQuery.NO_PARAMETERS;
        }
        if (this.logger.logDebug()) {
            object = new StringBuffer(" FE=> Parse(stmt=" + string + ",query=\"");
            for (n2 = 0; n2 < stringArray.length; ++n2) {
                if (n2 > 0) {
                    ((StringBuffer)object).append("?");
                }
                ((StringBuffer)object).append(stringArray[n2]);
            }
            ((StringBuffer)object).append("\",oids={");
            for (n2 = 1; n2 <= simpleParameterList.getParameterCount(); ++n2) {
                if (n2 != 1) {
                    ((StringBuffer)object).append(",");
                }
                ((StringBuffer)object).append("" + simpleParameterList.getTypeOID(n2));
            }
            ((StringBuffer)object).append("})");
            this.logger.debug(((StringBuffer)object).toString());
        }
        object = new byte[stringArray.length * 2 - 1][];
        n2 = 0;
        int n3 = 0;
        for (n = 0; n < stringArray.length; ++n) {
            if (n != 0) {
                object[n2] = Utils.encodeUTF8("?");
                n3 += ((Object)object[n2]).length;
                ++n2;
            }
            object[n2] = Utils.encodeUTF8(stringArray[n].replace("\u0000", "\\000"));
            n3 += ((Object)object[n2]).length;
            ++n2;
        }
        n3 = 4 + (byArray == null ? 0 : byArray.length) + 1 + n3 + 1 + 2 + 4 * simpleParameterList.getParameterCount();
        this.pgStream.SendChar(80);
        this.pgStream.SendInteger4(n3);
        if (byArray != null) {
            this.pgStream.Send(byArray);
        }
        this.pgStream.SendChar(0);
        for (n = 0; n < ((Object)object).length; ++n) {
            this.pgStream.Send((byte[])object[n]);
        }
        this.pgStream.SendChar(0);
        this.pgStream.SendInteger2(simpleParameterList.getParameterCount());
        for (n = 1; n <= simpleParameterList.getParameterCount(); ++n) {
            this.pgStream.SendInteger4(simpleParameterList.getTypeOID(n));
        }
        this.pendingParseQueue.add(new Object[]{simpleQuery, simpleQuery.getStatementName()});
    }

    private void sendBind(SimpleQuery simpleQuery, SimpleParameterList simpleParameterList, Portal portal) throws IOException {
        int n;
        byte[] byArray;
        String string = simpleQuery.getStatementName();
        byte[] byArray2 = simpleQuery.getEncodedStatementName();
        byte[] byArray3 = byArray = portal == null ? null : portal.getEncodedPortalName();
        if (this.logger.logDebug()) {
            StringBuffer stringBuffer = new StringBuffer(" FE=> Bind(stmt=" + string + ",portal=" + portal);
            for (int i = 1; i <= simpleParameterList.getParameterCount(); ++i) {
                stringBuffer.append(",$" + i + "=<" + simpleParameterList.toString(i) + ">");
            }
            stringBuffer.append(")");
            this.logger.debug(stringBuffer.toString());
        }
        long l = 0L;
        for (n = 1; n <= simpleParameterList.getParameterCount(); ++n) {
            if (simpleParameterList.isNull(n)) {
                l += 4L;
                continue;
            }
            l += 4L + (long)Utils.encodeUTF8(simpleParameterList.toString(n)).length;
        }
        l = (long)(4 + (byArray == null ? 0 : byArray.length) + 1 + (byArray2 == null ? 0 : byArray2.length) + 1 + 2 + simpleParameterList.getParameterCount() * 2 + simpleParameterList.getParameterCount() * 4 + 2) + l + 2L + 2L;
        if (l > 0x3FFFFFFFL) {
            throw new PGBindException(new IOException(GT.tr("Bind message length {0} too long.  This can be caused by very large or incorrect length specifications on InputStream parameters.", new Long(l))));
        }
        this.pgStream.SendChar(66);
        this.pgStream.SendInteger4((int)l);
        if (byArray != null) {
            this.pgStream.Send(byArray);
        }
        this.pgStream.SendChar(0);
        if (byArray2 != null) {
            this.pgStream.Send(byArray2);
        }
        this.pgStream.SendChar(0);
        this.pgStream.SendInteger2(simpleParameterList.getParameterCount());
        for (n = 1; n <= simpleParameterList.getParameterCount(); ++n) {
            this.pgStream.SendInteger2(0);
        }
        this.pgStream.SendInteger2(simpleParameterList.getParameterCount());
        for (n = 1; n <= simpleParameterList.getParameterCount(); ++n) {
            this.pgStream.SendInteger4(TypeInfoCache.getVerticaTypeOid(simpleParameterList.getTypeOID(n)));
        }
        PGBindException pGBindException = null;
        for (int i = 1; i <= simpleParameterList.getParameterCount(); ++i) {
            if (simpleParameterList.isNull(i)) {
                this.pgStream.SendInteger4(-1);
                continue;
            }
            byte[] byArray4 = Utils.encodeUTF8(simpleParameterList.toString(i));
            this.pgStream.SendInteger4(byArray4.length);
            try {
                this.pgStream.Send(byArray4);
                continue;
            }
            catch (PGBindException pGBindException2) {
                pGBindException = pGBindException2;
            }
        }
        this.pgStream.SendInteger2(1);
        this.pgStream.SendInteger2(this.binaryDataTransfer ? 1 : 0);
        this.pendingBindQueue.add(portal);
        if (pGBindException != null) {
            throw pGBindException;
        }
    }

    private void sendDescribePortal(Portal portal) throws IOException {
        if (this.logger.logDebug()) {
            this.logger.debug(" FE=> Describe(portal=" + portal + ")");
        }
        byte[] byArray = portal == null ? null : portal.getEncodedPortalName();
        int n = 5 + (byArray == null ? 0 : byArray.length) + 1;
        this.pgStream.SendChar(68);
        this.pgStream.SendInteger4(n);
        this.pgStream.SendChar(80);
        if (byArray != null) {
            this.pgStream.Send(byArray);
        }
        this.pgStream.SendChar(0);
    }

    private void sendDescribeStatement(SimpleQuery simpleQuery, SimpleParameterList simpleParameterList, boolean bl) throws IOException {
        byte[] byArray;
        if (this.logger.logDebug()) {
            this.logger.debug(" FE=> Describe(statement=" + simpleQuery.getStatementName() + ")");
        }
        int n = 5 + ((byArray = simpleQuery.getEncodedStatementName()) == null ? 0 : byArray.length) + 1;
        this.pgStream.SendChar(68);
        this.pgStream.SendInteger4(n);
        this.pgStream.SendChar(83);
        if (byArray != null) {
            this.pgStream.Send(byArray);
        }
        this.pgStream.SendChar(0);
        this.pendingDescribeStatementQueue.add(new Object[]{simpleQuery, simpleParameterList, new Boolean(bl)});
    }

    private void sendExecute(Query query, Portal portal, int n) throws IOException {
        if (this.logger.logDebug()) {
            this.logger.debug(" FE=> Execute(portal=" + portal + ",limit=" + n + ")");
        }
        byte[] byArray = portal == null ? null : portal.getEncodedPortalName();
        int n2 = byArray == null ? 0 : byArray.length;
        this.pgStream.SendChar(69);
        this.pgStream.SendInteger4(5 + n2 + 4);
        if (byArray != null) {
            this.pgStream.Send(byArray);
        }
        this.pgStream.SendChar(0);
        this.pgStream.SendInteger4(n);
        this.pendingExecuteQueue.add(new Object[]{query, portal});
    }

    private void sendSimpleQuery(SimpleQuery simpleQuery) throws IOException {
        if (this.logger.logDebug()) {
            this.logger.debug(" FE=> Query(query=" + simpleQuery.toString() + ")");
        }
        String[] stringArray = simpleQuery.getFragments();
        byte[] byArray = Utils.encodeUTF8(stringArray[0]);
        int n = byArray.length;
        this.pgStream.SendChar(81);
        this.pgStream.SendInteger4(5 + n);
        this.pgStream.Send(byArray);
        this.pgStream.SendChar(0);
        this.pgStream.flush();
        this.pendingExecuteQueue.add(new Object[]{simpleQuery, null});
    }

    private void sendClosePortal(String string) throws IOException {
        if (this.logger.logDebug()) {
            this.logger.debug(" FE=> ClosePortal(" + string + ")");
        }
        byte[] byArray = string == null ? null : Utils.encodeUTF8(string);
        int n = byArray == null ? 0 : byArray.length;
        this.pgStream.SendChar(67);
        this.pgStream.SendInteger4(6 + n);
        this.pgStream.SendChar(80);
        if (byArray != null) {
            this.pgStream.Send(byArray);
        }
        this.pgStream.SendChar(0);
    }

    private void sendCloseStatement(String string) throws IOException {
        if (this.logger.logDebug()) {
            this.logger.debug(" FE=> CloseStatement(" + string + ")");
        }
        byte[] byArray = Utils.encodeUTF8(string);
        this.pgStream.SendChar(67);
        this.pgStream.SendInteger4(5 + byArray.length + 1);
        this.pgStream.SendChar(83);
        this.pgStream.Send(byArray);
        this.pgStream.SendChar(0);
    }

    private void sendOneQuery(SimpleQuery simpleQuery, SimpleParameterList simpleParameterList, int n, int n2, int n3) throws IOException {
        boolean bl;
        boolean bl2 = (n3 & 4) != 0;
        boolean bl3 = (n3 & 2) != 0;
        boolean bl4 = (n3 & 0x20) != 0;
        boolean bl5 = (n3 & 8) != 0 && !bl2 && !bl3 && n2 > 0 && !bl4;
        boolean bl6 = bl = (n3 & 1) != 0 && !bl5 && !bl4;
        int n4 = bl2 ? 1 : (!bl5 ? n : (n != 0 && n2 > n ? n : n2));
        this.sendParse(simpleQuery, simpleParameterList, bl);
        if (bl) {
            simpleParameterList = SimpleQuery.NO_PARAMETERS;
        }
        this.sendDescribeStatement(simpleQuery, simpleParameterList, bl4);
        if (bl4) {
            return;
        }
        Portal portal = null;
        if (bl5) {
            String string = "C_" + this.nextUniqueID++;
            portal = new Portal(simpleQuery, string);
        }
        this.sendBind(simpleQuery, simpleParameterList, portal);
        this.sendExecute(simpleQuery, portal, n4);
    }

    private void registerParsedQuery(SimpleQuery simpleQuery, String string) {
        if (string == null) {
            return;
        }
        PhantomReference<SimpleQuery> phantomReference = new PhantomReference<SimpleQuery>(simpleQuery, this.parsedQueryCleanupQueue);
        this.parsedQueryMap.put(phantomReference, string);
        simpleQuery.setCleanupRef(phantomReference);
    }

    private void processDeadParsedQueries() throws IOException {
        PhantomReference phantomReference;
        while ((phantomReference = (PhantomReference)this.parsedQueryCleanupQueue.poll()) != null) {
            String string = (String)this.parsedQueryMap.remove(phantomReference);
            this.sendCloseStatement(string);
            phantomReference.clear();
        }
    }

    private void registerOpenPortal(Portal portal) {
        if (portal == null) {
            return;
        }
        String string = portal.getPortalName();
        PhantomReference<Portal> phantomReference = new PhantomReference<Portal>(portal, this.openPortalCleanupQueue);
        this.openPortalMap.put(phantomReference, string);
        portal.setCleanupRef(phantomReference);
    }

    private void processDeadPortals() throws IOException {
        PhantomReference phantomReference;
        while ((phantomReference = (PhantomReference)this.openPortalCleanupQueue.poll()) != null) {
            String string = (String)this.openPortalMap.remove(phantomReference);
            this.sendClosePortal(string);
            phantomReference.clear();
        }
    }

    private boolean incorrectCopyInWorkflow(ResultHandler resultHandler, int n) {
        if ((n & 0x80) != 0 && !this.protoConnection.isVerticaCopyStarted()) {
            resultHandler.handleError(new PSQLException(GT.tr("Unexpected ADD STREAM TO COPY request, COPY has not started yet"), PSQLState.PROTOCOL_VIOLATION));
            return true;
        }
        if ((n & 0x100) != 0 && !this.protoConnection.isVerticaCopyStarted()) {
            resultHandler.handleError(new PSQLException(GT.tr("Unexpected FINISH COPY request, COPY has not started yet"), PSQLState.PROTOCOL_VIOLATION));
            return true;
        }
        if ((n & 0x80) == 0 && (n & 0x100) == 0 && (n & 0x1000) == 0 && this.protoConnection.isVerticaCopyStarted()) {
            resultHandler.handleError(new PSQLException(GT.tr("Unexpected query, COPY is in progress"), PSQLState.PROTOCOL_VIOLATION));
            return true;
        }
        return false;
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    protected void processResults(ResultHandler var1_1, int var2_2) throws IOException {
        block91: {
            var3_3 = (var2_2 & 4) != 0;
            v0 = var4_4 = (var2_2 & 512) != 0;
            if ((var2_2 & 64) != 0) {
                this.protoConnection.setVerticaCopyStarted(true);
            }
            if ((var2_2 & 128) != 0) {
                if (this.inStream == null) {
                    this.protoConnection.setVerticaCopyStarted(false);
                    var1_1.handleError(new PSQLException(GT.tr("Expecting input stream for COPY"), PSQLState.COMMUNICATION_ERROR));
                    return;
                }
                var5_5 = this.sendCopyData(var2_2);
                if (var5_5 != null) {
                    this.protoConnection.setVerticaCopyStarted(false);
                    var1_1.handleError(var5_5);
                }
                return;
            }
            var5_6 = null;
            var6_7 = null;
            if (!this.protoConnection.isVerticaCopyStarted() || (var2_2 & 4096) == 0) break block91;
            var7_8 = this.sendBatchDone();
            if (var7_8 != null) {
                var1_1.handleError(var7_8);
            }
            var8_9 = 0;
            var9_10 = false;
            block43: while (var8_9 == 0) {
                var10_11 = (char)this.pgStream.ReceiveChar();
                if (this.logger.logDebug()) {
                    this.logger.debug(" <=BE batch response: " + var10_11);
                }
                switch (var10_11) {
                    case 'J': {
                        this.pgStream.ReceiveIntegerR(4);
                        var8_9 = 1;
                        this.protoConnection.setLoadingBatch(false);
                        if (this.logger.logDebug()) {
                            this.logger.debug(" <=end of response rows");
                        }
                        if (var5_6 == null && var6_7 == null) continue block43;
                        var11_12 = (Object[])this.pendingExecuteQueue.get(0);
                        var12_14 = (SimpleQuery)var11_12[0];
                        var1_1.handleResultRows((Query)var12_14, var5_6, var6_7, null);
                        break;
                    }
                    case 'T': {
                        var5_6 = this.receiveFields();
                        break;
                    }
                    case 'D': {
                        var11_12 = null;
                        try {
                            var11_12 = this.pgStream.ReceiveTupleV4();
                        }
                        catch (OutOfMemoryError var12_15) {
                            var1_1.handleError(new PSQLException(GT.tr("Ran out of memory retrieving query results."), PSQLState.OUT_OF_MEMORY, (Throwable)var12_15));
                            if (!var4_4) ** GOTO lbl52
                            this.protoConnection.setInLRS(false);
                        }
lbl52:
                        // 3 sources

                        if (var6_7 == null) {
                            var6_7 = new VectorTuple(this.logger);
                            var6_7.setStreaming(var4_4);
                            var6_7.setMaxLRSMemory(this.maxLRSMemory);
                        }
                        try {
                            var6_7.addElement(var11_12);
                        }
                        catch (PSQLException var12_16) {
                            var1_1.handleError(var12_16);
                            this.protoConnection.setVerticaCopyStarted(false);
                            var8_9 = 1;
                            var9_10 = true;
                            if (!var4_4) continue block43;
                            this.protoConnection.setInLRS(false);
                        }
                        break;
                    }
                    case 'E': {
                        var8_9 = 1;
                        var9_10 = true;
                        var12_14 = this.receiveErrorResponse();
                        var1_1.handleError((SQLException)var12_14);
                        break;
                    }
                    default: {
                        var8_9 = 1;
                        var9_10 = true;
                        var1_1.handleError(new PSQLException(GT.tr("Wrong state when ending batch: code " + var10_11), PSQLState.COMMUNICATION_ERROR));
                    }
                }
            }
            if (!var9_10) {
                return;
            }
            this.protoConnection.setVerticaCopyStarted(false);
            this.protoConnection.setInCopyIn(false);
            this.protoConnection.setLoadingBatch(false);
            this.protoConnection.setInLRS(false);
            this.inStream = null;
        }
        if ((var2_2 & 256) != 0) {
            var7_8 = this.sendCopyDone();
            if (var7_8 != null) {
                var1_1.handleError(var7_8);
            }
            this.inStream = null;
        }
        var9_10 = false;
        var10_11 = '\u0000';
        var11_13 = 0;
        var12_17 = 0;
        var13_18 = 0;
        var14_19 = 0;
        block44: while (!var9_10) {
            var8_9 = this.pgStream.ReceiveChar();
            switch (var8_9) {
                case 65: {
                    this.receiveAsyncNotify();
                    break;
                }
                case 49: {
                    this.pgStream.ReceiveIntegerR(4);
                    if (var11_13 > 0) break;
                    var15_20 = (Object[])this.pendingParseQueue.get(var11_13++);
                    var16_21 = (SimpleQuery)var15_20[0];
                    var17_22 = (String)var15_20[1];
                    if (this.logger.logDebug()) {
                        this.logger.debug(" <=BE ParseComplete [" + var17_22 + "]");
                    }
                    this.registerParsedQuery(var16_21, var17_22);
                    break;
                }
                case 116: {
                    this.pgStream.ReceiveIntegerR(4);
                    if (this.logger.logDebug()) {
                        this.logger.debug(" <=BE ParameterDescription");
                    }
                    var18_23 = (Object[])this.pendingDescribeStatementQueue.get(var12_17);
                    var19_24 = (SimpleQuery)var18_23[0];
                    var20_25 = (SimpleParameterList)var18_23[1];
                    var21_26 = (Boolean)var18_23[2];
                    var22_33 = this.pgStream.ReceiveIntegerR(2);
                    for (var23_37 = 1; var23_37 <= var22_33; ++var23_37) {
                        var24_43 = this.pgStream.ReceiveIntegerR(4);
                        var20_25.setResolvedType(var23_37, var24_43);
                    }
                    var19_24.setStatementTypes((int[])var20_25.getTypeOIDs().clone());
                    if (var21_26) {
                        var10_11 = '\u0001';
                        break;
                    }
                    ++var12_17;
                    break;
                }
                case 50: {
                    this.pgStream.ReceiveIntegerR(4);
                    var18_23 = (Object[])this.pendingBindQueue.get(var13_18++);
                    if (this.logger.logDebug()) {
                        this.logger.debug(" <=BE BindComplete [" + var18_23 + "]");
                    }
                    this.registerOpenPortal((Portal)var18_23);
                    break;
                }
                case 51: {
                    this.pgStream.ReceiveIntegerR(4);
                    if (!this.logger.logDebug()) continue block44;
                    this.logger.debug(" <=BE CloseComplete");
                    break;
                }
                case 110: {
                    this.pgStream.ReceiveIntegerR(4);
                    if (this.logger.logDebug()) {
                        this.logger.debug(" <=BE NoData");
                    }
                    if (var10_11 == '\u0000') continue block44;
                    if ((var20_25 = (SimpleQuery)(var19_24 = (Object[])this.pendingDescribeStatementQueue.get(var12_17++))[0]).getFields() != null) {
                        var5_6 = var20_25.getFields();
                    } else {
                        var20_25.setFields(var5_6);
                    }
                    if (var5_6 == null && var6_7 == null) continue block44;
                    var1_1.handleResultRows((Query)var20_25, var5_6, var6_7, null);
                    break;
                }
                case 115: {
                    if (var4_4) {
                        this.protoConnection.setInLRS(false);
                    }
                    this.pgStream.ReceiveIntegerR(4);
                    if (this.logger.logDebug()) {
                        this.logger.debug(" <=BE PortalSuspended");
                    }
                    var19_24 = (Object[])this.pendingExecuteQueue.get(var14_19++);
                    var20_25 = (SimpleQuery)var19_24[0];
                    var21_27 = (Portal)var19_24[1];
                    if (var20_25.getFields() != null) {
                        var5_6 = var20_25.getFields();
                    } else {
                        var20_25.setFields(var5_6);
                    }
                    var1_1.handleResultRows((Query)var20_25, var5_6, var6_7, var21_27);
                    var5_6 = null;
                    var6_7 = null;
                    break;
                }
                case 67: {
                    var19_24 = this.receiveCommandStatus();
                    var10_11 = '\u0000';
                    var20_25 = (Object[])this.pendingExecuteQueue.get(var14_19++);
                    var21_28 = (SimpleQuery)var20_25[0];
                    var22_34 = (Portal)var20_25[1];
                    if (var21_28.getFields() != null) {
                        var5_6 = var21_28.getFields();
                    } else {
                        var21_28.setFields(var5_6);
                    }
                    if (var5_6 == null) ** GOTO lbl219
                    if (var6_7 == null) {
                        var6_7 = new VectorTuple(this.logger);
                        var6_7.setStreaming(var4_4);
                        var6_7.setMaxLRSMemory(this.maxLRSMemory);
                    }
                    var1_1.handleResultRows(var21_28, var5_6, var6_7, null);
                    if (!var19_24.startsWith("INSERT") && !var19_24.startsWith("UPDATE") && !var19_24.startsWith("DELETE") && !var19_24.startsWith("MOVE")) ** GOTO lbl216
                    try {
                        var23_38 = 0;
                        if (var6_7.size() > 0) {
                            var24_44 /* !! */  = (Object[])((byte[][])var6_7.elementAt(0));
                            if (var5_6[0].getFormat() == 1) {
                                var23_38 = (int)ByteConverter.int8((byte[])var24_44 /* !! */ [0], 0);
                            } else {
                                var25_45 = new String((byte[])var24_44 /* !! */ [0]);
                                try {
                                    var23_38 = Integer.parseInt(var25_45);
                                }
                                catch (NumberFormatException var26_53) {
                                    var23_38 = 0x7FFFFFFF;
                                }
                            }
                        }
                        var1_1.handleCommandStatus((String)var19_24, var23_38, 0L);
                    }
                    catch (PSQLException var23_39) {
                        this.protoConnection.setVerticaCopyStarted(false);
                        var1_1.handleError(var23_39);
                        if (!var4_4) ** GOTO lbl216
                        this.protoConnection.setInLRS(false);
                    }
lbl216:
                    // 4 sources

                    var5_6 = null;
                    var6_7 = null;
                    ** GOTO lbl220
lbl219:
                    // 1 sources

                    this.interpretCommandStatus((String)var19_24, var1_1);
lbl220:
                    // 2 sources

                    if (var22_34 == null) continue block44;
                    var22_34.close();
                    break;
                }
                case 68: {
                    var20_25 = null;
                    try {
                        var20_25 = this.pgStream.ReceiveTupleV4();
                    }
                    catch (OutOfMemoryError var21_29) {
                        if (var3_3) ** GOTO lbl233
                        var1_1.handleError(new PSQLException(GT.tr("Ran out of memory retrieving query results."), PSQLState.OUT_OF_MEMORY, (Throwable)var21_29));
                        if (!var4_4) ** GOTO lbl233
                        this.protoConnection.setInLRS(false);
                    }
lbl233:
                    // 4 sources

                    if (var6_7 == null) {
                        var6_7 = new VectorTuple(this.logger);
                        var6_7.setStreaming(var4_4);
                        var6_7.setMaxLRSMemory(this.maxLRSMemory);
                    }
                    try {
                        var6_7.addElement(var20_25);
                        if (var4_4) {
                            this.protoConnection.setInLRS(true);
                            if (var6_7.getTuplesSize() >= this.maxLRSMemory) {
                                if (this.logger.logDebug()) {
                                    this.logger.debug(" <= LRS Streaming: maxLRSMemory=" + this.maxLRSMemory + " buffer size=" + var6_7.getTuplesSize());
                                }
                                var9_10 = true;
                                var21_30 = (Object[])this.pendingExecuteQueue.get(var14_19);
                                var22_35 = (SimpleQuery)var21_30[0];
                                if (var22_35.getFields() != null) {
                                    var5_6 = var22_35.getFields();
                                } else {
                                    var22_35.setFields(var5_6);
                                }
                                var1_1.handleResultRows(var22_35, var5_6, var6_7, new LRSStreamer(var22_35));
                            }
                        }
                    }
                    catch (PSQLException var21_31) {
                        var1_1.handleError(var21_31);
                        this.protoConnection.setVerticaCopyStarted(false);
                        var9_10 = true;
                        if (!var4_4) ** GOTO lbl259
                        this.protoConnection.setInLRS(false);
                    }
lbl259:
                    // 3 sources

                    if (!(var22_36 = (Query)(var21_32 = (Object[])this.pendingExecuteQueue.get(var14_19))[0]).isDML()) continue block44;
                    try {
                        var23_40 = 0;
                        if (var6_7.size() > 0) {
                            var24_44 /* !! */  = (Object[])((byte[][])var6_7.elementAt(0));
                            if (this.binaryDataTransfer) {
                                var23_40 = (int)ByteConverter.int8((byte[])var24_44 /* !! */ [0], 0);
                            } else {
                                var25_46 = new String((byte[])var24_44 /* !! */ [0]);
                                try {
                                    var23_40 = Integer.parseInt(var25_46);
                                }
                                catch (NumberFormatException var26_54) {
                                    var23_40 = 0x7FFFFFFF;
                                }
                            }
                        }
                        var1_1.handleCommandStatus("DML", var23_40, 0L);
                    }
                    catch (PSQLException var23_41) {
                        this.protoConnection.setVerticaCopyStarted(false);
                        var1_1.handleError(var23_41);
                        if (!var4_4) continue block44;
                        this.protoConnection.setInLRS(false);
                    }
                    break;
                }
                case 69: {
                    if (var4_4) {
                        this.protoConnection.setInLRS(false);
                    }
                    var23_42 = this.receiveErrorResponse();
                    var1_1.handleError(var23_42);
                    this.protoConnection.setVerticaCopyStarted(false);
                    break;
                }
                case 73: {
                    this.pgStream.ReceiveIntegerR(4);
                    if (this.logger.logDebug()) {
                        this.logger.debug(" <=BE EmptyQuery");
                    }
                    var24_44 /* !! */  = (Object[])this.pendingExecuteQueue.get(var14_19++);
                    var25_47 = (Query)var24_44 /* !! */ [0];
                    var26_52 = (Portal)var24_44 /* !! */ [1];
                    var1_1.handleCommandStatus("EMPTY", 0, 0L);
                    if (var26_52 == null) continue block44;
                    var26_52.close();
                    break;
                }
                case 78: {
                    var24_44 /* !! */  = this.receiveNoticeResponse();
                    var1_1.handleWarning((SQLWarning)var24_44 /* !! */ );
                    break;
                }
                case 83: {
                    var25_48 = this.pgStream.ReceiveIntegerR(4);
                    var26_52 = this.pgStream.ReceiveString();
                    var27_55 = this.pgStream.ReceiveString();
                    if (this.logger.logDebug()) {
                        this.logger.debug(" <=BE ParameterStatus(" + (String)var26_52 + " = " + var27_55 + ")");
                    }
                    if (var26_52.equals("client_encoding") && !var27_55.equalsIgnoreCase("UNICODE") && !this.allowEncodingChanges) {
                        this.protoConnection.close();
                        var1_1.handleError(new PSQLException(GT.tr("The server''s client_encoding parameter was changed to {0}. The JDBC driver requires client_encoding to be UNICODE for correct operation.", var27_55), PSQLState.CONNECTION_FAILURE));
                        var9_10 = true;
                    }
                    if (!var26_52.equals("DateStyle") || var27_55.startsWith("ISO,")) continue block44;
                    this.protoConnection.close();
                    var1_1.handleError(new PSQLException(GT.tr("The server''s DateStyle parameter was changed to {0}. The JDBC driver requires DateStyle to begin with ISO for correct operation.", var27_55), PSQLState.CONNECTION_FAILURE));
                    var9_10 = true;
                    break;
                }
                case 84: {
                    var5_6 = this.receiveFields();
                    var6_7 = new VectorTuple(this.logger);
                    var6_7.setStreaming(var4_4);
                    var6_7.setMaxLRSMemory(this.maxLRSMemory);
                    if (var10_11 == '\u0000') continue block44;
                    var25_49 = (Object[])this.pendingDescribeStatementQueue.get(var12_17++);
                    var26_52 = (SimpleQuery)var25_49[0];
                    var26_52.setFields(var5_6);
                    if (var5_6 == null && var6_7 == null) continue block44;
                    var1_1.handleResultRows((Query)var26_52, var5_6, var6_7, null);
                    break;
                }
                case 90: {
                    if (var4_4) {
                        this.protoConnection.setInLRS(false);
                    }
                    this.receiveRFQ();
                    var9_10 = true;
                    this.pendingParseQueue.clear();
                    this.pendingDescribeStatementQueue.clear();
                    this.pendingBindQueue.clear();
                    this.pendingExecuteQueue.clear();
                    break;
                }
                case 71: {
                    if (this.inStream == null) {
                        this.protoConnection.setVerticaCopyStarted(false);
                        var1_1.handleError(new PSQLException(GT.tr("Expecting input stream for COPY"), PSQLState.COMMUNICATION_ERROR));
                        var9_10 = true;
                        break;
                    }
                    this.receiveCopyInOutResponse();
                    var25_50 = this.sendCopyData(var2_2);
                    if (var25_50 != null) {
                        var1_1.handleError(var25_50);
                        this.protoConnection.setVerticaCopyStarted(false);
                        var9_10 = true;
                    }
                    if ((var2_2 & 64) == 0) continue block44;
                    var9_10 = true;
                    break;
                }
                case 72: {
                    this.receiveCopyInOutResponse();
                    break;
                }
                case 99: {
                    this.pgStream.ReceiveIntegerR(4);
                    break;
                }
                case 100: {
                    if (this.outStream == null) {
                        var1_1.handleError(new PSQLException(GT.tr("Expecting output stream for COPY"), PSQLState.COMMUNICATION_ERROR));
                        this.protoConnection.setVerticaCopyStarted(false);
                        var9_10 = true;
                        break;
                    }
                    var25_51 = this.receiveCopyData();
                    if (var25_51 == null) continue block44;
                    var1_1.handleError(var25_51);
                    this.protoConnection.setVerticaCopyStarted(false);
                    var9_10 = true;
                    break;
                }
                default: {
                    throw new IOException("Unexpected packet type: " + var8_9);
                }
            }
        }
    }

    public synchronized void fetch(ResultCursor resultCursor, ResultHandler resultHandler, int n) throws SQLException {
        final Portal portal = (Portal)resultCursor;
        final ResultHandler resultHandler2 = resultHandler;
        resultHandler = new ResultHandler(){

            public void handleResultRows(Query query, Field[] fieldArray, VectorTuple vectorTuple, ResultCursor resultCursor) {
                resultHandler2.handleResultRows(query, fieldArray, vectorTuple, resultCursor);
            }

            public void handleCommandStatus(String string, int n, long l) {
                this.handleResultRows(portal.getQuery(), null, new VectorTuple(QueryExecutorImpl.this.logger), null);
            }

            public void handleWarning(SQLWarning sQLWarning) {
                resultHandler2.handleWarning(sQLWarning);
            }

            public void handleError(SQLException sQLException) {
                resultHandler2.handleError(sQLException);
            }

            public void handleCompletion() throws SQLException {
                resultHandler2.handleCompletion();
            }
        };
        try {
            this.processDeadParsedQueries();
            this.processDeadPortals();
            this.sendExecute(portal.getQuery(), portal, n);
            this.sendSync();
            this.processResults(resultHandler, 0);
        }
        catch (IOException iOException) {
            this.protoConnection.close();
            resultHandler.handleError(new PSQLException(GT.tr("An I/O error occured while sending to the backend."), PSQLState.CONNECTION_FAILURE, (Throwable)iOException));
            this.protoConnection.setInLRS(false);
        }
        resultHandler.handleCompletion();
    }

    public synchronized void fetchLRS(ResultCursor resultCursor, ResultHandler resultHandler) throws SQLException {
        final LRSStreamer lRSStreamer = (LRSStreamer)resultCursor;
        final ResultHandler resultHandler2 = resultHandler;
        resultHandler = new ResultHandler(){

            public void handleResultRows(Query query, Field[] fieldArray, VectorTuple vectorTuple, ResultCursor resultCursor) {
                resultHandler2.handleResultRows(query, fieldArray, vectorTuple, resultCursor);
            }

            public void handleCommandStatus(String string, int n, long l) {
                this.handleResultRows(lRSStreamer.getQuery(), null, new VectorTuple(QueryExecutorImpl.this.logger), null);
            }

            public void handleWarning(SQLWarning sQLWarning) {
                resultHandler2.handleWarning(sQLWarning);
            }

            public void handleError(SQLException sQLException) {
                resultHandler2.handleError(sQLException);
            }

            public void handleCompletion() throws SQLException {
                resultHandler2.handleCompletion();
            }
        };
        try {
            this.processResults(resultHandler, 512);
        }
        catch (IOException iOException) {
            this.protoConnection.close();
            resultHandler.handleError(new PSQLException(GT.tr("An I/O error occured while sending to the backend."), PSQLState.CONNECTION_FAILURE, (Throwable)iOException));
            this.protoConnection.setInLRS(false);
        }
        resultHandler.handleCompletion();
    }

    private Field[] receiveFields() throws IOException {
        int n = this.pgStream.ReceiveIntegerR(4);
        int n2 = this.pgStream.ReceiveIntegerR(2);
        Field[] fieldArray = new Field[n2];
        if (this.logger.logDebug()) {
            this.logger.debug(" <=BE RowDescription(" + n2 + ")");
        }
        for (int i = 0; i < fieldArray.length; ++i) {
            String string = this.pgStream.ReceiveString();
            long l = this.pgStream.ReceiveLong();
            String string2 = "";
            String string3 = "";
            if (l != 0L) {
                string2 = this.pgStream.ReceiveString();
                string3 = this.pgStream.ReceiveString();
            }
            short s = (short)this.pgStream.ReceiveIntegerR(2);
            int n3 = this.pgStream.ReceiveIntegerR(4);
            int n4 = this.pgStream.ReceiveIntegerR(2);
            int n5 = this.pgStream.ReceiveIntegerR(2);
            int n6 = this.pgStream.ReceiveIntegerR(4);
            int n7 = this.pgStream.ReceiveIntegerR(2);
            fieldArray[i] = new Field(string, null, n3, n4, n6, l, string2, string3, s, n5);
            fieldArray[i].setFormat(this.binaryDataTransfer ? 1 : 0);
        }
        return fieldArray;
    }

    private void receiveAsyncNotify() throws IOException {
        int n = this.pgStream.ReceiveIntegerR(4);
        int n2 = this.pgStream.ReceiveIntegerR(4);
        String string = this.pgStream.ReceiveString();
        String string2 = this.pgStream.ReceiveString();
        this.protoConnection.addNotification(new Notification(string, n2, string2));
        if (this.logger.logDebug()) {
            this.logger.debug(" <=BE AsyncNotify(" + n2 + "," + string + "," + string2 + ")");
        }
    }

    private SQLException receiveErrorResponse() throws IOException {
        int n = this.pgStream.ReceiveIntegerR(4);
        String string = this.pgStream.ReceiveString(n - 4);
        ServerErrorMessage serverErrorMessage = new ServerErrorMessage(string, this.logger.getLogLevel());
        if (this.logger.logDebug()) {
            this.logger.debug(" <=BE ErrorMessage(" + serverErrorMessage.toString() + ")");
        }
        return new PSQLException(serverErrorMessage);
    }

    private SQLWarning receiveNoticeResponse() throws IOException {
        int n = this.pgStream.ReceiveIntegerR(4);
        ServerErrorMessage serverErrorMessage = new ServerErrorMessage(this.pgStream.ReceiveString(n - 4), this.logger.getLogLevel());
        if (this.logger.logDebug()) {
            this.logger.debug(" <=BE NoticeResponse(" + serverErrorMessage.toString() + ")");
        }
        return new PSQLWarning(serverErrorMessage);
    }

    private String receiveCommandStatus() throws IOException {
        int n = this.pgStream.ReceiveIntegerR(4);
        String string = this.pgStream.ReceiveString(n - 5);
        this.pgStream.Receive(1);
        if (this.logger.logDebug()) {
            this.logger.debug(" <=BE CommandStatus(" + string + ")");
        }
        return string;
    }

    private void interpretCommandStatus(String string, ResultHandler resultHandler) {
        int n = 0;
        long l = 0L;
        resultHandler.handleCommandStatus(string, n, l);
    }

    private void receiveRFQ() throws IOException {
        if (this.pgStream.ReceiveIntegerR(4) != 5) {
            throw new IOException("unexpected length of ReadyForQuery message");
        }
        char c = (char)this.pgStream.ReceiveChar();
        if (this.logger.logDebug()) {
            this.logger.debug(" <=BE ReadyForQuery(" + c + ")");
        }
        switch (c) {
            case 'I': {
                this.protoConnection.setTransactionState(0);
                break;
            }
            case 'T': {
                this.protoConnection.setTransactionState(1);
                try {
                    this.protoConnection.getConnection().autoCommit();
                    break;
                }
                catch (SQLException sQLException) {
                    throw new IOException("auto-commit error:" + sQLException.getMessage());
                }
            }
            case 'E': {
                this.protoConnection.setTransactionState(2);
                break;
            }
            default: {
                throw new IOException("unexpected transaction state in ReadyForQuery message: " + c);
            }
        }
    }

    private void receiveCopyInOutResponse() throws IOException {
        int n = this.pgStream.ReceiveIntegerR(4);
        int n2 = this.pgStream.ReceiveIntegerR(1);
        int n3 = this.pgStream.ReceiveIntegerR(2);
        for (int i = 0; i < n3; ++i) {
            int n4 = this.pgStream.ReceiveIntegerR(2);
        }
    }

    private SQLException sendCopyData(int n) {
        byte[] byArray = new byte[8192];
        int n2 = 0;
        while (n2 >= 0) {
            try {
                n2 = this.inStream.read(byArray);
            }
            catch (IOException iOException) {
                return new PSQLException("vertica.copy.inputsource", PSQLState.DATA_ERROR, (Throwable)iOException);
            }
            if (n2 <= 0) continue;
            try {
                this.pgStream.SendChar(100);
                int n3 = n2 + 4;
                this.pgStream.SendInteger4(n3);
                this.pgStream.Send(byArray, n2);
            }
            catch (IOException iOException) {
                return new PSQLException("vertica.copy.ioerror", PSQLState.CONNECTION_FAILURE_DURING_TRANSACTION, (Throwable)iOException);
            }
        }
        if ((n & 0x80) == 0 && (n & 0x40) == 0 && (n & 0x1000) == 0) {
            return this.sendCopyDone();
        }
        return null;
    }

    private SQLException sendCopyDone() {
        try {
            this.pgStream.SendChar(99);
            this.pgStream.SendInteger4(4);
            this.pgStream.flush();
        }
        catch (IOException iOException) {
            return new PSQLException("vertica.copy.ioerror", PSQLState.CONNECTION_FAILURE_DURING_TRANSACTION, (Throwable)iOException);
        }
        if (this.logger.logDebug()) {
            this.logger.debug(" FE=> copy done (c)");
        }
        this.protoConnection.setLoadingBatch(false);
        this.protoConnection.setInCopyIn(false);
        this.protoConnection.setVerticaCopyStarted(false);
        return null;
    }

    private SQLException sendBatchDone() {
        try {
            this.pgStream.SendChar(106);
            this.pgStream.SendInteger4(4);
            this.pgStream.flush();
        }
        catch (IOException iOException) {
            return new PSQLException("vertica.copy.ioerror", PSQLState.CONNECTION_FAILURE_DURING_TRANSACTION, (Throwable)iOException);
        }
        if (this.logger.logDebug()) {
            this.logger.debug(" FE=> batch done (j)");
        }
        return null;
    }

    private SQLException receiveCopyData() {
        byte[] byArray;
        try {
            int n = this.pgStream.ReceiveIntegerR(4);
            byArray = this.pgStream.Receive(n - 4);
        }
        catch (IOException iOException) {
            return new PSQLException("vertica.copy.ioerror", PSQLState.CONNECTION_FAILURE_DURING_TRANSACTION, (Throwable)iOException);
        }
        try {
            this.outStream.write(byArray);
        }
        catch (IOException iOException) {
            return new PSQLException("vertica.copy.outputsource", PSQLState.DATA_ERROR, (Throwable)iOException);
        }
        return null;
    }

    public void setMaxLRSMemory(int n) {
        this.maxLRSMemory = n;
    }

    public void resetCopyIn(boolean bl) throws SQLException {
        if (this.protoConnection.isVerticaCopyStarted() && this.protoConnection.isInCopyIn()) {
            String string = "Cancelled by client";
            byte[] byArray = string.getBytes();
            ErrorResultHandler errorResultHandler = new ErrorResultHandler();
            try {
                this.pgStream.SendChar(102);
                this.pgStream.SendInteger4(string.length() + 5);
                this.pgStream.Send(byArray);
                this.pgStream.SendChar(0);
                this.pgStream.flush();
                this.processResults(errorResultHandler, 0);
            }
            catch (IOException iOException) {
                this.protoConnection.close();
                errorResultHandler.handleError(new PSQLException(GT.tr("An I/O error occured while sending to the backend."), PSQLState.CONNECTION_FAILURE, (Throwable)iOException));
            }
            this.protoConnection.setVerticaCopyStarted(false);
            this.protoConnection.setInCopyIn(false);
            if (bl) {
                errorResultHandler.handleCompletion();
            }
        }
    }

    public void setCurrentStatement(BaseStatement baseStatement) throws PSQLException {
        if (this.stmt != null && this.stmt != baseStatement && this.protoConnection.isVerticaCopyStarted()) {
            if (this.protoConnection.loadingBatches()) {
                throw new PSQLException(GT.tr("Unable to switch statements while batch is loading"), PSQLState.OBJECT_NOT_IN_STATE);
            }
            if (this.protoConnection.isInLRS()) {
                throw new PSQLException(GT.tr("Unable to switch statements while streaming a large result set"), PSQLState.OBJECT_NOT_IN_STATE);
            }
        }
        this.stmt = baseStatement;
    }

    public BaseStatement getCurrentStatement() {
        return this.stmt;
    }

    private class ErrorResultHandler
    implements ResultHandler {
        private SQLException error;

        private ErrorResultHandler() {
        }

        public void handleResultRows(Query query, Field[] fieldArray, VectorTuple vectorTuple, ResultCursor resultCursor) {
        }

        public void handleCommandStatus(String string, int n, long l) {
        }

        public void handleWarning(SQLWarning sQLWarning) {
        }

        public void handleError(SQLException sQLException) {
            if (this.error == null) {
                this.error = sQLException;
            } else {
                this.error.setNextException(sQLException);
            }
        }

        public void handleCompletion() throws SQLException {
            if (this.error != null) {
                throw this.error;
            }
        }
    }

    private static class ErrorTrackingResultHandler
    implements ResultHandler {
        private final ResultHandler delegateHandler;
        private boolean sawError = false;

        ErrorTrackingResultHandler(ResultHandler resultHandler) {
            this.delegateHandler = resultHandler;
        }

        public void handleResultRows(Query query, Field[] fieldArray, VectorTuple vectorTuple, ResultCursor resultCursor) {
            this.delegateHandler.handleResultRows(query, fieldArray, vectorTuple, resultCursor);
        }

        public void handleCommandStatus(String string, int n, long l) {
            this.delegateHandler.handleCommandStatus(string, n, l);
        }

        public void handleWarning(SQLWarning sQLWarning) {
            this.delegateHandler.handleWarning(sQLWarning);
        }

        public void handleError(SQLException sQLException) {
            this.sawError = true;
            this.delegateHandler.handleError(sQLException);
        }

        public void handleCompletion() throws SQLException {
            this.delegateHandler.handleCompletion();
        }

        boolean hasErrors() {
            return this.sawError;
        }
    }
}

