/*
 * Decompiled with CFR 0.152.
 */
package com.vertica.core.v3;

import com.vertica.PGNotification;
import com.vertica.core.BaseConnection;
import com.vertica.core.Encoding;
import com.vertica.core.Logger;
import com.vertica.core.PGStream;
import com.vertica.core.ProtocolConnection;
import com.vertica.core.QueryExecutor;
import com.vertica.core.v3.QueryExecutorImpl;
import java.io.IOException;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.util.ArrayList;
import java.util.Properties;

class ProtocolConnectionImpl
implements ProtocolConnection {
    private String serverVersion;
    private String VTserverVersion;
    private int cancelPid;
    private int cancelKey;
    private int transactionState;
    private SQLWarning warnings;
    private boolean closed = false;
    private final ArrayList notifications = new ArrayList();
    private final PGStream pgStream;
    private final String user;
    private final String database;
    private final QueryExecutorImpl executor;
    private final Logger logger;
    private BaseConnection connection;
    private boolean inLRS;
    protected boolean batchStreamRunning = false;
    private boolean verticaCopyStarted = false;
    private boolean inCopyIn = false;

    ProtocolConnectionImpl(PGStream pGStream, String string, String string2, Properties properties, Logger logger) {
        this.pgStream = pGStream;
        this.user = string;
        this.database = string2;
        this.logger = logger;
        this.executor = new QueryExecutorImpl(this, pGStream, properties, logger);
        this.inLRS = false;
    }

    public String getHost() {
        return this.pgStream.getHost();
    }

    public int getPort() {
        return this.pgStream.getPort();
    }

    public String getUser() {
        return this.user;
    }

    public String getDatabase() {
        return this.database;
    }

    public String getServerVersion() {
        return this.serverVersion;
    }

    public String getVTServerVersion() {
        return this.VTserverVersion;
    }

    public synchronized int getTransactionState() {
        return this.transactionState;
    }

    public synchronized PGNotification[] getNotifications() throws SQLException {
        this.executor.processNotifies();
        PGNotification[] pGNotificationArray = this.notifications.toArray(new PGNotification[this.notifications.size()]);
        this.notifications.clear();
        return pGNotificationArray;
    }

    public synchronized SQLWarning getWarnings() {
        SQLWarning sQLWarning = this.warnings;
        this.warnings = null;
        return sQLWarning;
    }

    public QueryExecutor getQueryExecutor() {
        return this.executor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sendQueryCancel() throws SQLException {
        PGStream pGStream = null;
        try {
            if (this.logger.logDebug()) {
                this.logger.debug(" FE=> CancelRequest(pid=" + this.cancelPid + ",ckey=" + this.cancelKey + ")");
            }
            pGStream = new PGStream(this.pgStream.getHost(), this.pgStream.getPort());
            pGStream.SendInteger4(16);
            pGStream.SendInteger2(1234);
            pGStream.SendInteger2(5678);
            pGStream.SendInteger4(this.cancelPid);
            pGStream.SendInteger4(this.cancelKey);
            pGStream.flush();
            pGStream.ReceiveEOF();
            pGStream.close();
            pGStream = null;
        }
        catch (IOException iOException) {
            if (this.logger.logDebug()) {
                this.logger.debug("Ignoring exception on cancel request:", iOException);
            }
        }
        finally {
            if (pGStream != null) {
                try {
                    pGStream.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    public void close() {
        block4: {
            if (this.closed) {
                return;
            }
            try {
                if (this.logger.logDebug()) {
                    this.logger.debug(" FE=> Terminate");
                }
                this.pgStream.SendChar(88);
                this.pgStream.SendInteger4(4);
                this.pgStream.flush();
                this.pgStream.close();
            }
            catch (IOException iOException) {
                if (!this.logger.logDebug()) break block4;
                this.logger.debug("Discarding IOException on close:", iOException);
            }
        }
        this.closed = true;
        this.batchStreamRunning = false;
        this.verticaCopyStarted = false;
        this.inLRS = false;
        this.inCopyIn = false;
    }

    public Encoding getEncoding() {
        return this.pgStream.getEncoding();
    }

    public boolean isClosed() {
        return this.closed;
    }

    void setServerVersion(String string) {
        this.serverVersion = string;
    }

    void setVTServerVersion(String string) {
        this.VTserverVersion = string;
    }

    void setBackendKeyData(int n, int n2) {
        this.cancelPid = n;
        this.cancelKey = n2;
    }

    synchronized void addWarning(SQLWarning sQLWarning) {
        if (this.warnings == null) {
            this.warnings = sQLWarning;
        } else {
            this.warnings.setNextWarning(sQLWarning);
        }
    }

    synchronized void addNotification(PGNotification pGNotification) {
        this.notifications.add(pGNotification);
    }

    synchronized void setTransactionState(int n) {
        this.transactionState = n;
    }

    public int getProtocolVersion() {
        return 3;
    }

    public void setConnection(BaseConnection baseConnection) {
        this.connection = baseConnection;
    }

    public BaseConnection getConnection() {
        return this.connection;
    }

    public boolean isInLRS() {
        return this.inLRS;
    }

    public void setInLRS(boolean bl) {
        this.inLRS = bl;
    }

    public boolean loadingBatches() {
        return this.batchStreamRunning;
    }

    public void setLoadingBatch(boolean bl) {
        this.batchStreamRunning = bl;
    }

    public boolean isVerticaCopyStarted() {
        return this.verticaCopyStarted;
    }

    public void setVerticaCopyStarted(boolean bl) {
        this.verticaCopyStarted = bl;
    }

    public boolean isInCopyIn() {
        return this.inCopyIn;
    }

    public void setInCopyIn(boolean bl) {
        this.inCopyIn = bl;
    }
}

