/*
 * Decompiled with CFR 0.152.
 */
package com.vertica.core.v3;

import com.vertica.Driver;
import com.vertica.core.ConnectionFactory;
import com.vertica.core.Encoding;
import com.vertica.core.Field;
import com.vertica.core.Logger;
import com.vertica.core.PGStream;
import com.vertica.core.ProtocolConnection;
import com.vertica.core.Query;
import com.vertica.core.QueryExecutor;
import com.vertica.core.ResultCursor;
import com.vertica.core.ResultHandler;
import com.vertica.core.Utils;
import com.vertica.core.VectorTuple;
import com.vertica.core.v3.ProtocolConnectionImpl;
import com.vertica.util.GT;
import com.vertica.util.MD5Digest;
import com.vertica.util.PSQLException;
import com.vertica.util.PSQLState;
import com.vertica.util.PSQLWarning;
import com.vertica.util.ServerErrorMessage;
import com.vertica.util.UnixCrypt;
import java.io.IOException;
import java.lang.management.ManagementFactory;
import java.net.ConnectException;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.util.Properties;

public class ConnectionFactoryImpl
extends ConnectionFactory {
    private static final int AUTH_REQ_OK = 0;
    private static final int AUTH_REQ_KRB4 = 1;
    private static final int AUTH_REQ_KRB5 = 2;
    private static final int AUTH_REQ_PASSWORD = 3;
    private static final int AUTH_REQ_CRYPT = 4;
    private static final int AUTH_REQ_MD5 = 5;
    private static final int AUTH_REQ_SCM = 6;
    private static final int AUTH_REQ_CHANGE_PASSWORD = 9;
    private static final int AUTH_REQ_PASSWORD_CHANGED = 10;
    private static final int AUTH_REQ_PASSWORD_GRACE = 11;
    private static final int MAX_LABEL_SIZE = 255;

    private Integer getProcessId() {
        String string = ManagementFactory.getRuntimeMXBean().getName();
        StringBuffer stringBuffer = new StringBuffer();
        int n = string.length();
        for (int i = 0; i < n; ++i) {
            if (Character.isDigit(string.charAt(i))) {
                stringBuffer.append(string.charAt(i));
                continue;
            }
            if (stringBuffer.length() > 0) break;
        }
        try {
            return Integer.parseInt(stringBuffer.toString());
        }
        catch (NumberFormatException numberFormatException) {
            return 0;
        }
    }

    public ProtocolConnection openConnectionImpl(String string, int n, String string2, String string3, Properties properties, Logger logger) throws SQLException {
        boolean bl;
        boolean bl2 = bl = Boolean.parseBoolean(properties.getProperty("ssl", "false"));
        if (logger.logDebug()) {
            logger.debug("Trying to establish a protocol version 3 connection to " + string + ":" + n);
        }
        if (!Driver.sslEnabled()) {
            if (bl) {
                throw new PSQLException(GT.tr("The driver does not support SSL."), PSQLState.CONNECTION_FAILURE);
            }
            bl2 = false;
        }
        PGStream pGStream = null;
        try {
            pGStream = new PGStream(string, n);
            if (bl2) {
                pGStream = this.enableSSL(pGStream, bl, properties, logger);
            }
            if (properties.getProperty("KeepAlive") != null) {
                pGStream.getSocket().setKeepAlive(Boolean.valueOf(properties.getProperty("KeepAlive")));
            }
            boolean bl3 = true;
            if (properties.getProperty("BinaryDataTransfer") != null) {
                bl3 = Boolean.valueOf(properties.getProperty("BinaryDataTransfer"));
            } else {
                properties.setProperty("BinaryDataTransfer", "false");
            }
            String string4 = "";
            if (properties.getProperty("Label") != null && (string4 = properties.getProperty("Label")).length() > 255) {
                string4 = string4.substring(0, 255);
            }
            String[][] stringArray = new String[][]{{"user", string2}, {"database", string3}, {"client_encoding", "UNICODE"}, {"DateStyle", "ISO"}, {"binary_data_protocol", bl3 ? "1" : "0"}, {"client_pid", this.getProcessId().toString()}, {"client_label", string4}};
            this.sendStartupPacket(pGStream, stringArray, logger);
            this.doAuthentication(pGStream, string2, properties.getProperty("password"), logger);
            ProtocolConnectionImpl protocolConnectionImpl = new ProtocolConnectionImpl(pGStream, string2, string3, properties, logger);
            this.readStartupMessages(pGStream, protocolConnectionImpl, logger);
            this.runInitialQueries(protocolConnectionImpl, properties);
            return protocolConnectionImpl;
        }
        catch (UnsupportedProtocolException unsupportedProtocolException) {
            if (logger.logDebug()) {
                logger.debug("Protocol not supported, abandoning connection.");
            }
            try {
                pGStream.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            return null;
        }
        catch (ConnectException connectException) {
            throw new PSQLException(GT.tr("Connection refused. Check that the hostname and port are correct and that the postmaster is accepting TCP/IP connections."), PSQLState.CONNECTION_REJECTED, (Throwable)connectException);
        }
        catch (IOException iOException) {
            if (pGStream != null) {
                try {
                    pGStream.close();
                }
                catch (IOException iOException2) {
                    // empty catch block
                }
            }
            throw new PSQLException(GT.tr("The connection attempt failed."), PSQLState.CONNECTION_UNABLE_TO_CONNECT, (Throwable)iOException);
        }
        catch (SQLException sQLException) {
            if (pGStream != null) {
                try {
                    pGStream.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            throw sQLException;
        }
    }

    private PGStream enableSSL(PGStream pGStream, boolean bl, Properties properties, Logger logger) throws IOException, SQLException {
        if (logger.logDebug()) {
            logger.debug(" FE=> SSLRequest");
        }
        pGStream.SendInteger4(8);
        pGStream.SendInteger2(1234);
        pGStream.SendInteger2(5679);
        pGStream.flush();
        int n = pGStream.ReceiveChar();
        switch (n) {
            case 69: {
                if (logger.logDebug()) {
                    logger.debug(" <=BE SSLError");
                }
                if (bl) {
                    throw new PSQLException(GT.tr("The server does not support SSL."), PSQLState.CONNECTION_FAILURE);
                }
                pGStream.close();
                return new PGStream(pGStream.getHost(), pGStream.getPort());
            }
            case 78: {
                if (logger.logDebug()) {
                    logger.debug(" <=BE SSLRefused");
                }
                if (bl) {
                    throw new PSQLException(GT.tr("The server does not support SSL."), PSQLState.CONNECTION_FAILURE);
                }
                return pGStream;
            }
            case 83: {
                if (logger.logDebug()) {
                    logger.debug(" <=BE SSLOk");
                }
                Driver.makeSSL(pGStream, properties, logger);
                return pGStream;
            }
        }
        throw new PSQLException(GT.tr("An error occured while setting up the SSL connection."), PSQLState.CONNECTION_FAILURE);
    }

    private void sendStartupPacket(PGStream pGStream, String[][] stringArray, Logger logger) throws IOException {
        int n;
        if (logger.logDebug()) {
            String string = "";
            for (int i = 0; i < stringArray.length; ++i) {
                if (i != 0) {
                    string = string + ", ";
                }
                string = string + stringArray[i][0] + "=" + stringArray[i][1];
            }
            logger.debug(" FE=> StartupPacket(" + string + ")");
        }
        int n2 = 8;
        byte[][] byArrayArray = new byte[stringArray.length * 2][];
        for (n = 0; n < stringArray.length; ++n) {
            byArrayArray[n * 2] = stringArray[n][0].getBytes("US-ASCII");
            byArrayArray[n * 2 + 1] = stringArray[n][1].getBytes("US-ASCII");
            n2 += byArrayArray[n * 2].length + 1 + byArrayArray[n * 2 + 1].length + 1;
        }
        pGStream.SendInteger4(++n2);
        pGStream.SendInteger2(3);
        pGStream.SendInteger2(1);
        for (n = 0; n < byArrayArray.length; ++n) {
            pGStream.Send(byArrayArray[n]);
            pGStream.SendChar(0);
        }
        pGStream.SendChar(0);
        pGStream.flush();
    }

    private void doAuthentication(PGStream pGStream, String string, String string2, Logger logger) throws IOException, SQLException {
        block14: while (true) {
            int n = pGStream.ReceiveChar();
            switch (n) {
                case 69: {
                    int n2 = pGStream.ReceiveIntegerR(4);
                    if (n2 > 30000) {
                        throw new UnsupportedProtocolException();
                    }
                    ServerErrorMessage serverErrorMessage = new ServerErrorMessage(pGStream.ReceiveString(n2 - 4), logger.getLogLevel());
                    if (logger.logDebug()) {
                        logger.debug(" <=BE ErrorMessage(" + serverErrorMessage + ")");
                    }
                    throw new PSQLException(serverErrorMessage);
                }
                case 82: {
                    Object object;
                    int n3 = pGStream.ReceiveIntegerR(4);
                    int n4 = pGStream.ReceiveIntegerR(4);
                    switch (n4) {
                        case 4: {
                            byte[] byArray = new byte[]{(byte)pGStream.ReceiveChar(), (byte)pGStream.ReceiveChar()};
                            object = new String(byArray, 0, 2, "US-ASCII");
                            if (logger.logDebug()) {
                                logger.debug(" <=BE AuthenticationReqCrypt(salt='" + (String)object + "')");
                            }
                            if (string2 == null) {
                                throw new PSQLException(GT.tr("The server requested password-based authentication, but no password was provided."), PSQLState.CONNECTION_REJECTED);
                            }
                            String string3 = UnixCrypt.crypt((String)object, string2);
                            byte[] byArray2 = string3.getBytes("US-ASCII");
                            if (logger.logDebug()) {
                                logger.debug(" FE=> Password(crypt='" + string3 + "')");
                            }
                            pGStream.SendChar(112);
                            pGStream.SendInteger4(4 + byArray2.length + 1);
                            pGStream.Send(byArray2);
                            pGStream.SendChar(0);
                            pGStream.flush();
                            continue block14;
                        }
                        case 5: {
                            byte[] byArray = pGStream.Receive(4);
                            if (logger.logDebug()) {
                                logger.debug(" <=BE AuthenticationReqMD5(salt=" + Utils.toHexString(byArray) + ")");
                            }
                            if (string2 == null) {
                                throw new PSQLException(GT.tr("The server requested password-based authentication, but no password was provided."), PSQLState.CONNECTION_REJECTED);
                            }
                            object = MD5Digest.encode(string, string2, byArray);
                            if (logger.logDebug()) {
                                logger.debug(" FE=> Password(md5digest=" + new String((byte[])object, "US-ASCII") + ")");
                            }
                            pGStream.SendChar(112);
                            pGStream.SendInteger4(4 + ((Object)object).length + 1);
                            pGStream.Send((byte[])object);
                            pGStream.SendChar(0);
                            pGStream.flush();
                            continue block14;
                        }
                        case 3: {
                            if (logger.logDebug()) {
                                logger.debug(" <=BE AuthenticationReqPassword");
                                logger.debug(" FE=> Password(password=<not shown>)");
                            }
                            if (string2 == null) {
                                throw new PSQLException(GT.tr("The server requested password-based authentication, but no password was provided."), PSQLState.CONNECTION_REJECTED);
                            }
                            byte[] byArray = string2.getBytes("US-ASCII");
                            pGStream.SendChar(112);
                            pGStream.SendInteger4(4 + byArray.length + 1);
                            pGStream.Send(byArray);
                            pGStream.SendChar(0);
                            pGStream.flush();
                            continue block14;
                        }
                        case 0: {
                            if (logger.logDebug()) {
                                logger.debug(" <=BE AuthenticationOk");
                            }
                            return;
                        }
                        case 9: {
                            if (logger.logDebug()) {
                                logger.debug(" <=BE ChangePassword");
                            }
                            throw new PSQLException(GT.tr("The password has expired."), PSQLState.CONNECTION_REJECTED);
                        }
                        case 10: {
                            if (logger.logDebug()) {
                                logger.debug(" <=BE PasswordChanged");
                            }
                            throw new PSQLException(GT.tr("Protocol error. Session setup failed (password_changed)"), PSQLState.CONNECTION_REJECTED);
                        }
                        case 11: {
                            logger.debug(" <=BE PasswordExpiredButInGracePeriod");
                            logger.info("The password will expire soon. Please change password.");
                            continue block14;
                        }
                    }
                    if (logger.logDebug()) {
                        logger.debug(" <=BE AuthenticationReq (unsupported type " + n4 + ")");
                    }
                    throw new PSQLException(GT.tr("The authentication type {0} is not supported. Check that you have configured the pg_hba.conf file to include the client''s IP address or subnet, and that it is using an authentication scheme supported by the driver.", new Integer(n4)), PSQLState.CONNECTION_REJECTED);
                }
                case 78: {
                    int n5 = pGStream.ReceiveIntegerR(4);
                    Object object = new ServerErrorMessage(pGStream.ReceiveString(n5 - 4), logger.getLogLevel());
                    if (!logger.logDebug()) continue block14;
                    logger.debug(" <=BE NoticeResponse(" + object + ")");
                    continue block14;
                }
            }
            break;
        }
        throw new PSQLException(GT.tr("Protocol error.  Session setup failed."), PSQLState.CONNECTION_UNABLE_TO_CONNECT);
    }

    private void readStartupMessages(PGStream pGStream, ProtocolConnectionImpl protocolConnectionImpl, Logger logger) throws IOException, SQLException {
        int n;
        block12: while (true) {
            n = pGStream.ReceiveChar();
            switch (n) {
                case 90: {
                    if (pGStream.ReceiveIntegerR(4) != 5) {
                        throw new IOException("unexpected length of ReadyForQuery packet");
                    }
                    char c = (char)pGStream.ReceiveChar();
                    if (logger.logDebug()) {
                        logger.debug(" <=BE ReadyForQuery(" + c + ")");
                    }
                    switch (c) {
                        case 'I': {
                            protocolConnectionImpl.setTransactionState(0);
                            break;
                        }
                        case 'T': {
                            protocolConnectionImpl.setTransactionState(1);
                            break;
                        }
                        case 'E': {
                            protocolConnectionImpl.setTransactionState(2);
                            break;
                        }
                    }
                    return;
                }
                case 75: {
                    int n2 = pGStream.ReceiveIntegerR(4);
                    if (n2 != 12) {
                        throw new PSQLException(GT.tr("Protocol error.  Session setup failed."), PSQLState.CONNECTION_UNABLE_TO_CONNECT);
                    }
                    int n3 = pGStream.ReceiveIntegerR(4);
                    int n4 = pGStream.ReceiveIntegerR(4);
                    if (logger.logDebug()) {
                        logger.debug(" <=BE BackendKeyData(pid=" + n3 + ",ckey=" + n4 + ")");
                    }
                    protocolConnectionImpl.setBackendKeyData(n3, n4);
                    continue block12;
                }
                case 69: {
                    int n5 = pGStream.ReceiveIntegerR(4);
                    ServerErrorMessage serverErrorMessage = new ServerErrorMessage(pGStream.ReceiveString(n5 - 4), logger.getLogLevel());
                    if (logger.logDebug()) {
                        logger.debug(" <=BE ErrorMessage(" + serverErrorMessage + ")");
                    }
                    throw new PSQLException(serverErrorMessage);
                }
                case 78: {
                    int n6 = pGStream.ReceiveIntegerR(4);
                    ServerErrorMessage serverErrorMessage = new ServerErrorMessage(pGStream.ReceiveString(n6 - 4), logger.getLogLevel());
                    if (logger.logDebug()) {
                        logger.debug(" <=BE NoticeResponse(" + serverErrorMessage + ")");
                    }
                    protocolConnectionImpl.addWarning(new PSQLWarning(serverErrorMessage));
                    continue block12;
                }
                case 83: {
                    int n7 = pGStream.ReceiveIntegerR(4);
                    String string = pGStream.ReceiveString();
                    String string2 = pGStream.ReceiveString();
                    if (logger.logDebug()) {
                        logger.debug(" <=BE ParameterStatus(" + string + " = " + string2 + ")");
                    }
                    if (string.equals("server_version")) {
                        protocolConnectionImpl.setServerVersion(string2);
                        continue block12;
                    }
                    if (!string.equals("client_encoding")) continue block12;
                    if (!string2.equals("UNICODE")) {
                        throw new PSQLException(GT.tr("Protocol error.  Session setup failed."), PSQLState.CONNECTION_UNABLE_TO_CONNECT);
                    }
                    pGStream.setEncoding(Encoding.getDatabaseEncoding("UNICODE"));
                    continue block12;
                }
            }
            break;
        }
        if (logger.logDebug()) {
            logger.debug("invalid message type=" + (char)n);
        }
        throw new PSQLException(GT.tr("Protocol error.  Session setup failed."), PSQLState.CONNECTION_UNABLE_TO_CONNECT);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private byte[][] runSetupQuery(ProtocolConnectionImpl protocolConnectionImpl, String string, boolean bl) throws SQLException {
        QueryExecutor queryExecutor = protocolConnectionImpl.getQueryExecutor();
        Query query = queryExecutor.createSimpleQuery(string);
        queryExecutor.setMaxLRSMemory(0x8000000);
        SimpleResultHandler simpleResultHandler = new SimpleResultHandler(protocolConnectionImpl);
        int n = 529;
        if (!bl) {
            n |= 6;
        }
        try {
            queryExecutor.setCurrentStatement(null);
            queryExecutor.execute(query, null, (ResultHandler)simpleResultHandler, 0, 0, n);
        }
        finally {
            query.close();
        }
        if (!bl) {
            return null;
        }
        VectorTuple vectorTuple = simpleResultHandler.getResults();
        if (vectorTuple == null || vectorTuple.size() != 1) {
            throw new PSQLException(GT.tr("An unexpected result was returned by a query."), PSQLState.CONNECTION_UNABLE_TO_CONNECT);
        }
        return (byte[][])vectorTuple.elementAt(0);
    }

    private void runInitialQueries(ProtocolConnectionImpl protocolConnectionImpl, Properties properties) throws SQLException, IOException {
        byte[][] byArray;
        try {
            byArray = this.runSetupQuery(protocolConnectionImpl, "select version_internal()", true);
        }
        catch (SQLException sQLException) {
            try {
                byArray = this.runSetupQuery(protocolConnectionImpl, "select version()", true);
            }
            catch (SQLException sQLException2) {
                throw new PSQLException(GT.tr("Could not retrieve server version"), PSQLState.CONNECTION_FAILURE);
            }
        }
        String string = protocolConnectionImpl.getEncoding().decode(byArray[0]);
        String[] stringArray = string.split("\\s");
        String string2 = stringArray[stringArray.length - 1];
        protocolConnectionImpl.setVTServerVersion(string2);
        if (!ConnectionFactoryImpl.canConnect(string2)) {
            throw new PSQLException(GT.tr("This Vertica driver cannot connect to a server of version below 4.1"), PSQLState.CONNECTION_FAILURE);
        }
        if (properties.getProperty("Locale") != null) {
            this.runSetupQuery(protocolConnectionImpl, "SET LOCALE=" + Utils.escapeSingleQuotes(properties.getProperty("Locale")), false);
        }
    }

    private static boolean canConnect(String string) {
        String[] stringArray = string.substring(1).split("\\D");
        if (stringArray.length < 2) {
            return false;
        }
        int n = Integer.parseInt(stringArray[0]);
        int n2 = Integer.parseInt(stringArray[1]);
        return n > 4 || n == 4 && n2 >= 1;
    }

    private static void unitTestVersionString(String string, boolean bl) {
        boolean bl2 = ConnectionFactoryImpl.canConnect(string);
        System.out.println("Testing version string '" + string + "' -- " + (bl2 == bl ? "SUCC" : "FAIL"));
    }

    public static void main(String[] stringArray) throws Exception {
        ConnectionFactoryImpl.unitTestVersionString("v4.0.0", false);
        ConnectionFactoryImpl.unitTestVersionString("v4.0", false);
        ConnectionFactoryImpl.unitTestVersionString("v4.0.branch", false);
        ConnectionFactoryImpl.unitTestVersionString("v4.1.0", true);
        ConnectionFactoryImpl.unitTestVersionString("v4.1", true);
        ConnectionFactoryImpl.unitTestVersionString("v4.1.branch", true);
        ConnectionFactoryImpl.unitTestVersionString("v4.2.0", true);
        ConnectionFactoryImpl.unitTestVersionString("v5.0.0", true);
        ConnectionFactoryImpl.unitTestVersionString("v3.5", false);
    }

    private class SimpleResultHandler
    implements ResultHandler {
        private SQLException error;
        private VectorTuple tuples;
        private final ProtocolConnectionImpl protoConnection;

        SimpleResultHandler(ProtocolConnectionImpl protocolConnectionImpl) {
            this.protoConnection = protocolConnectionImpl;
        }

        VectorTuple getResults() {
            return this.tuples;
        }

        public void handleResultRows(Query query, Field[] fieldArray, VectorTuple vectorTuple, ResultCursor resultCursor) {
            this.tuples = vectorTuple;
        }

        public void handleCommandStatus(String string, int n, long l) {
        }

        public void handleWarning(SQLWarning sQLWarning) {
            this.protoConnection.addWarning(sQLWarning);
        }

        public void handleError(SQLException sQLException) {
            if (this.error == null) {
                this.error = sQLException;
            } else {
                this.error.setNextException(sQLException);
            }
        }

        public void handleCompletion() throws SQLException {
            if (this.error != null) {
                throw this.error;
            }
        }
    }

    private static class UnsupportedProtocolException
    extends IOException {
        private UnsupportedProtocolException() {
        }
    }
}

