/*
 * Decompiled with CFR 0.152.
 */
package com.vertica.core.v2;

import com.vertica.core.ParameterList;
import com.vertica.util.GT;
import com.vertica.util.PSQLException;
import com.vertica.util.PSQLState;
import com.vertica.util.StreamWrapper;
import java.io.IOException;
import java.io.InputStream;
import java.io.Writer;
import java.sql.SQLException;
import java.util.Arrays;

class SimpleParameterList
implements ParameterList {
    private final Object[] paramValues;
    private static final String NULL_OBJECT = new String("NULL");

    SimpleParameterList(int n) {
        this.paramValues = new Object[n];
    }

    public void registerOutParameter(int n, int n2) {
    }

    public void registerOutParameter(int n, int n2, int n3) {
    }

    public int getInParameterCount() {
        return this.paramValues.length;
    }

    public int getParameterCount() {
        return this.paramValues.length;
    }

    public int getOutParameterCount() {
        return 1;
    }

    public int[] getTypeOIDs() {
        return null;
    }

    public void setIntParameter(int n, int n2) throws SQLException {
        this.setLiteralParameter(n, "" + n2, 23);
    }

    public void setLiteralParameter(int n, String string, int n2) throws SQLException {
        if (n < 1 || n > this.paramValues.length) {
            throw new PSQLException(GT.tr("The column index is out of range: {0}, number of columns: {1}.", new Object[]{new Integer(n), new Integer(this.paramValues.length)}), PSQLState.INVALID_PARAMETER_VALUE);
        }
        this.paramValues[n - 1] = string;
    }

    public void setStringParameter(int n, String string, int n2) throws SQLException {
        StringBuffer stringBuffer = new StringBuffer(2 + string.length() * 11 / 10);
        stringBuffer.append('\'');
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            if (c == '\u0000') {
                throw new PSQLException(GT.tr("Zero bytes may not occur in string parameters."), PSQLState.INVALID_PARAMETER_VALUE);
            }
            if (c == '\\' || c == '\'') {
                stringBuffer.append('\\');
            }
            stringBuffer.append(c);
        }
        stringBuffer.append('\'');
        this.setLiteralParameter(n, stringBuffer.toString(), n2);
    }

    public void setBytea(int n, byte[] byArray, int n2, int n3) throws SQLException {
        if (n < 1 || n > this.paramValues.length) {
            throw new PSQLException(GT.tr("The column index is out of range: {0}, number of columns: {1}.", new Object[]{new Integer(n), new Integer(this.paramValues.length)}), PSQLState.INVALID_PARAMETER_VALUE);
        }
        this.paramValues[n - 1] = new StreamWrapper(byArray, n2, n3);
    }

    public void setBytea(int n, InputStream inputStream, int n2) throws SQLException {
        if (n < 1 || n > this.paramValues.length) {
            throw new PSQLException(GT.tr("The column index is out of range: {0}, number of columns: {1}.", new Object[]{new Integer(n), new Integer(this.paramValues.length)}), PSQLState.INVALID_PARAMETER_VALUE);
        }
        this.paramValues[n - 1] = new StreamWrapper(inputStream, n2);
    }

    public void setNull(int n, int n2) throws SQLException {
        if (n < 1 || n > this.paramValues.length) {
            throw new PSQLException(GT.tr("The column index is out of range: {0}, number of columns: {1}.", new Object[]{new Integer(n), new Integer(this.paramValues.length)}), PSQLState.INVALID_PARAMETER_VALUE);
        }
        this.paramValues[n - 1] = NULL_OBJECT;
    }

    public String toString(int n) {
        if (n < 1 || n > this.paramValues.length) {
            throw new IllegalArgumentException("Parameter index " + n + " out of range");
        }
        if (this.paramValues[n - 1] == null) {
            return "?";
        }
        if (this.paramValues[n - 1] == NULL_OBJECT) {
            return "NULL";
        }
        return this.paramValues[n - 1].toString();
    }

    private static void streamBytea(StreamWrapper streamWrapper, Writer writer) throws IOException {
        InputStream inputStream = streamWrapper.getStream();
        char[] cArray = new char[]{'\\', '\\', '\u0000', '\u0000', '\u0000'};
        writer.write(39);
        for (int i = streamWrapper.getLength(); i > 0; --i) {
            int n = inputStream.read();
            cArray[2] = (char)(48 + (n >> 6 & 3));
            cArray[3] = (char)(48 + (n >> 3 & 7));
            cArray[4] = (char)(48 + (n & 7));
            writer.write(cArray, 0, 5);
        }
        writer.write(39);
    }

    void writeV2Value(int n, Writer writer) throws IOException {
        if (this.paramValues[n - 1] instanceof StreamWrapper) {
            SimpleParameterList.streamBytea((StreamWrapper)this.paramValues[n - 1], writer);
        } else {
            writer.write((String)this.paramValues[n - 1]);
        }
    }

    void checkAllParametersSet() throws SQLException {
        for (int i = 0; i < this.paramValues.length; ++i) {
            if (this.paramValues[i] != null) continue;
            throw new PSQLException(GT.tr("No value specified for parameter {0}.", new Integer(i + 1)), PSQLState.INVALID_PARAMETER_VALUE);
        }
    }

    public ParameterList copy() {
        SimpleParameterList simpleParameterList = new SimpleParameterList(this.paramValues.length);
        System.arraycopy(this.paramValues, 0, simpleParameterList.paramValues, 0, this.paramValues.length);
        return simpleParameterList;
    }

    public String toBatchString(String string) {
        return null;
    }

    public byte[] toNativeBatchString(boolean bl) {
        return null;
    }

    public void clear() {
        Arrays.fill(this.paramValues, null);
    }
}

