/*
 * Decompiled with CFR 0.152.
 */
package com.vertica.core.types;

import com.vertica.core.types.PGBigDecimal;
import com.vertica.core.types.PGBoolean;
import com.vertica.core.types.PGDouble;
import com.vertica.core.types.PGFloat;
import com.vertica.core.types.PGInteger;
import com.vertica.core.types.PGShort;
import com.vertica.core.types.PGString;
import com.vertica.core.types.PGType;
import com.vertica.core.types.PGUnknown;
import com.vertica.util.GT;
import com.vertica.util.PSQLException;
import com.vertica.util.PSQLState;
import java.math.BigDecimal;

public class PGLong
implements PGType {
    private Long val;

    protected PGLong(Long l) {
        this.val = l;
    }

    public static PGType castToServerType(Long l, int n) throws PSQLException {
        try {
            switch (n) {
                case -7: {
                    return new PGBoolean(l == 0L ? Boolean.FALSE : Boolean.TRUE);
                }
                case 7: {
                    return new PGFloat(new Float(l.floatValue()));
                }
                case 6: 
                case 8: {
                    return new PGDouble(new Double(l.doubleValue()));
                }
                case -1: 
                case 12: {
                    return new PGString(l.toString());
                }
                case -5: {
                    return new PGLong(l);
                }
                case 4: {
                    return new PGInteger(new Integer(l.intValue()));
                }
                case -6: 
                case 5: {
                    return new PGShort(new Short(l.shortValue()));
                }
                case 2: 
                case 3: {
                    return new PGBigDecimal(new BigDecimal(l.toString()));
                }
            }
            return new PGUnknown(l);
        }
        catch (Exception exception) {
            throw new PSQLException(GT.tr("Cannot convert an instance of {0} to type {1}", new Object[]{l.getClass().getName(), "Types.OTHER"}), PSQLState.INVALID_PARAMETER_TYPE, (Throwable)exception);
        }
    }

    public String toString() {
        return this.val.toString();
    }
}

