/*
 * Decompiled with CFR 0.152.
 */
package com.vertica.core.types;

import com.vertica.core.types.PGBigDecimal;
import com.vertica.core.types.PGDouble;
import com.vertica.core.types.PGFloat;
import com.vertica.core.types.PGInteger;
import com.vertica.core.types.PGLong;
import com.vertica.core.types.PGShort;
import com.vertica.core.types.PGString;
import com.vertica.core.types.PGType;
import com.vertica.core.types.PGUnknown;
import com.vertica.util.GT;
import com.vertica.util.PSQLException;
import com.vertica.util.PSQLState;
import java.math.BigDecimal;

public class PGBoolean
implements PGType {
    private Boolean val;

    public PGBoolean(Boolean bl) {
        this.val = bl;
    }

    public static PGType castToServerType(Boolean bl, int n) throws PSQLException {
        try {
            switch (n) {
                case -5: {
                    return new PGLong(new Long(bl == true ? 1L : 0L));
                }
                case 4: {
                    return new PGInteger(new Integer(bl == true ? 1 : 0));
                }
                case -6: 
                case 5: {
                    return new PGShort(new Short(bl == true ? (short)1 : 0));
                }
                case -1: 
                case 12: {
                    return new PGString(bl == true ? "true" : "false");
                }
                case 6: 
                case 8: {
                    return new PGDouble(new Double(bl == true ? 1.0 : 0.0));
                }
                case 7: {
                    return new PGFloat(new Float(bl == true ? 1.0f : 0.0f));
                }
                case 2: 
                case 3: {
                    return new PGBigDecimal(new BigDecimal(bl == true ? 1 : 0));
                }
                case -7: {
                    return new PGBoolean(bl);
                }
            }
            return new PGUnknown(bl);
        }
        catch (Exception exception) {
            throw new PSQLException(GT.tr("Cannot convert an instance of {0} to type {1}", new Object[]{bl.getClass().getName(), "Types.OTHER"}), PSQLState.INVALID_PARAMETER_TYPE, (Throwable)exception);
        }
    }

    public String toString() {
        return this.val == true ? "true" : "false";
    }
}

