/*
 * Decompiled with CFR 0.152.
 */
package com.vertica.core;

import com.vertica.core.Logger;
import com.vertica.util.GT;
import com.vertica.util.PSQLException;
import com.vertica.util.PSQLState;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.util.Vector;

public class VectorTuple {
    private Vector memtuples = new Vector();
    private File tmp;
    private FileChannel ofc;
    private FileChannel ifc;
    private int memtupcount = 0;
    private int memtupsize = 0;
    private boolean eof_reached;
    private boolean isCatalogTuple = false;
    private boolean isStreaming = false;
    private int current = 0;
    private static final int TSS_INMEM_LIMIT = 0x1400000;
    private static final int TSS_INMEM = 0;
    private static final int TSS_WRITEFILE = 1;
    private static final int TSS_READFILE = 2;
    private static final String TEMP_FILE_PREFIX = "vtRS";
    private static final String TEMP_FILE_SUFFIX = ".dmp";
    private int maxLRSMemory = 0x1400000;
    private int status = 0;
    private final Logger logger;

    public VectorTuple(Logger logger) {
        this.logger = logger;
    }

    private byte[][] getTupleFromBuff(ByteBuffer byteBuffer, boolean bl) throws OutOfMemoryError {
        int n;
        if (!bl) {
            n = byteBuffer.getInt();
        }
        int n2 = byteBuffer.getShort();
        byte[][] byArrayArray = new byte[n2][];
        OutOfMemoryError outOfMemoryError = null;
        for (n = 0; n < n2; ++n) {
            int n3 = byteBuffer.getInt();
            if (n3 == -1) continue;
            try {
                byArrayArray[n] = new byte[n3];
                byteBuffer.get(byArrayArray[n]);
                continue;
            }
            catch (OutOfMemoryError outOfMemoryError2) {
                outOfMemoryError = outOfMemoryError2;
            }
        }
        if (outOfMemoryError != null) {
            throw outOfMemoryError;
        }
        return byArrayArray;
    }

    private void dumptuples() throws IOException {
        this.tmp = File.createTempFile(TEMP_FILE_PREFIX, TEMP_FILE_SUFFIX);
        this.tmp.deleteOnExit();
        if (this.logger.logDebug()) {
            this.logger.debug(" <= LRS: file=" + this.tmp.getCanonicalPath());
        }
        this.ofc = new FileOutputStream(this.tmp).getChannel();
        for (ByteBuffer byteBuffer : this.memtuples) {
            this.ofc.write(byteBuffer);
        }
        this.memtuples = null;
    }

    public void setStreaming(boolean bl) {
        this.isStreaming = bl;
    }

    public void setMaxLRSMemory(int n) {
        this.maxLRSMemory = n;
    }

    public void addElement(byte[][] byArray) throws PSQLException {
        this.isCatalogTuple = true;
        ++this.memtupcount;
        this.memtuples.addElement(byArray);
    }

    public void addElement(Object object) throws PSQLException {
        ByteBuffer byteBuffer = (ByteBuffer)object;
        byteBuffer.flip();
        try {
            switch (this.status) {
                case 0: {
                    this.memtupsize += byteBuffer.getInt();
                    ++this.memtupcount;
                    byteBuffer.rewind();
                    if (this.memtupsize < this.maxLRSMemory || this.isStreaming) {
                        this.memtuples.addElement(object);
                        return;
                    }
                    this.status = 1;
                    this.dumptuples();
                    this.ofc.write(byteBuffer);
                    break;
                }
                case 1: {
                    this.ofc.write(byteBuffer);
                    ++this.memtupcount;
                    break;
                }
                case 2: {
                    break;
                }
            }
        }
        catch (IOException iOException) {
            String string = ": ";
            try {
                String string2 = System.getProperty("java.io.tmpdir");
                if (string2 != null) {
                    string = " in temp directory " + string2 + ": ";
                }
            }
            catch (SecurityException securityException) {
                // empty catch block
            }
            throw new PSQLException(GT.tr("Error storing tuples" + string + iOException.getMessage()), PSQLState.SYSTEM_ERROR);
        }
    }

    public Object elementAt(int n) throws PSQLException {
        try {
            switch (this.status) {
                case 0: {
                    if (n < this.memtupcount) {
                        ++this.current;
                        if (this.isCatalogTuple) {
                            return this.memtuples.elementAt(n);
                        }
                        ByteBuffer byteBuffer = (ByteBuffer)this.memtuples.elementAt(n);
                        return this.getTupleFromBuff(byteBuffer, false);
                    }
                    this.eof_reached = true;
                    return null;
                }
                case 1: {
                    if (this.eof_reached) {
                        return null;
                    }
                    this.status = 2;
                    this.current = 0;
                    this.ofc.close();
                    this.ifc = new FileInputStream(this.tmp).getChannel();
                    if (this.logger.logDebug()) {
                        this.logger.debug(" <= LRS: file size=" + this.tmp.length());
                    }
                }
                case 2: {
                    if (n < this.current) {
                        return null;
                    }
                    if (this.current < this.memtupcount) {
                        ByteBuffer byteBuffer = ByteBuffer.allocate(4);
                        ByteBuffer byteBuffer2 = ByteBuffer.allocate(4);
                        while (this.current <= n) {
                            byteBuffer = ByteBuffer.allocate(4);
                            this.ifc.read(byteBuffer);
                            byteBuffer.flip();
                            int n2 = byteBuffer.getInt();
                            byteBuffer2 = ByteBuffer.allocate(n2 - 4);
                            this.ifc.read(byteBuffer2);
                            byteBuffer2.flip();
                            ++this.current;
                            if (this.current != this.memtupcount) continue;
                            this.ifc.close();
                            this.tmp.delete();
                            this.eof_reached = true;
                            break;
                        }
                        return this.getTupleFromBuff(byteBuffer2, true);
                    }
                    if (!this.eof_reached) {
                        this.ifc.close();
                        this.tmp.delete();
                        this.eof_reached = true;
                    }
                    return null;
                }
            }
        }
        catch (IOException iOException) {
            String string = ": ";
            try {
                String string2 = System.getProperty("java.io.tmpdir");
                if (string2 != null) {
                    string = " in temp directory " + string2 + ": ";
                }
            }
            catch (SecurityException securityException) {
                // empty catch block
            }
            throw new PSQLException(GT.tr("Error storing tuples" + string + iOException.getMessage()), PSQLState.SYSTEM_ERROR);
        }
        return null;
    }

    public int size() {
        return this.memtupcount;
    }

    public int getTuplesCount() {
        return this.memtupcount;
    }

    public int getTuplesSize() {
        return this.memtupsize;
    }

    public void insertElementAt(Object object, int n) {
        if (this.status == 0) {
            this.memtuples.insertElementAt(object, n);
            ++this.memtupcount;
        }
    }

    public void removeElementAt(int n) {
        if (this.status == 0) {
            this.memtuples.removeElementAt(n);
            --this.memtupcount;
        }
    }

    public void setElementAt(Object object, int n) {
        if (this.status == 0) {
            this.memtuples.setElementAt(object, n);
        }
    }
}

