/*
 * Decompiled with CFR 0.152.
 */
package com.vertica.core;

import com.vertica.core.Encoding;
import com.vertica.core.PGBindException;
import com.vertica.util.GT;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.EOFException;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Writer;
import java.net.Socket;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.sql.SQLException;

public class PGStream {
    private final String host;
    private final int port;
    private Socket connection;
    private InputStream pg_input;
    private OutputStream pg_output;
    private byte[] streamBuffer;
    private Encoding encoding;
    private Writer encodingWriter;
    private byte[] byte_buf = new byte[8192];

    public PGStream(String string, int n) throws IOException {
        this.host = string;
        this.port = n;
        this.changeSocket(new Socket(string, n));
        this.setEncoding(Encoding.getJVMEncoding("UTF-8"));
    }

    public String getHost() {
        return this.host;
    }

    public int getPort() {
        return this.port;
    }

    public Socket getSocket() {
        return this.connection;
    }

    public boolean hasMessagePending() throws IOException {
        return this.pg_input.available() > 0 || this.connection.getInputStream().available() > 0;
    }

    public void changeSocket(Socket socket) throws IOException {
        this.connection = socket;
        this.connection.setTcpNoDelay(true);
        this.pg_input = new BufferedInputStream(this.connection.getInputStream(), 8192);
        this.pg_output = new BufferedOutputStream(this.connection.getOutputStream(), 8192);
        if (this.encoding != null) {
            this.setEncoding(this.encoding);
        }
    }

    public Encoding getEncoding() {
        return this.encoding;
    }

    public void setEncoding(Encoding encoding) throws IOException {
        if (this.encodingWriter != null) {
            this.encodingWriter.close();
        }
        this.encoding = encoding;
        FilterOutputStream filterOutputStream = new FilterOutputStream(this.pg_output){

            public void flush() throws IOException {
            }

            public void close() throws IOException {
                super.flush();
            }
        };
        this.encodingWriter = encoding.getEncodingWriter(filterOutputStream);
    }

    public Writer getEncodingWriter() throws IOException {
        if (this.encodingWriter == null) {
            throw new IOException("No encoding has been set on this connection");
        }
        return this.encodingWriter;
    }

    public void SendChar(int n) throws IOException {
        this.pg_output.write((byte)n);
    }

    public void SendInteger4(int n) throws IOException {
        this.SendChar(n >> 24 & 0xFF);
        this.SendChar(n >> 16 & 0xFF);
        this.SendChar(n >> 8 & 0xFF);
        this.SendChar(n & 0xFF);
    }

    public void SendInteger2(int n) throws IOException {
        if (n < Short.MIN_VALUE || n > Short.MAX_VALUE) {
            throw new IOException("Tried to send an out-of-range integer as a 2-byte value: " + n);
        }
        this.SendChar(n >> 8 & 0xFF);
        this.SendChar(n & 0xFF);
    }

    public void Send(byte[] byArray) throws IOException {
        this.pg_output.write(byArray);
    }

    public void Send(byte[] byArray, int n) throws IOException {
        this.Send(byArray, 0, n);
    }

    public void Send(byte[] byArray, int n, int n2) throws IOException {
        this.pg_output.write(byArray, n, byArray.length - n < n2 ? byArray.length - n : n2);
        if (byArray.length - n < n2) {
            for (int i = byArray.length - n; i < n2; ++i) {
                this.pg_output.write(0);
            }
        }
    }

    public int ReceiveChar() throws IOException {
        int n = this.pg_input.read();
        if (n < 0) {
            throw new EOFException();
        }
        return n;
    }

    public int ReceiveIntegerR(int n) throws IOException {
        int n2 = 0;
        for (int i = 0; i < n; ++i) {
            int n3 = this.pg_input.read();
            if (n3 < 0) {
                throw new EOFException();
            }
            n2 = n3 | n2 << 8;
        }
        switch (n) {
            case 1: {
                return (byte)n2;
            }
            case 2: {
                return (short)n2;
            }
        }
        return n2;
    }

    public long ReceiveLong() throws IOException {
        long l = 0L;
        for (int i = 0; i < 8; ++i) {
            int n = this.pg_input.read();
            if (n < 0) {
                throw new EOFException();
            }
            l = (long)n | l << 8;
        }
        return l;
    }

    public String ReceiveString(int n) throws IOException {
        if (n > this.byte_buf.length) {
            this.byte_buf = new byte[n];
        }
        this.Receive(this.byte_buf, 0, n);
        return this.encoding.decode(this.byte_buf, 0, n);
    }

    public String ReceiveString() throws IOException {
        int n = 0;
        byte[] byArray = this.byte_buf;
        int n2 = byArray.length;
        while (true) {
            int n3;
            if ((n3 = this.pg_input.read()) < 0) {
                throw new EOFException();
            }
            if (n3 == 0) break;
            if (n == n2) {
                if ((n2 *= 2) <= 0) {
                    throw new IOException("Impossibly long string");
                }
                byte[] byArray2 = new byte[n2];
                System.arraycopy(byArray, 0, byArray2, 0, n);
                byArray = byArray2;
            }
            byArray[n++] = (byte)n3;
        }
        return this.encoding.decode(byArray, 0, n);
    }

    public byte[][] ReceiveTupleV3() throws IOException, OutOfMemoryError {
        int n = this.ReceiveIntegerR(4);
        int n2 = this.ReceiveIntegerR(2);
        byte[][] byArrayArray = new byte[n2][];
        OutOfMemoryError outOfMemoryError = null;
        for (int i = 0; i < n2; ++i) {
            int n3 = this.ReceiveIntegerR(4);
            if (n3 == -1) continue;
            try {
                byArrayArray[i] = new byte[n3];
                this.Receive(byArrayArray[i], 0, n3);
                continue;
            }
            catch (OutOfMemoryError outOfMemoryError2) {
                outOfMemoryError = outOfMemoryError2;
                this.Skip(n3);
            }
        }
        if (outOfMemoryError != null) {
            throw outOfMemoryError;
        }
        return byArrayArray;
    }

    public Buffer ReceiveTupleV4() throws IOException {
        int n = this.ReceiveIntegerR(4);
        int n2 = this.ReceiveIntegerR(2);
        byte[] byArray = new byte[n];
        ByteBuffer byteBuffer = ByteBuffer.wrap(byArray);
        byteBuffer.putInt(n);
        byteBuffer.putShort((short)n2);
        for (int i = 0; i < n2; ++i) {
            int n3 = this.ReceiveIntegerR(4);
            byteBuffer.putInt(n3);
            if (n3 == -1) continue;
            this.Receive(byArray, byteBuffer.position(), n3);
            byteBuffer.position(byteBuffer.position() + n3);
        }
        return byteBuffer;
    }

    public byte[][] ReceiveTupleV2(int n, boolean bl) throws IOException, OutOfMemoryError {
        int n2 = (n + 7) / 8;
        byte[] byArray = this.Receive(n2);
        byte[][] byArrayArray = new byte[n][];
        int n3 = 128;
        int n4 = 0;
        OutOfMemoryError outOfMemoryError = null;
        for (int i = 0; i < n; ++i) {
            boolean bl2;
            boolean bl3 = bl2 = (byArray[n4] & n3) == 0;
            if ((n3 >>= 1) == 0) {
                ++n4;
                n3 = 128;
            }
            if (bl2) continue;
            int n5 = this.ReceiveIntegerR(4);
            if (!bl) {
                n5 -= 4;
            }
            if (n5 < 0) {
                n5 = 0;
            }
            try {
                byArrayArray[i] = new byte[n5];
                this.Receive(byArrayArray[i], 0, n5);
                continue;
            }
            catch (OutOfMemoryError outOfMemoryError2) {
                outOfMemoryError = outOfMemoryError2;
                this.Skip(n5);
            }
        }
        if (outOfMemoryError != null) {
            throw outOfMemoryError;
        }
        return byArrayArray;
    }

    public byte[] Receive(int n) throws IOException {
        byte[] byArray = new byte[n];
        this.Receive(byArray, 0, n);
        return byArray;
    }

    public void Receive(byte[] byArray, int n, int n2) throws IOException {
        int n3;
        for (int i = 0; i < n2; i += n3) {
            n3 = this.pg_input.read(byArray, n + i, n2 - i);
            if (n3 >= 0) continue;
            throw new EOFException();
        }
    }

    public void Skip(int n) throws IOException {
        for (long i = 0L; i < (long)n; i += this.pg_input.skip((long)n - i)) {
        }
    }

    public void SendStream(InputStream inputStream, int n) throws IOException {
        int n2 = n;
        if (this.streamBuffer == null) {
            this.streamBuffer = new byte[8192];
        }
        while (n > 0) {
            int n3;
            int n4 = n > this.streamBuffer.length ? this.streamBuffer.length : n;
            try {
                n3 = inputStream.read(this.streamBuffer, 0, n4);
                if (n3 < 0) {
                    throw new EOFException(GT.tr("Premature end of input stream, expected {0} bytes, but only read {1}.", new Object[]{new Integer(n2), new Integer(n2 - n)}));
                }
            }
            catch (IOException iOException) {
                while (n > 0) {
                    this.Send(this.streamBuffer, n4);
                    n4 = (n -= n4) > this.streamBuffer.length ? this.streamBuffer.length : n;
                }
                throw new PGBindException(iOException);
            }
            this.Send(this.streamBuffer, n3);
            n -= n3;
        }
    }

    public void flush() throws IOException {
        if (this.encodingWriter != null) {
            this.encodingWriter.flush();
        }
        this.pg_output.flush();
    }

    public void ReceiveEOF() throws SQLException, IOException {
        int n = this.pg_input.read();
        if (n < 0) {
            return;
        }
    }

    public void close() throws IOException {
        if (this.encodingWriter != null) {
            this.encodingWriter.close();
        }
        this.pg_output.close();
        this.pg_input.close();
        this.connection.close();
    }
}

