/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.jboss;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLClassLoader;
import java.security.PrivilegedActionException;
import java.util.Properties;
import org.jboss.logging.Logger;
import org.teiid.jboss.ResourceActions;

public class Util {
    static Properties loadProperties(String propertiesName, Logger log) throws IOException {
        ClassLoader loader = ResourceActions.getContextClassLoader();
        URL url = null;
        if (loader instanceof URLClassLoader) {
            URLClassLoader ucl = (URLClassLoader)loader;
            url = ResourceActions.findResource(ucl, propertiesName);
            log.trace((Object)("findResource: " + url));
        }
        if (url == null) {
            url = loader.getResource(propertiesName);
        }
        if (url == null) {
            url = new URL(propertiesName);
        }
        log.trace((Object)("Properties file=" + url));
        Properties bundle = new Properties();
        InputStream is = null;
        try {
            is = ResourceActions.openStream(url);
        }
        catch (PrivilegedActionException e) {
            throw new IOException(e.getLocalizedMessage());
        }
        if (is == null) {
            throw new IOException("Properties file " + propertiesName + " not available");
        }
        bundle.load(is);
        is.close();
        log.debug((Object)("Loaded properties, users=" + bundle.keySet()));
        return bundle;
    }
}

