/*
 * Decompiled with CFR 0.152.
 */
package jscover.util;

import java.io.File;
import java.io.FileOutputStream;
import java.io.PrintStream;

public class Logger {
    private static Logger instance = new Logger();
    private static File log;
    private boolean loggedException;

    public static Logger getInstance() {
        return instance;
    }

    public static void setLogFile(File file) {
        if (file.exists()) {
            file.delete();
        }
        log = file;
    }

    public boolean isLoggedException() {
        return this.loggedException;
    }

    public void log(String message) {
        this.log(message, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void log(String message, RuntimeException t) {
        if (log == null) {
            if (t == null) {
                System.err.println(message);
                return;
            }
            throw t;
        }
        File file = log;
        synchronized (file) {
            try {
                PrintStream ps = new PrintStream(new FileOutputStream(log, true));
                ps.println("-------------------------------------------------------------------------------");
                ps.println(message);
                if (t != null) {
                    this.loggedException = true;
                    t.printStackTrace(ps);
                }
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
    }
}

