/*
 * Decompiled with CFR 0.152.
 */
package jscover.util;

import java.io.File;
import java.util.HashSet;
import java.util.Set;
import jscover.server.ConfigurationForServer;
import jscover.util.IoUtils;

public class FileScanner {
    private ConfigurationForServer configuration;
    private IoUtils ioUtils = IoUtils.getInstance();

    public FileScanner(ConfigurationForServer configuration) {
        this.configuration = configuration;
    }

    public Set<File> getFiles(Set<String> urisAlreadyProcessed) {
        HashSet<File> files = new HashSet<File>();
        this.searchFolder(this.configuration.getDocumentRoot(), files, urisAlreadyProcessed);
        return files;
    }

    private void searchFolder(File src, Set<File> list, Set<String> urisAlreadyProcessed) {
        if (src.isDirectory()) {
            String[] files;
            for (String file : files = src.list()) {
                File srcFile = new File(src, file);
                String path = this.ioUtils.getRelativePath(srcFile, this.configuration.getDocumentRoot());
                if (this.configuration.skipInstrumentation(path)) continue;
                this.searchFolder(srcFile, list, urisAlreadyProcessed);
            }
        } else {
            String path = this.ioUtils.getRelativePath(src, this.configuration.getDocumentRoot());
            if (src.getName().endsWith(".js") && !urisAlreadyProcessed.contains(path)) {
                list.add(src);
            }
        }
    }
}

