/*
 * Decompiled with CFR 0.152.
 */
package jscover.format;

import java.util.ArrayList;
import java.util.List;
import jscover.format.SourceFormatter;
import jscover.util.IoUtils;

public class PlainFormatter
implements SourceFormatter {
    private static PlainFormatter plainFormatter;
    private IoUtils ioUtils = IoUtils.getInstance();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static PlainFormatter getInstance() {
        Class<PlainFormatter> clazz = PlainFormatter.class;
        synchronized (PlainFormatter.class) {
            if (plainFormatter == null) {
                plainFormatter = new PlainFormatter();
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return plainFormatter;
        }
    }

    @Override
    public String toJsArrayOfHtml(String source) {
        StringBuilder sb = new StringBuilder();
        for (String line : this.ioUtils.readLines(source)) {
            if (sb.length() > 0) {
                sb.append(",");
            }
            sb.append("\"");
            sb.append(this.escapeHtml(line));
            sb.append("\"");
        }
        return sb.toString();
    }

    @Override
    public List<String> toHtmlLines(String source) {
        ArrayList<String> lines = new ArrayList<String>();
        for (String line : this.ioUtils.readLines(source)) {
            lines.add(this.escapeHtml(line));
        }
        return lines;
    }

    @Override
    public String escapeHtml(String string) {
        StringBuilder result = new StringBuilder();
        block8: for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            switch (c) {
                case '&': {
                    result.append("&amp;");
                    continue block8;
                }
                case '<': {
                    result.append("&lt;");
                    continue block8;
                }
                case '>': {
                    result.append("&gt;");
                    continue block8;
                }
                case '\"': {
                    result.append("\\\"");
                    continue block8;
                }
                case '\\': {
                    result.append("\\\\");
                    continue block8;
                }
                case '\t': {
                    result.append("\\t");
                    continue block8;
                }
                default: {
                    if (' ' <= c && c <= '~') {
                        result.append(c);
                        continue block8;
                    }
                    result.append(String.format("&#%d;", c));
                }
            }
        }
        return result.toString();
    }
}

