/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugin.dependency;

import java.io.File;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.maven.artifact.factory.ArtifactFactory;
import org.apache.maven.artifact.metadata.ArtifactMetadataSource;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.artifact.resolver.ArtifactCollector;
import org.apache.maven.artifact.resolver.filter.ArtifactFilter;
import org.apache.maven.artifact.resolver.filter.ScopeArtifactFilter;
import org.apache.maven.artifact.versioning.ArtifactVersion;
import org.apache.maven.artifact.versioning.InvalidVersionSpecificationException;
import org.apache.maven.artifact.versioning.Restriction;
import org.apache.maven.artifact.versioning.VersionRange;
import org.apache.maven.execution.RuntimeInformation;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugin.dependency.treeSerializers.DOTDependencyNodeVisitor;
import org.apache.maven.plugin.dependency.treeSerializers.GraphmlDependencyNodeVisitor;
import org.apache.maven.plugin.dependency.treeSerializers.TGFDependencyNodeVisitor;
import org.apache.maven.plugin.dependency.utils.DependencyUtil;
import org.apache.maven.project.MavenProject;
import org.apache.maven.shared.artifact.filter.StrictPatternExcludesArtifactFilter;
import org.apache.maven.shared.artifact.filter.StrictPatternIncludesArtifactFilter;
import org.apache.maven.shared.dependency.tree.DependencyNode;
import org.apache.maven.shared.dependency.tree.DependencyTreeBuilder;
import org.apache.maven.shared.dependency.tree.DependencyTreeBuilderException;
import org.apache.maven.shared.dependency.tree.filter.AncestorOrSelfDependencyNodeFilter;
import org.apache.maven.shared.dependency.tree.filter.AndDependencyNodeFilter;
import org.apache.maven.shared.dependency.tree.filter.ArtifactDependencyNodeFilter;
import org.apache.maven.shared.dependency.tree.filter.DependencyNodeFilter;
import org.apache.maven.shared.dependency.tree.filter.StateDependencyNodeFilter;
import org.apache.maven.shared.dependency.tree.traversal.BuildingDependencyNodeVisitor;
import org.apache.maven.shared.dependency.tree.traversal.CollectingDependencyNodeVisitor;
import org.apache.maven.shared.dependency.tree.traversal.DependencyNodeVisitor;
import org.apache.maven.shared.dependency.tree.traversal.FilteringDependencyNodeVisitor;
import org.apache.maven.shared.dependency.tree.traversal.SerializingDependencyNodeVisitor;

public class TreeMojo
extends AbstractMojo {
    private MavenProject project;
    private ArtifactRepository localRepository;
    private ArtifactFactory artifactFactory;
    private ArtifactMetadataSource artifactMetadataSource;
    private ArtifactCollector artifactCollector;
    private DependencyTreeBuilder dependencyTreeBuilder;
    private File output;
    private File outputFile;
    private String outputType;
    private String scope;
    private boolean verbose;
    private String tokens;
    private String includes;
    private String excludes;
    private RuntimeInformation rti;
    private DependencyNode rootNode;
    private boolean appendOutput;

    public void execute() throws MojoExecutionException, MojoFailureException {
        ArtifactVersion detectedMavenVersion = this.rti.getApplicationVersion();
        try {
            VersionRange vr = VersionRange.createFromVersionSpec((String)"[2.0.8,)");
            if (!TreeMojo.containsVersion(vr, detectedMavenVersion)) {
                this.getLog().warn((CharSequence)"The tree mojo requires at least Maven 2.0.8 to function properly. You may get erroneous results on earlier versions");
            }
        }
        catch (InvalidVersionSpecificationException e) {
            throw new MojoExecutionException(e.getLocalizedMessage(), (Exception)((Object)e));
        }
        if (this.output != null) {
            this.getLog().warn((CharSequence)"The parameter output is deprecated. Use outputFile instead.");
            this.outputFile = this.output;
        }
        ArtifactFilter artifactFilter = this.createResolvingArtifactFilter();
        try {
            this.rootNode = this.dependencyTreeBuilder.buildDependencyTree(this.project, this.localRepository, this.artifactFactory, this.artifactMetadataSource, artifactFilter, this.artifactCollector);
            String dependencyTreeString = this.serializeDependencyTree(this.rootNode);
            if (this.outputFile != null) {
                DependencyUtil.write(dependencyTreeString, this.outputFile, this.appendOutput, this.getLog());
                this.getLog().info((CharSequence)("Wrote dependency tree to: " + this.outputFile));
            } else {
                DependencyUtil.log(dependencyTreeString, this.getLog());
            }
        }
        catch (DependencyTreeBuilderException exception) {
            throw new MojoExecutionException("Cannot build project dependency tree", (Exception)((Object)exception));
        }
        catch (IOException exception) {
            throw new MojoExecutionException("Cannot serialise project dependency tree", (Exception)exception);
        }
    }

    public MavenProject getProject() {
        return this.project;
    }

    public DependencyNode getDependencyTree() {
        return this.rootNode;
    }

    private ArtifactFilter createResolvingArtifactFilter() {
        ScopeArtifactFilter filter;
        if (this.scope != null) {
            this.getLog().debug((CharSequence)("+ Resolving dependency tree for scope '" + this.scope + "'"));
            filter = new ScopeArtifactFilter(this.scope);
        } else {
            filter = null;
        }
        return filter;
    }

    private String serializeDependencyTree(DependencyNode rootNode) {
        StringWriter writer = new StringWriter();
        DependencyNodeVisitor visitor = this.getSerializingDependencyNodeVisitor(writer);
        visitor = new BuildingDependencyNodeVisitor(visitor);
        DependencyNodeFilter filter = this.createDependencyNodeFilter();
        if (filter != null) {
            CollectingDependencyNodeVisitor collectingVisitor = new CollectingDependencyNodeVisitor();
            FilteringDependencyNodeVisitor firstPassVisitor = new FilteringDependencyNodeVisitor((DependencyNodeVisitor)collectingVisitor, filter);
            rootNode.accept((DependencyNodeVisitor)firstPassVisitor);
            AncestorOrSelfDependencyNodeFilter secondPassFilter = new AncestorOrSelfDependencyNodeFilter(collectingVisitor.getNodes());
            visitor = new FilteringDependencyNodeVisitor(visitor, (DependencyNodeFilter)secondPassFilter);
        }
        rootNode.accept(visitor);
        return writer.toString();
    }

    public DependencyNodeVisitor getSerializingDependencyNodeVisitor(Writer writer) {
        if ("graphml".equals(this.outputType)) {
            return new GraphmlDependencyNodeVisitor(writer);
        }
        if ("tgf".equals(this.outputType)) {
            return new TGFDependencyNodeVisitor(writer);
        }
        if ("dot".equals(this.outputType)) {
            return new DOTDependencyNodeVisitor(writer);
        }
        return new SerializingDependencyNodeVisitor(writer, this.toTreeTokens(this.tokens));
    }

    private SerializingDependencyNodeVisitor.TreeTokens toTreeTokens(String tokens) {
        SerializingDependencyNodeVisitor.TreeTokens treeTokens;
        if ("whitespace".equals(tokens)) {
            this.getLog().debug((CharSequence)"+ Using whitespace tree tokens");
            treeTokens = SerializingDependencyNodeVisitor.WHITESPACE_TOKENS;
        } else if ("extended".equals(tokens)) {
            this.getLog().debug((CharSequence)"+ Using extended tree tokens");
            treeTokens = SerializingDependencyNodeVisitor.EXTENDED_TOKENS;
        } else {
            treeTokens = SerializingDependencyNodeVisitor.STANDARD_TOKENS;
        }
        return treeTokens;
    }

    private DependencyNodeFilter createDependencyNodeFilter() {
        StrictPatternIncludesArtifactFilter artifactFilter;
        List<String> patterns;
        ArrayList<Object> filters = new ArrayList<Object>();
        if (!this.verbose) {
            this.getLog().debug((CharSequence)"+ Filtering omitted nodes from dependency tree");
            filters.add(StateDependencyNodeFilter.INCLUDED);
        }
        if (this.includes != null) {
            patterns = Arrays.asList(this.includes.split(","));
            this.getLog().debug((CharSequence)("+ Filtering dependency tree by artifact include patterns: " + patterns));
            artifactFilter = new StrictPatternIncludesArtifactFilter(patterns);
            filters.add(new ArtifactDependencyNodeFilter((ArtifactFilter)artifactFilter));
        }
        if (this.excludes != null) {
            patterns = Arrays.asList(this.excludes.split(","));
            this.getLog().debug((CharSequence)("+ Filtering dependency tree by artifact exclude patterns: " + patterns));
            artifactFilter = new StrictPatternExcludesArtifactFilter(patterns);
            filters.add(new ArtifactDependencyNodeFilter((ArtifactFilter)artifactFilter));
        }
        return filters.isEmpty() ? null : new AndDependencyNodeFilter(filters);
    }

    public static boolean containsVersion(VersionRange allowedRange, ArtifactVersion theVersion) {
        ArtifactVersion recommendedVersion = allowedRange.getRecommendedVersion();
        if (recommendedVersion == null) {
            List restrictions = allowedRange.getRestrictions();
            for (Restriction restriction : restrictions) {
                if (!restriction.containsVersion(theVersion)) continue;
                return true;
            }
        }
        return recommendedVersion.compareTo((Object)theVersion) <= 0;
    }
}

