/*
 * Decompiled with CFR 0.152.
 */
package jmxlogger.integration.log4j;

import java.io.File;
import java.lang.management.ManagementFactory;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import jmxlogger.tools.JmxConfigStore;
import jmxlogger.tools.JmxLogService;
import jmxlogger.tools.ToolBox;
import org.apache.log4j.AppenderSkeleton;
import org.apache.log4j.Layout;
import org.apache.log4j.Level;
import org.apache.log4j.PatternLayout;
import org.apache.log4j.Priority;
import org.apache.log4j.spi.LoggingEvent;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JmxLogAppender
extends AppenderSkeleton {
    private JmxLogService jmxLogService;
    private JmxConfigStore configStore;
    private Layout logLayout = new PatternLayout("%-4r [%t] %-5p %c %x - %m%n");

    public JmxLogAppender() {
        this.initializeLogger();
    }

    public JmxLogAppender(ObjectName name) {
        this.initializeLogger();
        this.setObjectNameValue(name);
    }

    public JmxLogAppender(MBeanServer server) {
        this.initializeLogger();
        this.setMBeanServerValue(server);
    }

    public JmxLogAppender(MBeanServer server, ObjectName name) {
        this.initializeLogger();
        this.setMBeanServerValue(server);
        this.setObjectNameValue(name);
    }

    public void setThreshold(Priority level) {
        super.setThreshold(level);
        this.configStore.putValue("level", (Object)level.toString());
        this.configStore.postEvent(new JmxConfigStore.ConfigEvent((Object)this, "level", (Object)level.toString()));
    }

    public void setObjectName(String objName) {
        this.setObjectNameValue(this.createObjectNameInstance(objName));
    }

    public String getObjectName(String objName) {
        ObjectName name = (ObjectName)this.configStore.getValue("jmxObjectName");
        return name != null ? name.toString() : null;
    }

    public void setObjectNameValue(ObjectName name) {
        this.configStore.putValue("jmxObjectName", (Object)name);
    }

    public ObjectName getObjectNameValue() {
        return (ObjectName)this.configStore.getValue("jmxObjectName");
    }

    public void setMBeanServer(String domain) {
        this.setMBeanServerValue(this.createServerInstance(domain));
    }

    public String getMBeanServer() {
        MBeanServer svr = (MBeanServer)this.configStore.getValue("jmxServer");
        return svr != null ? svr.toString() : null;
    }

    public void setMBeanServerValue(MBeanServer server) {
        this.configStore.putValue("jmxServer", (Object)server);
    }

    public MBeanServer getMBeanServerValue() {
        return (MBeanServer)this.configStore.getValue("jmxServer");
    }

    public void setFilterExpression(String exp) {
        this.configStore.putValue("filterExpression", (Object)exp);
        this.configStore.postEvent(new JmxConfigStore.ConfigEvent((Object)this, "filterExpression", (Object)exp));
    }

    public String getFilterExpression() {
        return (String)this.configStore.getValue("filterExpression");
    }

    public void setFilterScriptFile(String fileName) {
        File f = new File(fileName);
        if (ToolBox.isFileValid((File)f)) {
            this.configStore.putValue("filterScript", (Object)f);
            this.configStore.postEvent(new JmxConfigStore.ConfigEvent((Object)this, "filterScript", (Object)f));
        }
    }

    public String getFilterScriptFile() {
        File file = (File)this.configStore.getValue("filterScript");
        return file != null ? file.getAbsolutePath() : null;
    }

    public String getServerAddress() {
        return (String)this.configStore.getValue("serverAddress");
    }

    public void setServerAddress(String addr) {
        this.configStore.putValue("serverAddress", (Object)addr);
    }

    public void activateOptions() {
        this.configure();
        if (!this.jmxLogService.isStarted()) {
            this.jmxLogService.start();
        }
    }

    protected void append(LoggingEvent log4jEvent) {
        if (!this.isConfiguredOk()) {
            this.errorHandler.error("Unable to log message, check configuration.");
            return;
        }
        if (!this.isLoggable(log4jEvent)) {
            return;
        }
        try {
            String msg = this.layout.format(log4jEvent);
            Map<String, Object> event = this.prepareLogEvent(msg, log4jEvent);
            this.jmxLogService.log(event);
        }
        catch (Exception ex) {
            this.errorHandler.error("Unable to send log to JMX.", ex, 0);
        }
    }

    public synchronized void close() {
        this.jmxLogService.stop();
        this.closed = true;
    }

    public boolean requiresLayout() {
        return true;
    }

    private boolean isConfiguredOk() {
        return this.jmxLogService != null && this.jmxLogService.isStarted() && this.configStore.getValue("jmxServer") != null && this.configStore.getValue("jmxObjectName") != null && this.layout != null && this.getThreshold() != null;
    }

    private boolean isLoggable(LoggingEvent event) {
        return event.getLevel().isGreaterOrEqual(this.getThreshold());
    }

    private void initializeLogger() {
        this.jmxLogService = this.jmxLogService == null ? JmxLogService.createInstance() : this.jmxLogService;
        this.configStore = this.jmxLogService.getDefaultConfigurationStore();
        this.configStore.addListener(new JmxConfigStore.ConfigEventListener(){

            public void onValueChanged(JmxConfigStore.ConfigEvent event) {
                if (event.getKey().equals("level") && event.getSource() != JmxLogAppender.this) {
                    JmxLogAppender.this.setInternalThreshold((String)event.getValue());
                }
            }
        });
    }

    private void setInternalThreshold(String t) {
        super.setThreshold((Priority)Level.toLevel((String)t));
    }

    private void configure() {
        if (this.getLayout() == null) {
            this.setLayout(this.logLayout);
        }
        if (this.getThreshold() == null) {
            this.setThreshold((Priority)Level.DEBUG);
        }
        if (this.configStore.getValue("jmxServer") == null) {
            this.setMBeanServerValue(this.createServerInstance("platform"));
        }
        if (this.configStore.getValue("jmxObjectName") == null) {
            this.setObjectNameValue(ToolBox.buildDefaultObjectName((String)Integer.toString(((Object)((Object)this)).hashCode())));
        }
    }

    private Map<String, Object> prepareLogEvent(String fmtMsg, LoggingEvent record) {
        HashMap<String, Object> event = new HashMap<String, Object>();
        long ts = new Date().getTime();
        event.put("source", ((Object)((Object)this)).getClass().getName());
        event.put("logLevel", record.getLevel().toString());
        event.put("loggerName", record.getLoggerName());
        event.put("formattedMessage", fmtMsg);
        event.put("rawMessage", record.getMessage());
        event.put("sequenceNumber", new Long(ts));
        event.put("threadId", record.getThreadName());
        event.put("exceptionName", record.getThrowableInformation() != null ? record.getThrowableInformation().getThrowable() : null);
        event.put("timestamp", new Long(ts));
        return event;
    }

    private ObjectName createObjectNameInstance(String name) {
        ObjectName objName = null;
        objName = name == null ? ToolBox.buildDefaultObjectName((String)Integer.toString(((Object)((Object)this)).hashCode())) : ToolBox.buildObjectName((String)name);
        return objName;
    }

    private MBeanServer createServerInstance(String domain) {
        MBeanServer svr = ManagementFactory.getPlatformMBeanServer();
        if (domain != null && !domain.equalsIgnoreCase("platform")) {
            svr = ToolBox.findMBeanServer((String)domain);
        }
        return svr;
    }
}

