/*
 * Decompiled with CFR 0.152.
 */
package com.tonbeller.wcf.log;

import com.tonbeller.tbutils.res.Resources;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.TreeMap;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;
import org.apache.log4j.PropertyConfigurator;

public class LogHandler {
    private static Logger logger = Logger.getLogger(LogHandler.class);
    public static final String DEFAULT = "default";
    public static final String NOLOG = "nolog";
    public static final String DEBUG_FILE = "debug-file";
    public static final String DEBUG_STDOUT = "debug-stdout";
    public static final String ERROR_FILE = "error-file";
    public static final String ERROR_STDOUT = "error-stdout";
    private Map configs = new TreeMap();
    private Map labels = new TreeMap();
    private String context;
    private File logFile;
    private File logDir;

    public LogHandler(String logDirName, Locale locale, String context) throws IOException {
        this.context = context;
        this.logDir = this.initLogDir(logDirName);
        this.logFile = new File(this.logDir, context + ".log");
        this.createDefConfigs();
        this.addConfigs();
    }

    private void createDefConfigs() throws IOException {
        this.createDefConfig(DEBUG_FILE);
        this.createDefConfig(DEBUG_STDOUT);
        this.createDefConfig(ERROR_FILE);
        this.createDefConfig(ERROR_STDOUT);
        this.createDefConfig(NOLOG);
    }

    private void createDefConfig(String name) throws IOException {
        String resName = "/com/tonbeller/wcf/log/" + name + ".properties";
        File file = new File(this.logDir, name + ".properties");
        if (!file.exists()) {
            this.copyRes(resName, file);
        }
    }

    private void addConfigs() {
        File[] files = this.logDir.listFiles(new FilenameFilter(){

            public boolean accept(File f, String name) {
                return name.endsWith(".properties");
            }
        });
        for (int i = 0; i < files.length; ++i) {
            String fname = files[i].getName();
            String name = fname.substring(0, fname.lastIndexOf(".properties"));
            this.configs.put(name, files[i]);
        }
    }

    public void addConfig(String resourceName, String label) throws IOException {
        File file;
        String name = resourceName;
        int pos = name.lastIndexOf(47);
        if (pos >= 0) {
            name = name.substring(pos + 1);
        }
        if (!(file = new File(this.logDir, name + ".properties")).exists()) {
            this.copyRes(resourceName + ".properties", file);
        }
        this.configs.put(name, file);
        this.labels.put(name, label);
    }

    private File initLogDir(String dir) {
        File baseDir = Resources.instance().getHomeDir();
        File dirObj = this.logDir(dir, baseDir);
        if (dirObj == null) {
            dirObj = this.logDir(dir, new File("java.io.tmpdir"));
        }
        if (dirObj == null) {
            throw new IllegalArgumentException("Not available: " + dirObj);
        }
        return dirObj;
    }

    private File logDir(String dir, File baseDir) {
        File dirObj = new File(dir);
        if (!dirObj.isAbsolute()) {
            dirObj = new File(baseDir, dir);
        }
        if (dirObj.exists()) {
            if (!dirObj.isDirectory()) {
                return null;
            }
            return dirObj;
        }
        if (dirObj.mkdirs()) {
            return dirObj;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void copyRes(String resName, File file) throws IOException {
        InputStream is = null;
        try {
            is = this.getClass().getResourceAsStream(resName);
            if (is == null) {
                throw new IllegalArgumentException("Resource " + resName + " not found");
            }
            FileOutputStream os = null;
            try {
                int len;
                os = new FileOutputStream(file);
                byte[] buf = new byte[1024];
                while ((len = is.read(buf)) > 0) {
                    os.write(buf, 0, len);
                }
            }
            finally {
                if (os != null) {
                    os.close();
                }
            }
        }
        finally {
            if (is != null) {
                is.close();
            }
        }
    }

    public String[] getConfigNames() {
        String[] names = new String[this.configs.keySet().size() + 1];
        names[0] = DEFAULT;
        Iterator it = this.configs.keySet().iterator();
        int idx = 1;
        while (it.hasNext()) {
            names[idx++] = (String)it.next();
        }
        return names;
    }

    public String getLabel(String configName) {
        return (String)this.labels.get(configName);
    }

    public void applyConfig(String name) throws IOException {
        Properties logProps = DEFAULT.equals(name) ? this.loadDefaultConfig() : this.loadConfig(name);
        LogManager.resetConfiguration();
        PropertyConfigurator.configure((Properties)logProps);
        System.out.println("--- Applied new logging configuration ---");
        logger.error((Object)"Test error message");
        logger.debug((Object)"Test debug message");
    }

    private Properties loadDefaultConfig() throws IOException {
        return this.loadProperties(this.getClass().getResource("/log4j.properties"));
    }

    private Properties loadConfig(String name) throws IOException {
        File file = (File)this.configs.get(name);
        if (file == null) {
            throw new IllegalArgumentException("Log configuration " + name + " not found");
        }
        Properties logProps = this.loadProperties(file);
        if (logProps.get("context") == null) {
            logProps.put("context", this.context);
        }
        if (logProps.get("logfile") == null) {
            logProps.put("logfile", this.logFile.getAbsolutePath());
        }
        return logProps;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Properties loadProperties(File file) throws IOException {
        Properties props = new Properties();
        FileInputStream in = null;
        try {
            in = new FileInputStream(file);
            props.load(in);
            Properties properties = props;
            return properties;
        }
        finally {
            if (in != null) {
                in.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Properties loadProperties(URL url) throws IOException {
        Properties props = new Properties();
        InputStream in = null;
        try {
            in = url.openStream();
            props.load(in);
            Properties properties = props;
            return properties;
        }
        finally {
            if (in != null) {
                in.close();
            }
        }
    }

    public String version() {
        Package p = LogManager.class.getPackage();
        StringBuffer version = new StringBuffer();
        version.append(p.getImplementationVendor());
        version.append(' ');
        version.append(p.getImplementationTitle());
        version.append(' ');
        version.append(p.getImplementationVersion());
        return version.toString();
    }

    public File getLogFile() {
        return this.logFile;
    }

    public void setLogFile(File logFile) {
        this.logFile = logFile;
    }

    public static String getDefault() {
        return DEFAULT;
    }

    public String getRootLoggerLevel() {
        Logger logger = Logger.getRootLogger();
        if (logger.getLevel() != null) {
            return logger.getLevel().toString();
        }
        return "";
    }
}

