/*
 * Decompiled with CFR 0.152.
 */
package com.tonbeller.wcf.controller;

import com.tonbeller.tbutils.res.Resources;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.Vector;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;
import org.apache.commons.fileupload.DiskFileUpload;
import org.apache.commons.fileupload.FileItem;
import org.apache.commons.fileupload.FileUpload;
import org.apache.commons.fileupload.FileUploadException;
import org.apache.log4j.Logger;

public class MultiPartEnabledRequest
extends HttpServletRequestWrapper {
    private static Logger logger = Logger.getLogger(MultiPartEnabledRequest.class);
    private static Resources res = Resources.instance(MultiPartEnabledRequest.class);
    private boolean multipart;
    private Map fileItems = new HashMap();
    private Map httpParams = new HashMap();

    public MultiPartEnabledRequest(HttpServletRequest req) {
        super(req);
        this.multipart = FileUpload.isMultipartContent((HttpServletRequest)req);
        if (this.multipart) {
            try {
                this.readHttpParams(req);
            }
            catch (FileUploadException e) {
                logger.error((Object)"", (Throwable)e);
                e.printStackTrace();
            }
        }
    }

    private void readHttpParams(HttpServletRequest req) throws FileUploadException {
        List valList;
        List all = this.uploadFiles(req);
        for (FileItem item : all) {
            if (item.isFormField()) {
                valList = this.valueList(this.httpParams, item.getFieldName());
                if (req.getCharacterEncoding() != null) {
                    try {
                        valList.add(item.getString(req.getCharacterEncoding()));
                    }
                    catch (UnsupportedEncodingException e) {
                        logger.error(null, (Throwable)e);
                        valList.add(item.getString());
                    }
                    continue;
                }
                valList.add(item.getString());
                continue;
            }
            valList = this.valueList(this.fileItems, item.getFieldName());
            valList.add(item);
        }
        for (String name : this.httpParams.keySet()) {
            valList = (List)this.httpParams.get(name);
            this.httpParams.put(name, this.toStringArray(valList));
        }
        for (String name : this.fileItems.keySet()) {
            valList = (List)this.fileItems.get(name);
            this.fileItems.put(name, this.toFileItemArray(valList));
        }
    }

    private List valueList(Map params, String name) {
        ArrayList valList = (ArrayList)params.get(name);
        if (valList == null) {
            valList = new ArrayList();
            params.put(name, valList);
        }
        return valList;
    }

    private String[] toStringArray(List valList) {
        String[] vals = new String[valList.size()];
        for (int i = 0; i < vals.length; ++i) {
            vals[i] = (String)valList.get(i);
        }
        return vals;
    }

    private FileItem[] toFileItemArray(List valList) {
        FileItem[] vals = new FileItem[valList.size()];
        for (int i = 0; i < vals.length; ++i) {
            vals[i] = (FileItem)valList.get(i);
        }
        return vals;
    }

    private List uploadFiles(HttpServletRequest req) throws FileUploadException {
        DiskFileUpload upload = new DiskFileUpload();
        try {
            upload.setSizeThreshold(res.getInteger("file.upload.size.threshold"));
        }
        catch (MissingResourceException e) {
            // empty catch block
        }
        try {
            upload.setSizeMax((long)res.getInteger("file.upload.size.max"));
        }
        catch (MissingResourceException e) {
            // empty catch block
        }
        try {
            upload.setRepositoryPath(res.getString("file.upload.repository"));
        }
        catch (MissingResourceException e) {
            // empty catch block
        }
        List all = new DiskFileUpload().parseRequest(req);
        return all;
    }

    public boolean isMultipart() {
        return this.multipart;
    }

    public String getParameter(String name) {
        if (!this.isMultipart()) {
            return super.getParameter(name);
        }
        String[] vals = (String[])this.httpParams.get(name);
        if (vals == null) {
            return null;
        }
        return vals[0];
    }

    public FileItem getFileParameter(String name) {
        FileItem[] vals = (FileItem[])this.fileItems.get(name);
        if (vals == null) {
            return null;
        }
        return vals[0];
    }

    public Map getParameterMap() {
        if (!this.isMultipart()) {
            return super.getParameterMap();
        }
        return new HashMap(this.httpParams);
    }

    public Map getFileParameterMap() {
        return new HashMap(this.fileItems);
    }

    public Enumeration getParameterNames() {
        if (!this.isMultipart()) {
            return super.getParameterNames();
        }
        return new Vector(this.httpParams.keySet()).elements();
    }

    public Enumeration getFileParameterNames() {
        return new Vector(this.fileItems.keySet()).elements();
    }

    public String[] getParameterValues(String name) {
        if (!this.isMultipart()) {
            return super.getParameterValues(name);
        }
        return (String[])this.httpParams.get(name);
    }

    public FileItem[] getFileParameterValues(String name) {
        return (FileItem[])this.fileItems.get(name);
    }
}

