/*
 * Decompiled with CFR 0.152.
 */
package com.tonbeller.tbutils.res;

import com.tonbeller.tbutils.res.Dumper;
import com.tonbeller.tbutils.res.PersistentResourceProvider;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Collection;
import java.util.Properties;
import org.apache.log4j.Logger;

class FilePersistentResourceProvider
implements PersistentResourceProvider {
    Properties props;
    File file;
    private static Logger logger = Logger.getLogger(FilePersistentResourceProvider.class);

    public FilePersistentResourceProvider(File file) {
        this.file = file;
        this.load();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void load() {
        this.props = new Properties();
        InputStream is = null;
        try {
            if (!this.file.exists()) {
                return;
            }
            is = new FileInputStream(this.file);
            this.props.load(is);
        }
        catch (IOException e) {
            logger.error(null, (Throwable)e);
        }
        finally {
            if (is != null) {
                try {
                    is.close();
                }
                catch (IOException e) {
                    logger.error(null, (Throwable)e);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void store() {
        FileOutputStream os = null;
        try {
            os = new FileOutputStream(this.file);
            this.props.store(os, "## TONBELLER");
        }
        catch (IOException e) {
            logger.error(null, (Throwable)e);
        }
        finally {
            if (os != null) {
                try {
                    ((OutputStream)os).close();
                }
                catch (IOException e1) {
                    logger.error(null, (Throwable)e1);
                }
            }
        }
    }

    public String getString(String key) {
        return this.props.getProperty(key);
    }

    public void store(String key, String value) {
        this.props.setProperty(key, value);
    }

    public void remove(String key) {
        this.props.remove(key);
    }

    public Collection keySet() {
        return this.props.keySet();
    }

    public void flush() {
        this.store();
    }

    public void close() {
        this.store();
    }

    public void dump(Dumper d) {
        d.dump(this);
    }

    public String getName() {
        return "FileResouceProvider " + this.file;
    }
}

