/*
 * Decompiled with CFR 0.152.
 */
package com.tonbeller.jpivot.mondrian;

import com.tonbeller.jpivot.mondrian.MondrianMember;
import com.tonbeller.jpivot.mondrian.MondrianModel;
import com.tonbeller.jpivot.mondrian.MondrianQueryAdapter;
import com.tonbeller.jpivot.olap.navi.SortRank;
import com.tonbeller.jpivot.olap.query.QuaxChangeListener;
import com.tonbeller.jpivot.olap.query.SortRankBase;
import mondrian.mdx.MemberExpr;
import mondrian.mdx.UnresolvedFunCall;
import mondrian.olap.Exp;
import mondrian.olap.Literal;
import mondrian.olap.Query;
import mondrian.olap.QueryAxis;
import mondrian.olap.Syntax;
import org.apache.log4j.Logger;

public class MondrianSortRank
extends SortRankBase
implements SortRank,
QuaxChangeListener {
    static Logger logger = Logger.getLogger(MondrianSortRank.class);

    public MondrianSortRank() {
        super.setId("sortRank");
    }

    public void addSortToQuery() {
        if (this.sorting && this.sortPosMembers != null) {
            MondrianModel model = (MondrianModel)this.getModel();
            Query monQuery = ((MondrianQueryAdapter)model.getQueryAdapter()).getMonQuery();
            switch (this.sortMode) {
                case 1: 
                case 2: 
                case 3: 
                case 4: {
                    this.orderAxis(monQuery, this.sortMode);
                    break;
                }
                case 5: {
                    this.topBottomAxis(monQuery, "TopCount");
                    break;
                }
                case 6: {
                    this.topBottomAxis(monQuery, "BottomCount");
                    break;
                }
                default: {
                    return;
                }
            }
        }
    }

    private static String sortModeName(int sortMode) {
        switch (sortMode) {
            case 1: {
                return "ASC";
            }
            case 2: {
                return "DESC";
            }
            case 3: {
                return "BASC";
            }
            case 4: {
                return "BDESC";
            }
        }
        return null;
    }

    private void orderAxis(Query monQuery, int sortMode) {
        MemberExpr memToSort;
        QueryAxis monAx = monQuery.getAxes()[this.quaxToSort.getOrdinal()];
        Exp setForAx = monAx.getSet();
        if (this.sortPosMembers.length == 1) {
            memToSort = new MemberExpr(((MondrianMember)this.sortPosMembers[0]).getMonMember());
        } else {
            MemberExpr[] memberExprs = new MemberExpr[this.sortPosMembers.length];
            for (int i = 0; i < memberExprs.length; ++i) {
                memberExprs[i] = new MemberExpr(((MondrianMember)this.sortPosMembers[i]).getMonMember());
            }
            memToSort = new UnresolvedFunCall("()", Syntax.Parentheses, (Exp[])memberExprs);
        }
        String sDirection = MondrianSortRank.sortModeName(sortMode);
        UnresolvedFunCall funOrder = new UnresolvedFunCall("Order", new Exp[]{setForAx, memToSort, Literal.createSymbol((String)sDirection)});
        monAx.setSet((Exp)funOrder);
    }

    private void topBottomAxis(Query monQuery, String function) {
        MemberExpr memToSort;
        QueryAxis monAx = monQuery.getAxes()[this.quaxToSort.getOrdinal()];
        Exp setForAx = monAx.getSet();
        if (this.sortPosMembers.length > 1) {
            MemberExpr[] memberExprs = new MemberExpr[this.sortPosMembers.length];
            for (int i = 0; i < memberExprs.length; ++i) {
                memberExprs[i] = new MemberExpr(((MondrianMember)this.sortPosMembers[i]).getMonMember());
            }
            memToSort = new UnresolvedFunCall("()", Syntax.Parentheses, (Exp[])memberExprs);
        } else {
            memToSort = new MemberExpr(((MondrianMember)this.sortPosMembers[0]).getMonMember());
        }
        UnresolvedFunCall funOrder = new UnresolvedFunCall(function, new Exp[]{setForAx, Literal.create((Integer)new Integer(this.topBottomCount)), memToSort});
        monAx.setSet((Exp)funOrder);
    }
}

