/*
 * Decompiled with CFR 0.152.
 */
package nux.xom.pool;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import javax.xml.transform.TransformerFactory;
import nu.xom.Document;
import nu.xom.NodeFactory;
import nu.xom.ParsingException;
import nu.xom.xslt.XSLException;
import nu.xom.xslt.XSLTransform;
import nux.xom.pool.ClassLoaderUtil;
import nux.xom.pool.DocumentFactory;
import nux.xom.pool.SoftThreadLocal;
import nux.xom.pool.XOMUtil;

public class XSLTransformFactory {
    private static final String[] DEFAULT_TRAX_FACTORIES = new String[]{"org.apache.xalan.processor.TransformerFactoryImpl", "com.sun.org.apache.xalan.internal.xsltc.trax.TransformerFactoryImpl", "net.sf.saxon.TransformerFactoryImpl", "org.apache.xalan.xsltc.trax.TransformerFactoryImpl", "com.icl.saxon.TransformerFactoryImpl", "oracle.xml.jaxp.JXSAXTransformerFactory", "jd.xml.xslt.trax.TransformerFactoryImpl"};
    private final ThreadLocal threadLocal;
    private final DocumentFactory factory = new DocumentFactory();
    private static final boolean DEBUG = XOMUtil.getSystemProperty("nux.xom.pool.XSLTransformFactory.debug", false);

    public XSLTransformFactory() {
        this.threadLocal = new SoftThreadLocal(){

            protected Object initialSoftValue() {
                String[] traxFactories = XSLTransformFactory.this.getPreferredTransformerFactories();
                int i = 0;
                while (traxFactories != null && i < traxFactories.length) {
                    try {
                        TransformerFactory factory = (TransformerFactory)ClassLoaderUtil.newInstance(traxFactories[i]);
                        XSLTransformFactory.this.initFactory(factory);
                        if (DEBUG) {
                            System.err.println("using TRAX TransformerFactory=" + factory.getClass().getName());
                        }
                        return factory;
                    }
                    catch (ClassNotFoundException e) {
                    }
                    catch (NoClassDefFoundError err) {
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                    ++i;
                }
                TransformerFactory factory = TransformerFactory.newInstance();
                XSLTransformFactory.this.initFactory(factory);
                if (DEBUG) {
                    System.err.println("using default TRAX TransformerFactory=" + factory.getClass().getName());
                }
                return factory;
            }
        };
    }

    public XSLTransform createTransform(Document stylesheet) throws XSLException {
        return this.newTransform(stylesheet, (TransformerFactory)this.threadLocal.get());
    }

    public XSLTransform createTransform(File stylesheet) throws XSLException, ParsingException, IOException {
        return this.createTransform(this.factory.createDocument(stylesheet));
    }

    public XSLTransform createTransform(InputStream stylesheet, URI baseURI) throws XSLException, ParsingException, IOException {
        return this.createTransform(this.factory.createDocument(stylesheet, baseURI));
    }

    protected XSLTransform newTransform(Document stylesheet, TransformerFactory transformerFactory) throws XSLException {
        return new XSLTransform(stylesheet, new NodeFactory(), transformerFactory);
    }

    protected String[] getPreferredTransformerFactories() {
        return DEFAULT_TRAX_FACTORIES;
    }

    protected void initFactory(TransformerFactory factory) {
    }
}

