/*
 * Decompiled with CFR 0.152.
 */
package nu.xom.converters;

import nu.xom.Attribute;
import nu.xom.Comment;
import nu.xom.DocType;
import nu.xom.Document;
import nu.xom.Element;
import nu.xom.Node;
import nu.xom.Nodes;
import nu.xom.ParentNode;
import nu.xom.ProcessingInstruction;
import nu.xom.Text;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;
import org.xml.sax.ext.LexicalHandler;
import org.xml.sax.helpers.AttributesImpl;
import org.xml.sax.helpers.LocatorImpl;

public class SAXConverter {
    private ContentHandler contentHandler;
    private LexicalHandler lexicalHandler;
    private LocatorImpl locator;
    private boolean stripBaseAttributes = true;

    public SAXConverter(ContentHandler handler) {
        this.setContentHandler(handler);
    }

    public void setContentHandler(ContentHandler handler) {
        if (handler == null) {
            throw new NullPointerException("ContentHandler must be non-null.");
        }
        if ("nu.xom.xslt.XSLTHandler".equals(handler.getClass().getName())) {
            this.stripBaseAttributes = false;
        } else {
            this.contentHandler = handler;
        }
    }

    public ContentHandler getContentHandler() {
        return this.contentHandler;
    }

    public void setLexicalHandler(LexicalHandler handler) {
        this.lexicalHandler = handler;
    }

    public LexicalHandler getLexicalHandler() {
        return this.lexicalHandler;
    }

    public void convert(Document doc) throws SAXException {
        this.locator = new LocatorImpl();
        this.locator.setSystemId(doc.getBaseURI());
        this.contentHandler.setDocumentLocator(this.locator);
        this.contentHandler.startDocument();
        int i = 0;
        while (i < doc.getChildCount()) {
            this.process(doc.getChild(i));
            ++i;
        }
        this.contentHandler.endDocument();
    }

    private void process(Node node) throws SAXException {
        if (node instanceof Element) {
            this.convertElement((Element)node);
        } else if (node instanceof Text) {
            String data = node.getValue();
            this.contentHandler.characters(data.toCharArray(), 0, data.length());
        } else if (node instanceof ProcessingInstruction) {
            ProcessingInstruction instruction = (ProcessingInstruction)node;
            this.contentHandler.processingInstruction(instruction.getTarget(), instruction.getValue());
        } else if (node instanceof Comment && this.lexicalHandler != null) {
            String data = node.getValue();
            this.lexicalHandler.comment(data.toCharArray(), 0, data.length());
        } else if (node instanceof DocType && this.lexicalHandler != null) {
            DocType type = (DocType)node;
            this.lexicalHandler.startDTD(type.getRootElementName(), type.getPublicID(), type.getSystemID());
            this.lexicalHandler.endDTD();
        }
    }

    private boolean convertNamespace(Element element, String prefix) throws SAXException {
        String uri = element.getNamespaceURI(prefix);
        ParentNode parentNode = element.getParent();
        Element parent = null;
        if (parentNode instanceof Element) {
            parent = (Element)parentNode;
        }
        if (parent != null && uri.equals(parent.getNamespaceURI(prefix))) {
            return false;
        }
        if (parent == null && "".equals(uri)) {
            return false;
        }
        this.contentHandler.startPrefixMapping(prefix, uri);
        return true;
    }

    private void convertElement(Element element) throws SAXException {
        this.locator.setSystemId(element.getBaseURI());
        int namespaceCount = element.getNamespaceDeclarationCount();
        String[] prefixes = new String[namespaceCount];
        int prefixCount = 0;
        int i = 0;
        while (i < namespaceCount) {
            String prefix = element.getNamespacePrefix(i);
            boolean converted = this.convertNamespace(element, prefix);
            if (converted) {
                prefixes[prefixCount] = prefix;
                ++prefixCount;
            }
            ++i;
        }
        AttributesImpl saxAttributes = new AttributesImpl();
        int attributeCount = element.getAttributeCount();
        int i2 = 0;
        while (i2 < attributeCount) {
            Attribute attribute = element.getAttribute(i2);
            if (!("base".equals(attribute.getLocalName()) && "http://www.w3.org/XML/1998/namespace".equals(attribute.getNamespaceURI()) && this.stripBaseAttributes)) {
                saxAttributes.addAttribute(attribute.getNamespaceURI(), attribute.getLocalName(), attribute.getQualifiedName(), SAXConverter.getSAXType(attribute), attribute.getValue());
            }
            ++i2;
        }
        this.contentHandler.startElement(element.getNamespaceURI(), element.getLocalName(), element.getQualifiedName(), saxAttributes);
        int childCount = element.getChildCount();
        int i3 = 0;
        while (i3 < childCount) {
            this.process(element.getChild(i3));
            ++i3;
        }
        this.contentHandler.endElement(element.getNamespaceURI(), element.getLocalName(), element.getQualifiedName());
        i3 = 0;
        while (i3 < prefixCount) {
            this.contentHandler.endPrefixMapping(prefixes[i3]);
            ++i3;
        }
    }

    private static String getSAXType(Attribute attribute) {
        Attribute.Type type = attribute.getType();
        if (type.equals(Attribute.Type.UNDECLARED)) {
            return "CDATA";
        }
        if (type.equals(Attribute.Type.CDATA)) {
            return "CDATA";
        }
        if (type.equals(Attribute.Type.ID)) {
            return "ID";
        }
        if (type.equals(Attribute.Type.IDREF)) {
            return "IDREF";
        }
        if (type.equals(Attribute.Type.IDREFS)) {
            return "IDREFS";
        }
        if (type.equals(Attribute.Type.NMTOKEN)) {
            return "NMTOKEN";
        }
        if (type.equals(Attribute.Type.NMTOKENS)) {
            return "NMTOKENS";
        }
        if (type.equals(Attribute.Type.ENTITY)) {
            return "ENTITY";
        }
        if (type.equals(Attribute.Type.ENTITIES)) {
            return "ENTITIES";
        }
        if (type.equals(Attribute.Type.NOTATION)) {
            return "NOTATION";
        }
        return "NMTOKEN";
    }

    public void convert(Nodes nodes) throws SAXException {
        if (nodes.size() == 1 && nodes.get(0) instanceof Document) {
            this.convert((Document)nodes.get(0));
        } else {
            this.locator = new LocatorImpl();
            this.contentHandler.setDocumentLocator(this.locator);
            this.contentHandler.startDocument();
            int i = 0;
            while (i < nodes.size()) {
                this.process(nodes.get(i));
                ++i;
            }
            this.contentHandler.endDocument();
        }
    }
}

