/*
 * Decompiled with CFR 0.152.
 */
package nu.xom;

final class QName {
    private final String uri;
    private final String name;
    private String prefix;
    private String localName;

    public QName(String name, String uri) {
        if (name == null) {
            throw new NullPointerException();
        }
        if (uri == null) {
            uri = "";
        }
        this.name = name;
        this.uri = uri;
    }

    public String getLocalName() {
        if (this.localName == null) {
            this.splitName();
        }
        return this.localName;
    }

    public String getNamespacePrefix() {
        if (this.prefix == null) {
            this.splitName();
        }
        return this.prefix;
    }

    public String getNamespaceURI() {
        return this.uri;
    }

    public String getQualifiedName() {
        return this.name;
    }

    private void splitName() {
        int i = this.name.indexOf(58);
        if (i < 0) {
            this.prefix = "";
            this.localName = this.name;
        } else {
            this.prefix = this.name.substring(0, i);
            this.localName = this.name.substring(i + 1);
        }
    }

    public QName intern() {
        String name2 = this.name.intern();
        String uri2 = this.uri.length() == 0 ? "" : this.uri.intern();
        return this.name == name2 && this.uri == uri2 ? this : new QName(name2, uri2);
    }

    public boolean equals(Object o2) {
        if (o2 instanceof QName) {
            QName q2 = (QName)o2;
            return !(this.name != q2.name && !this.name.equals(q2.name) || this.uri != q2.uri && !this.uri.equals(q2.uri));
        }
        return false;
    }

    public int hashCode() {
        return this.uri.hashCode() ^ this.name.hashCode();
    }
}

