/*
 * Decompiled with CFR 0.152.
 */
package org.unitils.dbunit.util;

import java.io.File;
import java.io.FileInputStream;
import java.util.HashMap;
import java.util.Map;
import javax.xml.parsers.SAXParserFactory;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.dbunit.dataset.CachedDataSet;
import org.dbunit.dataset.Column;
import org.dbunit.dataset.DataSetException;
import org.dbunit.dataset.DefaultTableMetaData;
import org.dbunit.dataset.IDataSet;
import org.dbunit.dataset.ITableMetaData;
import org.dbunit.dataset.ReplacementDataSet;
import org.dbunit.dataset.datatype.DataType;
import org.unitils.core.UnitilsException;
import org.unitils.dbunit.util.MultiSchemaDataSet;
import org.unitils.thirdparty.org.apache.commons.io.IOUtils;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;

public class MultiSchemaXmlDataSetReader {
    private static Log logger = LogFactory.getLog(MultiSchemaXmlDataSetReader.class);
    private String defaultSchemaName;

    public MultiSchemaXmlDataSetReader(String defaultSchemaName) {
        this.defaultSchemaName = defaultSchemaName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MultiSchemaDataSet readDataSetXml(File ... dataSetFiles) {
        try {
            DataSetContentHandler dataSetContentHandler = new DataSetContentHandler(this.defaultSchemaName);
            XMLReader xmlReader = this.createXMLReader();
            xmlReader.setContentHandler(dataSetContentHandler);
            xmlReader.setErrorHandler(dataSetContentHandler);
            for (File dataSetFile : dataSetFiles) {
                FileInputStream dataSetInputStream = null;
                try {
                    dataSetInputStream = new FileInputStream(dataSetFile);
                    xmlReader.parse(new InputSource(dataSetInputStream));
                }
                catch (Throwable throwable) {
                    IOUtils.closeQuietly(dataSetInputStream);
                    throw throwable;
                }
                IOUtils.closeQuietly(dataSetInputStream);
            }
            return dataSetContentHandler.getMultiSchemaDataSet();
        }
        catch (Exception e) {
            throw new UnitilsException("Unable to parse data set xml.", e);
        }
    }

    protected XMLReader createXMLReader() {
        try {
            SAXParserFactory saxParserFactory = SAXParserFactory.newInstance();
            saxParserFactory.setNamespaceAware(true);
            this.disableValidation(saxParserFactory);
            return saxParserFactory.newSAXParser().getXMLReader();
        }
        catch (Exception e) {
            throw new UnitilsException("Unable to create SAX parser to read data set xml.", e);
        }
    }

    protected void disableValidation(SAXParserFactory saxParserFactory) {
        saxParserFactory.setValidating(false);
        try {
            saxParserFactory.setFeature("http://xml.org/sax/features/external-parameter-entities", false);
        }
        catch (Exception e) {
            logger.debug((Object)("Unable to set http://xml.org/sax/features/external-parameter-entities feature on SAX parser factory to false. Igoring exception: " + e.getMessage()));
        }
        try {
            saxParserFactory.setFeature("http://apache.org/xml/features/nonvalidating/load-external-dtd", false);
        }
        catch (Exception e) {
            logger.debug((Object)("Unable to set http://apache.org/xml/features/nonvalidating/load-external-dtd feature on SAX parser factory to false. Igoring exception: " + e.getMessage()));
        }
    }

    protected static class DataSetContentHandler
    extends DefaultHandler {
        private String defaultSchemaName;
        private Map<String, CachedDataSet> dataSets = new HashMap<String, CachedDataSet>();

        public DataSetContentHandler(String defaultSchemaName) {
            this.defaultSchemaName = defaultSchemaName;
        }

        public MultiSchemaDataSet getMultiSchemaDataSet() throws DataSetException {
            for (CachedDataSet dataSet : this.dataSets.values()) {
                dataSet.endDataSet();
            }
            MultiSchemaDataSet multiSchemaDataSet = new MultiSchemaDataSet();
            for (String schemaName : this.dataSets.keySet()) {
                CachedDataSet cachedDataSet = this.dataSets.get(schemaName);
                ReplacementDataSet replacementDataSet = new ReplacementDataSet((IDataSet)cachedDataSet);
                replacementDataSet.addReplacementObject((Object)"[null]", null);
                multiSchemaDataSet.setDataSetForSchema(schemaName, (IDataSet)replacementDataSet);
            }
            return multiSchemaDataSet;
        }

        public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
            try {
                CachedDataSet dataSet;
                if ("dataset".equals(localName)) {
                    if (!StringUtils.isEmpty((String)uri)) {
                        this.defaultSchemaName = uri;
                    }
                    return;
                }
                String schemaName = this.defaultSchemaName;
                if (!StringUtils.isEmpty((String)uri)) {
                    schemaName = uri;
                }
                if ((dataSet = this.dataSets.get(schemaName)) == null) {
                    dataSet = new CachedDataSet();
                    dataSet.startDataSet();
                    this.dataSets.put(schemaName, dataSet);
                }
                ITableMetaData tableMetaData = this.createTableMetaData(localName, attributes);
                dataSet.startTable(tableMetaData);
                Object[] rowValues = this.getRowValues(tableMetaData.getColumns(), attributes);
                if (rowValues != null) {
                    dataSet.row(rowValues);
                }
                dataSet.endTable();
            }
            catch (DataSetException e) {
                throw new SAXException((Exception)((Object)e));
            }
        }

        protected ITableMetaData createTableMetaData(String tableName, Attributes attributes) {
            Column[] columns = new Column[attributes.getLength()];
            for (int i = 0; i < attributes.getLength(); ++i) {
                columns[i] = new Column(attributes.getQName(i), DataType.UNKNOWN);
            }
            return new DefaultTableMetaData(tableName, columns);
        }

        protected String[] getRowValues(Column[] columns, Attributes attributes) {
            if (columns.length == 0 || attributes.getLength() == 0) {
                return null;
            }
            String[] rowValues = new String[columns.length];
            for (int i = 0; i < columns.length; ++i) {
                Column column = columns[i];
                rowValues[i] = attributes.getValue(column.getColumnName());
            }
            return rowValues;
        }

        public void error(SAXParseException e) throws SAXException {
            throw e;
        }
    }
}

