/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.cobertura;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import net.sourceforge.cobertura.coveragedata.ClassData;
import net.sourceforge.cobertura.coveragedata.CoverageData;
import net.sourceforge.cobertura.coveragedata.CoverageDataFileHandler;
import net.sourceforge.cobertura.coveragedata.ProjectData;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.project.MavenProject;
import org.codehaus.mojo.cobertura.AbstractCoberturaMojo;
import org.codehaus.mojo.cobertura.util.DependenciesMatchingUtil;
import org.codehaus.mojo.cobertura.util.JavaFileUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CoberturaConsolidateMojo
extends AbstractCoberturaMojo {
    protected List<MavenProject> reactorProjects;
    protected String consolidateDataFileName;
    private File globalDataFile;

    public void execute() throws MojoExecutionException, MojoFailureException {
        if (this.reactorProjects.size() <= 1) {
            this.getLog().info((CharSequence)"The project is not a multi-module project, skipping cobertura consolidation...");
            return;
        }
        File baseDir = this.reactorProjects.get(0).getBasedir();
        this.globalDataFile = new File(baseDir, "target/cobertura/consolidate-cobertura.ser");
        List<MavenProject> mavenProjects = this.removeAgregator(this.reactorProjects);
        if (this.isLastProject(this.project, mavenProjects)) {
            this.mergeModuleDataFiles(this.globalDataFile, mavenProjects);
            this.consolidateCobertura(mavenProjects, this.globalDataFile);
        }
    }

    private List<MavenProject> removeAgregator(List<MavenProject> reactorProjects) {
        ArrayList<MavenProject> result = new ArrayList<MavenProject>();
        for (MavenProject reactorProject : reactorProjects) {
            if (this.isMultiModule(reactorProject)) continue;
            result.add(reactorProject);
        }
        return result;
    }

    private boolean isMultiModule(MavenProject mavenProject) {
        return mavenProject.getModel().getPackaging().equals("pom");
    }

    private boolean isLastProject(MavenProject project, List<MavenProject> mavenProjectList) {
        return project.equals((Object)mavenProjectList.get(mavenProjectList.size() - 1));
    }

    public void mergeModuleDataFiles(File globalDataFile, List<MavenProject> reactorProjects) {
        ProjectData globalProjectData = new ProjectData();
        globalDataFile.getParentFile().mkdirs();
        Iterable<? extends File> serFiles = this.getAllSerFiles(reactorProjects);
        for (File file : serFiles) {
            ProjectData data = CoverageDataFileHandler.loadCoverageData((File)file);
            globalProjectData.merge((CoverageData)data);
        }
        this.getLog().info((CharSequence)("Saving global cobertura information in " + globalDataFile.getAbsolutePath()));
        CoverageDataFileHandler.saveCoverageData((ProjectData)globalProjectData, (File)globalDataFile);
    }

    private Iterable<? extends File> getAllSerFiles(List<MavenProject> mavenProjectList) {
        ArrayList<File> listSerFiles = new ArrayList<File>();
        for (MavenProject reactorProject : mavenProjectList) {
            if (this.shouldBeSkippedAsExcludedFromInstrumentation(reactorProject)) {
                String referenceId = reactorProject.getGroupId() + ":" + reactorProject.getArtifactId() + ":" + reactorProject.getVersion();
                this.getLog().info((CharSequence)("Ignoring consolidation of [" + referenceId + "]" + " (excludesArtifactId match)"));
                continue;
            }
            File fileForProject = this.getSerFileForProject(reactorProject);
            if (!fileForProject.exists()) continue;
            this.getLog().info((CharSequence)("Adding " + fileForProject + " for cobertura consolidation"));
            listSerFiles.add(fileForProject);
        }
        return listSerFiles;
    }

    private boolean shouldBeSkippedAsExcludedFromInstrumentation(MavenProject mavenProject) {
        return this.instrumentation != null && DependenciesMatchingUtil.matchListRegex(this.instrumentation.getExcludesArtifactId(), mavenProject.getArtifactId());
    }

    public File getSerFileForProject(MavenProject mavenProject) {
        File baseDir = mavenProject.getBasedir();
        return new File(baseDir, "target/cobertura/cobertura.ser");
    }

    public void consolidateCobertura(List<MavenProject> projectList, File globalDataFile) {
        for (MavenProject project : projectList) {
            if (this.instrumentation != null && this.shouldBeSkippedAsExcludedFromInstrumentation(project)) {
                this.getLog().info((CharSequence)("Skipping consolidation for project " + project.getName() + " (excludesArtifactId match)"));
                continue;
            }
            File consolidateDataFile = this.getConsolidatedFile(project);
            consolidateDataFile.delete();
            this.getLog().info((CharSequence)("Consolidate project " + project.getName()));
            List<String> classNameList = JavaFileUtil.listProjectClassFiles(project);
            ProjectData globalData = CoverageDataFileHandler.loadCoverageData((File)globalDataFile);
            ProjectData moduleData = this.filterCoberturaSerWithClassName(globalData, classNameList);
            this.getLog().info((CharSequence)("Project " + project.getName() + " has line coverage to " + moduleData.getLineCoverageRate() + ", saving file in " + consolidateDataFile));
            CoverageDataFileHandler.saveCoverageData((ProjectData)moduleData, (File)consolidateDataFile);
        }
    }

    public File getConsolidatedFile(MavenProject project) {
        return new File(project.getBasedir(), this.consolidateDataFileName);
    }

    public ProjectData filterCoberturaSerWithClassName(ProjectData globalSer, List<String> classListName) {
        ProjectData resultProjectData = new ProjectData();
        for (String className : classListName) {
            ClassData classData = globalSer.getClassData(className);
            if (classData == null) {
                this.getLog().warn((CharSequence)("No class data found for [" + className + "]"));
                continue;
            }
            resultProjectData.addClassData(classData);
        }
        return resultProjectData;
    }

    public void setConsolidateDataFileName(String consolidateDataFileName) {
        this.consolidateDataFileName = consolidateDataFileName;
    }
}

