/*
 * Copyright (C) 2005 - 2011 Jaspersoft Corporation. All rights reserved.
 * http://www.jaspersoft.com.
 *
 * Unless you have purchased  a commercial license agreement from Jaspersoft,
 * the following license terms  apply:
 *
 * This program is free software: you can redistribute it and/or  modify
 * it under the terms of the GNU Affero General Public License  as
 * published by the Free Software Foundation, either version 3 of  the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU Affero  General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public  License
 * along with this program. If not, see <http://www.gnu.org/licenses/>.
 */
package com.jaspersoft.jasperserver.api.engine.scheduling.hibernate;

import com.jaspersoft.jasperserver.api.engine.scheduling.domain.FTPInfo;
import com.jaspersoft.jasperserver.api.engine.scheduling.domain.reportjobmodel.FTPInfoModel;
import com.jaspersoft.jasperserver.api.metadata.common.util.NullValue;

import java.util.Map;

/**
 * @author Ivan Chan (lucianc@users.sourceforge.net)
 * @version $Id: PersistentFTPInfo.java 22627 2012-03-19 19:41:28Z ichan $
 */
public class PersistentFTPInfo {



    String userName;
    String password;
    String folderPath;
    String serverName;
    Map<String, String> PropertiesMap;

	public PersistentFTPInfo() {
	}

    public String getUserName() {
        return userName;
    }

    public void setUserName(String userName) {
        this.userName = userName;
    }

    public String getPassword() {
        return password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public String getFolderPath() {
        return folderPath;
    }

    public void setFolderPath(String folderPath) {
        this.folderPath = folderPath;
    }

    public String getServerName() {
        return serverName;
    }

    public void setServerName(String serverName) {
        this.serverName = serverName;
    }

    public Map<String, String> getPropertiesMap() {
        return PropertiesMap;
    }

    public void setPropertiesMap(Map<String, String> propertiesMap) {
        PropertiesMap = propertiesMap;
    }

    public void copyFrom(FTPInfo ftpInfo) {
        setUserName(ftpInfo.getUserName());
        setPassword(ftpInfo.getPassword());
        setFolderPath(ftpInfo.getFolderPath());
        setServerName(ftpInfo.getServerName());
        setPropertiesMap(NullValue.replaceWithNullValues(ftpInfo.getPropertiesMap()));
	}

	public void copyFrom(FTPInfoModel ftpInfoModel) {
        if (ftpInfoModel.isUserNameModified()) setUserName(ftpInfoModel.getUserName());
        if (ftpInfoModel.isPasswordModified()) setPassword(ftpInfoModel.getPassword());
        if (ftpInfoModel.isFolderPathModified()) setFolderPath(ftpInfoModel.getFolderPath());
        if (ftpInfoModel.isServerNameModified()) setServerName(ftpInfoModel.getServerName());
        if (ftpInfoModel.isPropertiesMapModified()) setPropertiesMap(NullValue.replaceWithNullValues(ftpInfoModel.getPropertiesMap()));

	}

	public FTPInfo toClient() {
	    FTPInfo ftpInfo = new FTPInfo();
        ftpInfo.setUserName(getUserName());
        ftpInfo.setPassword(getPassword());
        ftpInfo.setFolderPath(getFolderPath());
        ftpInfo.setServerName(getServerName());
        ftpInfo.setPropertiesMap(NullValue.restoreNulls(getPropertiesMap()));
        return ftpInfo;
	}

}
