/*
 * Copyright (C) 2005 - 2011 Jaspersoft Corporation. All rights reserved.
 * http://www.jaspersoft.com.
 *
 * Unless you have purchased  a commercial license agreement from Jaspersoft,
 * the following license terms  apply:
 *
 * This program is free software: you can redistribute it and/or  modify
 * it under the terms of the GNU Affero General Public License  as
 * published by the Free Software Foundation, either version 3 of  the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU Affero  General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public  License
 * along with this program. If not, see <http://www.gnu.org/licenses/>.
 */
package com.jaspersoft.jasperserver.api.logging.diagnostic.datasource;

import com.jaspersoft.jasperserver.api.logging.diagnostic.service.impl.DiagnosticDataProvider;
import com.jaspersoft.jasperserver.api.metadata.jasperreports.service.ReportDataSourceService;
import net.sf.jasperreports.engine.JRDataSource;
import net.sf.jasperreports.engine.JRParameter;

import java.util.Map;

/**
 * @author vsabadosh
 */
public class DiagnosticCustomDataSourceService implements ReportDataSourceService {

    JRDataSource ds;
    private Map propertyMap;
    private SpringBeanFinder springBeanFinder;

    public Map getPropertyMap() {
        return propertyMap;
    }

    public void setPropertyMap(Map propertyMap) {
        this.propertyMap = propertyMap;
    }

    public DiagnosticCustomDataSourceService() {
    }

    public DiagnosticCustomDataSourceService(JRDataSource ds) {
        this.ds = ds;
    }

    /* (non-Javadoc)
      * @see com.jaspersoft.jasperserver.api.metadata.jasperreports.service.ReportDataSourceService#closeConnection()
      */
    public void closeConnection() {
        // Do nothing
    }

    /* (non-Javadoc)
      * @see com.jaspersoft.jasperserver.api.metadata.jasperreports.service.ReportDataSourceService#setReportParameterValues(java.util.Map)
      */
    public void setReportParameterValues(Map parameterValues) {
        DiagnosticDataProvider dataProvider = (DiagnosticDataProvider)springBeanFinder.getBean("diagnosticDataProvider");
        parameterValues.put(JRParameter.REPORT_DATA_SOURCE, new DiagnosticCustomDataSource(dataProvider.getDiagnosticAttributesList()));
    }

    public SpringBeanFinder getSpringBeanFinder() {
        return springBeanFinder;
    }

    public void setSpringBeanFinder(SpringBeanFinder springBeanFinder) {
        this.springBeanFinder = springBeanFinder;
    }
}
