/*
 * Copyright (C) 2005 - 2011 Jaspersoft Corporation. All rights reserved.
 * http://www.jaspersoft.com.
 *
 * Unless you have purchased  a commercial license agreement from Jaspersoft,
 * the following license terms  apply:
 *
 * This program is free software: you can redistribute it and/or  modify
 * it under the terms of the GNU Affero General Public License  as
 * published by the Free Software Foundation, either version 3 of  the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU Affero  General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public  License
 * along with this program. If not, see <http://www.gnu.org/licenses/>.
 */
package com.jaspersoft.jasperserver.export.modules.scheduling.beans;

import com.jaspersoft.jasperserver.api.engine.scheduling.domain.FTPInfo;
import com.jaspersoft.jasperserver.export.modules.common.ReportParameterValueBean;
import com.jaspersoft.jasperserver.export.modules.scheduling.SchedulingModuleConfiguration;

import java.util.HashMap;
import java.util.Map;

/**
 * @author ichan
 * @version $Id: FTPInfoBean.java 22677 2012-03-20 23:33:43Z ichan $
 */
public class FTPInfoBean {

    String userName;
    String password;
    String folderPath;
    String serverName;
    private String[] propertiesMapKeys;
    private String[] propertiesMapValues;

	public void copyFrom(FTPInfo src) {
		setUserName(src.getUserName());
        setPassword(src.getPassword());
        setFolderPath(src.getFolderPath());
        setServerName(src.getServerName());
        if (src.getPropertiesMap() == null) {
            propertiesMapKeys = new String[0];
            propertiesMapValues = new String[0];
        } else {
            propertiesMapKeys = new String[src.getPropertiesMap().size()];
            propertiesMapValues = new String[propertiesMapKeys.length];
            int i = 0;
            for (Map.Entry<String, String> entry : src.getPropertiesMap().entrySet()) {
                propertiesMapKeys[i] = entry.getKey();
                propertiesMapValues[i++] = entry.getValue();
            }
        }
	}

	public void copyTo(FTPInfo dest) {
		dest.setUserName(dest.getUserName());
        dest.setPassword(dest.getPassword());
        dest.setFolderPath(dest.getFolderPath());
        dest.setServerName(dest.getServerName());
        HashMap<String, String> map = new HashMap<String, String>();
        if (propertiesMapKeys != null) {
            for (int i = 0; i < propertiesMapKeys.length; i++) {
                map.put(propertiesMapKeys[i], propertiesMapValues[i]);
            }
        }
        dest.setPropertiesMap(map);
	}

    public String getUserName() {
        return userName;
    }

    public void setUserName(String userName) {
        this.userName = userName;
    }

    public String getPassword() {
        return password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public String getFolderPath() {
        return folderPath;
    }

    public void setFolderPath(String folderPath) {
        this.folderPath = folderPath;
    }

    public String getServerName() {
        return serverName;
    }

    public void setServerName(String serverName) {
        this.serverName = serverName;
    }

    public String[] getPropertiesMapKeys() {
        return propertiesMapKeys;
    }

    public void setPropertiesMapKeys(String[] propertiesMapKeys) {
        this.propertiesMapKeys = propertiesMapKeys;
    }

    public String[] getPropertiesMapValues() {
        return propertiesMapValues;
    }

    public void setPropertiesMapValues(String[] propertiesMapValues) {
        this.propertiesMapValues = propertiesMapValues;
    }


}
