/*
 * Copyright (C) 2005 - 2011 Jaspersoft Corporation. All rights reserved.
 * http://www.jaspersoft.com.
 *
 * Unless you have purchased  a commercial license agreement from Jaspersoft,
 * the following license terms  apply:
 *
 * This program is free software: you can redistribute it and/or  modify
 * it under the terms of the GNU Affero General Public License  as
 * published by the Free Software Foundation, either version 3 of  the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU Affero  General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public  License
 * along with this program. If not, see <http://www.gnu.org/licenses/>.
 */
package com.jaspersoft.jasperserver.export.modules.repository.beans;

import com.jaspersoft.jasperserver.api.metadata.common.domain.DataType;
import com.jaspersoft.jasperserver.api.metadata.common.domain.Resource;
import com.jaspersoft.jasperserver.export.modules.repository.ResourceExportHandler;
import com.jaspersoft.jasperserver.export.modules.repository.ResourceImportHandler;

/**
 * @author tkavanagh
 * @version $Id: DataTypeBean.java 19925 2010-12-11 15:06:41Z tmatyashovsky $
 */

public class DataTypeBean extends ResourceBean {

	private byte type;
	private Integer maxLength;
	private Integer decimals;
	private String regularExpr;
	private Object minValue;
	private Object maxValue;
	private boolean strictMin;
	private boolean strictMax;
	
	protected void additionalCopyFrom(Resource res, ResourceExportHandler referenceHandler) {
		DataType dt = (DataType) res;
		setType(dt.getType());
		setMaxLength(dt.getMaxLength());
		setDecimals(dt.getDecimals());
		setRegularExpr(dt.getRegularExpr());
		setMinValue(dt.getMinValue());
		setMaxValue(dt.getMaxValue());
		setStrictMin(dt.isStrictMin());
		setStrictMax(dt.isStrictMax());
	}

	protected void additionalCopyTo(Resource res, ResourceImportHandler importHandler) {
		DataType dt = (DataType) res;
		dt.setType(getType());
		dt.setMaxLength(getMaxLength());
		dt.setDecimals(getDecimals());
		dt.setRegularExpr(getRegularExpr());
		dt.setMinValue((Comparable) getMinValue());
		dt.setMaxValue((Comparable) getMaxValue());
		dt.setStrictMin(isStrictMin());
		dt.setStrictMax(isStrictMax());
	}

	public Integer getDecimals() {
		return decimals;
	}

	public void setDecimals(Integer decimals) {
		this.decimals = decimals;
	}

	public Integer getMaxLength() {
		return maxLength;
	}

	public void setMaxLength(Integer maxLength) {
		this.maxLength = maxLength;
	}

	public Object getMaxValue() {
		return maxValue;
	}

	public void setMaxValue(Object maxValue) {
		this.maxValue = maxValue;
	}

	public Object getMinValue() {
		return minValue;
	}

	public void setMinValue(Object minValue) {
		this.minValue = minValue;
	}

	public String getRegularExpr() {
		return regularExpr;
	}

	public void setRegularExpr(String regularExpr) {
		this.regularExpr = regularExpr;
	}

	public byte getType() {
		return type;
	}

	public void setType(byte type) {
		this.type = type;
	}

	public boolean isStrictMax() {
		return strictMax;
	}

	public void setStrictMax(boolean strictMax) {
		this.strictMax = strictMax;
	}

	public boolean isStrictMin() {
		return strictMin;
	}

	public void setStrictMin(boolean strictMin) {
		this.strictMin = strictMin;
	}

}
