/*
 * Copyright (C) 2005 - 2011 Jaspersoft Corporation. All rights reserved.
 * http://www.jaspersoft.com.
 *
 * Unless you have purchased  a commercial license agreement from Jaspersoft,
 * the following license terms  apply:
 *
 * This program is free software: you can redistribute it and/or  modify
 * it under the terms of the GNU Affero General Public License  as
 * published by the Free Software Foundation, either version 3 of  the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU Affero  General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public  License
 * along with this program. If not, see <http://www.gnu.org/licenses/>.
 */
package com.jaspersoft.jasperserver.war.dto;

import javax.xml.bind.annotation.XmlRootElement;
import java.io.Serializable;

/**
 * InputControlOption
 * @author akasych
 * @version $Id: InputControlOption.java 22427 2012-03-07 15:50:44Z andy21ca $
 * Simple class to transfer Input Control list option.
 */

@XmlRootElement(name = "inputControlOption")
public class InputControlOption implements Serializable {

    private final static long serialVersionUID = 1l;

    private boolean selected;
    private String label;
    private String value;

    public InputControlOption() {
    }

    public InputControlOption(String value, String label, boolean selected) {
        this.label = label;
        this.value = value;
        this.selected = selected;
    }

    public InputControlOption(String value, String label) {
        this.label = label;
        this.value = value;
        this.selected = false;
    }

    public boolean isSelected() {
        return selected;
    }
    public void setSelected(boolean selected) {
        this.selected = selected;
    }

    public String getLabel() {
        return label;
    }
    public void setLabel(String label) {
        this.label = label;
    }

    public String getValue() {
        return value;
    }

    public void setValue(String value) {
        this.value = value;
    }
}
