/*
* Copyright (C) 2005 - 2009 Jaspersoft Corporation. All rights  reserved.
* http://www.jaspersoft.com.
*
* Unless you have purchased  a commercial license agreement from Jaspersoft,
* the following license terms  apply:
*
* This program is free software: you can redistribute it and/or  modify
* it under the terms of the GNU Affero General Public License  as
* published by the Free Software Foundation, either version 3 of  the
* License, or (at your option) any later version.
*
* This program is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
* GNU Affero  General Public License for more details.
*
* You should have received a copy of the GNU Affero General Public  License
* along with this program.&nbsp; If not, see <http://www.gnu.org/licenses/>.
*/
package com.jaspersoft.jasperserver.remote.resources.converters;

import com.jaspersoft.jasperserver.api.metadata.olap.domain.OlapUnit;
import com.jaspersoft.jasperserver.dto.resources.ClientOlapUnit;
import com.jaspersoft.jasperserver.remote.exception.IllegalParameterValueException;
import org.springframework.stereotype.Service;

/**
 * @author vsabadosh
 */
@Service
public class OlapUnitResourceConverter extends ResourceConverterImpl<OlapUnit, ClientOlapUnit> {
    @Override
    protected OlapUnit resourceSpecificFieldsToServer(ClientOlapUnit clientObject, OlapUnit resultToUpdate) throws IllegalParameterValueException {
        resultToUpdate.setMdxQuery(clientObject.getMdxQuery());
        return resultToUpdate;
    }

    @Override
    protected ClientOlapUnit resourceSpecificFieldsToClient(ClientOlapUnit client, OlapUnit serverObject) {
        client.setMdxQuery(serverObject.getMdxQuery());
        return client;
    }
}
