/*
 * Copyright (C) 2005 - 2012 Jaspersoft Corporation. All rights reserved.
 * http://www.jaspersoft.com.
 * Unless you have purchased  a commercial license agreement from Jaspersoft,
 * the following license terms  apply:
 *
 * This program is free software: you can redistribute it and/or  modify
 * it under the terms of the GNU Affero General Public License  as
 * published by the Free Software Foundation, either version 3 of  the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU Affero  General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public  License
 * along with this program. If not, see <http://www.gnu.org/licenses/>.
 */

package com.jaspersoft.jasperserver.remote.resources.converters;

import com.jaspersoft.jasperserver.api.metadata.common.domain.InputControl;
import com.jaspersoft.jasperserver.dto.resources.ClientInputControl;
import com.jaspersoft.jasperserver.dto.resources.ClientReferenceableDataType;
import com.jaspersoft.jasperserver.dto.resources.ClientReferenceableListOfValues;
import com.jaspersoft.jasperserver.dto.resources.ClientReferenceableQuery;
import com.jaspersoft.jasperserver.remote.exception.IllegalParameterValueException;
import com.jaspersoft.jasperserver.remote.exception.MandatoryParameterNotFoundException;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;
import java.util.Arrays;

/**
 * <p></p>
 *
 * @author Zakhar.Tomchenco
 * @version $Id: InputControlResourceConverter.java 29488 2013-03-11 15:58:05Z ztomchenco $
 */
@Service
public class InputControlResourceConverter extends ResourceConverterImpl<InputControl, ClientInputControl> {
    @Resource(name = "resourceReferenceConverterProvider")
    private ResourceReferenceConverterProvider resourceConverterProvider;

    @Override
    protected InputControl resourceSpecificFieldsToServer(ClientInputControl clientObject, InputControl resultToUpdate) throws IllegalParameterValueException, MandatoryParameterNotFoundException {
        ResourceReferenceConverter<ClientReferenceableDataType> dataTypeConverter = resourceConverterProvider.getConverterForType(ClientReferenceableDataType.class);
        ResourceReferenceConverter<ClientReferenceableListOfValues> lovConverter = resourceConverterProvider.getConverterForType(ClientReferenceableListOfValues.class);
        ResourceReferenceConverter<ClientReferenceableQuery> queryConverter = resourceConverterProvider.getConverterForType(ClientReferenceableQuery.class);

        resultToUpdate.setDataType(dataTypeConverter.toServer(clientObject.getDataType()));
        resultToUpdate.setListOfValues(lovConverter.toServer(clientObject.getListOfValues()));
        resultToUpdate.setQuery(queryConverter.toServer(clientObject.getQuery()));

        resultToUpdate.setMandatory(clientObject.isMandatory());
        resultToUpdate.setReadOnly(clientObject.isReadOnly());
        resultToUpdate.setVisible(clientObject.isVisible());
        resultToUpdate.setType(clientObject.getType());
        resultToUpdate.setQueryValueColumn(clientObject.getValueColumn());

        for( String column : clientObject.getVisibleColumns()){
            resultToUpdate.addQueryVisibleColumn(column);
        }

        return resultToUpdate;
    }

    @Override
    protected ClientInputControl resourceSpecificFieldsToClient(ClientInputControl client, InputControl serverObject) {
        ResourceReferenceConverter<ClientReferenceableDataType> dataTypeConverter = resourceConverterProvider.getConverterForType(ClientReferenceableDataType.class);
        ResourceReferenceConverter<ClientReferenceableListOfValues> lovConverter = resourceConverterProvider.getConverterForType(ClientReferenceableListOfValues.class);
        ResourceReferenceConverter<ClientReferenceableQuery> queryConverter = resourceConverterProvider.getConverterForType(ClientReferenceableQuery.class);

        client.setDataType(dataTypeConverter.toClient(serverObject.getDataType()));
        client.setListOfValues(lovConverter.toClient(serverObject.getListOfValues()));
        client.setQuery(queryConverter.toClient(serverObject.getQuery()));

        client.setMandatory(serverObject.isMandatory());
        client.setReadOnly(serverObject.isReadOnly());
        client.setVisible(serverObject.isVisible());
        client.setType(serverObject.getType());
        client.setValueColumn(serverObject.getQueryValueColumn());
        client.setVisibleColumns(Arrays.asList(serverObject.getQueryVisibleColumns()));

        return client;
    }
}
