/*
 * Copyright (C) 2005 - 2012 Jaspersoft Corporation. All rights reserved.
 * http://www.jaspersoft.com.
 *
 * Unless you have purchased  a commercial license agreement from Jaspersoft,
 * the following license terms  apply:
 *
 * This program is free software: you can redistribute it and/or  modify
 * it under the terms of the GNU Affero General Public License  as
 * published by the Free Software Foundation, either version 3 of  the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU Affero  General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public  License
 * along with this program. If not, see <http://www.gnu.org/licenses/>.
 */
package com.jaspersoft.jasperserver.api.common.virtualdatasourcequery;

import com.jaspersoft.jasperserver.api.JasperServerAPI;

import java.util.Collection;

/**
 * @author Ivan Chan (ichan@jaspersoft.com)
 * @version $Id: VirtualDataSourceQueryService.java 24704 2012-08-29 22:13:51Z ichan $
 */
@JasperServerAPI
public interface VirtualDataSourceQueryService {

    /*
     * a hook to replace teiid with other virtual data source service (like JDBCUnity)
     * jasperserver engine is going to provide a list of sub data sources and connection information
     * virtualDataSourceQueryService is supposed to build a virtual data source and return a connection factory
     * @param dataSources a collection of sub data sources
     * @return connection factory for virtual data source
     */
    public ConnectionFactory getConnectionFactory(Collection<DataSource> dataSources) throws Exception;
}
