/*
* Copyright (C) 2005 - 2009 Jaspersoft Corporation. All rights  reserved.
* http://www.jaspersoft.com.
*
* Unless you have purchased  a commercial license agreement from Jaspersoft,
* the following license terms  apply:
*
* This program is free software: you can redistribute it and/or  modify
* it under the terms of the GNU Affero General Public License  as
* published by the Free Software Foundation, either version 3 of  the
* License, or (at your option) any later version.
*
* This program is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
* GNU Affero  General Public License for more details.
*
* You should have received a copy of the GNU Affero General Public  License
* along with this program.&nbsp; If not, see <http://www.gnu.org/licenses/>.
*/
package com.jaspersoft.jasperserver.dto.resources;

/**
 * <p></p>
 *
 * @author Yaroslav.Kovalchyk
 * @version $Id: ResourceMediaType.java 29489 2013-03-11 15:59:46Z ztomchenco $
 */
public interface ResourceMediaType {
    public static final String RESOURCE_MEDIA_TYPE_PREFIX = "application/repository.";
    public static final String RESOURCE_TYPE_PLACEHOLDER = "{resourceType}";
    public static final String RESOURCE_JSON_TYPE = "+json";
    public static final String RESOURCE_XML_TYPE = "+xml";

    public static final String RESOURCE_XML_TEMPLATE = RESOURCE_MEDIA_TYPE_PREFIX + RESOURCE_TYPE_PLACEHOLDER + RESOURCE_XML_TYPE;
    public static final String RESOURCE_JSON_TEMPLATE = RESOURCE_MEDIA_TYPE_PREFIX + RESOURCE_TYPE_PLACEHOLDER + RESOURCE_JSON_TYPE;
    // AwsReportDataSource
    public static final String AWS_DATA_SOURCE_CLIENT_TYPE = "awsDataSource";
    public static final String AWS_DATA_SOURCE_JSON = RESOURCE_MEDIA_TYPE_PREFIX + AWS_DATA_SOURCE_CLIENT_TYPE + RESOURCE_JSON_TYPE;
    public static final String AWS_DATA_SOURCE_XML = RESOURCE_MEDIA_TYPE_PREFIX + AWS_DATA_SOURCE_CLIENT_TYPE + RESOURCE_XML_TYPE;
    // BeanReportDataSource
    public static final String BEAN_DATA_SOURCE_CLIENT_TYPE = "beanDataSource";
    public static final String BEAN_DATA_SOURCE_JSON = RESOURCE_MEDIA_TYPE_PREFIX + BEAN_DATA_SOURCE_CLIENT_TYPE + RESOURCE_JSON_TYPE;
    public static final String BEAN_DATA_SOURCE_XML = RESOURCE_MEDIA_TYPE_PREFIX + BEAN_DATA_SOURCE_CLIENT_TYPE + RESOURCE_XML_TYPE;
    // CustomReportDataSource
    public static final String CUSTOM_DATA_SOURCE_CLIENT_TYPE = "customDataSource";
    public static final String CUSTOM_DATA_SOURCE_JSON = RESOURCE_MEDIA_TYPE_PREFIX + CUSTOM_DATA_SOURCE_CLIENT_TYPE + RESOURCE_JSON_TYPE;
    public static final String CUSTOM_DATA_SOURCE_XML = RESOURCE_MEDIA_TYPE_PREFIX + CUSTOM_DATA_SOURCE_CLIENT_TYPE + RESOURCE_XML_TYPE;
    // DataType
    public static final String DATA_TYPE_CLIENT_TYPE = "dataType";
    public static final String DATA_TYPE_JSON = RESOURCE_MEDIA_TYPE_PREFIX + DATA_TYPE_CLIENT_TYPE + RESOURCE_JSON_TYPE;
    public static final String DATA_TYPE_XML = RESOURCE_MEDIA_TYPE_PREFIX + DATA_TYPE_CLIENT_TYPE + RESOURCE_XML_TYPE;
    // Folder
    public static final String FOLDER_CLIENT_TYPE = "folder";
    public static final String FOLDER_JSON = RESOURCE_MEDIA_TYPE_PREFIX + FOLDER_CLIENT_TYPE + RESOURCE_JSON_TYPE;
    public static final String FOLDER_XML = RESOURCE_MEDIA_TYPE_PREFIX + FOLDER_CLIENT_TYPE + RESOURCE_XML_TYPE;
    // JdbcReportDataSource
    public static final String JDBC_DATA_SOURCE_CLIENT_TYPE = "jdbcDataSource";
    public static final String JDBC_DATA_SOURCE_JSON = RESOURCE_MEDIA_TYPE_PREFIX + JDBC_DATA_SOURCE_CLIENT_TYPE + RESOURCE_JSON_TYPE;
    public static final String JDBC_DATA_SOURCE_XML = RESOURCE_MEDIA_TYPE_PREFIX + JDBC_DATA_SOURCE_CLIENT_TYPE + RESOURCE_XML_TYPE;
    // JndiJdbcReportDataSource
    public static final String JNDI_JDBC_DATA_SOURCE_CLIENT_TYPE = "jndiJdbcDataSource";
    public static final String JNDI_JDBC_DATA_SOURCE_JSON = RESOURCE_MEDIA_TYPE_PREFIX + JNDI_JDBC_DATA_SOURCE_CLIENT_TYPE + RESOURCE_JSON_TYPE;
    public static final String JNDI_JDBC_DATA_SOURCE_XML = RESOURCE_MEDIA_TYPE_PREFIX + JNDI_JDBC_DATA_SOURCE_CLIENT_TYPE + RESOURCE_XML_TYPE;
    // ListOfValues
    public static final String LIST_OF_VALUES_CLIENT_TYPE = "listOfValues";
    public static final String LIST_OF_VALUES_JSON = RESOURCE_MEDIA_TYPE_PREFIX + LIST_OF_VALUES_CLIENT_TYPE + RESOURCE_JSON_TYPE;
    public static final String LIST_OF_VALUES_XML = RESOURCE_MEDIA_TYPE_PREFIX + LIST_OF_VALUES_CLIENT_TYPE + RESOURCE_XML_TYPE;
    // OlapUnit
    public static final String OLAP_UNIT_CLIENT_TYPE = "olapUnit";
    public static final String OLAP_UNIT_JSON = RESOURCE_MEDIA_TYPE_PREFIX + OLAP_UNIT_CLIENT_TYPE + RESOURCE_JSON_TYPE;
    public static final String OLAP_UNIT_XML = RESOURCE_MEDIA_TYPE_PREFIX + OLAP_UNIT_CLIENT_TYPE + RESOURCE_XML_TYPE;
    // Query
    public static final String QUERY_CLIENT_TYPE = "query";
    public static final String QUERY_JSON = RESOURCE_MEDIA_TYPE_PREFIX + QUERY_CLIENT_TYPE + RESOURCE_JSON_TYPE;
    public static final String QUERY_XML = RESOURCE_MEDIA_TYPE_PREFIX + QUERY_CLIENT_TYPE + RESOURCE_XML_TYPE;
    // VirtualReportDataSource
    public static final String VIRTUAL_DATA_SOURCE_CLIENT_TYPE = "virtualDataSource";
    public static final String VIRTUAL_DATA_SOURCE_JSON = RESOURCE_MEDIA_TYPE_PREFIX + VIRTUAL_DATA_SOURCE_CLIENT_TYPE + RESOURCE_JSON_TYPE;
    public static final String VIRTUAL_DATA_SOURCE_XML = RESOURCE_MEDIA_TYPE_PREFIX + VIRTUAL_DATA_SOURCE_CLIENT_TYPE + RESOURCE_XML_TYPE;
    // XmlaConnection
    public static final String XMLA_CONNECTION_CLIENT_TYPE = "xmlaConnection";
    public static final String XMLA_CONNECTION_JSON = RESOURCE_MEDIA_TYPE_PREFIX + XMLA_CONNECTION_CLIENT_TYPE + RESOURCE_JSON_TYPE;
    public static final String XMLA_CONNECTION_XML = RESOURCE_MEDIA_TYPE_PREFIX + XMLA_CONNECTION_CLIENT_TYPE + RESOURCE_XML_TYPE;
    // InputControl
    public static final String INPUT_CONTROL_CLIENT_TYPE = "inputControl";
    public static final String INPUT_CONTROL_JSON = RESOURCE_MEDIA_TYPE_PREFIX + INPUT_CONTROL_CLIENT_TYPE + RESOURCE_JSON_TYPE;
    public static final String INPUT_CONTROL_XML = RESOURCE_MEDIA_TYPE_PREFIX + INPUT_CONTROL_CLIENT_TYPE + RESOURCE_XML_TYPE;

}
