/*
 * Decompiled with CFR 0.152.
 */
package com.tonbeller.wcf.popup;

import com.tonbeller.wcf.component.Renderable;
import com.tonbeller.wcf.controller.RequestContext;
import com.tonbeller.wcf.popup.GroupItem;
import com.tonbeller.wcf.popup.Item;
import com.tonbeller.wcf.popup.MenuItem;
import com.tonbeller.wcf.utils.DomUtils;
import com.tonbeller.wcf.utils.XmlUtils;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class PopUp
implements Renderable {
    private String label;
    private String image;
    private String id = DomUtils.randomId();
    private List items = new ArrayList();

    public void addItem(Item item) {
        this.items.add(item);
    }

    private boolean isEmpty(List list) {
        EmptySwitch es = new EmptySwitch();
        es.handleList(list);
        return es.isEmpty();
    }

    public Element render(Document factory) {
        if (this.isEmpty(this.items)) {
            return null;
        }
        Element popup = factory.createElement("popup-menu");
        popup.setAttribute("id", this.id);
        if (this.label != null) {
            popup.setAttribute("label", this.label);
        }
        if (this.image != null) {
            popup.setAttribute("image", this.image);
        }
        Renderer r = new Renderer(popup, 0);
        r.handleList(this.items);
        return popup;
    }

    public Document render(RequestContext context) throws Exception {
        Document dom = XmlUtils.createDocument();
        Element root = this.render(dom);
        dom.appendChild(root);
        return dom;
    }

    public String getImage() {
        return this.image;
    }

    public void setImage(String image) {
        this.image = image;
    }

    public String getLabel() {
        return this.label;
    }

    public void setLabel(String label) {
        this.label = label;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    private class Renderer
    extends Switch {
        private Element parent;
        private int level;

        Renderer(Element parent, int level) {
            this.parent = parent;
            this.level = level;
        }

        void handleGroupItem(GroupItem item) {
            if (PopUp.this.isEmpty(item.getChildren())) {
                return;
            }
            Element elem = DomUtils.appendElement(this.parent, "popup-group");
            this.setItemAttrs(elem, item);
            Renderer r = new Renderer(elem, this.level + 1);
            r.handleList(item.getChildren());
        }

        void handleMenuItem(MenuItem item) {
            Element elem = DomUtils.appendElement(this.parent, "popup-item");
            this.setItemAttrs(elem, item);
            elem.setAttribute("href", item.getHref());
        }

        private void setItemAttrs(Element elem, Item item) {
            elem.setAttribute("level", "" + this.level);
            if (item.getLabel() != null) {
                elem.setAttribute("label", item.getLabel());
            }
            if (item.getImage() != null) {
                elem.setAttribute("image", item.getImage());
            }
        }
    }

    private class EmptySwitch
    extends Switch {
        boolean empty;

        private EmptySwitch() {
            this.empty = true;
        }

        void handleGroupItem(GroupItem g) {
            this.handleList(g.getChildren());
        }

        void handleMenuItem(MenuItem m) {
            this.empty = false;
        }

        public boolean isEmpty() {
            return this.empty;
        }
    }

    private abstract class Switch {
        private Switch() {
        }

        abstract void handleGroupItem(GroupItem var1);

        abstract void handleMenuItem(MenuItem var1);

        void handleItem(Item it) {
            if (it == null) {
                return;
            }
            if (it instanceof GroupItem) {
                this.handleGroupItem((GroupItem)it);
            } else {
                this.handleMenuItem((MenuItem)it);
            }
        }

        void handleList(List list) {
            Iterator it = list.iterator();
            while (it.hasNext()) {
                this.handleItem((Item)it.next());
            }
        }
    }
}

