/*
 * Decompiled with CFR 0.152.
 */
package com.tonbeller.wcf.param;

import com.tonbeller.tbutils.res.Resources;
import com.tonbeller.wcf.controller.Controller;
import com.tonbeller.wcf.controller.RequestContext;
import com.tonbeller.wcf.controller.RequestListener;
import com.tonbeller.wcf.expr.ExprUtils;
import com.tonbeller.wcf.param.ParamLinkGroupTag;
import com.tonbeller.wcf.param.SessionParam;
import com.tonbeller.wcf.param.SessionParamPool;
import com.tonbeller.wcf.token.RequestToken;
import com.tonbeller.wcf.utils.DomUtils;
import java.io.IOException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.tagext.Tag;
import javax.servlet.jsp.tagext.TagSupport;
import org.apache.log4j.Logger;

public class ParamLinkTag
extends TagSupport {
    String page;
    String displayName;
    String displayValue;
    String paramName;
    String sqlValue;
    String mdxValue;
    String textValue;
    String target;
    boolean token;
    ClickHandler clickHandler;
    private static Logger logger = Logger.getLogger(ParamLinkTag.class);
    ParamLinkGroupTag groupTag;

    public int doStartTag() throws JspException {
        try {
            this.clickHandler = null;
            this.groupTag = (ParamLinkGroupTag)ParamLinkTag.findAncestorWithClass((Tag)this, ParamLinkGroupTag.class);
            if (this.groupTag == null) {
                throw new JspException("ParamLinkTag must be used inside a ParamLinkGroupTag");
            }
            if (!this.groupTag.isRenderActions()) {
                return 1;
            }
            String id = DomUtils.randomId();
            this.clickHandler = new ClickHandler(this.evalString(this.page));
            this.groupTag.getDispatcher().addRequestListener(this.groupTag.getId(), id, this.clickHandler);
            Resources res = Resources.instance(ParamLinkTag.class);
            String htmlTarget = "";
            if (this.getTarget() != null) {
                htmlTarget = " " + res.getString("jsp.wcf.paramLinkTag.targetTag", this.getTarget());
            }
            String href = "?" + this.groupTag.getId() + "=" + id;
            if (this.token) {
                RequestToken rt = RequestToken.instance(this.pageContext.getSession());
                href = rt.appendHttpParameter(href);
            }
            Object[] args = new Object[]{href, htmlTarget};
            String s = res.getString("jsp.wcf.paramLinkTag.startTag", args);
            this.pageContext.getOut().print(s);
            if (this.paramName != null) {
                this.addParam(this.paramName, this.displayName, this.displayValue, this.sqlValue, this.mdxValue, this.textValue);
            }
        }
        catch (IOException e) {
            logger.error(null, (Throwable)e);
        }
        return 1;
    }

    public void addParam(String paramName, String displayName, String displayValue, String sqlValue, String mdxValue, String textValue) {
        if (paramName == null) {
            throw new IllegalArgumentException("parameter name is null");
        }
        SessionParam p = new SessionParam();
        p.setName(paramName);
        p.setDisplayName(this.evalString(displayName));
        p.setDisplayValue(this.evalString(displayValue));
        p.setTextValue(this.evalString(textValue));
        p.setMdxValue(mdxValue);
        p.setSqlValue(this.eval(sqlValue));
        this.addParam(p);
    }

    public void addParam(SessionParam p) {
        if (this.clickHandler != null) {
            this.clickHandler.addParam(p);
        }
    }

    public void addAction(Action a) {
        if (this.clickHandler != null) {
            this.clickHandler.addAction(a);
        }
    }

    public int doEndTag() throws JspException {
        if (!this.groupTag.isRenderActions()) {
            return super.doEndTag();
        }
        try {
            Resources res = Resources.instance(ParamLinkTag.class);
            String s = res.getString("jsp.wcf.paramLinkTag.endTag");
            this.pageContext.getOut().print(s);
        }
        catch (IOException e) {
            logger.error(null, (Throwable)e);
        }
        this.clickHandler = null;
        return super.doEndTag();
    }

    private Object eval(String expr) {
        if (expr == null) {
            return null;
        }
        if (ExprUtils.isExpression(expr)) {
            return ExprUtils.getModelReference(this.pageContext, expr);
        }
        return expr;
    }

    private String evalString(String expr) {
        if (expr == null) {
            return null;
        }
        if (ExprUtils.isExpression(expr)) {
            return String.valueOf(ExprUtils.getModelReference(this.pageContext, expr));
        }
        return expr;
    }

    public void setDisplayName(String displayName) {
        this.displayName = displayName;
    }

    public void setDisplayValue(String displayValue) {
        this.displayValue = displayValue;
    }

    public void setMdxValue(String mdxValue) {
        this.mdxValue = mdxValue;
    }

    public void setParamName(String paramName) {
        this.paramName = paramName;
    }

    public void setSqlValue(String sqlValue) {
        this.sqlValue = sqlValue;
    }

    public void setPage(String page) {
        this.page = page;
    }

    public String getTextValue() {
        return this.textValue;
    }

    public void setTextValue(String textValue) {
        this.textValue = textValue;
    }

    public void setTarget(String target) {
        this.target = target;
    }

    public String getTarget() {
        return this.target;
    }

    public void setToken(boolean token) {
        this.token = token;
    }

    static class ClickHandler
    implements RequestListener {
        private List params = new ArrayList();
        private List actions = new ArrayList();
        private String page;

        ClickHandler(String page) {
            this.page = page;
        }

        public void addParam(SessionParam param) {
            this.params.add(param);
        }

        public void addAction(Action action) {
            this.actions.add(action);
        }

        public void request(RequestContext context) throws Exception {
            SessionParamPool pool = SessionParamPool.instance(context.getSession());
            for (SessionParam p : this.params) {
                if (logger.isInfoEnabled()) {
                    logger.info((Object)("setting parameter: " + p));
                }
                pool.setParam(p);
            }
            for (Action a : this.actions) {
                a.execute(context);
            }
            if (this.page != null) {
                Controller.instance(context.getSession()).setNextView(this.page);
            }
        }
    }

    public static class InvokeMethodAction
    implements Action {
        private String methodName;
        private String targetExpr;

        InvokeMethodAction(String targetExpr, String methodName) {
            this.targetExpr = targetExpr;
            this.methodName = methodName;
        }

        public void execute(RequestContext context) throws Exception {
            Object target = context.getModelReference(this.targetExpr);
            Class<?> c = target.getClass();
            Method m = c.getMethod(this.methodName, RequestContext.class);
            m.invoke(target, context);
        }
    }

    public static interface Action {
        public void execute(RequestContext var1) throws Exception;
    }
}

