/*
 * Decompiled with CFR 0.152.
 */
package com.tonbeller.wcf.convert;

import com.tonbeller.wcf.convert.NodeConverterBase;
import com.tonbeller.wcf.format.FormatException;
import com.tonbeller.wcf.format.FormatHandler;
import com.tonbeller.wcf.format.Formatter;
import com.tonbeller.wcf.ui.EditCtrl;
import com.tonbeller.wcf.ui.TypedCtrl;
import com.tonbeller.wcf.utils.XoplonNS;
import java.lang.reflect.InvocationTargetException;
import java.util.Map;
import org.apache.commons.beanutils.PropertyUtils;
import org.apache.log4j.Logger;
import org.w3c.dom.Element;

public class EditCtrlConverter
extends NodeConverterBase {
    private static Logger logger = Logger.getLogger(EditCtrlConverter.class);
    private Map param = null;

    public void convert(Formatter formatter, Map param, Map fileSource, Element element, Object bean) throws FormatException, IllegalAccessException, NoSuchMethodException, InvocationTargetException {
        if (TypedCtrl.isDisabled(element)) {
            return;
        }
        String id = EditCtrl.getId(element);
        String[] inputValue = (String[])param.get(id);
        this.param = param;
        if (inputValue != null && inputValue.length > 0) {
            XoplonNS.removeAttribute(element, "error");
            String formatString = EditCtrl.getFormatString(element);
            String strValue = null;
            try {
                this.checkRequired(formatter.getLocale(), element, inputValue[0].trim().length() == 0);
                String type = EditCtrl.getType(element);
                FormatHandler handler = formatter.getHandler(type);
                if (handler == null) {
                    throw new FormatException("no handler found for type: " + type);
                }
                Object newValue = handler.parse(inputValue[0], formatString);
                strValue = handler.format(newValue, formatString);
                EditCtrl.setValue(element, strValue);
                String model = EditCtrl.getModelReference(element);
                if (bean != null && model.length() > 0) {
                    PropertyUtils.setProperty((Object)bean, (String)model, (Object)newValue);
                }
            }
            catch (IllegalAccessException e) {
                logger.error((Object)"exception caught", (Throwable)e);
                XoplonNS.setAttribute(element, "error", e.getMessage());
                XoplonNS.setAttribute(element, "value", strValue);
                throw e;
            }
            catch (NoSuchMethodException e) {
                logger.error((Object)"exception caught", (Throwable)e);
                XoplonNS.setAttribute(element, "error", e.getMessage());
                XoplonNS.setAttribute(element, "value", strValue);
                throw e;
            }
            catch (InvocationTargetException e) {
                logger.error((Object)"exception caught", (Throwable)e);
                XoplonNS.setAttribute(element, "error", e.getMessage());
                XoplonNS.setAttribute(element, "value", strValue);
                throw e;
            }
            catch (FormatException e) {
                logger.error((Object)("invalid user input: " + e.getMessage()));
                XoplonNS.setAttribute(element, "error", e.getMessage());
                XoplonNS.setAttribute(element, "value", strValue);
                throw e;
            }
        }
    }

    public void convert(Formatter formatter, Object bean, Element element) throws IllegalAccessException, NoSuchMethodException, InvocationTargetException {
        try {
            String model = EditCtrl.getModelReference(element);
            if (model.length() == 0) {
                return;
            }
            String type = EditCtrl.getType(element);
            FormatHandler handler = formatter.getHandler(type);
            if (handler == null) {
                throw new FormatException("no handler found for type: " + type);
            }
            Object value = PropertyUtils.getProperty((Object)bean, (String)model);
            String pattern = EditCtrl.getFormatString(element);
            String strValue = handler.format(value, pattern);
            EditCtrl.setValue(element, strValue);
        }
        catch (IllegalAccessException e) {
            XoplonNS.setAttribute(element, "error", e.getMessage());
            throw e;
        }
        catch (NoSuchMethodException e) {
            XoplonNS.setAttribute(element, "error", e.getMessage());
            throw e;
        }
        catch (InvocationTargetException e) {
            XoplonNS.setAttribute(element, "error", e.getMessage());
            throw e;
        }
        catch (FormatException e) {
            XoplonNS.setAttribute(element, "error", e.getMessage());
            throw e;
        }
    }
}

