/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.jasperserver.api.security.externalAuth;

import com.jaspersoft.jasperserver.api.JasperServerAPI;
import com.jaspersoft.jasperserver.api.security.externalAuth.ExternalDataSynchronizer;
import com.jaspersoft.jasperserver.api.security.internalAuth.InternalAuthenticationToken;
import java.io.IOException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.security.Authentication;
import org.springframework.security.context.SecurityContextHolder;
import org.springframework.security.ui.webapp.AuthenticationProcessingFilter;
import org.springframework.util.Assert;

@JasperServerAPI
public class BaseAuthenticationProcessingFilter
extends AuthenticationProcessingFilter {
    private ExternalDataSynchronizer externalDataSynchronizer;
    private String internalAuthenticationFailureUrl;

    public void afterPropertiesSet() throws Exception {
        super.afterPropertiesSet();
        Assert.notNull((Object)this.externalDataSynchronizer, (String)"externalDataSynchronizer cannot be null");
    }

    protected void onSuccessfulAuthentication(HttpServletRequest request, HttpServletResponse response, Authentication authResult) throws IOException {
        try {
            if (!(authResult instanceof InternalAuthenticationToken)) {
                this.externalDataSynchronizer.synchronize();
            }
        }
        catch (RuntimeException e) {
            SecurityContextHolder.getContext().setAuthentication(null);
            throw e;
        }
    }

    protected ExternalDataSynchronizer getExternalDataSynchronizer() {
        return this.externalDataSynchronizer;
    }

    public void setExternalDataSynchronizer(ExternalDataSynchronizer externalDataSynchronizer) {
        this.externalDataSynchronizer = externalDataSynchronizer;
    }

    public void setInternalAuthenticationFailureUrl(String internalAuthenticationFailureUrl) {
        this.setAuthenticationFailureUrl(internalAuthenticationFailureUrl);
    }
}

