/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.jasperserver.test;

import com.jaspersoft.jasperserver.api.metadata.user.domain.ProfileAttribute;
import com.jaspersoft.jasperserver.api.metadata.user.domain.User;
import com.jaspersoft.jasperserver.util.test.BaseServiceSetupTestNG;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.testng.AssertJUnit;
import org.testng.annotations.Test;

public class ProfileAttributeTestTestNG
extends BaseServiceSetupTestNG {
    protected static Log m_logger = LogFactory.getLog(ProfileAttributeTestTestNG.class);

    public ProfileAttributeTestTestNG() {
        m_logger.info((Object)"ProfileAttributeTestTestNG => constructor() called");
    }

    @Test
    public void doProfileAttributeServiceTest() {
        m_logger.info((Object)"ProfileAttributeTestTestNG => doProfileAttributeServiceTest() called");
        User caluser = this.createUser("CaliforniaUser", null, "CaliforniaUser");
        ProfileAttribute attr = this.createTestAttr(caluser, "State", "CA");
        this.getProfileAttributeService().putProfileAttribute(null, attr);
        attr = this.createTestAttr(caluser, "Cities", "San Francisco, Oakland, San Jose, Los Angeles, Sacramento, Fresno");
        this.getProfileAttributeService().putProfileAttribute(null, attr);
        List attrList = this.getProfileAttributeService().getProfileAttributesForPrincipal(null, (Object)caluser);
        AssertJUnit.assertTrue((String)"ProfileAttribute list was empty", (attrList.size() > 0 ? 1 : 0) != 0);
        Iterator it = attrList.iterator();
        while (!attrList.isEmpty() && it.hasNext()) {
            ProfileAttribute elem = (ProfileAttribute)it.next();
            if (!"State".equals(elem.getAttrName())) continue;
            AssertJUnit.assertTrue((String)"Test attribute did not match expected value", (boolean)"CA".equals(elem.getAttrValue()));
        }
        this.getUserAuthorityService().deleteUser(null, "CaliforniaUser");
    }
}

