/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.jasperserver.test;

import com.jaspersoft.jasperserver.api.common.domain.ExecutionContext;
import com.jaspersoft.jasperserver.api.metadata.common.domain.DataType;
import com.jaspersoft.jasperserver.api.metadata.common.domain.FileResource;
import com.jaspersoft.jasperserver.api.metadata.common.domain.Folder;
import com.jaspersoft.jasperserver.api.metadata.common.domain.InputControl;
import com.jaspersoft.jasperserver.api.metadata.common.domain.ListOfValues;
import com.jaspersoft.jasperserver.api.metadata.common.domain.ListOfValuesItem;
import com.jaspersoft.jasperserver.api.metadata.common.domain.Query;
import com.jaspersoft.jasperserver.api.metadata.common.domain.Resource;
import com.jaspersoft.jasperserver.api.metadata.common.domain.ResourceReference;
import com.jaspersoft.jasperserver.api.metadata.common.domain.client.DataTypeImpl;
import com.jaspersoft.jasperserver.api.metadata.common.domain.client.FolderImpl;
import com.jaspersoft.jasperserver.api.metadata.common.domain.client.ListOfValuesItemImpl;
import com.jaspersoft.jasperserver.api.metadata.jasperreports.domain.JdbcReportDataSource;
import com.jaspersoft.jasperserver.api.metadata.jasperreports.domain.JndiJdbcReportDataSource;
import com.jaspersoft.jasperserver.api.metadata.jasperreports.domain.ReportUnit;
import com.jaspersoft.jasperserver.api.metadata.jasperreports.domain.VirtualReportDataSource;
import com.jaspersoft.jasperserver.api.metadata.olap.domain.MondrianConnection;
import com.jaspersoft.jasperserver.api.metadata.olap.domain.MondrianXMLADefinition;
import com.jaspersoft.jasperserver.api.metadata.olap.domain.OlapUnit;
import com.jaspersoft.jasperserver.api.metadata.olap.domain.XMLAConnection;
import com.jaspersoft.jasperserver.api.metadata.olap.service.impl.OlapConnectionServiceImpl;
import com.jaspersoft.jasperserver.api.metadata.security.JasperServerAclEntry;
import com.jaspersoft.jasperserver.api.metadata.user.domain.Role;
import com.jaspersoft.jasperserver.api.metadata.user.domain.User;
import com.jaspersoft.jasperserver.util.test.BaseServiceSetupTestNG;
import com.jaspersoft.jasperserver.war.common.JasperServerUtil;
import java.io.InputStream;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.testng.annotations.AfterClass;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

public class FullDataCreateTestNG
extends BaseServiceSetupTestNG {
    protected final Log m_logger = LogFactory.getLog(FullDataCreateTestNG.class);
    protected final String foodMartSchema2012URI = "/queries/FoodmartSchema2012.xml";
    protected final String foodMartSchema2012UpperURI = "/queries/FoodmartSchema2012Upper.xml";
    protected final String foodMartJaSchemaURI = "/queries/FoodMart_ja.xml";
    protected final String sugarCRMSchemaURI = "/queries/SugarCRMSchema.xml";
    protected final String sugarCRMSchemaUpperURI = "/queries/SugarcrmSchemaUpper.xml";
    private OlapConnectionServiceImpl olapConnectionServiceTarget;
    public static String SAMPLE_FOODMART_MDX_QUERY = "select {[Measures].[Unit Sales], [Measures].[Store Cost], [Measures].[Store Sales]} on columns, {([Promotion Media].[All Media], [Product].[All Products])} ON rows from Sales ";
    private String SAMPLE_SUGAR_CRM_MDX_QUERY = "select {[Measures].[Total Sale Amount], [Measures].[Number of Sales], [Measures].[Avg Sale Amount], [Measures].[Avg Time To Close (Days)], [Measures].[Avg Close Probability]} ON COLUMNS,  NON EMPTY {([Account Categorization].[All Accounts], [Close Period].[All Periods])} ON ROWS  from [SalesAnalysis]  where [Sale State].[All Types].[Closed Won]";
    public static String SAMPLE_FOODMART_JA_MDX_QUERY = "select {[Measures].[Unit Sales\u65e5\u672c\u8a9e], [Measures].[Store Cost\u65e5\u672c\u8a9e], [Measures].[Store Sales\u65e5\u672c\u8a9e]} on columns, {([Promotion Media\u65e5\u672c\u8a9e].[All Media\u65e5\u672c\u8a9e], [Product\u65e5\u672c\u8a9e].[All Products\u65e5\u672c\u8a9e])} ON rows from [Sales\u65e5\u672c\u8a9e]";
    private final boolean DO_PSEUDO_JAPANESE_FOODMART = false;
    private static final String FOODMART_REPORT_JRXML = "/reports/jasper/MondrianFoodMartSalesReport2012.jrxml";

    @BeforeClass
    protected void onSetUp() throws Exception {
        this.m_logger.info((Object)"onSetUp() called");
    }

    @AfterClass
    public void onTearDown() {
        this.m_logger.info((Object)"onTearDown() called");
    }

    @Test
    public void createFullDataResources() throws Exception {
        this.m_logger.info((Object)"createFullDataResources() called");
        this.addHibernateRepositoryDataSourceResources();
        this.addHibernateRepositoryReportResources();
        this.addContentRepositoryTestResources();
        this.addUserAuthorityServiceTestResources();
        this.addOlapConnectionResources();
        this.addOlapDependentReportResources();
    }

    private void addOlapDependentReportResources() {
        this.m_logger.info((Object)"addOlapDependentReportResources() called");
        Folder folder = this.getUnsecureRepositoryService().getFolder(null, "/reports/samples");
        this.createDepartmentReport(folder);
    }

    private void addUserAuthorityServiceTestResources() {
        this.m_logger.info((Object)"addUserAuthorityServiceTestResources() called");
        User newUser = this.createUser("joeuser", "joeuser", "Joe User");
        this.addRole(newUser, "ROLE_USER");
    }

    private void addContentRepositoryTestResources() {
        this.m_logger.info((Object)"addContentRepositoryTestResources() called");
        this.m_logger.info((Object)"addContentRepositoryTestResources() => creating /ContentFiles");
        FolderImpl dsFolder = new FolderImpl();
        dsFolder.setName("ContentFiles");
        dsFolder.setLabel("Content Files");
        dsFolder.setDescription("Content files generated by reports");
        this.getUnsecureRepositoryService().saveFolder(null, (Folder)dsFolder);
        this.m_logger.info((Object)"addContentRepositoryTestResources() => creating /ContentFiles/html");
        FolderImpl newFolder = new FolderImpl();
        newFolder.setParentFolder((Folder)dsFolder);
        newFolder.setName("html");
        newFolder.setLabel("html");
        this.getUnsecureRepositoryService().saveFolder(null, (Folder)newFolder);
        this.m_logger.info((Object)"addContentRepositoryTestResources() => creating /ContentFiles/pdf");
        newFolder = new FolderImpl();
        newFolder.setParentFolder((Folder)dsFolder);
        newFolder.setName("pdf");
        newFolder.setLabel("pdf");
        this.getUnsecureRepositoryService().saveFolder(null, (Folder)newFolder);
        this.m_logger.info((Object)"addContentRepositoryTestResources() => creating /ContentFiles/xls");
        newFolder = new FolderImpl();
        newFolder.setParentFolder((Folder)dsFolder);
        newFolder.setName("xls");
        newFolder.setLabel("xls");
        this.getUnsecureRepositoryService().saveFolder(null, (Folder)newFolder);
    }

    private void addHibernateRepositoryDataSourceResources() {
        this.m_logger.info((Object)"addHibernateRepositoryDataSourceResources() called");
        this.m_logger.info((Object)"addHibernateRepositoryDataSourceResources() => creating /datasources");
        FolderImpl dsFolder = new FolderImpl();
        dsFolder.setName("datasources");
        dsFolder.setLabel("Data Sources");
        dsFolder.setDescription("Data Sources used by reports");
        this.getUnsecureRepositoryService().saveFolder(null, (Folder)dsFolder);
        this.createJndiDS();
        this.createRepoDS();
        this.createJdbcDS();
    }

    private void addHibernateRepositoryReportResources() {
        this.m_logger.info((Object)"addHibernateRepositoryReportResources() called");
        this.m_logger.info((Object)"addHibernateRepositoryReportResources() => creating /reports");
        FolderImpl reportsFolder = new FolderImpl();
        reportsFolder.setName("reports");
        reportsFolder.setLabel("Reports");
        reportsFolder.setDescription("Reports");
        this.getUnsecureRepositoryService().saveFolder(null, (Folder)reportsFolder);
        Role userRole = this.getRole("ROLE_USER");
        this.createObjectPermission("/reports", userRole, JasperServerAclEntry.READ_WRITE_CREATE_DELETE);
        this.m_logger.info((Object)"addHibernateRepositoryReportResources() => creating /reports/samples");
        FolderImpl samplesFolder = new FolderImpl();
        samplesFolder.setName("samples");
        samplesFolder.setLabel("Samples");
        samplesFolder.setDescription("Samples");
        samplesFolder.setParentFolder((Folder)reportsFolder);
        this.getUnsecureRepositoryService().saveFolder(null, (Folder)samplesFolder);
        this.createInteractiveFolderAndReportResources((Folder)reportsFolder);
        this.createImagesFolderAndSampleImage();
        this.createAllAccounts((Folder)samplesFolder);
        this.createSalesByMonth((Folder)samplesFolder);
        this.createEmployeeAccounts((Folder)samplesFolder);
        this.createEmployees((Folder)samplesFolder);
        this.createParamMany((Folder)samplesFolder);
        this.createAllCharts((Folder)samplesFolder);
        this.createAllCascading((Folder)samplesFolder);
        this.m_logger.info((Object)"addHibernateRepositoryReportResources() => adding /analysis");
        FolderImpl olapFolder = new FolderImpl();
        olapFolder.setName("analysis");
        olapFolder.setLabel("Analysis Components");
        olapFolder.setDescription("Analysis Components");
        this.getUnsecureRepositoryService().saveFolder(null, (Folder)olapFolder);
        this.m_logger.info((Object)"addHibernateRepositoryReportResources() => adding /analysis/connections");
        FolderImpl connectionsFolder = new FolderImpl();
        connectionsFolder.setName("connections");
        connectionsFolder.setLabel("Analysis Connections");
        connectionsFolder.setDescription("Connections used by Analysis");
        connectionsFolder.setParentFolder((Folder)olapFolder);
        this.getUnsecureRepositoryService().saveFolder(null, (Folder)connectionsFolder);
        this.m_logger.info((Object)"addHibernateRepositoryReportResources() => adding /analysis/schemas");
        FolderImpl schemasFolder = new FolderImpl();
        schemasFolder.setName("schemas");
        schemasFolder.setLabel("Analysis Schemas");
        schemasFolder.setDescription("Schemas used by Analysis");
        schemasFolder.setParentFolder((Folder)olapFolder);
        this.getUnsecureRepositoryService().saveFolder(null, (Folder)schemasFolder);
        this.m_logger.info((Object)"addHibernateRepositoryReportResources() => adding /analysis/datasources");
        FolderImpl olapDsFolder = new FolderImpl();
        olapDsFolder.setName("datasources");
        olapDsFolder.setLabel("Analysis Data Sources");
        olapDsFolder.setDescription("Data sources used by Analysis");
        olapDsFolder.setParentFolder((Folder)olapFolder);
        this.getUnsecureRepositoryService().saveFolder(null, (Folder)olapDsFolder);
        this.m_logger.info((Object)"addHibernateRepositoryReportResources() => adding /analysis/views");
        FolderImpl olapViewsFolder = new FolderImpl();
        olapViewsFolder.setName("views");
        olapViewsFolder.setLabel("Analysis Views");
        olapViewsFolder.setDescription("Analysis Views");
        olapViewsFolder.setParentFolder((Folder)olapFolder);
        this.getUnsecureRepositoryService().saveFolder(null, (Folder)olapViewsFolder);
        this.setupExecuteOnlyPermissions();
        this.setupNoAccessPermissions();
    }

    private void setupExecuteOnlyPermissions() {
        Role userRole = this.getRole("ROLE_USER");
        this.createObjectPermission("/datasources", userRole, JasperServerAclEntry.EXECUTE);
        this.createObjectPermission("/images", userRole, JasperServerAclEntry.EXECUTE);
        this.createObjectPermission("/themes", userRole, JasperServerAclEntry.EXECUTE);
    }

    private void setupNoAccessPermissions() {
        Role userRole = this.getRole("ROLE_USER");
        this.createObjectPermission("/datasources/repositoryDS", userRole, 0);
        this.createObjectPermission("/reports/samples/PermissionsOfUsersWithARoleSharedByLoggedIn", userRole, 0);
    }

    private void createImagesFolderAndSampleImage() {
        this.m_logger.info((Object)"createImagesFolderAndSampleImage() => creating /images");
        FolderImpl folder = new FolderImpl();
        folder.setName("images");
        folder.setLabel("Images");
        folder.setDescription("Folder containing reusable images");
        this.getUnsecureRepositoryService().saveFolder(null, (Folder)folder);
        this.m_logger.info((Object)"createImagesFolderAndSampleImage() => creating /images/JRLogo");
        FileResource image = (FileResource)this.getUnsecureRepositoryService().newResource(null, FileResource.class);
        image.setFileType("img");
        image.readData(((Object)((Object)this)).getClass().getResourceAsStream("/images/jasperreports.png"));
        image.setName("JRLogo");
        image.setLabel("JR logo");
        image.setDescription("JR logo");
        image.setParentFolder((Folder)folder);
        this.getUnsecureRepositoryService().saveResource(null, (Resource)image);
    }

    private void createJndiDS() {
        JndiJdbcReportDataSource datasource = (JndiJdbcReportDataSource)this.getUnsecureRepositoryService().newResource(null, JndiJdbcReportDataSource.class);
        datasource.setName("JServerJNDIDS");
        datasource.setLabel("JServer JNDI Data Source");
        datasource.setDescription("JServer JNDI Data Source");
        datasource.setJndiName(this.getJdbcProps().getProperty("test.jndi"));
        datasource.setParentFolder("/datasources");
        this.getUnsecureRepositoryService().saveResource(null, (Resource)datasource);
    }

    private void createRepoDS() {
        JndiJdbcReportDataSource datasource = (JndiJdbcReportDataSource)this.getUnsecureRepositoryService().newResource(null, JndiJdbcReportDataSource.class);
        datasource.setName("repositoryDS");
        datasource.setLabel("Jasperserver Repository SQL data source");
        datasource.setDescription("Jasperserver Repository SQL data source for reporting");
        datasource.setJndiName(this.getJdbcProps().getProperty("metadata.jndi"));
        datasource.setParentFolder("/datasources");
        this.getUnsecureRepositoryService().saveResource(null, (Resource)datasource);
    }

    private void createJdbcDS() {
        JdbcReportDataSource datasource = (JdbcReportDataSource)this.getUnsecureRepositoryService().newResource(null, JdbcReportDataSource.class);
        datasource.setName("JServerJdbcDS");
        datasource.setLabel("JServer Jdbc Data Source");
        datasource.setDescription("JServer Jdbc Data Source");
        datasource.setParentFolder("/datasources");
        datasource.setDriverClass(this.getJdbcProps().getProperty("test.jdbc.driverClassName"));
        datasource.setConnectionUrl(this.getJdbcProps().getProperty("test.jdbc.url"));
        datasource.setUsername(this.getJdbcProps().getProperty("test.jdbc.username"));
        datasource.setPassword(this.getJdbcProps().getProperty("test.jdbc.password"));
        this.getUnsecureRepositoryService().saveResource(null, (Resource)datasource);
    }

    private void createSalesByMonth(Folder folder) {
        this.m_logger.info((Object)"createSalesByMonth() => creating /reports/samples/SalesByMonth");
        FileResource reportRes = (FileResource)this.getUnsecureRepositoryService().newResource(null, FileResource.class);
        reportRes.setFileType("jrxml");
        reportRes.setName("SalesByMonthReport");
        reportRes.setLabel("Sales By Month Jasper Report");
        reportRes.setDescription("Sales By Month Jasper Report");
        InputStream jrxml = ((Object)((Object)this)).getClass().getResourceAsStream("/reports/jasper/SalesByMonth.jrxml");
        reportRes.readData(jrxml);
        ReportUnit unit = (ReportUnit)this.getUnsecureRepositoryService().newResource(null, ReportUnit.class);
        unit.setName("SalesByMonth");
        unit.setLabel("Sales By Month Report");
        unit.setDescription("Sales By Month Report");
        unit.setParentFolder(folder);
        unit.setDataSourceReference("/datasources/JServerJNDIDS");
        unit.setMainReport(reportRes);
        FileResource jar = (FileResource)this.getUnsecureRepositoryService().newResource(null, FileResource.class);
        jar.setFileType("jar");
        jar.readData(((Object)((Object)this)).getClass().getResourceAsStream("/jars/scriptlet.jar"));
        this.setCommon((Resource)jar, "Scriptlet");
        unit.addResource(jar);
        FileResource img = (FileResource)this.getUnsecureRepositoryService().newResource(null, FileResource.class);
        img.setFileType("img");
        img.readData(((Object)((Object)this)).getClass().getResourceAsStream("/images/jasperreports.png"));
        this.setCommon((Resource)img, "Logo");
        unit.addResource(img);
        FileResource subrep = (FileResource)this.getUnsecureRepositoryService().newResource(null, FileResource.class);
        subrep.setFileType("jrxml");
        subrep.readData(((Object)((Object)this)).getClass().getResourceAsStream("/reports/jasper/SalesByMonthDetail.jrxml"));
        this.setCommon((Resource)subrep, "SalesByMonthDetail");
        unit.addResource(subrep);
        FileResource resBdl = (FileResource)this.getUnsecureRepositoryService().newResource(null, FileResource.class);
        resBdl.setFileType("prop");
        resBdl.readData(((Object)((Object)this)).getClass().getResourceAsStream("/resource_bundles/sales.properties"));
        this.setCommon((Resource)resBdl, "sales.properties");
        unit.addResource(resBdl);
        FileResource resBdl_ro = (FileResource)this.getUnsecureRepositoryService().newResource(null, FileResource.class);
        resBdl_ro.setFileType("prop");
        resBdl_ro.readData(((Object)((Object)this)).getClass().getResourceAsStream("/resource_bundles/sales_ro.properties"));
        this.setCommon((Resource)resBdl_ro, "sales_ro.properties");
        unit.addResource(resBdl_ro);
        InputControl textInputCtrl = (InputControl)this.getUnsecureRepositoryService().newResource(null, InputControl.class);
        this.setCommon((Resource)textInputCtrl, "TextInputControl");
        textInputCtrl.setType((byte)2);
        textInputCtrl.setMandatory(false);
        textInputCtrl.setReadOnly(false);
        textInputCtrl.setVisible(true);
        textInputCtrl.setLabel("Text Input Control");
        textInputCtrl.setName("TextInput");
        DataTypeImpl dataType = new DataTypeImpl();
        dataType.setName("test");
        dataType.setLabel("test");
        dataType.setType((byte)2);
        textInputCtrl.setDataType((DataType)dataType);
        unit.addInputControl(textInputCtrl);
        InputControl checkboxInputControl = (InputControl)this.getUnsecureRepositoryService().newResource(null, InputControl.class);
        this.setCommon((Resource)checkboxInputControl, "CheckboxInputControl");
        checkboxInputControl.setType((byte)1);
        checkboxInputControl.setMandatory(true);
        checkboxInputControl.setReadOnly(false);
        checkboxInputControl.setVisible(true);
        checkboxInputControl.setLabel("Checkbox Input Control");
        checkboxInputControl.setName("CheckboxInput");
        unit.addInputControl(checkboxInputControl);
        InputControl listInputControl = (InputControl)this.getUnsecureRepositoryService().newResource(null, InputControl.class);
        this.setCommon((Resource)listInputControl, "ListInputControl");
        listInputControl.setType((byte)3);
        listInputControl.setMandatory(true);
        listInputControl.setReadOnly(false);
        listInputControl.setVisible(true);
        listInputControl.setLabel("List Input Control");
        listInputControl.setName("ListInput");
        ListOfValues values = (ListOfValues)this.getUnsecureRepositoryService().newResource(null, ListOfValues.class);
        values.setName("List_of_values");
        values.setLabel("List of values label");
        values.setDescription("List of values description");
        ListOfValuesItemImpl item = new ListOfValuesItemImpl();
        item.setLabel("An item");
        item.setValue((Object)"1");
        values.addValue((ListOfValuesItem)item);
        item = new ListOfValuesItemImpl();
        item.setLabel("Another item");
        item.setValue((Object)"2");
        values.addValue((ListOfValuesItem)item);
        item = new ListOfValuesItemImpl();
        item.setLabel("Yet another item");
        item.setValue((Object)"3");
        values.addValue((ListOfValuesItem)item);
        listInputControl.setListOfValues(values);
        dataType = new DataTypeImpl();
        dataType.setName("test");
        dataType.setLabel("test");
        dataType.setType((byte)1);
        listInputControl.setDataType((DataType)dataType);
        unit.addInputControl(listInputControl);
        this.createDateDatatype();
        InputControl dateInputCtrl = (InputControl)this.getUnsecureRepositoryService().newResource(null, InputControl.class);
        this.setCommon((Resource)dateInputCtrl, "DateInput");
        dateInputCtrl.setType((byte)2);
        dateInputCtrl.setMandatory(false);
        dateInputCtrl.setReadOnly(false);
        dateInputCtrl.setVisible(true);
        dateInputCtrl.setDataTypeReference("/datatypes/date");
        unit.addInputControl(dateInputCtrl);
        InputControl queryInputCtrl = (InputControl)this.getUnsecureRepositoryService().newResource(null, InputControl.class);
        this.setCommon((Resource)queryInputCtrl, "QueryInput");
        queryInputCtrl.setType((byte)4);
        queryInputCtrl.setMandatory(false);
        queryInputCtrl.setReadOnly(false);
        queryInputCtrl.setVisible(true);
        queryInputCtrl.setQueryValueColumn("user_name");
        queryInputCtrl.addQueryVisibleColumn("first_name");
        queryInputCtrl.addQueryVisibleColumn("last_name");
        Query query = (Query)this.getUnsecureRepositoryService().newResource(null, Query.class);
        this.setCommon((Resource)query, "testQuery");
        query.setLanguage("sql");
        query.setSql("select user_name, first_name, last_name from users");
        queryInputCtrl.setQuery(query);
        unit.addInputControl(queryInputCtrl);
        unit.setAlwaysPromptControls(false);
        this.getUnsecureRepositoryService().saveResource(null, (Resource)unit);
    }

    private void createEmployees(Folder folder) {
        this.m_logger.info((Object)"createEmployees() => creating /reports/samples/Employees");
        FileResource reportRes = (FileResource)this.getUnsecureRepositoryService().newResource(null, FileResource.class);
        reportRes.setFileType("jrxml");
        this.setCommon((Resource)reportRes, "EmployeesJRXML");
        InputStream jrxml = ((Object)((Object)this)).getClass().getResourceAsStream("/reports/jasper/Employees.jrxml");
        reportRes.readData(jrxml);
        ReportUnit unit = (ReportUnit)this.getUnsecureRepositoryService().newResource(null, ReportUnit.class);
        unit.setName("Employees");
        unit.setLabel("Employee List");
        unit.setDescription("Employee List");
        unit.setParentFolder(folder);
        unit.setDataSourceReference("/datasources/JServerJNDIDS");
        unit.setMainReport(reportRes);
        this.getUnsecureRepositoryService().saveResource(null, (Resource)unit);
    }

    private void createEmployeeAccounts(Folder folder) {
        this.m_logger.info((Object)"createEmployeeAccounts() => creating /reports/samples/EmployeeAccounts");
        FileResource reportRes = (FileResource)this.getUnsecureRepositoryService().newResource(null, FileResource.class);
        reportRes.setFileType("jrxml");
        this.setCommon((Resource)reportRes, "EmployeeAccountsJRXML");
        InputStream jrxml = ((Object)((Object)this)).getClass().getResourceAsStream("/reports/jasper/EmployeeAccounts.jrxml");
        reportRes.readData(jrxml);
        ReportUnit unit = (ReportUnit)this.getUnsecureRepositoryService().newResource(null, ReportUnit.class);
        unit.setName("EmployeeAccounts");
        unit.setLabel("Employee Accounts");
        unit.setDescription("List of Accounts per Employee");
        unit.setParentFolder(folder);
        unit.setDataSourceReference("/datasources/JServerJNDIDS");
        unit.setMainReport(reportRes);
        InputControl empIC = (InputControl)this.getUnsecureRepositoryService().newResource(null, InputControl.class);
        empIC.setName("EmployeeID");
        empIC.setLabel("Employee");
        empIC.setMandatory(true);
        Query empQuery = (Query)this.getUnsecureRepositoryService().newResource(null, Query.class);
        empQuery.setName("EmployeeQuery");
        empQuery.setLabel("Employee Query");
        empQuery.setLanguage("sql");
        empQuery.setSql("SELECT id, user_name FROM users WHERE employee_status = 'Active'");
        empIC.setType((byte)4);
        empIC.setQuery(empQuery);
        empIC.setQueryValueColumn("id");
        empIC.addQueryVisibleColumn("user_name");
        unit.addInputControl(empIC);
        unit.setAlwaysPromptControls(false);
        this.getUnsecureRepositoryService().saveResource(null, (Resource)unit);
    }

    private void createParamMany(Folder folder) {
        this.m_logger.info((Object)"createParamMany() => creating /reports/samples/Freight");
        FileResource reportRes = (FileResource)this.getUnsecureRepositoryService().newResource(null, FileResource.class);
        reportRes.setFileType("jrxml");
        this.setCommon((Resource)reportRes, "ParametersJRXML");
        InputStream jrxml = ((Object)((Object)this)).getClass().getResourceAsStream("/reports/jasper/ParamMany.jrxml");
        reportRes.readData(jrxml);
        ReportUnit unit = (ReportUnit)this.getUnsecureRepositoryService().newResource(null, ReportUnit.class);
        unit.setName("Freight");
        unit.setLabel("Freight Report");
        unit.setDescription("Freight Report with Saved Parameters");
        unit.setParentFolder(folder);
        unit.setDataSourceReference("/datasources/JServerJNDIDS");
        unit.setMainReport(reportRes);
        InputControl countryIC = (InputControl)this.getUnsecureRepositoryService().newResource(null, InputControl.class);
        countryIC.setName("Country");
        countryIC.setLabel("Country");
        countryIC.setDescription("Country");
        countryIC.setMandatory(true);
        countryIC.setType((byte)4);
        Query countryQ = (Query)this.getUnsecureRepositoryService().newResource(null, Query.class);
        countryQ.setName("CountryQuery");
        countryQ.setLabel("CountryQuery");
        countryQ.setLanguage("sql");
        countryQ.setDataSourceReference("/datasources/JServerJNDIDS");
        countryQ.setSql("select distinct SHIPCOUNTRY from ORDERS");
        countryIC.setQuery(countryQ);
        countryIC.setQueryValueColumn("SHIPCOUNTRY");
        countryIC.addQueryVisibleColumn("SHIPCOUNTRY");
        unit.addInputControl(countryIC);
        InputControl requestDateIC = (InputControl)this.getUnsecureRepositoryService().newResource(null, InputControl.class);
        requestDateIC.setName("RequestDate");
        requestDateIC.setLabel("RequestDate");
        requestDateIC.setDescription("RequestDate");
        requestDateIC.setMandatory(false);
        requestDateIC.setType((byte)2);
        DataType dateDT = (DataType)this.getUnsecureRepositoryService().newResource(null, DataType.class);
        this.setCommon((Resource)dateDT, "Date");
        dateDT.setType((byte)3);
        requestDateIC.setDataType(dateDT);
        unit.addInputControl(requestDateIC);
        InputControl orderIdIC = (InputControl)this.getUnsecureRepositoryService().newResource(null, InputControl.class);
        orderIdIC.setName("OrderId");
        orderIdIC.setLabel("OrderId");
        orderIdIC.setDescription("OrderId");
        orderIdIC.setMandatory(false);
        orderIdIC.setType((byte)2);
        DataType numberDT = (DataType)this.getUnsecureRepositoryService().newResource(null, DataType.class);
        this.setCommon((Resource)numberDT, "Number");
        numberDT.setType((byte)2);
        orderIdIC.setDataType(numberDT);
        unit.addInputControl(orderIdIC);
        unit.setAlwaysPromptControls(false);
        this.getUnsecureRepositoryService().saveResource(null, (Resource)unit);
    }

    protected void createDateDatatype() {
        FolderImpl folder = new FolderImpl();
        folder.setName("datatypes");
        folder.setLabel("Input data Types");
        this.getUnsecureRepositoryService().saveFolder(null, (Folder)folder);
        DataTypeImpl dateDataType = new DataTypeImpl();
        this.setCommon((Resource)dateDataType, "date");
        dateDataType.setType((byte)3);
        dateDataType.setParentFolder((Folder)folder);
        this.getUnsecureRepositoryService().saveResource(null, (Resource)dateDataType);
    }

    private void setCommon(Resource res, String id) {
        res.setName(id);
        res.setLabel(id + " Label");
        res.setDescription(id + " description");
    }

    private void createAllAccounts(Folder folder) {
        this.m_logger.info((Object)"createAllAccounts() => creating /reports/samples/AllAccounts");
        FileResource reportRes = (FileResource)this.getUnsecureRepositoryService().newResource(null, FileResource.class);
        reportRes.setFileType("jrxml");
        reportRes.setName("AllAccountsReport");
        reportRes.setLabel("All Accounts Jasper Report");
        reportRes.setDescription("All Accounts Jasper Report");
        reportRes.setParentFolder(folder);
        InputStream jrxml = ((Object)((Object)this)).getClass().getResourceAsStream("/reports/jasper/AllAccounts.jrxml");
        reportRes.readData(jrxml);
        ReportUnit unit = (ReportUnit)this.getUnsecureRepositoryService().newResource(null, ReportUnit.class);
        unit.setName("AllAccounts");
        unit.setLabel("Accounts Report");
        unit.setDescription("All Accounts Report");
        unit.setParentFolder(folder);
        unit.setDataSourceReference("/datasources/JServerJNDIDS");
        unit.setMainReport(reportRes);
        FileResource res2 = (FileResource)this.getUnsecureRepositoryService().newResource(null, FileResource.class);
        res2.setFileType("img");
        res2.readData(((Object)((Object)this)).getClass().getResourceAsStream("/images/logo.jpg"));
        res2.setName("AllAccounts_Res2");
        res2.setLabel("AllAccounts_Res2");
        res2.setDescription("AllAccounts_Res2");
        unit.addResource(res2);
        FileResource res3 = (FileResource)this.getUnsecureRepositoryService().newResource(null, FileResource.class);
        res3.setFileType("img");
        res3.readData(((Object)((Object)this)).getClass().getResourceAsStream("/images/jasperreports.png"));
        res3.setName("AllAccounts_Res3");
        res3.setLabel("AllAccounts_Res3");
        res3.setDescription("AllAccounts_Res3");
        unit.addResource(res3);
        FileResource res4 = (FileResource)this.getUnsecureRepositoryService().newResource(null, FileResource.class);
        res4.setFileType("img");
        res4.setReferenceURI("/images/JRLogo");
        this.setCommon((Resource)res4, "LogoLink");
        unit.addResource(res4);
        this.getUnsecureRepositoryService().saveResource(null, (Resource)unit);
    }

    private void createAllCharts(Folder folder) {
        this.m_logger.info((Object)"createAllCharts() => creating /reports/samples/StandardChartsReport");
        FileResource reportRes = (FileResource)this.getUnsecureRepositoryService().newResource(null, FileResource.class);
        reportRes.setFileType("jrxml");
        reportRes.setName("StandardChartsReport");
        reportRes.setLabel("Standard Charts Report");
        reportRes.setDescription("Standard Charts Report");
        reportRes.setParentFolder(folder);
        InputStream jrxml = ((Object)((Object)this)).getClass().getResourceAsStream("/reports/jasper/StandardChartsReport.jrxml");
        reportRes.readData(jrxml);
        ReportUnit unit = (ReportUnit)this.getUnsecureRepositoryService().newResource(null, ReportUnit.class);
        unit.setName("StandardChartsReport");
        unit.setLabel("Standard Charts Report");
        unit.setDescription("Standard Charts Report");
        unit.setParentFolder(folder);
        unit.setDataSourceReference("/datasources/JServerJNDIDS");
        unit.setMainReport(reportRes);
        FileResource resBdl = (FileResource)this.getUnsecureRepositoryService().newResource(null, FileResource.class);
        resBdl.setFileType("prop");
        resBdl.readData(((Object)((Object)this)).getClass().getResourceAsStream("/resource_bundles/standardCharts.properties"));
        this.setCommon((Resource)resBdl, "standardCharts.properties");
        unit.addResource(resBdl);
        FileResource resBdl_ro = (FileResource)this.getUnsecureRepositoryService().newResource(null, FileResource.class);
        resBdl_ro.setFileType("prop");
        resBdl_ro.readData(((Object)((Object)this)).getClass().getResourceAsStream("/resource_bundles/standardCharts_ro.properties"));
        this.setCommon((Resource)resBdl_ro, "standardCharts_ro.properties");
        unit.addResource(resBdl_ro);
        this.getUnsecureRepositoryService().saveResource(null, (Resource)unit);
        this.m_logger.info((Object)"createAllCharts() => creating /reports/samples/StandardChartsAegeanReport");
        reportRes = (FileResource)this.getUnsecureRepositoryService().newResource(null, FileResource.class);
        reportRes.setFileType("jrxml");
        reportRes.setName("StandardChartsAegeanReport");
        reportRes.setLabel("Standard Charts Aegean Report");
        reportRes.setDescription("Standard Charts Aegean Report");
        reportRes.setParentFolder(folder);
        jrxml = ((Object)((Object)this)).getClass().getResourceAsStream("/reports/jasper/StandardChartsAegeanReport.jrxml");
        reportRes.readData(jrxml);
        unit = (ReportUnit)this.getUnsecureRepositoryService().newResource(null, ReportUnit.class);
        unit.setName("StandardChartsAegeanReport");
        unit.setLabel("Standard Charts Aegean Report");
        unit.setDescription("Standard Charts Aegean Report");
        unit.setParentFolder(folder);
        unit.setDataSourceReference("/datasources/JServerJNDIDS");
        unit.setMainReport(reportRes);
        resBdl = (FileResource)this.getUnsecureRepositoryService().newResource(null, FileResource.class);
        resBdl.setFileType("prop");
        resBdl.readData(((Object)((Object)this)).getClass().getResourceAsStream("/resource_bundles/standardCharts.properties"));
        this.setCommon((Resource)resBdl, "standardCharts.properties");
        unit.addResource(resBdl);
        resBdl_ro = (FileResource)this.getUnsecureRepositoryService().newResource(null, FileResource.class);
        resBdl_ro.setFileType("prop");
        resBdl_ro.readData(((Object)((Object)this)).getClass().getResourceAsStream("/resource_bundles/standardCharts_ro.properties"));
        this.setCommon((Resource)resBdl_ro, "standardCharts_ro.properties");
        unit.addResource(resBdl_ro);
        this.getUnsecureRepositoryService().saveResource(null, (Resource)unit);
        this.m_logger.info((Object)"createAllCharts() => creating /reports/samples/StandardChartsEyeCandyReport");
        reportRes = (FileResource)this.getUnsecureRepositoryService().newResource(null, FileResource.class);
        reportRes.setFileType("jrxml");
        reportRes.setName("StandardChartsEyeCandyReport");
        reportRes.setLabel("Standard Charts Eye Candy Report");
        reportRes.setDescription("Standard Charts Eye Candy Report");
        reportRes.setParentFolder(folder);
        jrxml = ((Object)((Object)this)).getClass().getResourceAsStream("/reports/jasper/StandardChartsEyeCandyReport.jrxml");
        reportRes.readData(jrxml);
        unit = (ReportUnit)this.getUnsecureRepositoryService().newResource(null, ReportUnit.class);
        unit.setName("StandardChartsEyeCandyReport");
        unit.setLabel("Standard Charts Eye Candy Report");
        unit.setDescription("Standard Charts Eye Candy Report");
        unit.setParentFolder(folder);
        unit.setDataSourceReference("/datasources/JServerJNDIDS");
        unit.setMainReport(reportRes);
        resBdl = (FileResource)this.getUnsecureRepositoryService().newResource(null, FileResource.class);
        resBdl.setFileType("prop");
        resBdl.readData(((Object)((Object)this)).getClass().getResourceAsStream("/resource_bundles/standardCharts.properties"));
        this.setCommon((Resource)resBdl, "standardCharts.properties");
        unit.addResource(resBdl);
        resBdl_ro = (FileResource)this.getUnsecureRepositoryService().newResource(null, FileResource.class);
        resBdl_ro.setFileType("prop");
        resBdl_ro.readData(((Object)((Object)this)).getClass().getResourceAsStream("/resource_bundles/standardCharts_ro.properties"));
        this.setCommon((Resource)resBdl_ro, "standardCharts_ro.properties");
        unit.addResource(resBdl_ro);
        this.getUnsecureRepositoryService().saveResource(null, (Resource)unit);
    }

    private void createAllCascading(Folder folder) {
        this.m_logger.info((Object)"createAllCascading() => creating /reports/samples/Cascading_multi_select_report");
        FileResource reportRes = (FileResource)this.getUnsecureRepositoryService().newResource(null, FileResource.class);
        reportRes.setFileType("jrxml");
        reportRes.setName("Cascading_multi_select_report");
        reportRes.setLabel("Cascading multi select example report");
        reportRes.setDescription("Shows cascading input controls. Multi-select and single select queries");
        reportRes.setParentFolder(folder);
        InputStream jrxml = ((Object)((Object)this)).getClass().getResourceAsStream("/reports/jasper/CascadingMultiSelectReport.jrxml");
        reportRes.readData(jrxml);
        ReportUnit unit = (ReportUnit)this.getUnsecureRepositoryService().newResource(null, ReportUnit.class);
        unit.setName("Cascading_multi_select_report");
        unit.setLabel("Cascading multi select example report");
        unit.setDescription("Example report with Cascading multi select input controls");
        unit.setParentFolder(folder);
        unit.setDataSourceReference("/datasources/JServerJNDIDS");
        unit.setMainReport(reportRes);
        FileResource img = (FileResource)this.getUnsecureRepositoryService().newResource(null, FileResource.class);
        img.setFileType("img");
        img.readData(((Object)((Object)this)).getClass().getResourceAsStream("/images/RightArrow.png"));
        this.setCommon((Resource)img, "RightArrow.png");
        unit.addResource(img);
        img = (FileResource)this.getUnsecureRepositoryService().newResource(null, FileResource.class);
        img.setFileType("img");
        img.readData(((Object)((Object)this)).getClass().getResourceAsStream("/images/js_samples.png"));
        this.setCommon((Resource)img, "js_samples.png");
        unit.addResource(img);
        unit.setControlsLayout((byte)4);
        InputControl countryIC = (InputControl)this.getUnsecureRepositoryService().newResource(null, InputControl.class);
        countryIC.setName("Country_multi_select");
        countryIC.setLabel("Country multi select");
        countryIC.setDescription("Country multi select");
        countryIC.setMandatory(true);
        countryIC.setType((byte)7);
        Query countryQ = (Query)this.getUnsecureRepositoryService().newResource(null, Query.class);
        countryQ.setName("country_query");
        countryQ.setLabel("Country Query");
        countryQ.setLanguage("sql");
        countryQ.setDataSourceReference("/datasources/JServerJNDIDS");
        countryQ.setSql("select distinct billing_address_country from accounts order by billing_address_country");
        countryIC.setQuery(countryQ);
        countryIC.setQueryValueColumn("billing_address_country");
        countryIC.addQueryVisibleColumn("billing_address_country");
        unit.addInputControl(countryIC);
        InputControl stateIC = (InputControl)this.getUnsecureRepositoryService().newResource(null, InputControl.class);
        stateIC.setName("Cascading_state_multi_select");
        stateIC.setLabel("Cascading state multi select control");
        stateIC.setDescription("Cascading state multi select control");
        stateIC.setMandatory(true);
        stateIC.setType((byte)7);
        Query stateQ = (Query)this.getUnsecureRepositoryService().newResource(null, Query.class);
        stateQ.setName("Cascading_state_query");
        stateQ.setLabel("Cascading state query");
        stateQ.setLanguage("sql");
        stateQ.setDataSourceReference("/datasources/JServerJNDIDS");
        stateQ.setSql("select distinct billing_address_state, billing_address_country from accounts where $X{IN, billing_address_country, Country_multi_select} order by billing_address_country, billing_address_state");
        stateIC.setQuery(stateQ);
        stateIC.setQueryValueColumn("billing_address_state");
        stateIC.addQueryVisibleColumn("billing_address_country");
        stateIC.addQueryVisibleColumn("billing_address_state");
        unit.addInputControl(stateIC);
        InputControl nameIC = (InputControl)this.getUnsecureRepositoryService().newResource(null, InputControl.class);
        nameIC.setName("Cascading_name_single_select");
        nameIC.setLabel("Cascading name single select");
        nameIC.setDescription("Cascading name single select");
        nameIC.setMandatory(true);
        nameIC.setType((byte)4);
        Query nameQ = (Query)this.getUnsecureRepositoryService().newResource(null, Query.class);
        nameQ.setName("country_state_to_name");
        nameQ.setLabel("Country State to Name");
        nameQ.setLanguage("sql");
        nameQ.setDataSourceReference("/datasources/JServerJNDIDS");
        nameQ.setSql("select name from accounts where $X{IN, billing_address_country, Country_multi_select} and $X{IN, billing_address_state, Cascading_state_multi_select} order by name");
        nameIC.setQuery(nameQ);
        nameIC.setQueryValueColumn("name");
        nameIC.addQueryVisibleColumn("name");
        unit.addInputControl(nameIC);
        unit.setAlwaysPromptControls(false);
        this.getUnsecureRepositoryService().saveResource(null, (Resource)unit);
        this.m_logger.info((Object)"createAllCascading() => creating /reports/samples/PermissionsOfUsersWithARoleSharedByLoggedIn");
        reportRes = (FileResource)this.getUnsecureRepositoryService().newResource(null, FileResource.class);
        reportRes.setFileType("jrxml");
        reportRes.setName("PermissionsOfUsersWithARoleSharedByLoggedIn");
        reportRes.setLabel("Permissions Of Users with a role shared by LoggedIn");
        reportRes.setDescription("Input control controlled by user profile");
        reportRes.setParentFolder(folder);
        String dbName = this.getJdbcProps().getProperty("test.databaseFlavor");
        jrxml = dbName != null && dbName.startsWith("postgre") ? ((Object)((Object)this)).getClass().getResourceAsStream("/reports/jasper/PermissionsOfUsersWithARoleSharedByLoggedIn_postgres.jrxml") : (dbName != null && dbName.startsWith("db2") ? ((Object)((Object)this)).getClass().getResourceAsStream("/reports/jasper/PermissionsOfUsersWithARoleSharedByLoggedIn_db2.jrxml") : (dbName != null && dbName.startsWith("sqlserver") ? ((Object)((Object)this)).getClass().getResourceAsStream("/reports/jasper/PermissionsOfUsersWithARoleSharedByLoggedIn_mssql.jrxml") : ((Object)((Object)this)).getClass().getResourceAsStream("/reports/jasper/PermissionsOfUsersWithARoleSharedByLoggedIn.jrxml")));
        reportRes.readData(jrxml);
        unit = (ReportUnit)this.getUnsecureRepositoryService().newResource(null, ReportUnit.class);
        unit.setName("PermissionsOfUsersWithARoleSharedByLoggedIn");
        unit.setLabel("Permissions Of Users with a role shared by LoggedIn");
        unit.setDescription("Input control controlled by user profile");
        unit.setParentFolder(folder);
        unit.setDataSourceReference("/datasources/repositoryDS");
        unit.setMainReport(reportRes);
        InputControl rolesIC = (InputControl)this.getUnsecureRepositoryService().newResource(null, InputControl.class);
        rolesIC.setName("RolesOfLoggedInUser");
        rolesIC.setLabel("Roles of LoggedIn User");
        rolesIC.setDescription("Roles of LoggedIn User");
        rolesIC.setMandatory(true);
        rolesIC.setType((byte)7);
        Query rolesQ = (Query)this.getUnsecureRepositoryService().newResource(null, Query.class);
        rolesQ.setName("RolesOfUserQuery");
        rolesQ.setLabel("RolesOfUserQuery");
        rolesQ.setLanguage("sql");
        rolesQ.setDataSourceReference("/datasources/repositoryDS");
        rolesQ.setSql("select rolename from JIRole where $X{IN, rolename, LoggedInUserRoles}");
        rolesIC.setQuery(rolesQ);
        rolesIC.setQueryValueColumn("rolename");
        rolesIC.addQueryVisibleColumn("rolename");
        unit.addInputControl(rolesIC);
        unit.setAlwaysPromptControls(true);
        this.getUnsecureRepositoryService().saveResource(null, (Resource)unit);
    }

    private void createDepartmentReport(Folder folder) {
        this.m_logger.info((Object)"createDepartmentReport() => creating /reports/samples/Department");
        FileResource reportRes = (FileResource)this.getUnsecureRepositoryService().newResource(null, FileResource.class);
        reportRes.setFileType("jrxml");
        this.setCommon((Resource)reportRes, "DepartmentJRXML");
        InputStream jrxml = ((Object)((Object)this)).getClass().getResourceAsStream("/reports/jasper/Department.jrxml");
        reportRes.readData(jrxml);
        ReportUnit unit = (ReportUnit)this.getUnsecureRepositoryService().newResource(null, ReportUnit.class);
        unit.setName("Department");
        unit.setLabel("Department");
        unit.setDescription("A report that displays multi-lingual input controls");
        unit.setParentFolder(folder);
        unit.setDataSourceReference("/analysis/datasources/FoodmartDataSourceJNDI");
        unit.setMainReport(reportRes);
        InputControl listInputControl = (InputControl)this.getUnsecureRepositoryService().newResource(null, InputControl.class);
        this.setCommon((Resource)listInputControl, "Gender");
        listInputControl.setType((byte)6);
        listInputControl.setMandatory(true);
        listInputControl.setReadOnly(false);
        listInputControl.setVisible(true);
        listInputControl.setLabel("$R{Gender}");
        listInputControl.setName("gender");
        ListOfValues values = (ListOfValues)this.getUnsecureRepositoryService().newResource(null, ListOfValues.class);
        values.setName("Gender_list_of_values");
        values.setLabel("Gender list of values label");
        values.setDescription("Gender list of values description");
        ListOfValuesItemImpl item = new ListOfValuesItemImpl();
        item.setLabel("$R{Male}");
        item.setValue((Object)"M");
        values.addValue((ListOfValuesItem)item);
        item = new ListOfValuesItemImpl();
        item.setLabel("$R{Female}");
        item.setValue((Object)"F");
        values.addValue((ListOfValuesItem)item);
        listInputControl.setListOfValues(values);
        DataTypeImpl dataType = new DataTypeImpl();
        dataType.setName("gender_type");
        dataType.setLabel("gender_type");
        dataType.setType((byte)1);
        listInputControl.setDataType((DataType)dataType);
        unit.addInputControl(listInputControl);
        listInputControl = (InputControl)this.getUnsecureRepositoryService().newResource(null, InputControl.class);
        this.setCommon((Resource)listInputControl, "Marital Status");
        listInputControl.setType((byte)10);
        listInputControl.setMandatory(true);
        listInputControl.setReadOnly(false);
        listInputControl.setVisible(true);
        listInputControl.setLabel("$R{MaritalStatus}");
        listInputControl.setName("maritalStatus");
        values = (ListOfValues)this.getUnsecureRepositoryService().newResource(null, ListOfValues.class);
        values.setName("Marital_status_list_of_values");
        values.setLabel("Marital status list of values");
        values.setDescription("Marital status list of values description");
        item = new ListOfValuesItemImpl();
        item.setLabel("$R{Married}");
        item.setValue((Object)"M");
        values.addValue((ListOfValuesItem)item);
        item = new ListOfValuesItemImpl();
        item.setLabel("$R{Single}");
        item.setValue((Object)"S");
        values.addValue((ListOfValuesItem)item);
        listInputControl.setListOfValues(values);
        dataType = new DataTypeImpl();
        dataType.setName("maritalStatus_type");
        dataType.setLabel("maritalStatus_type");
        dataType.setType((byte)1);
        listInputControl.setDataType((DataType)dataType);
        unit.addInputControl(listInputControl);
        listInputControl = (InputControl)this.getUnsecureRepositoryService().newResource(null, InputControl.class);
        this.setCommon((Resource)listInputControl, "Department");
        listInputControl.setType((byte)3);
        listInputControl.setMandatory(true);
        listInputControl.setReadOnly(false);
        listInputControl.setVisible(true);
        listInputControl.setLabel("$R{Department}");
        listInputControl.setName("department");
        values = (ListOfValues)this.getUnsecureRepositoryService().newResource(null, ListOfValues.class);
        values.setName("Department_list_of_values");
        values.setLabel("Department list of values label");
        values.setDescription("Department list of values description");
        item = new ListOfValuesItemImpl();
        item.setLabel("$R{Dep1}");
        item.setValue((Object)1);
        values.addValue((ListOfValuesItem)item);
        item = new ListOfValuesItemImpl();
        item.setLabel("$R{Dep2}");
        item.setValue((Object)2);
        values.addValue((ListOfValuesItem)item);
        item = new ListOfValuesItemImpl();
        item.setLabel("$R{Dep3}");
        item.setValue((Object)3);
        values.addValue((ListOfValuesItem)item);
        item = new ListOfValuesItemImpl();
        item.setLabel("$R{Dep4}");
        item.setValue((Object)4);
        values.addValue((ListOfValuesItem)item);
        item = new ListOfValuesItemImpl();
        item.setLabel("$R{Dep5}");
        item.setValue((Object)5);
        values.addValue((ListOfValuesItem)item);
        item = new ListOfValuesItemImpl();
        item.setLabel("$R{Dep11}");
        item.setValue((Object)11);
        values.addValue((ListOfValuesItem)item);
        item = new ListOfValuesItemImpl();
        item.setLabel("$R{Dep14}");
        item.setValue((Object)14);
        values.addValue((ListOfValuesItem)item);
        item = new ListOfValuesItemImpl();
        item.setLabel("$R{Dep15}");
        item.setValue((Object)15);
        values.addValue((ListOfValuesItem)item);
        item = new ListOfValuesItemImpl();
        item.setLabel("$R{Dep16}");
        item.setValue((Object)16);
        values.addValue((ListOfValuesItem)item);
        item = new ListOfValuesItemImpl();
        item.setLabel("$R{Dep17}");
        item.setValue((Object)17);
        values.addValue((ListOfValuesItem)item);
        item = new ListOfValuesItemImpl();
        item.setLabel("$R{Dep18}");
        item.setValue((Object)18);
        values.addValue((ListOfValuesItem)item);
        item = new ListOfValuesItemImpl();
        item.setLabel("$R{Dep19}");
        item.setValue((Object)19);
        values.addValue((ListOfValuesItem)item);
        listInputControl.setListOfValues(values);
        dataType = new DataTypeImpl();
        dataType.setName("department_type");
        dataType.setLabel("department_type");
        dataType.setType((byte)2);
        listInputControl.setDataType((DataType)dataType);
        unit.addInputControl(listInputControl);
        FileResource resBdl = (FileResource)this.getRepositoryService().newResource(null, FileResource.class);
        resBdl.setFileType("prop");
        resBdl.readData(((Object)((Object)this)).getClass().getResourceAsStream("/resource_bundles/department.properties"));
        this.setCommon((Resource)resBdl, "department.properties");
        unit.addResource(resBdl);
        resBdl = (FileResource)this.getRepositoryService().newResource(null, FileResource.class);
        resBdl.setFileType("prop");
        resBdl.readData(((Object)((Object)this)).getClass().getResourceAsStream("/resource_bundles/department_fr.properties"));
        this.setCommon((Resource)resBdl, "department_fr.properties");
        unit.addResource(resBdl);
        resBdl = (FileResource)this.getRepositoryService().newResource(null, FileResource.class);
        resBdl.setFileType("prop");
        resBdl.readData(((Object)((Object)this)).getClass().getResourceAsStream("/resource_bundles/department_es.properties"));
        this.setCommon((Resource)resBdl, "department_es.properties");
        unit.addResource(resBdl);
        this.getUnsecureRepositoryService().saveResource(null, (Resource)unit);
    }

    protected void createFoodmartSchemaResource() {
        this.m_logger.info((Object)"createFoodmartSchemaResource() => creating /analysis/schemas/FoodmartSchema");
        this.createOrUpdateSchemaResource("/analysis/schemas", "FoodmartSchema", "FoodmartSchema", "Foodmart Analysis Schema", "/queries/FoodmartSchema2012.xml");
    }

    protected void createFoodmartSchemaUpperResource() {
        this.m_logger.info((Object)"createFoodmartSchemaUpperResource() => creating /analysis/schemas/FoodmartSchemaUpper");
        this.createOrUpdateSchemaResource("/analysis/schemas", "FoodmartSchemaUpper", "Foodmart Schema Uppercase", "Foodmart Analysis Schema Uppercase", "/queries/FoodmartSchema2012Upper.xml");
    }

    protected void createSugarCRMSchemaResource() {
        this.m_logger.info((Object)"createSugarCRMSchemaResource() => creating /analysis/schemas/SugarCRMSchema");
        this.createOrUpdateSchemaResource("/analysis/schemas", "SugarCRMSchema", "SugarCRM Schema", "SugarCRM Analysis Schema", "/queries/SugarCRMSchema.xml");
    }

    protected void createSugarCRMSchemaUpperResource() {
        this.m_logger.info((Object)"createSugarCRMSchemaUpperResource() => creating /analysis/schemas/SugarCRMSchemaUpper");
        this.createOrUpdateSchemaResource("/analysis/schemas", "SugarCRMSchemaUpper", "SugarCRM Schema Uppercase", "SugarCRM Analysis Schema Upper Case", "/queries/SugarcrmSchemaUpper.xml");
    }

    protected void createFoodmartJDBCDataSourceResource() throws Exception {
        this.m_logger.info((Object)"createFoodmartJDBCDataSourceResource() => creating /analysis/datasources/FoodmartDataSource");
        this.createJDBCDataSourceResource("/analysis/datasources", "FoodmartDataSource", "Foodmart Data Source", "Foodmart Data Source", this.getJdbcProps().getProperty("foodmart.jdbc.driverClassName"), this.getJdbcProps().getProperty("foodmart.jdbc.url"), this.getJdbcProps().getProperty("foodmart.jdbc.username"), this.getJdbcProps().getProperty("foodmart.jdbc.password"));
    }

    protected void createFoodmartJNDIDataSourceResource() {
        this.m_logger.info((Object)"createFoodmartJNDIDataSourceResource() => creating /analysis/datasources/FoodmartDataSourceJNDI");
        this.createJNDIDataSourceResource("/analysis/datasources", "FoodmartDataSourceJNDI", "Foodmart Data Source JNDI", "Foodmart Data Source JNDI", "jdbc/foodmart");
    }

    protected void createSugarCRMDataSourceResource() throws Exception {
        this.m_logger.info((Object)"createSugarCRMDataSourceResource() => creating /analysis/datasources/SugarCRMDataSource");
        this.createJDBCDataSourceResource("/analysis/datasources", "SugarCRMDataSource", "SugarCRM Data Source", "SugarCRM Data Source", this.getJdbcProps().getProperty("test.jdbc.driverClassName"), this.getJdbcProps().getProperty("test.jdbc.url"), this.getJdbcProps().getProperty("test.jdbc.username"), this.getJdbcProps().getProperty("test.jdbc.password"));
    }

    protected void createSugarCRMDataSourceResourceJNDI() {
        this.m_logger.info((Object)"createSugarCRMDataSourceResourceJNDI() => creating /analysis/datasources/SugarCRMDataSourceJNDI");
        this.createJNDIDataSourceResource("/analysis/datasources", "SugarCRMDataSourceJNDI", "SugarCRM Data Source JNDI", "SugarCRM Data Source JNDI", "jdbc/sugarcrm");
    }

    protected void createSugarFoodmartDataSourceResourceVirtual() {
        this.m_logger.info((Object)"createSugarCRMDataSourceResourceVirtual() => creating /datasources/SugarFoodmartVDS");
        HashMap<String, String> dataSourceUriMap = new HashMap<String, String>();
        dataSourceUriMap.put("FoodmartDataSource", "FoodmartDataSourceJNDI");
        dataSourceUriMap.put("SugarCRMDataSource", "SugarCRMDataSourceJNDI");
        this.createVirtualDataSourceResource("/datasources", "/analysis/datasources", "SugarFoodmartVDS", "SugarCRM-Foodmart Virtual Data Source", "Virtual Data Source Combining SugarCRM and Foodmart", dataSourceUriMap);
    }

    public void createVirtualDataSourceResource(String dataSourceFolderParentURI, String subDataSourceFolderParentURI, String dataSourceName, String dataSourceLabel, String dataSourceDescription, Map<String, String> dataSourceIDMap) {
        VirtualReportDataSource dataSourceResource = (VirtualReportDataSource)this.getRepositoryService().getResource(null, dataSourceFolderParentURI + "/" + dataSourceName, VirtualReportDataSource.class);
        if (dataSourceResource == null) {
            dataSourceResource = (VirtualReportDataSource)this.getRepositoryService().newResource(null, VirtualReportDataSource.class);
            dataSourceResource.setParentFolder(dataSourceFolderParentURI);
            dataSourceResource.setName(dataSourceName);
        }
        dataSourceResource.setLabel(dataSourceLabel);
        dataSourceResource.setDescription(dataSourceDescription);
        LinkedHashMap<String, ResourceReference> dataSourceUriMap = new LinkedHashMap<String, ResourceReference>();
        for (Map.Entry<String, String> entry : dataSourceIDMap.entrySet()) {
            String subDataSourceUri = subDataSourceFolderParentURI + "/" + entry.getValue();
            dataSourceUriMap.put(entry.getKey(), new ResourceReference(subDataSourceUri));
        }
        dataSourceResource.setDataSourceUriMap(dataSourceUriMap);
        this.getRepositoryService().saveResource(null, (Resource)dataSourceResource);
    }

    protected void createFoodmartMondrianConnectionResource() throws Exception {
        this.m_logger.info((Object)"createFoodmartMondrianConnectionResource() => creating /analysis/connections/Foodmart");
        String schemaResourceReference = "/analysis/schemas/FoodmartSchema";
        if (this.getJdbcProps().getProperty("foodmart.upperCaseNames") != null && this.getJdbcProps().getProperty("foodmart.upperCaseNames").equalsIgnoreCase("true")) {
            schemaResourceReference = "/analysis/schemas/FoodmartSchemaUpper";
        }
        this.createMondrianConnectionResource("/analysis/connections", "Foodmart", "Foodmart Mondrian Connection", "Foodmart Mondrian Analysis Connection", schemaResourceReference, "/analysis/datasources/FoodmartDataSourceJNDI");
    }

    protected void createFoodmartXMLAConnectionResource() {
        this.m_logger.info((Object)"createFoodmartXMLAConnectionResource() => creating /analysis/connections/FoodmartXmlaConnection");
        this.createXMLAConnectionResource("/analysis/connections", "FoodmartXmlaConnection", "Foodmart XML/A Connection", "Foodmart XML/A Connection", "Foodmart", "Provider=Mondrian;DataSource=Foodmart;", "http://localhost:8080/jasperserver/xmla", "jasperadmin", "jasperadmin");
    }

    protected void createSugarCRMMondrianConnectionResource() throws Exception {
        this.m_logger.info((Object)"createSugarCRMMondrianConnectionResource() => creating /analysis/connections/SugarCRM");
        String schemaResourceReference = "/analysis/schemas/SugarCRMSchema";
        if (this.getJdbcProps().getProperty("sugarcrm.upperCaseNames") != null && this.getJdbcProps().getProperty("sugarcrm.upperCaseNames").equalsIgnoreCase("true")) {
            schemaResourceReference = "/analysis/schemas/SugarCRMSchemaUpper";
        }
        this.createMondrianConnectionResource("/analysis/connections", "SugarCRM", "SugarCRM Mondrian Connection", "SugarCRM Mondrian Analysis Connection: only opportunities", schemaResourceReference, "/analysis/datasources/SugarCRMDataSourceJNDI");
    }

    protected void createSugarCRMXMLAConnectionResource() {
        this.m_logger.info((Object)"createSugarCRMXMLAConnectionResource() => creating /analysis/connections/SugarCRMXmlaConnection");
        this.createXMLAConnectionResource("/analysis/connections", "SugarCRMXmlaConnection", "SugarCRM XML/A Connection", "SugarCRM XML/A Connection", "SugarCRM", "Provider=Mondrian;DataSource=SugarCRM;", "http://localhost:8080/jasperserver/xmla", "jasperadmin", "jasperadmin");
    }

    protected void createFoodmartOlapUnit() {
        this.m_logger.info((Object)"createFoodmartOlapUnit() => creating /analysis/views/Foodmart_sample");
        this.creatOlapUnitResource("/analysis/views", "Foodmart_sample", "Foodmart Sample Analysis View", "Sample Analysis View: Foodmart Unit Sales", "/analysis/connections/Foodmart", SAMPLE_FOODMART_MDX_QUERY, true);
    }

    protected void createSugarCRMOlapUnit() {
        this.m_logger.info((Object)"createSugarCRMOlapUnit() => creating /analysis/views/SugarCRM_sample");
        this.creatOlapUnitResource("/analysis/views", "SugarCRM_sample", "SugarCRM Sample Analysis View", "Sample SugarCRM Analysis View: Sales Performance by Industry/Account", "/analysis/connections/SugarCRM", this.SAMPLE_SUGAR_CRM_MDX_QUERY, true);
    }

    protected void createSugarCRMXmlaOlapUnit() {
        this.m_logger.info((Object)"createSugarCRMXmlaOlapUnit() => creating /analysis/views/SugarCRM_xmla_sample");
        this.creatOlapUnitResource("/analysis/views", "SugarCRM_xmla_sample", "SugarCRM Sample XMLA Analysis View", "Sample SugarCRM Analysis View (XMLA): Sales Performance by Industry/Account", "/analysis/connections/SugarCRMXmlaConnection", this.SAMPLE_SUGAR_CRM_MDX_QUERY, true);
    }

    protected void createFoodmartMondrianXMLADefinitionResource() {
        this.m_logger.info((Object)"createFoodmartMondrianXMLADefinitionResource() => creating /analysis/xmla/definitions/FoodmartXmlaDefinition");
        this.creatMondrianXMLADefinitionResource("/analysis/xmla/definitions", "FoodmartXmlaDefinition", "Foodmart Mondrian XMLA definition", "Foodmart Mondrian XMLA definition", "Foodmart", "/analysis/connections/Foodmart");
    }

    protected void createSugarCRMMondrianXMLADefinitionResource() {
        this.m_logger.info((Object)"createSugarCRMMondrianXMLADefinitionResource() => creating /analysis/xmla/definitions/SugarCRMXmlaDefinition");
        this.creatMondrianXMLADefinitionResource("/analysis/xmla/definitions", "SugarCRMXmlaDefinition", "SugarCRM Mondrian XMLA definition", "SugarCRM Mondrian XMLA definition", "SugarCRM", "/analysis/connections/SugarCRM");
    }

    protected void createFoodmartJaSchemaResource() {
        this.m_logger.info((Object)"createFoodmartJaSchemaResource() => creating /analysis/schemas/FoodmartJaSchema");
        this.createOrUpdateSchemaResource("/analysis/schemas", "FoodmartJaSchema", "Foodmart Schema Pseudo Japanese", "Foodmart Analysis Pseudo Japanese Schema", "/queries/FoodMart_ja.xml");
    }

    protected void createFoodmartJaDataSourceResource() throws Exception {
        this.m_logger.info((Object)"createFoodmartJaDataSourceResource() => creating /analysis/datasources/FoodmartJaDataSource");
        this.createJDBCDataSourceResource("/analysis/datasources", "FoodmartJaDataSource", "Foodmart Japanese Data Source", "Foodmart Japanese Data Source", this.getJdbcProps().getProperty("foodmart_ja.jdbc.driverClassName"), this.getJdbcProps().getProperty("foodmart_ja.jdbc.url"), this.getJdbcProps().getProperty("foodmart_ja.jdbc.username"), this.getJdbcProps().getProperty("foodmart_ja.jdbc.password"));
    }

    protected void createFoodmartJaMondrianConnectionResource() {
        this.m_logger.info((Object)"createFoodmartJaMondrianConnectionResource() => creating /analysis/connections/FoodmartJa");
        this.createMondrianConnectionResource("/analysis/connections", "FoodmartJa", "FoodmartJa Mondrian Connection", "FoodmartJa Mondrian Analysis Connection", "/analysis/schemas/FoodmartJaSchema", "/analysis/datasources/FoodmartJaDataSource");
    }

    protected void createFoodmartJaOlapUnit() {
        this.m_logger.info((Object)"createFoodmartJaOlapUnit() => creating /analysis/views/FoodmartJa_sample_unit_1");
        this.creatOlapUnitResource("/analysis/views", "FoodmartJa_sample_unit_1", "FoodmartJa Sample Analysis View", "Sample Analysis View: FoodmartJa Unit Sales", "/analysis/connections/FoodmartJa", SAMPLE_FOODMART_JA_MDX_QUERY, true);
    }

    public void addOlapConnectionResources() throws Exception {
        this.m_logger.info((Object)"addOlapConnectionResources() called");
        this.createFoodmartSchemaResource();
        this.createFoodmartSchemaUpperResource();
        this.createSugarCRMSchemaResource();
        this.createSugarCRMSchemaUpperResource();
        this.createFoodmartJDBCDataSourceResource();
        this.createFoodmartJNDIDataSourceResource();
        this.createSugarCRMDataSourceResource();
        this.createSugarCRMDataSourceResourceJNDI();
        this.createSugarFoodmartDataSourceResourceVirtual();
        this.createFoodmartMondrianConnectionResource();
        this.createFoodmartXMLAConnectionResource();
        this.createSugarCRMMondrianConnectionResource();
        this.createSugarCRMXMLAConnectionResource();
        this.createFoodmartOlapUnit();
        this.createSugarCRMOlapUnit();
        this.createSugarCRMXmlaOlapUnit();
        this.createFoodmartMondrianXMLADefinitionResource();
        this.createSugarCRMMondrianXMLADefinitionResource();
        Folder analysisReports = this.createAnalysisReportsFolder();
        this.createMondrianFoodmartReport(analysisReports);
    }

    protected void createMondrianFoodmartReport(Folder parent) {
        this.createOlapFoodmartReport(parent, "/analysis/reports/", "FoodmartSalesMondrianReport", "Foodmart Mondrian Sales Report", "Report with Mondrian Datasource", "/analysis/connections/Foodmart");
    }

    protected Folder createAnalysisReportsFolder() {
        return this.createOrUpdateFolder("/analysis", "reports", "Analysis Reports");
    }

    public void createOlapFoodmartReport(Folder parent, String path, String name, String label, String desc, String connectionUri) {
        boolean newReportUnit = false;
        ExecutionContext executionContext = JasperServerUtil.getExecutionContext();
        ReportUnit unit = (ReportUnit)this.getRepositoryService().getResource(null, path + name, ReportUnit.class);
        if (unit == null) {
            unit = (ReportUnit)this.getRepositoryService().newResource(executionContext, ReportUnit.class);
            unit.setParentFolder(parent);
            unit.setName(name);
            newReportUnit = true;
        }
        unit.setLabel(label);
        unit.setDescription(desc);
        FileResource report = null;
        if (!newReportUnit) {
            report = (FileResource)unit.getMainReport().getLocalResource();
            assert (report != null);
        } else {
            report = (FileResource)this.getRepositoryService().newResource(executionContext, FileResource.class);
            report.setFileType("jrxml");
            report.setName("FoodmartSalesReportJRXML");
            report.setLabel("FoodmartSalesReportJRXML");
        }
        report.readData(((Object)((Object)this)).getClass().getResourceAsStream(FOODMART_REPORT_JRXML));
        unit.setMainReport(report);
        unit.setDataSourceReference(connectionUri);
        this.getRepositoryService().saveResource(executionContext, (Resource)unit);
    }

    public Folder createOrUpdateFolder(String folderParentURI, String folderName, String folderLabel) {
        Folder aFolder = null;
        ExecutionContext executionContext = JasperServerUtil.getExecutionContext();
        aFolder = this.getRepositoryService().getFolder(null, folderParentURI + "/" + folderName);
        if (aFolder == null) {
            aFolder = new FolderImpl();
            aFolder.setParentFolder(folderParentURI);
            aFolder.setName(folderName);
        }
        aFolder.setLabel(folderLabel);
        this.getRepositoryService().saveFolder(executionContext, aFolder);
        return aFolder;
    }

    public void createOrUpdateSchemaResource(String schemaFolderParentURI, String schemaName, String schemaLabel, String schemaDescription, String resourcePath) {
        FileResource schemaResource = (FileResource)this.getRepositoryService().getResource(null, schemaFolderParentURI + "/" + schemaName, FileResource.class);
        if (schemaResource == null) {
            schemaResource = (FileResource)this.getRepositoryService().newResource(null, FileResource.class);
            schemaResource.setParentFolder(schemaFolderParentURI);
            schemaResource.setName(schemaName);
        }
        schemaResource.setLabel(schemaLabel);
        schemaResource.setDescription(schemaDescription);
        schemaResource.setFileType("olapMondrianSchema");
        InputStream in = ((Object)((Object)this)).getClass().getResourceAsStream(resourcePath);
        schemaResource.readData(in);
        this.getOlapConnectionService().saveResource(null, schemaFolderParentURI, (Resource)schemaResource);
    }

    public void createJDBCDataSourceResource(String dataSourceFolderParentURI, String dataSourceName, String dataSourceLabel, String dataSourceDescription, String driverClassName, String connectionURL, String username, String password) {
        JdbcReportDataSource dataSourceResource = (JdbcReportDataSource)this.getRepositoryService().getResource(null, dataSourceFolderParentURI + "/" + dataSourceName, JdbcReportDataSource.class);
        if (dataSourceResource == null) {
            dataSourceResource = (JdbcReportDataSource)this.getRepositoryService().newResource(null, JdbcReportDataSource.class);
            dataSourceResource.setParentFolder(dataSourceFolderParentURI);
            dataSourceResource.setName(dataSourceName);
        }
        dataSourceResource.setLabel(dataSourceLabel);
        dataSourceResource.setDescription(dataSourceDescription);
        dataSourceResource.setDriverClass(driverClassName);
        dataSourceResource.setConnectionUrl(connectionURL);
        dataSourceResource.setUsername(username);
        dataSourceResource.setPassword(password);
        this.getOlapConnectionService().saveResource(null, dataSourceFolderParentURI, (Resource)dataSourceResource);
    }

    public void createJNDIDataSourceResource(String dataSourceFolderParentURI, String dataSourceName, String dataSourceLabel, String dataSourceDescription, String jndiURI) {
        JndiJdbcReportDataSource dataSourceResource = (JndiJdbcReportDataSource)this.getRepositoryService().getResource(null, dataSourceFolderParentURI + "/" + dataSourceName, JndiJdbcReportDataSource.class);
        if (dataSourceResource == null) {
            dataSourceResource = (JndiJdbcReportDataSource)this.getRepositoryService().newResource(null, JndiJdbcReportDataSource.class);
            dataSourceResource.setParentFolder(dataSourceFolderParentURI);
            dataSourceResource.setName(dataSourceName);
        }
        dataSourceResource.setLabel(dataSourceLabel);
        dataSourceResource.setDescription(dataSourceDescription);
        dataSourceResource.setJndiName(jndiURI);
        this.getOlapConnectionService().saveResource(null, dataSourceFolderParentURI, (Resource)dataSourceResource);
    }

    public void createMondrianConnectionResource(String mondrianConnectionFolderParentURI, String mondrianConnectionName, String mondrianConnectionLabel, String mondrianConnectionDescription, String schemaURI, String dataSourceURI) {
        MondrianConnection mondrianConnectionResource = (MondrianConnection)this.getRepositoryService().getResource(null, mondrianConnectionFolderParentURI + "/" + mondrianConnectionName, MondrianConnection.class);
        if (mondrianConnectionResource == null) {
            mondrianConnectionResource = (MondrianConnection)this.getRepositoryService().newResource(null, MondrianConnection.class);
            mondrianConnectionResource.setParentFolder(mondrianConnectionFolderParentURI);
            mondrianConnectionResource.setName(mondrianConnectionName);
        }
        mondrianConnectionResource.setLabel(mondrianConnectionName);
        mondrianConnectionResource.setDescription(mondrianConnectionDescription);
        mondrianConnectionResource.setSchemaReference(schemaURI);
        mondrianConnectionResource.setDataSourceReference(dataSourceURI);
        this.getOlapConnectionService().saveResource(null, mondrianConnectionFolderParentURI, (Resource)mondrianConnectionResource);
    }

    public void createXMLAConnectionResource(String xmlaConnectionFolderParentURI, String xmlaConnectionName, String xmlaConnectionLabel, String xmlaConnectionDescription, String catalog, String xmlaDataSource, String URI2, String username, String password) {
        XMLAConnection xmlaConnection = (XMLAConnection)this.getRepositoryService().getResource(null, xmlaConnectionFolderParentURI + "/" + xmlaConnectionName, XMLAConnection.class);
        if (xmlaConnection == null) {
            xmlaConnection = (XMLAConnection)this.getRepositoryService().newResource(null, XMLAConnection.class);
            xmlaConnection.setParentFolder(xmlaConnectionFolderParentURI);
            xmlaConnection.setName(xmlaConnectionName);
        }
        xmlaConnection.setLabel(xmlaConnectionLabel);
        xmlaConnection.setDescription(xmlaConnectionDescription);
        xmlaConnection.setCatalog(catalog);
        xmlaConnection.setDataSource(xmlaDataSource);
        xmlaConnection.setURI(URI2);
        xmlaConnection.setUsername(username);
        xmlaConnection.setPassword(password);
        this.getOlapConnectionService().saveResource(null, xmlaConnectionFolderParentURI, (Resource)xmlaConnection);
    }

    public void creatMondrianXMLADefinitionResource(String xmlaDefinitionFolderParentURI, String xmlaDefinitionName, String xmlaDefinitionLabel, String xmlaDefinitionDescription, String catalog, String mondrianConnectionURI) {
        MondrianXMLADefinition mondrianXmlaConnection = (MondrianXMLADefinition)this.getRepositoryService().getResource(null, xmlaDefinitionFolderParentURI + "/" + xmlaDefinitionName, MondrianXMLADefinition.class);
        if (mondrianXmlaConnection == null) {
            mondrianXmlaConnection = (MondrianXMLADefinition)this.getRepositoryService().newResource(null, MondrianXMLADefinition.class);
            mondrianXmlaConnection.setParentFolder(xmlaDefinitionFolderParentURI);
            mondrianXmlaConnection.setName(xmlaDefinitionName);
        }
        mondrianXmlaConnection.setLabel(xmlaDefinitionLabel);
        mondrianXmlaConnection.setDescription(xmlaDefinitionDescription);
        mondrianXmlaConnection.setCatalog(catalog);
        mondrianXmlaConnection.setMondrianConnectionReference(mondrianConnectionURI);
        this.getOlapConnectionService().saveResource(null, xmlaDefinitionFolderParentURI, (Resource)mondrianXmlaConnection);
    }

    public OlapUnit creatOlapUnitResource(String olapUnitFolderParentURI, String olapUnitName, String olapUnitLabel, String olapUnitDescription, String connectionReference, String mdxQuery, boolean saveUnit) {
        OlapUnit olapUnit = (OlapUnit)this.getRepositoryService().getResource(null, olapUnitFolderParentURI + "/" + olapUnitName, OlapUnit.class);
        if (olapUnit == null) {
            olapUnit = (OlapUnit)this.getRepositoryService().newResource(null, OlapUnit.class);
            olapUnit.setParentFolder(olapUnitFolderParentURI);
            olapUnit.setName(olapUnitName);
        }
        olapUnit.setLabel(olapUnitLabel);
        olapUnit.setDescription(olapUnitDescription);
        olapUnit.setOlapClientConnectionReference(connectionReference);
        olapUnit.setMdxQuery(mdxQuery);
        if (saveUnit) {
            this.getOlapConnectionService().saveResource(null, olapUnitFolderParentURI, (Resource)olapUnit);
        }
        return olapUnit;
    }

    public void setOlapConnectionServiceTarget(OlapConnectionServiceImpl olapConnectionServiceTarget) {
        this.olapConnectionServiceTarget = olapConnectionServiceTarget;
    }

    public OlapConnectionServiceImpl getOlapConnectionServiceTarget() {
        return this.olapConnectionServiceTarget;
    }

    private void createInteractiveFolderAndReportResources(Folder reportsFolder) {
        this.m_logger.info((Object)"createInteractiveFolderAndReportResources() called");
        this.m_logger.info((Object)"createInteractiveFolderAndReportResources() => creating /reports/interactive");
        FolderImpl interactiveFolder = new FolderImpl();
        interactiveFolder.setName("interactive");
        interactiveFolder.setLabel("Interactive");
        interactiveFolder.setDescription("Interactive");
        interactiveFolder.setParentFolder(reportsFolder);
        this.getUnsecureRepositoryService().saveFolder(null, (Folder)interactiveFolder);
        this.createCustomersReport((Folder)interactiveFolder);
        this.createCustomersData((Folder)interactiveFolder);
        this.createCustomersDataAdapter((Folder)interactiveFolder);
        this.createTableReport((Folder)interactiveFolder);
        this.createCsvData((Folder)interactiveFolder);
        this.createCsvDataAdapter((Folder)interactiveFolder);
        this.createMapReport((Folder)interactiveFolder);
    }

    private void createCustomersReport(Folder folder) {
        this.m_logger.info((Object)"createCustomersReport() => creating /reports/interactive/CustomersReport");
        FileResource reportRes = (FileResource)this.getUnsecureRepositoryService().newResource(null, FileResource.class);
        reportRes.setFileType("jrxml");
        reportRes.setName("CustomersReport");
        reportRes.setLabel("Customers Report");
        reportRes.setDescription("Customers Report");
        reportRes.setParentFolder(folder);
        InputStream jrxml = ((Object)((Object)this)).getClass().getResourceAsStream("/reports/jasper/CustomersReport.jrxml");
        reportRes.readData(jrxml);
        ReportUnit unit = (ReportUnit)this.getUnsecureRepositoryService().newResource(null, ReportUnit.class);
        unit.setName("CustomersReport");
        unit.setLabel("Customers Report");
        unit.setDescription("Customers Report");
        unit.setParentFolder(folder);
        unit.setMainReport(reportRes);
        FileResource res2 = (FileResource)this.getUnsecureRepositoryService().newResource(null, FileResource.class);
        res2.setFileType("jrxml");
        res2.readData(((Object)((Object)this)).getClass().getResourceAsStream("/reports/jasper/OrdersReport.jrxml"));
        res2.setName("OrdersReport");
        res2.setLabel("OrdersReport");
        res2.setDescription("OrdersReport");
        unit.addResource(res2);
        this.getUnsecureRepositoryService().saveResource(null, (Resource)unit);
    }

    private void createCustomersData(Folder folder) {
        this.m_logger.info((Object)"createCustomersData() => creating /reports/interactive/CustomersData");
        FileResource xmlData = (FileResource)this.getUnsecureRepositoryService().newResource(null, FileResource.class);
        xmlData.setFileType("xml");
        xmlData.readData(((Object)((Object)this)).getClass().getResourceAsStream("/reports/jasper/CustomersData.xml"));
        xmlData.setName("CustomersData");
        xmlData.setLabel("Customers Data");
        xmlData.setDescription("Customers Data");
        xmlData.setParentFolder(folder);
        this.getUnsecureRepositoryService().saveResource(null, (Resource)xmlData);
    }

    private void createCustomersDataAdapter(Folder folder) {
        this.m_logger.info((Object)"createCustomersDataAdapter() => creating /reports/interactive/CustomersDataAdapter");
        FileResource xmlRes = (FileResource)this.getUnsecureRepositoryService().newResource(null, FileResource.class);
        xmlRes.setFileType("xml");
        xmlRes.readData(((Object)((Object)this)).getClass().getResourceAsStream("/reports/jasper/CustomersDataAdapter.xml"));
        xmlRes.setName("CustomersDataAdapter");
        xmlRes.setLabel("Customers Data Adapter");
        xmlRes.setDescription("Customers Data Adapter");
        xmlRes.setParentFolder(folder);
        this.getUnsecureRepositoryService().saveResource(null, (Resource)xmlRes);
    }

    private void createTableReport(Folder folder) {
        this.m_logger.info((Object)"createTableReport() => creating /reports/interactive/TableReport");
        FileResource reportRes = (FileResource)this.getUnsecureRepositoryService().newResource(null, FileResource.class);
        reportRes.setFileType("jrxml");
        reportRes.setName("TableReport");
        reportRes.setLabel("Table Report");
        reportRes.setDescription("Table Report");
        reportRes.setParentFolder(folder);
        InputStream jrxml = ((Object)((Object)this)).getClass().getResourceAsStream("/reports/jasper/TableReport.jrxml");
        reportRes.readData(jrxml);
        ReportUnit unit = (ReportUnit)this.getUnsecureRepositoryService().newResource(null, ReportUnit.class);
        unit.setName("TableReport");
        unit.setLabel("Table Report");
        unit.setDescription("Table Report");
        unit.setParentFolder(folder);
        unit.setMainReport(reportRes);
        this.getUnsecureRepositoryService().saveResource(null, (Resource)unit);
    }

    private void createCsvData(Folder folder) {
        this.m_logger.info((Object)"createCsvData() => creating /reports/interactive/CsvData");
        FileResource csvData = (FileResource)this.getUnsecureRepositoryService().newResource(null, FileResource.class);
        csvData.setFileType("xml");
        csvData.readData(((Object)((Object)this)).getClass().getResourceAsStream("/reports/jasper/CsvData.csv"));
        csvData.setName("CsvData");
        csvData.setLabel("CSV Data");
        csvData.setDescription("CSV Data");
        csvData.setParentFolder(folder);
        this.getUnsecureRepositoryService().saveResource(null, (Resource)csvData);
    }

    private void createCsvDataAdapter(Folder folder) {
        this.m_logger.info((Object)"createCsvDataAdapter() => creating /reports/interactive/CsvDataAdapter");
        FileResource xmlRes = (FileResource)this.getUnsecureRepositoryService().newResource(null, FileResource.class);
        xmlRes.setFileType("xml");
        xmlRes.readData(((Object)((Object)this)).getClass().getResourceAsStream("/reports/jasper/CsvDataAdapter.xml"));
        xmlRes.setName("CsvDataAdapter");
        xmlRes.setLabel("CSV Data Adapter");
        xmlRes.setDescription("CSV Data Adapter");
        xmlRes.setParentFolder(folder);
        this.getUnsecureRepositoryService().saveResource(null, (Resource)xmlRes);
    }

    private void createMapReport(Folder folder) {
        this.m_logger.info((Object)"createMapReport() => creating /reports/interactive/MapReport");
        FileResource reportRes = (FileResource)this.getUnsecureRepositoryService().newResource(null, FileResource.class);
        reportRes.setFileType("jrxml");
        reportRes.setName("MapReport");
        reportRes.setLabel("Map Report");
        reportRes.setDescription("Map Report");
        reportRes.setParentFolder(folder);
        InputStream jrxml = ((Object)((Object)this)).getClass().getResourceAsStream("/reports/jasper/MapReport.jrxml");
        reportRes.readData(jrxml);
        ReportUnit unit = (ReportUnit)this.getUnsecureRepositoryService().newResource(null, ReportUnit.class);
        unit.setName("MapReport");
        unit.setLabel("Map Report");
        unit.setDescription("Map Report");
        unit.setParentFolder(folder);
        unit.setMainReport(reportRes);
        this.getUnsecureRepositoryService().saveResource(null, (Resource)unit);
    }
}

