/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.jasperserver.externalAuth.test;

import com.jaspersoft.jasperserver.api.common.domain.ExecutionContext;
import com.jaspersoft.jasperserver.api.common.domain.impl.ExecutionContextImpl;
import com.jaspersoft.jasperserver.api.metadata.user.domain.Role;
import com.jaspersoft.jasperserver.api.metadata.user.domain.User;
import com.jaspersoft.jasperserver.api.security.externalAuth.ExternalAuthProperties;
import com.jaspersoft.jasperserver.api.security.externalAuth.processors.ExternalUserSetupProcessor;
import com.jaspersoft.jasperserver.externalAuth.mocks.MockExternalJDBCUserDetailsService;
import com.jaspersoft.jasperserver.externalAuth.mocks.MockSsoTicketValidatorImpl;
import com.jaspersoft.jasperserver.externalAuth.test.BaseTransactionalTestNGSpringContextTests;
import java.net.URI;
import java.net.URL;
import java.net.URLEncoder;
import java.util.Arrays;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Set;
import javax.annotation.Resource;
import javax.servlet.FilterChain;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import org.springframework.mock.web.MockFilterChain;
import org.springframework.mock.web.MockHttpServletRequest;
import org.springframework.mock.web.MockHttpServletResponse;
import org.springframework.security.ui.ExceptionTranslationFilter;
import org.springframework.security.ui.webapp.AuthenticationProcessingFilterEntryPoint;
import org.springframework.security.util.FilterChainProxy;
import org.springframework.test.annotation.DirtiesContext;
import org.springframework.test.context.ContextConfiguration;
import org.springframework.web.context.request.RequestAttributes;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;
import org.testng.Assert;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.Test;

@ContextConfiguration(locations={"classpath:sample-applicationContext-externalAuth-sso.xml", "classpath:testMocks/externalAuth-test-mocks.xml"})
@DirtiesContext(classMode=DirtiesContext.ClassMode.AFTER_CLASS)
public class SSOIntegrationTest
extends BaseTransactionalTestNGSpringContextTests {
    @Resource(name="filterChainProxy")
    private FilterChainProxy filterChainProxy;
    @Resource(name="proxyExceptionTranslationFilter")
    private ExceptionTranslationFilter proxyExceptionTranslationFilter;
    @Resource(name="externalAuthProperties")
    private ExternalAuthProperties externalAuthProperties;
    @Resource(name="httpBasedSsoTicketValidator")
    private MockSsoTicketValidatorImpl mockSsoTicketValidator;
    @Resource(name="externalUserSetupProcessor")
    private ExternalUserSetupProcessor externalUserSetupProcessor;
    @Resource(name="externalJDBCUserDetailsService")
    private MockExternalJDBCUserDetailsService mockExternalJDBCUserDetailsService;

    @Test
    public void testUserWithoutExternalRoles() {
        try {
            this.logger.info((Object)"Starting testUserWithoutExternalRoles.");
            this.createTenant("", "organizations", "root", "organizations", " ", "/", "/", "default");
            MockHttpServletRequest mockRequest = new MockHttpServletRequest("GET", "/home.html");
            mockRequest.setServletPath(null);
            MockHttpServletResponse mockResponse = new MockHttpServletResponse();
            Assert.assertNull((Object)mockResponse.getRedirectedUrl(), (String)"Redirect url should be null at the start");
            this.filterChainProxy.doFilter((ServletRequest)mockRequest, (ServletResponse)mockResponse, (FilterChain)new MockFilterChain());
            String redirectUrlStr = mockResponse.getRedirectedUrl();
            Assert.assertNotNull((Object)redirectUrlStr, (String)"Redirect url should not be null");
            this.logger.info((Object)("SSO redirect url: " + redirectUrlStr));
            String configuredLoginFormUrl = ((AuthenticationProcessingFilterEntryPoint)this.proxyExceptionTranslationFilter.getAuthenticationEntryPoint()).getLoginFormUrl();
            Assert.assertNotNull((Object)mockResponse.getRedirectedUrl(), (String)"Redirect url should NOT be null at the start");
            String responseRedirectUrlPath = new URL(mockResponse.getRedirectedUrl()).getPath();
            String configuredLoginFormUrlPath = new URI(configuredLoginFormUrl).getPath();
            Assert.assertTrue((boolean)responseRedirectUrlPath.equalsIgnoreCase(configuredLoginFormUrlPath), (String)("The url to which sso redirected (" + redirectUrlStr + ") was not the as expected " + configuredLoginFormUrl));
            Assert.assertNull((Object)this.mockSsoTicketValidator.getTicketValidationUrl(), (String)"Ticket validation url should be null at the start");
            String testTicket = "testTicket";
            MockHttpServletRequest mockRequest2 = new MockHttpServletRequest("GET", "/j_spring_security_check");
            mockRequest2.setServletPath(null);
            mockRequest2.setParameter(this.externalAuthProperties.getTicketParameterName(), "testTicket");
            RequestContextHolder.setRequestAttributes((RequestAttributes)new ServletRequestAttributes((HttpServletRequest)mockRequest2));
            this.filterChainProxy.doFilter((ServletRequest)mockRequest2, (ServletResponse)new MockHttpServletResponse(), (FilterChain)new MockFilterChain());
            URI ticketValidationUrl = this.mockSsoTicketValidator.getTicketValidationUrl();
            Assert.assertNotNull((Object)ticketValidationUrl, (String)"Ticket validation url should be not be null");
            URI testTicketValidationUrl = new URI(this.externalAuthProperties.getSsoServerTicketValidationUrl() + "?" + this.externalAuthProperties.getTicketParameterName() + "=" + "testTicket" + "&" + this.externalAuthProperties.getServiceParameterName() + "=" + URLEncoder.encode(mockRequest2.getRequestURL().toString(), "ISO-8859-1"));
            Assert.assertTrue((boolean)testTicketValidationUrl.equals(ticketValidationUrl), (String)("Ticket validation url " + ticketValidationUrl + " was not as expected: " + testTicketValidationUrl));
            User user = this.userAuthorityService.getUser((ExecutionContext)new ExecutionContextImpl(), this.mockSsoTicketValidator.getTestValidatedPrincipal());
            Assert.assertNotNull((Object)user, (String)"External user was not added to jasperserver database after authentication.");
            Assert.assertTrue((boolean)user.isExternallyDefined(), (String)"User must be externally defined in db.");
            this.logger.info((Object)("created user " + user.getUsername()));
            HashSet defaultInternalRoles = new HashSet(this.externalUserSetupProcessor.getDefaultInternalRoles());
            Set userRoles = user.getRoles();
            Assert.assertNotNull((Object)userRoles, (String)"Test user must have non-null userRoles in this test");
            Assert.assertEquals((int)userRoles.size(), (int)defaultInternalRoles.size(), (String)("Test user must have " + defaultInternalRoles.size() + " default role(s) in this test"));
            for (Role r : userRoles) {
                Assert.assertTrue((!r.isExternallyDefined() ? 1 : 0) != 0, (String)"All roles must be internally defined in this test.");
                Assert.assertTrue((boolean)defaultInternalRoles.remove(r.getRoleName()), (String)(r.getRoleName() + " internal role was improperly assigned to the test user."));
            }
            Assert.assertEquals((int)defaultInternalRoles.size(), (int)0, (String)("Some default internal roles are missing for the test user: " + ((Object)defaultInternalRoles).toString()));
        }
        catch (Exception e) {
            this.logger.error((Object)e.getMessage(), (Throwable)e);
            Assert.fail((String)e.getMessage());
        }
    }

    @Test
    public void testUserWithExternalRoles() {
        try {
            this.logger.info((Object)"Starting testUserWithExternalRoles.");
            this.createTenant("", "organizations", "root", "organizations", " ", "/", "/", "default");
            String EXTERNAL_TEST_ROLE_1 = "EXTERNAL_TEST_ROLE_1";
            String EXTERNAL_TEST_ROLE_2 = "EXTERNAL_TEST_ROLE_2";
            LinkedList<String> EXTERNAL_TEST_ROLE_LIST = new LinkedList<String>(Arrays.asList("EXTERNAL_TEST_ROLE_1", "EXTERNAL_TEST_ROLE_2"));
            this.mockExternalJDBCUserDetailsService.setExternalUserRoles(EXTERNAL_TEST_ROLE_LIST);
            MockHttpServletRequest mockRequest = new MockHttpServletRequest("GET", "/home.html");
            mockRequest.setServletPath(null);
            MockHttpServletResponse mockResponse = new MockHttpServletResponse();
            Assert.assertNull((Object)mockResponse.getRedirectedUrl(), (String)"Redirect url should be null at the start");
            this.filterChainProxy.doFilter((ServletRequest)mockRequest, (ServletResponse)mockResponse, (FilterChain)new MockFilterChain());
            String redirectUrlStr = mockResponse.getRedirectedUrl();
            Assert.assertNotNull((Object)redirectUrlStr, (String)"Redirect url should not be null");
            this.logger.info((Object)("SSO redirect url: " + redirectUrlStr));
            String configuredLoginFormUrl = ((AuthenticationProcessingFilterEntryPoint)this.proxyExceptionTranslationFilter.getAuthenticationEntryPoint()).getLoginFormUrl();
            Assert.assertNotNull((Object)"Redirect url should NOT be null at the start", (String)mockResponse.getRedirectedUrl());
            String responseRedirectUrlPath = new URL(mockResponse.getRedirectedUrl()).getPath();
            String configuredLoginFormUrlPath = new URI(configuredLoginFormUrl).getPath();
            Assert.assertTrue((boolean)responseRedirectUrlPath.equalsIgnoreCase(configuredLoginFormUrlPath), (String)("The url to which sso redirected (" + redirectUrlStr + ") was not the as expected " + configuredLoginFormUrl));
            Assert.assertNull((Object)this.mockSsoTicketValidator.getTicketValidationUrl(), (String)"Ticket validation url should be null at the start");
            String testTicket = "testTicket";
            MockHttpServletRequest mockRequest2 = new MockHttpServletRequest("GET", "/j_spring_security_check");
            mockRequest2.setServletPath(null);
            mockRequest2.setParameter(this.externalAuthProperties.getTicketParameterName(), "testTicket");
            RequestContextHolder.setRequestAttributes((RequestAttributes)new ServletRequestAttributes((HttpServletRequest)mockRequest2));
            this.filterChainProxy.doFilter((ServletRequest)mockRequest2, (ServletResponse)new MockHttpServletResponse(), (FilterChain)new MockFilterChain());
            URI ticketValidationUrl = this.mockSsoTicketValidator.getTicketValidationUrl();
            Assert.assertNotNull((Object)ticketValidationUrl, (String)"Ticket validation url should be not be null");
            URI testTicketValidationUrl = new URI(this.externalAuthProperties.getSsoServerTicketValidationUrl() + "?" + this.externalAuthProperties.getTicketParameterName() + "=" + "testTicket" + "&" + this.externalAuthProperties.getServiceParameterName() + "=" + URLEncoder.encode(mockRequest2.getRequestURL().toString(), "ISO-8859-1"));
            Assert.assertTrue((boolean)testTicketValidationUrl.equals(ticketValidationUrl), (String)("Ticket validation url " + ticketValidationUrl + " was not as expected: " + testTicketValidationUrl));
            User user = this.userAuthorityService.getUser((ExecutionContext)new ExecutionContextImpl(), this.mockSsoTicketValidator.getTestValidatedPrincipal());
            Assert.assertNotNull((Object)user, (String)"External user was not added to jasperserver database after authentication.");
            Assert.assertTrue((boolean)user.isExternallyDefined(), (String)"User must be externally defined in db.");
            this.logger.info((Object)("created user " + user.getUsername()));
            HashSet defaultInternalRoles = new HashSet(this.externalUserSetupProcessor.getDefaultInternalRoles());
            Set userRoles = user.getRoles();
            Assert.assertNotNull((Object)userRoles, (String)"Test user must have non-null userRoles in this test");
            String ROLE_PREFIX = "ROLE_";
            HashSet<String> userInternalRoles = new HashSet<String>();
            HashSet<String> userExternalRoles = new HashSet<String>();
            for (Role r : userRoles) {
                String roleName = r.getRoleName();
                if (r.isExternallyDefined()) {
                    userExternalRoles.add(roleName.startsWith("ROLE_") ? roleName.substring("ROLE_".length()) : roleName);
                    continue;
                }
                userInternalRoles.add(roleName);
            }
            Assert.assertTrue((boolean)((Object)userInternalRoles).equals(defaultInternalRoles), (String)"The new user should be assigned all default internal roles in this test.");
            HashSet<String> EXTERNAL_TEST_ROLE_SET = new HashSet<String>(EXTERNAL_TEST_ROLE_LIST);
            Assert.assertTrue((boolean)((Object)userExternalRoles).equals(EXTERNAL_TEST_ROLE_SET), (String)("The new user should be assigned " + EXTERNAL_TEST_ROLE_SET + " external roles in this test."));
            EXTERNAL_TEST_ROLE_LIST.remove("EXTERNAL_TEST_ROLE_2");
            this.mockExternalJDBCUserDetailsService.setExternalUserRoles(EXTERNAL_TEST_ROLE_LIST);
            String testTicket3 = "testTicket";
            MockHttpServletRequest mockRequest3 = new MockHttpServletRequest("GET", "/j_spring_security_check");
            mockRequest3.setServletPath(null);
            mockRequest3.setParameter(this.externalAuthProperties.getTicketParameterName(), "testTicket");
            RequestContextHolder.setRequestAttributes((RequestAttributes)new ServletRequestAttributes((HttpServletRequest)mockRequest3));
            this.filterChainProxy.doFilter((ServletRequest)mockRequest3, (ServletResponse)new MockHttpServletResponse(), (FilterChain)new MockFilterChain());
            User user2 = this.userAuthorityService.getUser((ExecutionContext)new ExecutionContextImpl(), this.mockSsoTicketValidator.getTestValidatedPrincipal());
            Assert.assertNotNull((Object)user2, (String)"External user was not added to jasperserver database after authentication.");
            Assert.assertTrue((boolean)user2.isExternallyDefined(), (String)"User must be externally defined in db.");
            Set userRoles2 = user2.getRoles();
            Assert.assertNotNull((Object)userRoles2, (String)"Test user must have non-null userRoles in this test");
            HashSet<String> userExternalRoles2 = new HashSet<String>();
            HashSet<String> userInternalRoles2 = new HashSet<String>();
            for (Role r : userRoles2) {
                String roleName = r.getRoleName();
                if (r.isExternallyDefined()) {
                    userExternalRoles2.add(roleName.startsWith("ROLE_") ? roleName.substring("ROLE_".length()) : roleName);
                    continue;
                }
                userInternalRoles2.add(roleName);
            }
            Assert.assertTrue((boolean)((Object)userInternalRoles2).equals(defaultInternalRoles), (String)"The new user should be assigned all default internal roles in this test.");
            HashSet<String> EXTERNAL_TEST_ROLE_SET_2 = new HashSet<String>(EXTERNAL_TEST_ROLE_LIST);
            Assert.assertTrue((boolean)((Object)userExternalRoles2).equals(EXTERNAL_TEST_ROLE_SET_2), (String)("The new user should be assigned " + EXTERNAL_TEST_ROLE_SET_2 + " external roles in this test."));
        }
        catch (Exception e) {
            this.logger.error((Object)e.getMessage(), (Throwable)e);
            Assert.fail((String)e.getMessage());
        }
    }

    @AfterMethod
    public void tearDown() {
        this.mockSsoTicketValidator.cleanup();
        this.mockExternalJDBCUserDetailsService.cleanup();
    }
}

