/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.jasperserver.externalAuth.test;

import com.jaspersoft.jasperserver.api.common.domain.ExecutionContext;
import com.jaspersoft.jasperserver.api.common.domain.impl.ExecutionContextImpl;
import com.jaspersoft.jasperserver.api.metadata.common.domain.Folder;
import com.jaspersoft.jasperserver.api.metadata.common.domain.client.FolderImpl;
import com.jaspersoft.jasperserver.api.metadata.common.service.impl.hibernate.HibernateRepositoryService;
import com.jaspersoft.jasperserver.api.metadata.user.domain.Role;
import com.jaspersoft.jasperserver.api.metadata.user.domain.Tenant;
import com.jaspersoft.jasperserver.api.metadata.user.domain.client.TenantImpl;
import com.jaspersoft.jasperserver.api.metadata.user.service.TenantService;
import com.jaspersoft.jasperserver.api.metadata.user.service.UserAuthorityService;
import com.jaspersoft.jasperserver.common.test.MockServletContextLoader;
import java.util.List;
import javax.annotation.Resource;
import javax.sql.DataSource;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.test.context.ContextConfiguration;
import org.springframework.test.context.testng.AbstractTransactionalTestNGSpringContextTests;
import org.testng.Assert;

@ContextConfiguration(loader=MockServletContextLoader.class, locations={"classpath:applicationContext*.xml"})
public abstract class BaseTransactionalTestNGSpringContextTests
extends AbstractTransactionalTestNGSpringContextTests {
    public static final String FORWARD_SLASH = "/";
    public static final String TEMP_DIR = "temp";
    public static final String TEMP_DIR_LAB = "Temp";
    public static final String ORGS_DIR = "organizations";
    public static final String ORGS_URI = "/organizations";
    public static final String ORGS_DIR_LAB = "Organizations";
    public static final String TEMPLATE_DIR = "org_template";
    public static final String TEMPLATE_URI = "/organizations/org_template";
    public static final String TEMPLATE_DIR_LAB = "Folder Template";
    public static final String DEFAULT_ORG_NAME = "organization_1";
    public static final String DEFAULT_ORG_URI = "/organizations/organization_1";
    public static final String DEFAULT_ORG_LAB = "Organization";
    public static final String PROPERTIES_DIR = "properties";
    public static final String ADHOC_DIR = "adhoc";
    public static final String ADHOC_DIR_LAB = "Ad Hoc Components";
    public static final String TOPICS_DIR = "topics";
    public static final String TOPICS_DIR_LAB = "Topics";
    public static final String THEMES_DIR = "themes";
    public static final String THEMES_DIR_LABEL = "Themes";
    public static final String DEFAULT_THEME_DIR = "default";
    public final String DEFAULT_THEME = "default";
    public static final String ROLE_ADMINISTRATOR = "ROLE_ADMINISTRATOR";
    public static final String ROLE_USER = "ROLE_USER";
    @Autowired
    protected DataSource dataSource;
    @Resource(name="tenantService")
    protected TenantService tenantService;
    @Resource(name="unsecureRepositoryService")
    protected HibernateRepositoryService repositoryService;
    @Resource(name="userAuthorityService")
    protected UserAuthorityService userAuthorityService;

    protected void createTenant(String parentTenantId, String tenantId, String tenantName, String tenantDesc, String tenantNote, String relativeUri, String uri, String theme) {
        TenantImpl aTenant = new TenantImpl();
        if (!ORGS_DIR.equals(tenantId) && !ORGS_DIR.equals(parentTenantId)) {
            tenantId = parentTenantId + "_" + tenantId;
        }
        aTenant.setParentId(parentTenantId);
        aTenant.setId(tenantId);
        aTenant.setAlias(tenantId);
        aTenant.setTenantName(tenantName);
        aTenant.setTenantDesc(tenantDesc);
        aTenant.setTenantNote(tenantNote);
        aTenant.setTenantUri(relativeUri);
        aTenant.setTenantFolderUri(uri);
        aTenant.setTheme(theme);
        this.tenantService.putTenant(null, (Tenant)aTenant);
    }

    protected void constructMultiTenancyFolderStructure() {
        this.logger.info((Object)"constructMultiTenancyFolderStructure() called");
        FolderImpl orgsFolder = this.createFolder(ORGS_DIR, ORGS_DIR_LAB, ORGS_DIR_LAB, FORWARD_SLASH);
        this.createFolder(DEFAULT_ORG_NAME, DEFAULT_ORG_LAB, DEFAULT_ORG_LAB, orgsFolder);
        this.createFolder(TEMPLATE_DIR, TEMPLATE_DIR_LAB, TEMPLATE_DIR_LAB, orgsFolder);
        this.createFolder(TEMP_DIR, TEMP_DIR_LAB, TEMP_DIR_LAB, TEMPLATE_URI);
        this.createFolder(ADHOC_DIR, ADHOC_DIR_LAB, ADHOC_DIR_LAB, TEMPLATE_URI);
        this.createFolder(TOPICS_DIR, TOPICS_DIR_LAB, TOPICS_DIR_LAB, "/organizations/org_template/adhoc");
        this.createFolder(THEMES_DIR, THEMES_DIR_LABEL, THEMES_DIR, TEMPLATE_URI);
        this.createFolder(DEFAULT_THEME_DIR, DEFAULT_THEME_DIR, DEFAULT_THEME_DIR, "/organizations/org_template/themes");
        List folders = this.repositoryService.getSubFolders(null, FORWARD_SLASH);
        for (Object folder : folders) {
            if (ORGS_DIR.equalsIgnoreCase(((Folder)folder).getName()) || PROPERTIES_DIR.equalsIgnoreCase(((Folder)folder).getName())) continue;
            this.repositoryService.moveFolder((ExecutionContext)new ExecutionContextImpl(), ((Folder)folder).getURIString(), DEFAULT_ORG_URI);
        }
    }

    private FolderImpl createFolder(String name, String label, String description, String parentFolder) {
        FolderImpl folder = new FolderImpl();
        folder.setName(name);
        folder.setLabel(label);
        folder.setDescription(description);
        folder.setParentFolder(parentFolder);
        this.repositoryService.saveFolder((ExecutionContext)new ExecutionContextImpl(), (Folder)folder);
        return folder;
    }

    private Folder createFolder(String name, String label, String description, FolderImpl parentFolder) {
        return this.createFolder(name, label, description, parentFolder == null ? null : parentFolder.getURIString());
    }

    protected void createUsersAndRoles() {
        this.logger.info((Object)"createUsersAndRoles() called");
        this.createRole(ROLE_ADMINISTRATOR);
        this.createRole(ROLE_USER);
    }

    private Role createRole(String roleName) {
        Role role = this.userAuthorityService.getRole(null, roleName);
        Assert.assertTrue((role == null ? 1 : 0) != 0, (String)("Error: trying to create a role that already exists, roleName=" + roleName));
        role = this.userAuthorityService.newRole(null);
        role.setRoleName(roleName);
        role.setExternallyDefined(false);
        this.userAuthorityService.putRole(null, role);
        return role;
    }
}

