/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.jasperserver.externalAuth.mocks;

import com.jaspersoft.jasperserver.api.JSException;
import com.jaspersoft.jasperserver.api.security.externalAuth.sso.SsoTicketValidatorImpl;
import com.jaspersoft.jasperserver.externalAuth.mocks.MockClientHttpResponse;
import java.io.StringWriter;
import java.net.URI;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;
import org.springframework.http.client.ClientHttpResponse;
import org.springframework.security.AuthenticationServiceException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Text;

public class MockSsoTicketValidatorImpl
extends SsoTicketValidatorImpl {
    private static final Logger logger = LogManager.getLogger(MockSsoTicketValidatorImpl.class);
    private String testValidatedPrincipal;
    private URI ticketValidationUrl;

    protected final URI constructValidationUrl(String ticket) throws AuthenticationServiceException {
        this.ticketValidationUrl = super.constructValidationUrl(ticket);
        return this.ticketValidationUrl;
    }

    protected ClientHttpResponse requestTicketValidationFromSsoServer(URI validationUrl) throws AuthenticationServiceException {
        MockClientHttpResponse response = new MockClientHttpResponse();
        try {
            DocumentBuilderFactory dbfac = DocumentBuilderFactory.newInstance();
            DocumentBuilder docBuilder = dbfac.newDocumentBuilder();
            Document doc = docBuilder.newDocument();
            Element root = doc.createElement("response");
            root.setAttribute("xmlns:cas", "http://www.yale.edu/tp/cas");
            Element rootChild = doc.createElement(this.getExternalAuthProperties().getCustomSsoProperty("principalXmlTagName"));
            root.appendChild(rootChild);
            Text text = doc.createTextNode(this.testValidatedPrincipal);
            rootChild.appendChild(text);
            doc.appendChild(root);
            Transformer transformer = TransformerFactory.newInstance().newTransformer();
            transformer.setOutputProperty("omit-xml-declaration", "yes");
            StringWriter writer = new StringWriter();
            transformer.transform(new DOMSource(doc), new StreamResult(writer));
            response.setBody(writer.getBuffer().toString());
        }
        catch (ParserConfigurationException e) {
            logger.error((Object)e);
            throw new JSException((Throwable)e);
        }
        catch (TransformerException te) {
            logger.error((Object)te);
            throw new JSException((Throwable)te);
        }
        return response;
    }

    public URI getTicketValidationUrl() {
        return this.ticketValidationUrl;
    }

    public String getTestValidatedPrincipal() {
        return this.testValidatedPrincipal;
    }

    public void setTestValidatedPrincipal(String testValidatedPrincipal) {
        this.testValidatedPrincipal = testValidatedPrincipal;
    }

    public void cleanup() {
        this.ticketValidationUrl = null;
    }
}

