/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.jasperserver.externalAuth.mocks;

import com.jaspersoft.jasperserver.api.security.externalAuth.db.ExternalJDBCUserDetailsService;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import org.springframework.dao.DataAccessException;
import org.springframework.security.GrantedAuthority;
import org.springframework.security.GrantedAuthorityImpl;
import org.springframework.security.userdetails.UsernameNotFoundException;

public class MockExternalJDBCUserDetailsService
extends ExternalJDBCUserDetailsService {
    private List<String> externalUserRoles = new LinkedList<String>();

    public boolean doesUserHaveExternalRoles() {
        return this.externalUserRoles != null && this.externalUserRoles.size() > 0;
    }

    public void setExternalUserRoles(List<String> roles) {
        this.externalUserRoles = roles;
    }

    public List<GrantedAuthority> loadAuthoritiesByUsername(String username) throws UsernameNotFoundException, DataAccessException {
        if (!this.doesUserHaveExternalRoles()) {
            logger.debug((Object)"This test is setup for a user with no external roles.");
            return Collections.emptyList();
        }
        ArrayList<GrantedAuthority> authorities = new ArrayList<GrantedAuthority>();
        for (String s : this.externalUserRoles) {
            authorities.add((GrantedAuthority)new GrantedAuthorityImpl(s));
        }
        return authorities;
    }

    public void cleanup() {
        this.externalUserRoles.clear();
    }
}

