/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.jasperserver.common.test;

import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import javax.servlet.ServletContext;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;
import org.springframework.beans.factory.support.BeanDefinitionReader;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.beans.factory.support.DefaultListableBeanFactory;
import org.springframework.beans.factory.xml.XmlBeanDefinitionReader;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.context.annotation.AnnotationConfigUtils;
import org.springframework.context.support.GenericApplicationContext;
import org.springframework.mock.web.MockServletContext;
import org.springframework.test.context.MergedContextConfiguration;
import org.springframework.test.context.support.AbstractContextLoader;
import org.springframework.util.StringUtils;
import org.springframework.web.context.WebApplicationContext;
import org.springframework.web.context.support.GenericWebApplicationContext;

public class MockServletContextLoader
extends AbstractContextLoader {
    protected static final Logger logger = LogManager.getLogger(MockServletContextLoader.class);
    public static final ServletContext SERVLET_CONTEXT = new MockServletContext();
    private ExecutorService executor = Executors.newFixedThreadPool(1);

    protected BeanDefinitionReader createBeanDefinitionReader(GenericApplicationContext context) {
        return new XmlBeanDefinitionReader((BeanDefinitionRegistry)context);
    }

    public final ConfigurableApplicationContext loadContext(final String ... locations) throws Exception {
        Callable<ConfigurableApplicationContext> callable = new Callable<ConfigurableApplicationContext>(){

            @Override
            public ConfigurableApplicationContext call() throws Exception {
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("Loading ApplicationContext for locations [" + StringUtils.arrayToCommaDelimitedString((Object[])locations) + "]."));
                }
                GenericWebApplicationContext webContext = new GenericWebApplicationContext();
                SERVLET_CONTEXT.setAttribute(WebApplicationContext.ROOT_WEB_APPLICATION_CONTEXT_ATTRIBUTE, (Object)webContext);
                webContext.setServletContext(SERVLET_CONTEXT);
                MockServletContextLoader.this.createBeanDefinitionReader((GenericApplicationContext)webContext).loadBeanDefinitions(locations);
                AnnotationConfigUtils.registerAnnotationConfigProcessors((BeanDefinitionRegistry)webContext);
                webContext.refresh();
                webContext.registerShutdownHook();
                return webContext;
            }
        };
        Future<ConfigurableApplicationContext> future = this.executor.submit(callable);
        return future.get();
    }

    protected String getResourceSuffix() {
        return "-context.xml";
    }

    public final ApplicationContext loadContext(final MergedContextConfiguration mergedConfig) throws Exception {
        Callable<ConfigurableApplicationContext> callable = new Callable<ConfigurableApplicationContext>(){

            @Override
            public ConfigurableApplicationContext call() throws Exception {
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)String.format("Loading ApplicationContext for merged context configuration [%s].", mergedConfig));
                }
                GenericWebApplicationContext webContext = new GenericWebApplicationContext();
                SERVLET_CONTEXT.setAttribute(WebApplicationContext.ROOT_WEB_APPLICATION_CONTEXT_ATTRIBUTE, (Object)webContext);
                webContext.setServletContext(SERVLET_CONTEXT);
                webContext.getEnvironment().setActiveProfiles(mergedConfig.getActiveProfiles());
                MockServletContextLoader.this.prepareContext((GenericApplicationContext)webContext);
                MockServletContextLoader.this.customizeBeanFactory(webContext.getDefaultListableBeanFactory());
                MockServletContextLoader.this.loadBeanDefinitions((GenericApplicationContext)webContext, mergedConfig);
                AnnotationConfigUtils.registerAnnotationConfigProcessors((BeanDefinitionRegistry)webContext);
                MockServletContextLoader.this.customizeContext((GenericApplicationContext)webContext);
                webContext.refresh();
                webContext.registerShutdownHook();
                return webContext;
            }
        };
        Future<ConfigurableApplicationContext> future = this.executor.submit(callable);
        return (ApplicationContext)future.get();
    }

    protected void prepareContext(GenericApplicationContext context) {
    }

    protected void customizeBeanFactory(DefaultListableBeanFactory beanFactory) {
    }

    protected void loadBeanDefinitions(GenericApplicationContext context, MergedContextConfiguration mergedConfig) {
        this.createBeanDefinitionReader(context).loadBeanDefinitions(mergedConfig.getLocations());
    }

    protected void customizeContext(GenericApplicationContext context) {
    }
}

